/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.custom.runtime.provider;

import com.sun.encoder.custom.runtime.provider.Nodes;
import com.sun.encoder.runtime.OtdInputStream;
import com.sun.encoder.runtime.StringCoder;
import com.sun.encoder.tools.xml.SchemaLocationAttributes;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Match {
    private static final EmptyAttributes mEmptyAttrs = new EmptyAttributes();
    private URL mMetadataLocation;
    private ArrayList mItems = new ArrayList();
    private int mCursor = 0;
    private int[] mHead = new int[0];
    private int[] mTail = new int[0];
    private String mMetadataNamespace;

    public void setMetadataLocation(URL location) {
        this.mMetadataLocation = location;
    }

    public URL getMetadataLocation() {
        return this.mMetadataLocation;
    }

    public void setMetadataNamespace(String namespace) {
        this.mMetadataNamespace = namespace;
    }

    public String getMetadataNamespace() {
        return this.mMetadataNamespace;
    }

    public void clear() {
        this.mCursor = 0;
    }

    private Item next(byte type, int child) {
        Item item = null;
        if (this.mCursor < this.mItems.size()) {
            item = this.getItem(this.mCursor);
        } else {
            item = new Item();
            this.mItems.add(item);
        }
        ++this.mCursor;
        item.mType = type;
        item.mChild = child;
        return item;
    }

    public int enter(int child, int index, long pos) {
        int at = this.mCursor;
        Item item = this.next((byte)0, child);
        item.mIndex = index;
        item.mOffset = pos;
        return at;
    }

    public int enter(int child, long pos) {
        return this.enter(child, -1, pos);
    }

    public void reset(int enter) {
        if (this.mCursor <= enter) {
            throw new IllegalArgumentException("forward reset");
        }
        this.mCursor = enter;
    }

    public void leave(int enter) {
        if (this.mCursor <= enter) {
            throw new IllegalArgumentException("forward leave");
        }
        Item item = this.next((byte)2, enter);
    }

    public void field(int child, int index, long offset, int length) {
        Item item = this.next((byte)1, child);
        item.mIndex = index;
        item.mOffset = offset;
        item.mLength = length;
    }

    public void apply(Nodes nodes, ContentHandler handler, StringCoder decoder, OtdInputStream in) throws IOException, SAXException {
        Item item;
        int max = 0;
        for (int i = 1; i < this.mCursor - 1; ++i) {
            item = this.getItem(i);
            if (item.mType != 1 || max >= item.mLength) continue;
            max = item.mLength;
        }
        byte[] buf = new byte[max];
        char[] charBuf = new char[max];
        long pos = 0L;
        in.rewind();
        if (handler == null) {
            throw new NullPointerException("no content handler");
        }
        if (decoder == null) {
            throw new NullPointerException("no character decoder");
        }
        Nodes.Node root = nodes.get(nodes.getRoot());
        if (root.mOrder != 0 && this.getItem((int)0).mType == 0) {
            this.sort(root, 0);
        }
        Nodes.Node node = root;
        handler.startDocument();
        handler.startPrefixMapping("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        handler.startElement(node.mNamespace, node.mName, node.mName, (Attributes)new SchemaLocationAttributes(this.mMetadataNamespace, this.mMetadataLocation));
        int next = 1;
        for (int i = 1; i < this.mCursor - 1; ++i) {
            item = this.getItem(next);
            switch (item.mType) {
                case 0: {
                    item.mParent = node;
                    node = nodes.get(node.mSub[item.mChild]);
                    if (node.mOrder != 0) {
                        this.sort(node, next);
                    }
                    handler.startElement(node.mNamespace, node.mName, node.mName, mEmptyAttrs);
                    break;
                }
                case 2: {
                    Item back = this.getItem(item.mChild);
                    if (back.mType != 0) {
                        throw new RuntimeException("map corrupt; leave #" + next + " has non-enter link " + item.mChild);
                    }
                    handler.endElement(node.mNamespace, node.mName, node.mName);
                    node = back.mParent;
                    break;
                }
                case 1: {
                    long skip = item.mOffset - pos;
                    if (skip < 0L) {
                        in.rewind();
                        pos = 0L;
                        skip = item.mOffset;
                    }
                    if (skip > 0L) {
                        in.skip(skip);
                    }
                    pos += skip;
                    in.read(buf, 0, item.mLength);
                    pos += (long)item.mLength;
                    Nodes.Node childNode = nodes.get(node.mSub[item.mChild]);
                    handler.startElement(childNode.mNamespace, childNode.mName, childNode.mName, mEmptyAttrs);
                    String data = decoder.decode(buf, 0, item.mLength);
                    data.getChars(0, data.length(), charBuf, 0);
                    handler.characters(charBuf, 0, data.length());
                    handler.endElement(childNode.mNamespace, childNode.mName, childNode.mName);
                    break;
                }
                default: {
                    throw new RuntimeException("unknown item type #" + item.mType);
                }
            }
            if (item.mNext < 0) {
                ++next;
                continue;
            }
            next = item.mNext;
        }
        if (root != node) {
            throw new RuntimeException("unbalanced map");
        }
        handler.endElement(node.mNamespace, node.mName, node.mName);
        handler.endPrefixMapping("xsi");
        handler.endDocument();
        this.clear();
    }

    private void sort(Nodes.Node node, int itemIdx) {
        if (this.getItem((int)itemIdx).mType != 0) {
            throw new IllegalArgumentException("Must be ENTER event");
        }
        if (node.mSub == null) {
            return;
        }
        if (this.mHead.length < node.mSub.length) {
            this.mHead = new int[node.mSub.length];
            this.mTail = new int[node.mSub.length];
        }
        Arrays.fill(this.mHead, 0, node.mSub.length, -1);
        Arrays.fill(this.mTail, 0, node.mSub.length, -1);
        int start = itemIdx;
        int enterChild = -1;
        int level = -1;
        block5: while (++itemIdx < this.mCursor) {
            Item item = this.getItem(itemIdx);
            switch (item.mType) {
                case 0: {
                    if (level == -1) {
                        enterChild = itemIdx;
                    }
                    ++level;
                    continue block5;
                }
                case 2: {
                    if (level == -1) {
                        if (item.mChild == start) break block5;
                        throw new RuntimeException("map corrupt; leave #" + start + " does not match enter link " + item.mChild);
                    }
                    if (--level != -1) continue block5;
                    if (item.mChild != enterChild) {
                        throw new RuntimeException("map corrupt; leave #" + itemIdx + " does not match enter link " + item.mChild);
                    }
                    Item childItem = this.getItem(enterChild);
                    if (this.mHead[childItem.mChild] == -1) {
                        this.mHead[childItem.mChild] = enterChild;
                        this.mTail[childItem.mChild] = itemIdx;
                        continue block5;
                    }
                    this.getItem((int)this.mTail[childItem.mChild]).mNext = enterChild;
                    this.mTail[childItem.mChild] = itemIdx;
                    continue block5;
                }
                case 1: {
                    if (level != -1) continue block5;
                    Item childItem = this.getItem(itemIdx);
                    if (this.mHead[childItem.mChild] == -1) {
                        this.mHead[childItem.mChild] = itemIdx;
                        this.mTail[childItem.mChild] = itemIdx;
                        continue block5;
                    }
                    this.getItem((int)this.mTail[childItem.mChild]).mNext = itemIdx;
                    this.mTail[childItem.mChild] = itemIdx;
                    continue block5;
                }
                default: {
                    throw new RuntimeException("unknown item type #" + item.mType);
                }
            }
        }
        int last = -1;
        for (int i = 0; i < node.mSub.length; ++i) {
            if (this.mHead[i] == -1) continue;
            if (last == -1) {
                this.getItem((int)start).mNext = this.mHead[i];
            } else {
                this.getItem((int)this.mTail[last]).mNext = this.mHead[i];
            }
            last = i;
        }
        if (last >= 0) {
            this.getItem((int)this.mTail[last]).mNext = itemIdx;
        }
    }

    public int[] last() {
        ArrayList<Integer> rev = new ArrayList<Integer>();
        int level = 0;
        int seen = 0;
        int i = this.mCursor;
        while (--i > 0) {
            Item item = this.getItem(i);
            switch (item.mType) {
                case 0: {
                    if (seen <= --level) break;
                    seen = level;
                    rev.add(new Integer(item.mIndex));
                    rev.add(new Integer(item.mChild));
                    break;
                }
                case 2: {
                    if (rev.size() == 0) {
                        rev.add(new Integer(item.mIndex));
                        rev.add(new Integer(item.mChild));
                    }
                    ++level;
                    break;
                }
                case 1: {
                    if (rev.size() != 0) break;
                    rev.add(new Integer(item.mIndex));
                    rev.add(new Integer(item.mChild));
                }
            }
        }
        int[] result = new int[rev.size()];
        int i2 = 0;
        int j = rev.size();
        while (j-- > 0) {
            result[i2] = (Integer)rev.get(j);
            ++i2;
        }
        return result;
    }

    public void print(PrintWriter out) {
        out.println("Total items: " + this.mCursor);
        block5: for (int i = 0; i < this.mCursor; ++i) {
            Item item = this.getItem(i);
            out.print("(" + i + ") ");
            switch (item.mType) {
                case 0: {
                    out.println("enter " + item.mChild + (item.mIndex < 0 ? "" : "[" + item.mIndex + "]"));
                    continue block5;
                }
                case 2: {
                    out.println("leave -> " + item.mChild);
                    continue block5;
                }
                case 1: {
                    out.println("field " + item.mChild + (item.mIndex < 0 ? "" : "[" + item.mIndex + "]") + " = " + item.mOffset + "/" + item.mLength);
                    continue block5;
                }
                default: {
                    throw new RuntimeException("unknown item type #" + item.mType);
                }
            }
        }
    }

    public Item getItem(int index) {
        return (Item)this.mItems.get(index);
    }

    private static final class EmptyAttributes
    implements Attributes {
        private EmptyAttributes() {
        }

        public int getLength() {
            return 0;
        }

        public String getURI(int index) {
            return null;
        }

        public String getLocalName(int index) {
            return null;
        }

        public String getQName(int index) {
            return null;
        }

        public String getType(int index) {
            return null;
        }

        public String getValue(int index) {
            return null;
        }

        public int getIndex(String uri, String localName) {
            return -1;
        }

        public int getIndex(String qName) {
            return -1;
        }

        public String getType(String uri, String localName) {
            return null;
        }

        public String getType(String qName) {
            return null;
        }

        public String getValue(String uri, String localName) {
            return null;
        }

        public String getValue(String qName) {
            return null;
        }
    }

    public static class Item {
        public byte mType;
        public int mChild;
        public int mIndex;
        public int mLength;
        public long mOffset;
        public Nodes.Node mParent;
        public int mNext = -1;

        public static interface Type {
            public static final byte ENTER = 0;
            public static final byte FIELD = 1;
            public static final byte LEAVE = 2;
        }
    }
}

