/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.colorchooser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.BufferedImage;
import org.netbeans.swing.colorchooser.ColorChooser;
import org.netbeans.swing.colorchooser.Palette;

final class ContinuousPalette
extends BufferedImage
implements Palette {
    public static final int SMALL_SPEC_WIDTH = 128;
    public static final int SMALL_SPEC_HEIGHT = 64;
    public static final int LARGE_SPEC_WIDTH = 200;
    public static final int LARGE_SPEC_HEIGHT = 100;
    public static final int SPEC_IMAGE_COUNT = 8;
    private boolean initialized = false;
    private float saturation = 1.0f;
    private boolean verticalHue = true;
    private float grayStripSize = 0.05f;
    private String name;
    private static Palette[] defaultPalettes = null;

    private ContinuousPalette() {
        super(128, 60, 2);
    }

    private ContinuousPalette(String string, int n, int n2) {
        super(n, n2, 2);
        this.name = string;
    }

    private ContinuousPalette(String string, int n, int n2, float f) {
        super(n, n2, 2);
        this.setSaturation(f);
        this.name = string;
    }

    private ContinuousPalette(String string, int n, int n2, float f, boolean bl) {
        super(n, n2, 2);
        this.setSaturation(f);
        this.verticalHue = bl;
        this.name = string;
    }

    protected void initImage() {
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                int n = this.getColorAt(i, j).getRGB();
                this.setRGB(i, j, n);
            }
        }
    }

    public final void initializeImage() {
        if (!this.initialized) {
            this.initImage();
        }
    }

    public void paintTo(Graphics graphics) {
        if (graphics != null) {
            this.initializeImage();
            graphics.drawImage(this, 0, 0, null);
            this.initialized = true;
        }
    }

    public Color getColorAt(int n, int n2) {
        float f;
        float f2;
        float f3;
        boolean bl;
        boolean bl2 = bl = (float)n2 / (float)this.getHeight() > 1.0f - this.grayStripSize;
        if (this.verticalHue) {
            f3 = (float)n2 / (float)this.getHeight();
            f2 = (float)n / (float)this.getWidth();
        } else {
            if (bl) {
                return this.grayValueFromX(n);
            }
            f3 = 1.0f - (float)n / (float)this.getWidth();
            f2 = 1.0f - (float)n2 / (float)this.getHeight();
        }
        f2 *= 2.0f;
        if (f2 > 1.0f) {
            f = this.saturation - (f2 - 1.0f) * this.saturation;
            f2 = 1.0f;
        } else {
            f = this.saturation;
        }
        Color color = Color.getHSBColor(f3, f, f2);
        return color;
    }

    public Color colorFromPoint(Point point) {
        int n = new Double(point.getX()).intValue();
        int n2 = new Double(point.getY()).intValue();
        return this.getColorAt(n, n2);
    }

    protected Color grayValueFromX(int n) {
        Color color = Color.getHSBColor(0.0f, 0.0f, (float)n / (float)this.getWidth());
        return color;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public void setSaturation(float f) {
        if (this.saturation != f) {
            this.saturation = f;
            this.doChange();
        }
    }

    public boolean isVerticalHue() {
        return this.verticalHue;
    }

    public void setVerticalHue(boolean bl) {
        if (this.verticalHue != bl) {
            this.verticalHue = bl;
            this.doChange();
        }
    }

    protected void doChange() {
        this.initialized = false;
    }

    public void setGrayStripSize(float f) {
        float f2 = f;
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        if (f2 != f) {
            this.grayStripSize = f;
            this.doChange();
        }
    }

    public float getGrayStripSize() {
        return this.grayStripSize;
    }

    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public String getNameAt(int n, int n2) {
        Color color = this.getColorAt(n, n2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(color.getRed());
        stringBuffer.append(",");
        stringBuffer.append(color.getGreen());
        stringBuffer.append(",");
        stringBuffer.append(color.getBlue());
        return stringBuffer.toString();
    }

    public static Palette[] createDefaultPalettes() {
        if (defaultPalettes == null) {
            defaultPalettes = new Palette[]{new ContinuousPalette("satLarge", 200, 100, 1.0f, false), new ContinuousPalette("unsatLarge", 200, 100, 0.4f, false), new ContinuousPalette("satLargeHoriz", 200, 100, 1.0f, true), new ContinuousPalette("unsatLargeHoriz", 200, 100, 0.4f, true)};
        }
        return defaultPalettes;
    }

    public String getDisplayName() {
        return ColorChooser.getString(this.name);
    }
}

