/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.colorchooser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.netbeans.swing.colorchooser.ContinuousPalette;
import org.netbeans.swing.colorchooser.NamedColor;
import org.netbeans.swing.colorchooser.Palette;
import org.netbeans.swing.colorchooser.PalettePopup;
import org.netbeans.swing.colorchooser.PredefinedPalette;
import org.netbeans.swing.colorchooser.RecentColors;

public final class ColorChooser
extends JComponent {
    private Border border = null;
    private static CCBorder ccborder = null;
    private transient Palette[] palettes = null;
    private Color color = Color.BLUE;
    private transient Color transientColor = null;
    private transient int paletteIndex = 0;
    private transient Point nextFocusPopupLocation = null;
    private transient ArrayList actionListenerList;
    public static final String PROP_COLOR = "color";
    public static final String PROP_TRANSIENT_COLOR = "transientColor";
    public static final String PROP_CONTINUOUS_PALETTE = "continuousPalette";
    private boolean continuousPalette = true;
    private JColorChooser chooser = null;

    public ColorChooser() {
        this(null);
    }

    public ColorChooser(Color color) {
        this(null, color);
    }

    public ColorChooser(Palette[] paletteArray, Color color) {
        this.setPalettes(paletteArray);
        if (color != null) {
            this.color = color;
        }
        this.enableEvents(60L);
        this.setPreferredSize(new Dimension(24, 24));
    }

    public Color getColor() {
        return this.color;
    }

    public Color getBackground() {
        return this.getColor();
    }

    public void setBackground(Color color) {
        this.setColor(color);
    }

    public void addNotify() {
        super.addNotify();
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void removeNotify() {
        ToolTipManager.sharedInstance().unregisterComponent(this);
        super.removeNotify();
    }

    public void setColor(Color color) {
        if (this.color != null && !this.color.equals(color) || this.color == null && color != null) {
            Color color2 = this.color;
            this.color = color;
            this.repaint();
            this.firePropertyChange(PROP_COLOR, color2, color);
        }
    }

    void setTransientColor(Color color) {
        Color color2 = this.transientColor;
        this.transientColor = color;
        this.firePropertyChange(PROP_TRANSIENT_COLOR, color2, color);
        this.repaint();
    }

    public Color getTransientColor() {
        return this.transientColor;
    }

    public void setContinuousPalettePreferred(boolean bl) {
        if (bl != this.continuousPalette) {
            this.continuousPalette = bl;
            this.setPalettes(null);
            this.firePropertyChange(PROP_CONTINUOUS_PALETTE, !bl, bl);
        }
    }

    public void paintComponent(Graphics graphics) {
        Color color = this.transientColor != null ? this.transientColor : this.getColor();
        graphics.setColor(color);
        graphics.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        if (this.hasFocus()) {
            graphics.setColor(ColorChooser.invertColor(color));
            graphics.drawRect(4, 4, this.getWidth() - 8, this.getHeight() - 8);
        }
    }

    public String getToolTipText() {
        String string = super.getToolTipText();
        if (string == null) {
            return ColorChooser.getString("tip");
        }
        return super.getToolTipText();
    }

    public void setPalettes(Palette[] paletteArray) {
        if (paletteArray != null && paletteArray.length != 8) {
            throw new IllegalArgumentException("Must be 8 palettes");
        }
        Palette[] paletteArray2 = this.palettes;
        if (paletteArray == null) {
            Palette[] paletteArray3 = this.continuousPalette ? ContinuousPalette.createDefaultPalettes() : PredefinedPalette.createDefaultPalettes();
            Palette[] paletteArray4 = !this.continuousPalette ? ContinuousPalette.createDefaultPalettes() : PredefinedPalette.createDefaultPalettes();
            paletteArray = new Palette[paletteArray4.length + paletteArray3.length];
            System.arraycopy(paletteArray3, 0, paletteArray, 0, 4);
            System.arraycopy(paletteArray4, 0, paletteArray, 4, 4);
        }
        this.palettes = paletteArray;
        this.firePropertyChange("palettes", paletteArray2, paletteArray);
    }

    public Palette[] getPalettes() {
        Palette[] paletteArray = new Palette[this.palettes.length];
        System.arraycopy(this.palettes, 0, paletteArray, 0, this.palettes.length);
        return paletteArray;
    }

    public void setBorder(Border border) {
        Border border2 = this.getBorder();
        super.setBorder(border);
        this.firePropertyChange("border", border2, border);
    }

    public Border getBorder() {
        if (this.border == null) {
            return ColorChooser.getCCBorder();
        }
        return super.getBorder();
    }

    private void initPaletteIndex(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiersEx();
        this.paletteIndex = (n & 0x40) != 0 ? 1 : 0;
        this.paletteIndex += (n & 0x80) != 0 ? 2 : 0;
        this.paletteIndex += (n & 0x200) != 0 ? 4 : 0;
        this.checkRange();
    }

    private void checkRange() {
        if (this.paletteIndex >= this.getPalettes().length) {
            this.paletteIndex = this.getPalettes().length - 1;
        }
    }

    private void updatePaletteIndex(int n, boolean bl) {
        int n2 = this.paletteIndex;
        int n3 = this.paletteIndex;
        n3 = bl ? (n3 |= n) : (n3 ^= n);
        if (n2 != n3 && PalettePopup.getDefault().isPopupVisible(this)) {
            this.paletteIndex = n3;
            this.checkRange();
            PalettePopup.getDefault().setPalette(this.getPalettes()[this.paletteIndex]);
        }
    }

    private static final int keyMaskFromEvent(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        int n2 = n == 16 ? 1 : 0;
        n2 += n == 17 ? 2 : 0;
        return n2 += n == 18 ? 4 : 0;
    }

    private int getPaletteIndex() {
        return this.paletteIndex;
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (!mouseEvent.isPopupTrigger()) {
            if (mouseEvent.getID() == 501) {
                Point point = mouseEvent.getPoint();
                SwingUtilities.convertPointToScreen(point, this);
                this.initPaletteIndex(mouseEvent);
                PalettePopup.getDefault().setPalette(this.getPalettes()[this.getPaletteIndex()]);
                if (!this.hasFocus()) {
                    this.nextFocusPopupLocation = point;
                    this.requestFocus();
                    return;
                }
                PalettePopup.getDefault().showPopup(this, point);
                mouseEvent.consume();
            } else if (mouseEvent.getID() == 502) {
                this.nextFocusPopupLocation = null;
                if (PalettePopup.getDefault().isPopupVisible(this)) {
                    PalettePopup.getDefault().hidePopup(this);
                    if (this.transientColor != null) {
                        this.setColor(new Color(this.transientColor.getRed(), this.transientColor.getGreen(), this.transientColor.getBlue()));
                        RecentColors.getDefault().add(this.transientColor);
                        this.transientColor = null;
                        this.fireActionPerformed(new ActionEvent(this, 1001, PROP_COLOR));
                        mouseEvent.consume();
                    }
                }
            }
        }
        this.nextFocusPopupLocation = null;
    }

    static String getString(String string) {
        String string2 = "org.netbeans.swing.colorchooser.Bundle";
        try {
            return ResourceBundle.getBundle(string2).getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    public static NamedColor getColorName(Color color) {
        RecentColors.getDefault();
        NamedColor namedColor = RecentColors.findNamedColor(color);
        return namedColor;
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (focusEvent.getID() == 1004 && this.nextFocusPopupLocation != null) {
            PalettePopup.getDefault().showPopup(this, this.nextFocusPopupLocation);
        }
        this.nextFocusPopupLocation = null;
        this.repaint();
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        block3: {
            block6: {
                block5: {
                    block4: {
                        block2: {
                            super.processKeyEvent(keyEvent);
                            if (keyEvent.getID() == 401) break block2;
                            if (keyEvent.getID() != 402) break block3;
                        }
                        boolean bl = keyEvent.getID() == 401;
                        this.updatePaletteIndex(ColorChooser.keyMaskFromEvent(keyEvent), bl);
                        if (keyEvent.getKeyCode() == 18) break block4;
                        if (keyEvent.getKeyCode() == 17) break block4;
                        if (keyEvent.getKeyCode() != 16) break block5;
                    }
                    keyEvent.consume();
                    break block3;
                }
                if (keyEvent.getKeyCode() == 32) break block6;
                if (keyEvent.getKeyCode() != 10 || keyEvent.getID() != 402) break block3;
            }
            this.keyboardInvoke();
        }
    }

    private static final Border getCCBorder() {
        if (ccborder == null) {
            ccborder = new CCBorder();
        }
        return ccborder;
    }

    private static final Color invertColor(Color color) {
        int n = ColorChooser.checkRange(255 - color.getRed());
        int n2 = ColorChooser.checkRange(255 - color.getGreen());
        int n3 = ColorChooser.checkRange(255 - color.getBlue());
        return new Color(n, n2, n3);
    }

    private static final int checkRange(int n) {
        int n2 = n;
        if (Math.abs(128 - n) < 24) {
            n2 = Math.abs(128 - n);
        }
        return n2;
    }

    private static final Color darken(Color color) {
        int n = 30;
        int n2 = ColorChooser.minMax(color.getRed() - n);
        int n3 = ColorChooser.minMax(color.getGreen() - n);
        int n4 = ColorChooser.minMax(color.getGreen() - n);
        return new Color(n2, n3, n4);
    }

    private static final Color brighten(Color color) {
        int n = 30;
        int n2 = ColorChooser.minMax(color.getRed() + n);
        int n3 = ColorChooser.minMax(color.getGreen() + n);
        int n4 = ColorChooser.minMax(color.getGreen() + n);
        return new Color(n2, n3, n4);
    }

    private static final int minMax(int n) {
        return Math.min(255, Math.max(0, n));
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        final JLabel jLabel = new JLabel("Choose a color (combine Shift/Ctrl/Alt to switch palettes)");
        final ColorChooser colorChooser = new ColorChooser();
        colorChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jLabel.setForeground(colorChooser.getColor());
            }
        });
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().setLayout(new FlowLayout());
        jFrame.getContentPane().add(colorChooser);
        jLabel.setBorder(null);
        jFrame.getContentPane().add(jLabel);
        jFrame.setSize(500, 160);
        jFrame.setLocation(20, 20);
        jFrame.show();
        colorChooser.requestFocus();
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        if (this.actionListenerList == null) {
            this.actionListenerList = new ArrayList();
        }
        this.actionListenerList.add(actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        if (this.actionListenerList != null) {
            this.actionListenerList.remove(actionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActionPerformed(ActionEvent actionEvent) {
        ArrayList arrayList;
        ColorChooser colorChooser = this;
        synchronized (colorChooser) {
            if (this.actionListenerList == null) {
                return;
            }
            arrayList = (ArrayList)this.actionListenerList.clone();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            ((ActionListener)arrayList.get(i)).actionPerformed(actionEvent);
        }
    }

    private void keyboardInvoke() {
        if (this.chooser != null) {
            return;
        }
        this.chooser = new JColorChooser();
        this.chooser.setColor(this.getColor());
        Color color = JColorChooser.showDialog(this, ColorChooser.getString("chooseColor"), this.getColor());
        if (color != null) {
            this.setColor(color);
            this.fireActionPerformed(new ActionEvent(this, 1001, PROP_COLOR));
        }
        this.chooser = null;
    }

    private static class CCBorder
    implements Border {
        private CCBorder() {
        }

        public Insets getBorderInsets(Component component) {
            Insets insets = UIManager.getLookAndFeel() instanceof MetalLookAndFeel ? new Insets(2, 2, 1, 1) : new Insets(1, 1, 1, 1);
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color;
            ColorChooser colorChooser = (ColorChooser)component;
            Color color2 = color = colorChooser.transientColor == null ? colorChooser.getColor() : colorChooser.transientColor;
            if (colorChooser == null && (color = component.getBackground()) == null) {
                color = Color.BLACK;
            }
            if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
                graphics.setColor(ColorChooser.darken(color));
                graphics.drawLine(n, n2, n + n3 - 1, n2);
                graphics.drawLine(n, n2, n, n2 + n4 - 1);
                graphics.drawLine(n + n3 - 1, n2 + n4 - 1, n, n2 + n4 - 1);
                graphics.drawLine(n + n3 - 1, n2 + n4 - 1, n + n3 - 1, n2);
                graphics.setColor(ColorChooser.brighten(color));
                graphics.drawLine(n + n3 - 2, n2 + n4 - 2, n + 1, n2 + n4 - 2);
                graphics.drawLine(n + n3 - 2, n2 + n4 - 2, n + n3 - 2, n2 + 1);
            } else {
                graphics.setColor(ColorChooser.darken(color));
                graphics.drawLine(n + n3 - 1, n2 + n4 - 1, n, n2 + n4 - 1);
                graphics.drawLine(n + n3 - 1, n2 + n4 - 1, n + n3 - 1, n2);
                graphics.setColor(ColorChooser.brighten(color));
                graphics.drawLine(n, n2, n + n3 - 1, n2);
                graphics.drawLine(n, n2, n, n2 + n4 - 1);
            }
        }
    }
}

