/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.Util;
import org.rubyforge.debugcommons.model.RubyDebugTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RubyDebuggerFactory {
    private static final String CLASSIC_DEBUG_NAME = "classic-debug.rb";
    private static final String CLASSIC_VERBOSE_DEBUG_NAME = "classic-debug-verbose.rb";
    private static final int DEFAULT_PORT = 1098;

    public static RubyDebuggerProxy startClassicDebugger(Descriptor descriptor, String pathToClassicDebugDir, String interpreter, int timeout) throws IOException, RubyDebuggerException {
        descriptor.setType(RubyDebuggerProxy.CLASSIC_DEBUGGER);
        ArrayList<String> args = new ArrayList<String>();
        args.add(interpreter);
        args.addAll(descriptor.getAddtionalOptions());
        args.add("-I");
        args.add(pathToClassicDebugDir);
        if (!descriptor.defaultPortUsed() && descriptor.getPort() != -1) {
            try {
                String path = RubyDebuggerFactory.createRemoteDebugPortFile(descriptor.getPort());
                args.add("-r");
                args.add(path);
            }
            catch (IOException e) {
                Util.severe("Could not create 'RemoteDebugPortFile'. Using default port.", e);
            }
        }
        RubyDebuggerFactory.appendIOSynchronizer(args, descriptor);
        args.add("-r");
        args.add(descriptor.isVerbose() ? CLASSIC_VERBOSE_DEBUG_NAME : CLASSIC_DEBUG_NAME);
        args.add(descriptor.getScriptPath());
        if (descriptor.getScriptArguments() != null) {
            args.addAll(Arrays.asList(descriptor.getScriptArguments()));
        }
        return RubyDebuggerFactory.startDebugger(descriptor, args, timeout);
    }

    public static RubyDebuggerProxy startClassicDebugger(Descriptor descriptor, String pathToClassicDebugDir, String interpreter) throws IOException, RubyDebuggerException {
        return RubyDebuggerFactory.startClassicDebugger(descriptor, pathToClassicDebugDir, interpreter, 10);
    }

    public static RubyDebuggerProxy startRubyDebug(Descriptor descriptor, String rdebugExecutable, String interpreter, int timeout) throws IOException, RubyDebuggerException {
        descriptor.setType(RubyDebuggerProxy.RUBY_DEBUG);
        ArrayList<String> args = new ArrayList<String>();
        if (interpreter != null) {
            args.add(interpreter);
            RubyDebuggerFactory.appendIOSynchronizer(args, descriptor);
        }
        args.addAll(descriptor.getAddtionalOptions());
        args.add(rdebugExecutable);
        args.add("-p");
        args.add(String.valueOf(descriptor.getPort()));
        if (descriptor.isVerbose()) {
            args.add("-d");
        }
        args.add("--");
        args.add(descriptor.getScriptPath());
        if (descriptor.getScriptArguments() != null) {
            args.addAll(Arrays.asList(descriptor.getScriptArguments()));
        }
        return RubyDebuggerFactory.startDebugger(descriptor, args, timeout);
    }

    private static RubyDebuggerProxy startDebugger(Descriptor desc, List<String> args, int timeout) throws IOException, RubyDebuggerException {
        Util.fine("Running [basedir: " + desc.getBaseDirectory() + "]: \"" + RubyDebuggerFactory.getProcessAsString(args) + "\"");
        ProcessBuilder pb = new ProcessBuilder(args);
        pb.directory(desc.getBaseDirectory());
        if (desc.getEnvironment() != null) {
            pb.environment().putAll(desc.getEnvironment());
        }
        RubyDebuggerProxy proxy = new RubyDebuggerProxy(desc.getType(), timeout);
        RubyDebugTarget target = new RubyDebugTarget(proxy, pb.start(), desc.getPort(), desc.getScriptPath(), desc.getBaseDirectory());
        proxy.connect(target);
        RubyDebuggerProxy.PROXIES.add(proxy);
        return proxy;
    }

    private static String createRemoteDebugPortFile(int port) throws IOException {
        File debugParameterFile = File.createTempFile("classic-debug", ".rb");
        debugParameterFile.deleteOnExit();
        FileWriter fWriter = new FileWriter(debugParameterFile);
        new PrintWriter(fWriter).println("$RemoteDebugPort=" + port);
        fWriter.close();
        return debugParameterFile.getCanonicalPath();
    }

    private static String createIOSynchronizer() throws IOException {
        File ioSynchronizer = File.createTempFile("io-synchronizer", ".rb");
        ioSynchronizer.deleteOnExit();
        FileWriter fWriter = new FileWriter(ioSynchronizer);
        PrintWriter pwWriter = new PrintWriter(fWriter);
        pwWriter.println("$stdout.sync=true");
        pwWriter.println("$stderr.sync=true");
        fWriter.close();
        return ioSynchronizer.getCanonicalPath();
    }

    private static void appendIOSynchronizer(List<? super String> args, Descriptor descriptor) throws IOException {
        if (descriptor.isSynchronizedOutput()) {
            String path = RubyDebuggerFactory.createIOSynchronizer();
            args.add("-r");
            args.add(path);
        }
    }

    private static String getProcessAsString(List<? extends String> process) {
        StringBuilder sb = new StringBuilder();
        for (String string : process) {
            sb.append(string).append(' ');
        }
        return sb.toString().trim();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Descriptor {
        private int coputedPort = -1;
        private RubyDebuggerProxy.DebuggerType type;
        private boolean verbose;
        private boolean useDefaultPort;
        private String scriptPath;
        private File baseDir;
        private String[] scriptArguments;
        private Map<String, String> environment;
        private boolean synchronizedOutput;
        private Collection<? extends String> additionalOptions;

        public RubyDebuggerProxy.DebuggerType getType() {
            return this.type;
        }

        public void setType(RubyDebuggerProxy.DebuggerType type) {
            this.type = type;
        }

        public boolean isVerbose() {
            return this.verbose || Boolean.getBoolean("org.rubyforge.debugcommons.verbose");
        }

        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }

        public boolean defaultPortUsed() {
            return this.useDefaultPort;
        }

        public void useDefaultPort(boolean useDefaultPort) {
            this.useDefaultPort = useDefaultPort;
        }

        public String getScriptPath() {
            return this.scriptPath;
        }

        public void setScriptPath(String scriptPath) {
            this.scriptPath = scriptPath;
        }

        public void setBaseDirectory(File baseDir) {
            this.baseDir = baseDir;
        }

        public File getBaseDirectory() {
            return this.baseDir != null ? this.baseDir : new File(this.getScriptPath()).getParentFile();
        }

        public String[] getScriptArguments() {
            return this.scriptArguments;
        }

        public void setScriptArguments(String[] scriptArguments) {
            this.scriptArguments = scriptArguments;
        }

        public Map<String, String> getEnvironment() {
            return this.environment;
        }

        public void setEnvironment(Map<String, String> environment) {
            this.environment = environment;
        }

        public boolean isSynchronizedOutput() {
            return this.synchronizedOutput;
        }

        public void setSynchronizedOutput(boolean synchronizedOutput) {
            this.synchronizedOutput = synchronizedOutput;
        }

        public Collection<? extends String> getAddtionalOptions() {
            return this.additionalOptions == null ? Collections.emptySet() : this.additionalOptions;
        }

        public void setAdditionalOptions(Collection<? extends String> additionalOptions) {
            this.additionalOptions = additionalOptions;
        }

        int getPort() {
            if (this.coputedPort == -1) {
                this.coputedPort = this.defaultPortUsed() ? 1098 : Util.findFreePort();
            }
            return this.coputedPort;
        }
    }
}

