/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.util;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.primitives.ArrayIntList;
import org.apache.commons.collections.primitives.IntList;
import org.apache.commons.collections.primitives.IntListIterator;

public class IntListIteratorChain
implements IntListIterator {
    private List _listOfIterators = new ArrayList();
    private IntList _tempList = null;
    private boolean _tempValueSet = false;
    private int _tempValue;
    private IntListIterator _currentIterator = null;
    private ListIterator _iteratorOverIterators = null;
    private int _nextIndex = 0;

    public void addIterator(IntListIterator iter) {
        this.assertNotStarted();
        this.addTempListIfNeeded();
        this._listOfIterators.add(iter);
    }

    public void addIterator(int value) {
        this.assertNotStarted();
        this.addToTempList(value);
    }

    public boolean hasNext() {
        this.ensureStarted();
        if (this._currentIterator != null && this._currentIterator.hasNext()) {
            return true;
        }
        if (this._iteratorOverIterators.hasNext()) {
            this._currentIterator = (IntListIterator)this._iteratorOverIterators.next();
            return this.hasNext();
        }
        return false;
    }

    public boolean hasPrevious() {
        this.ensureStarted();
        if (this._currentIterator != null && this._currentIterator.hasPrevious()) {
            return true;
        }
        if (this._iteratorOverIterators.hasPrevious()) {
            this._currentIterator = (IntListIterator)this._iteratorOverIterators.previous();
            return this.hasPrevious();
        }
        return false;
    }

    public int next() {
        if (this.hasNext()) {
            ++this._nextIndex;
            return this._currentIterator.next();
        }
        throw new NoSuchElementException();
    }

    public int previous() {
        if (this.hasPrevious()) {
            --this._nextIndex;
            return this._currentIterator.previous();
        }
        throw new NoSuchElementException();
    }

    public void add(int elt) {
        throw new UnsupportedOperationException();
    }

    public int nextIndex() {
        return this._nextIndex;
    }

    public int previousIndex() {
        return this._nextIndex - 1;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void set(int elt) {
        throw new UnsupportedOperationException();
    }

    private void assertNotStarted() throws IllegalStateException {
        if (null != this._iteratorOverIterators) {
            throw new IllegalStateException("Already started iterating");
        }
    }

    private void ensureStarted() {
        if (null == this._iteratorOverIterators) {
            this.addTempListIfNeeded();
            this._iteratorOverIterators = this._listOfIterators.listIterator();
        }
    }

    private final void addTempListIfNeeded() {
        if (null != this._tempList) {
            this._listOfIterators.add(this._tempList.listIterator());
            this._tempList = null;
        } else if (this._tempValueSet) {
            this._listOfIterators.add(new SingleElementIntListIterator(this._tempValue));
            this._tempValueSet = false;
        }
    }

    private final void addToTempList(int value) {
        if (null == this._tempList) {
            if (!this._tempValueSet) {
                this._tempValue = value;
                this._tempValueSet = true;
            } else {
                this._tempList = new ArrayIntList(2);
                this._tempList.add(this._tempValue);
                this._tempList.add(value);
                this._tempValueSet = false;
            }
        } else {
            this._tempList.add(value);
        }
    }

    private final class SingleElementIntListIterator
    implements IntListIterator {
        private boolean _before = true;
        private int _value = 0;

        public SingleElementIntListIterator(int value) {
            this._value = value;
        }

        public boolean hasNext() {
            return this._before;
        }

        public boolean hasPrevious() {
            return !this._before;
        }

        public int next() {
            if (this._before) {
                this._before = false;
                return this._value;
            }
            throw new NoSuchElementException();
        }

        public int nextIndex() {
            return this._before ? 0 : 1;
        }

        public int previous() {
            if (!this._before) {
                this._before = true;
                return this._value;
            }
            throw new NoSuchElementException();
        }

        public int previousIndex() {
            return this._before ? -1 : 0;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(int arg0) {
            throw new UnsupportedOperationException();
        }

        public void add(int arg0) {
            throw new UnsupportedOperationException();
        }
    }
}

