/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import org.axiondb.AxionException;
import org.axiondb.io.BufferedDataInputStream;
import org.axiondb.types.FileOffsetLobSource;
import org.axiondb.types.LobLocator;
import org.axiondb.types.LobSource;

public class FileOffsetLobLocator
implements LobLocator {
    private transient long _offset = -1L;
    private transient int _length = -1;

    public FileOffsetLobLocator(long offset, int length) {
        this._offset = offset;
        this._length = length;
    }

    public LobSource getLobSource(File parentDir, BufferedDataInputStream in) throws AxionException {
        return new FileOffsetLobSource(in, this._offset, this._length);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this._offset);
        buf.append(";");
        buf.append(this._length);
        return buf.toString();
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this._offset);
        out.writeInt(this._length);
    }

    public LobLocator read(DataInput in) throws IOException {
        return new FileOffsetLobLocator(in.readLong(), in.readInt());
    }
}

