/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Comparator;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.types.BaseNumberDataType;

public class DoubleType
extends BaseNumberDataType {
    private static final long serialVersionUID = -831981915887585231L;
    private static final long EXP_MANTISSA_MASK = Long.MAX_VALUE;
    private static final long EXP_MANTISSA_MAX = 0x7FEFFFFFFFFFFFFFL;
    private static final long SIGN_MASK = Long.MIN_VALUE;
    private static final long SIGN_NEGATIVE = Long.MIN_VALUE;

    public int getJdbcType() {
        return 8;
    }

    public String getPreferredValueClassName() {
        return "java.lang.Double";
    }

    public int getPrecision() {
        return String.valueOf(Double.MAX_VALUE).length();
    }

    public int getPrecisionRadix() {
        return 10;
    }

    public int getScale() {
        return 0;
    }

    public int getColumnDisplaySize() {
        return String.valueOf(Double.MAX_VALUE).length();
    }

    public String toString() {
        return "double";
    }

    public Object convert(Object value) throws AxionException {
        BigDecimal bdValue = null;
        if (value instanceof Double) {
            double doubleValue = ((Number)value).doubleValue();
            if (Double.isInfinite(doubleValue) || Double.isNaN(doubleValue)) {
                throw new AxionException(22003);
            }
            return value;
        }
        if (value instanceof BigDecimal) {
            bdValue = (BigDecimal)value;
        } else {
            if (value instanceof Number) {
                return new Double(((Number)value).doubleValue());
            }
            if (value instanceof String) {
                try {
                    bdValue = new BigDecimal(value.toString().trim());
                }
                catch (NumberFormatException e) {
                    throw new AxionException(22018);
                }
            } else {
                return super.convert(value);
            }
        }
        this.assertValueInRange(bdValue);
        return new Double(bdValue.doubleValue());
    }

    public Object read(DataInput in) throws IOException {
        double value = in.readDouble();
        if (Double.MIN_VALUE == value && !in.readBoolean()) {
            return null;
        }
        return new Double(value);
    }

    public boolean supportsSuccessor() {
        return true;
    }

    public Object successor(Object value) throws IllegalArgumentException {
        Double obj = (Double)value;
        double v = obj;
        if (Double.MAX_VALUE == v) {
            return value;
        }
        long ieee754Bits = Double.doubleToLongBits(v);
        long sign = ieee754Bits & Long.MIN_VALUE;
        boolean isNegative = Long.MIN_VALUE == sign;
        long accumExpMantissa = ieee754Bits & Long.MAX_VALUE;
        if (isNegative) {
            if (0L != accumExpMantissa) {
                --accumExpMantissa;
            } else {
                sign = 0L;
                accumExpMantissa = 0L;
            }
        } else {
            accumExpMantissa = 0L != accumExpMantissa ? ++accumExpMantissa : 1L;
        }
        return new Double(Double.longBitsToDouble(sign | accumExpMantissa));
    }

    public void write(Object value, DataOutput out) throws IOException {
        if (null == value) {
            out.writeDouble(Double.MIN_VALUE);
            out.writeBoolean(false);
        } else {
            try {
                double val = (Double)this.convert(value);
                out.writeDouble(val);
                if (Double.MIN_VALUE == val) {
                    out.writeBoolean(true);
                }
            }
            catch (AxionException e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    public DataType makeNewInstance() {
        return new DoubleType();
    }

    public int compare(Object a, Object b) {
        double pb;
        double pa = ((Number)a).doubleValue();
        return pa < (pb = ((Number)b).doubleValue()) ? -1 : (pa == pb ? 0 : 1);
    }

    protected Comparator getComparator() {
        return this;
    }

    private void assertValueInRange(BigDecimal bdValue) throws AxionException {
        long expMantissa = Double.doubleToLongBits(bdValue.doubleValue()) & Long.MAX_VALUE;
        if (expMantissa > 0x7FEFFFFFFFFFFFFFL) {
            throw new AxionException(22003);
        }
    }
}

