/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.jdbc;

import java.io.File;
import java.sql.Connection;
import org.axiondb.AxionException;
import org.axiondb.jdbc.AxionConnection;

public abstract class ConnectionFactory {
    public static final String URL_PREFIX = "jdbc:axiondb:";

    protected boolean isValidConnectString(String url) {
        return url != null && url.startsWith(URL_PREFIX);
    }

    protected Connection createConnection(String url) throws AxionException {
        String name = null;
        File path = null;
        String prefixStripped = url.substring(URL_PREFIX.length());
        int colon = prefixStripped.indexOf(":");
        if (colon == -1 || prefixStripped.length() - 1 == colon) {
            name = prefixStripped;
        } else {
            name = prefixStripped.substring(0, colon);
            path = new File(prefixStripped.substring(colon + 1));
        }
        return new AxionConnection(name, path, url);
    }
}

