/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.RowDecorator;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.StringType;

public class ReplaceFunction
extends BaseFunction
implements ScalarFunction,
FunctionFactory {
    private static final DataType STRING_TYPE = new StringType();

    public ReplaceFunction() {
        super("REPLACE");
    }

    public ConcreteFunction makeNewInstance() {
        return new ReplaceFunction();
    }

    public DataType getDataType() {
        return STRING_TYPE;
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        Object val = this.getArgument(0).evaluate(row);
        Object val1 = this.getArgument(1).evaluate(row);
        if (val == null || val1 == null) {
            return val;
        }
        String s1 = (String)STRING_TYPE.convert(val);
        String s2 = (String)STRING_TYPE.convert(val1);
        int i2 = s2.length();
        if (this.getArgumentCount() == 3) {
            Object val2 = this.getArgument(2).evaluate(row);
            String s3 = (String)STRING_TYPE.convert(val2);
            return this.replacedString(s1, s2, s3, i2);
        }
        return this.replacedString(s1, s2, "", i2);
    }

    private String replacedString(String s1, String s2, String s3, int i2) {
        int i0 = s1.indexOf(s2);
        if (i0 != -1) {
            s1 = s1.substring(0, i0) + s3 + s1.substring(i0 + i2);
            s1 = this.replacedString(s1, s2, s3, i2);
        }
        return s1;
    }

    public boolean isValid() {
        return this.getArgumentCount() >= 2 && this.getArgumentCount() < 4;
    }
}

