/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import java.sql.Timestamp;
import java.util.Calendar;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.RowDecorator;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.IntegerType;
import org.axiondb.types.StringType;
import org.axiondb.types.TimestampType;
import org.axiondb.util.DateTimeUtils;

public class DateDiffFunction
extends BaseFunction
implements ScalarFunction,
FunctionFactory {
    private static final DataType RETURN_TYPE = new IntegerType();
    private static final DataType STRING_TYPE = new StringType();
    private static final DataType TIMESTAMP_TYPE = new TimestampType();
    private static final int SECONDS_IN_MILLISECOND = 1000;
    private static final int MINUTES_IN_MILLISECOND = 60000;
    private static final int HOURS_IN_MILLISECOND = 3600000;
    private static final int DAYS_IN_MILLISECOND = 86400000;

    public DateDiffFunction() {
        super("DATEDIFF");
    }

    public ConcreteFunction makeNewInstance() {
        return new DateDiffFunction();
    }

    public DataType getDataType() {
        return RETURN_TYPE;
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        int intervalType = DateTimeUtils.labelToCode((String)STRING_TYPE.convert(this.getArgument(0).evaluate(row)));
        Timestamp timestamp1 = null;
        Object val1 = this.getArgument(1).evaluate(row);
        timestamp1 = (Timestamp)TIMESTAMP_TYPE.convert(val1);
        Timestamp timestamp2 = null;
        Object val2 = this.getArgument(2).evaluate(row);
        timestamp2 = (Timestamp)TIMESTAMP_TYPE.convert(val2);
        if (timestamp1 == null || timestamp2 == null) {
            return null;
        }
        return new Long(this.calculateDateDiff(intervalType, timestamp1, timestamp2));
    }

    long calculateDateDiff(int intervalType, Timestamp t1, Timestamp t2) throws AxionException {
        Calendar c1 = null;
        Calendar c2 = null;
        if (intervalType == 16 || intervalType == 32 || intervalType == 64 || intervalType == 128 || intervalType == 256) {
            c1 = Calendar.getInstance(TimestampType.getTimeZone());
            c2 = Calendar.getInstance(TimestampType.getTimeZone());
            c1.setTimeInMillis(t1.getTime());
            c2.setTimeInMillis(t2.getTime());
        }
        switch (intervalType) {
            default: {
                return this.getMilisecondsBetween(t2, t1);
            }
            case 2: {
                return this.getSecondsBetween(t2, t1);
            }
            case 4: {
                return this.getMinutesBetween(t2, t1);
            }
            case 8: {
                return this.getHoursBetween(t2, t1);
            }
            case 16: {
                return this.getDaysBetween(t2, t1);
            }
            case 32: {
                return this.getWeeksBetween(c2, c1);
            }
            case 64: {
                return this.getMonthsBetween(c2, c1);
            }
            case 128: {
                return this.getQuartersBetween(c2, c1);
            }
            case 256: 
        }
        return this.getYearsBetween(c2, c1);
    }

    private long getYearsBetween(Calendar d1, Calendar d2) {
        boolean negativeResult = false;
        if (d1.after(d2)) {
            Calendar swap = d1;
            d1 = d2;
            d2 = swap;
        } else {
            negativeResult = true;
        }
        long years = d2.get(1) - d1.get(1);
        if (negativeResult) {
            years *= -1L;
        }
        return years;
    }

    private long getQuartersBetween(Calendar d1, Calendar d2) {
        long quarters = this.getMonthsBetween(d1, d2) / 3L;
        return quarters;
    }

    private long getMonthsBetween(Calendar d1, Calendar d2) {
        boolean negativeResult = false;
        if (d1.after(d2)) {
            Calendar swap = d1;
            d1 = d2;
            d2 = swap;
        } else {
            negativeResult = true;
        }
        long months = d2.get(2) - d1.get(2);
        int y2 = d2.get(1);
        if (d1.get(1) != y2) {
            d1 = (Calendar)d1.clone();
            do {
                months += 12L;
                d1.add(1, 1);
            } while (d1.get(1) != y2);
        }
        if (negativeResult) {
            months *= -1L;
        }
        return months;
    }

    private long getWeeksBetween(Calendar d1, Calendar d2) {
        boolean negativeResult = false;
        if (d1.after(d2)) {
            Calendar swap = d1;
            d1 = d2;
            d2 = swap;
        } else {
            negativeResult = true;
        }
        long days = d2.get(3) - d1.get(3);
        int y2 = d2.get(1);
        if (d1.get(1) != y2) {
            d1 = (Calendar)d1.clone();
            do {
                days += (long)d1.getActualMaximum(3);
                d1.add(1, 1);
            } while (d1.get(1) != y2);
        }
        if (negativeResult) {
            days *= -1L;
        }
        return days;
    }

    private long getDaysBetween(Timestamp t1, Timestamp t2) {
        long days = (t1.getTime() - t2.getTime()) / 86400000L;
        return days;
    }

    private long getHoursBetween(Timestamp t1, Timestamp t2) {
        long hours = (t1.getTime() - t2.getTime()) / 3600000L;
        return hours;
    }

    private long getMinutesBetween(Timestamp t1, Timestamp t2) {
        long seconds = (t1.getTime() - t2.getTime()) / 60000L;
        return seconds;
    }

    private long getSecondsBetween(Timestamp t1, Timestamp t2) {
        long seconds = (t1.getTime() - t2.getTime()) / 1000L;
        return seconds;
    }

    private long getMilisecondsBetween(Timestamp t1, Timestamp t2) {
        long milliseconds = t1.getTime() - t2.getTime();
        return milliseconds;
    }

    public boolean isValid() {
        return this.getArgumentCount() == 3;
    }
}

