/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.RowDecorator;
import org.axiondb.Selectable;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.CharacterType;

public class CharFunction
extends BaseFunction
implements ScalarFunction,
FunctionFactory {
    private static final DataType CHAR_TYPE = new CharacterType();

    public CharFunction() {
        super("CHAR");
    }

    public ConcreteFunction makeNewInstance() {
        return new CharFunction();
    }

    public DataType getDataType() {
        return CHAR_TYPE;
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        Selectable sel = this.getArgument(0);
        Object val = sel.evaluate(row);
        if (null == val) {
            return null;
        }
        return new Character((char)sel.getDataType().toInt(val));
    }

    public boolean isValid() {
        return this.getArgumentCount() == 1;
    }
}

