/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.RowDecorator;
import org.axiondb.Selectable;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.IntegerType;
import org.axiondb.util.ValuePool;

public class AsciiFunction
extends BaseFunction
implements ScalarFunction,
FunctionFactory {
    private static final DataType RETURN_TYPE = new IntegerType();

    public AsciiFunction() {
        super("ASCII");
    }

    public ConcreteFunction makeNewInstance() {
        return new AsciiFunction();
    }

    public DataType getDataType() {
        return RETURN_TYPE;
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        Selectable sel = this.getArgument(0);
        Object val = sel.evaluate(row);
        String intVal = sel.getDataType().toString(val);
        if (null == intVal) {
            return null;
        }
        return ValuePool.getInt(intVal.charAt(0));
    }

    public boolean isValid() {
        return this.getArgumentCount() == 1;
    }
}

