/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.visitors;

import java.util.HashSet;
import java.util.List;
import org.axiondb.AxionException;
import org.axiondb.ColumnIdentifier;
import org.axiondb.Literal;
import org.axiondb.OrderNode;
import org.axiondb.engine.commands.SubSelectCommand;
import org.axiondb.functions.ConcreteFunction;

public class AmbiguousColumnReferenceVisitor {
    public void visit(List selectList, List referenceColumns) throws AxionException {
        int I = referenceColumns.size();
        for (int i = 0; i < I; ++i) {
            String refCol = this.getResolvedColumnName(referenceColumns.get(i));
            HashSet<String> colidset = new HashSet<String>();
            int J = selectList.size();
            for (int j = 0; j < J; ++j) {
                Object col = selectList.get(j);
                String colname = this.getResolvedColumnName(col);
                if (colidset.contains(colname) && !(col instanceof Literal)) {
                    throw new AxionException(42705);
                }
                if (!refCol.equals(colname)) continue;
                colidset.add(colname);
            }
        }
    }

    private String getResolvedColumnName(Object obj) {
        String colName = null;
        if (obj instanceof ColumnIdentifier) {
            ColumnIdentifier col = (ColumnIdentifier)obj;
            colName = col.getAlias();
            if (colName == null) {
                colName = col.getName();
            }
        } else if (obj instanceof ConcreteFunction) {
            ConcreteFunction fn = (ConcreteFunction)obj;
            colName = fn.getLabel();
        } else if (obj instanceof SubSelectCommand) {
            SubSelectCommand sq = (SubSelectCommand)obj;
            colName = sq.getName();
        } else if (obj instanceof Literal) {
            Literal lit = (Literal)obj;
            colName = lit.getName();
        } else if (obj instanceof OrderNode) {
            colName = this.getResolvedColumnName(((OrderNode)obj).getSelectable());
        }
        return colName;
    }
}

