/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.rowiterators;

import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.axiondb.AxionException;
import org.axiondb.Row;
import org.axiondb.RowDecorator;
import org.axiondb.RowIterator;
import org.axiondb.Selectable;
import org.axiondb.engine.commands.SelectCommand;
import org.axiondb.engine.rowiterators.BaseRowIterator;
import org.axiondb.engine.rows.RowView;
import org.axiondb.functions.ConcreteFunction;

public class RowViewRowIterator
extends BaseRowIterator {
    private Map _colIdToFieldMap;
    private int _currentIndex = -1;
    private RowView _currentRow;
    private RowDecorator _decorator;
    private RowIterator _rowIter;
    private List _selected;
    private int[] _selectedColIndex;

    public RowViewRowIterator(RowIterator rowIter, Map colIdToFieldMap, List selected) {
        this._rowIter = rowIter;
        this._selected = selected;
        this._colIdToFieldMap = colIdToFieldMap;
        this._selectedColIndex = this.buildSelectedColumnIndex();
        this._decorator = new RowDecorator(colIdToFieldMap);
    }

    public Row current() {
        if (this.hasCurrent()) {
            return this._currentRow;
        }
        throw new NoSuchElementException("No current row has been set.");
    }

    public int currentIndex() {
        return this._currentIndex;
    }

    public boolean hasCurrent() {
        return null != this._currentRow;
    }

    public boolean hasNext() {
        return this._rowIter.hasNext();
    }

    public boolean hasPrevious() {
        return this._rowIter.hasPrevious();
    }

    public Row next() throws AxionException {
        this._currentIndex = this._rowIter.nextIndex();
        this.setCurrentRow(this._rowIter.next());
        return this._currentRow;
    }

    public int nextIndex() {
        return this._rowIter.nextIndex();
    }

    public Row previous() throws AxionException {
        this.setCurrentRow(this._rowIter.previous());
        this._currentIndex = this._rowIter.nextIndex();
        return this._currentRow;
    }

    public int previousIndex() {
        return this._rowIter.previousIndex();
    }

    public void reset() throws AxionException {
        this._currentRow = null;
        this._currentIndex = -1;
        this._rowIter.reset();
    }

    public String toString() {
        return "View(" + this._rowIter + ")";
    }

    private int[] buildSelectedColumnIndex() {
        int[] selectedIds = new int[this._selected.size()];
        int I = this._selected.size();
        for (int i = 0; i < I; ++i) {
            Object col = this._selected.get(i);
            selectedIds[i] = col instanceof ConcreteFunction || col instanceof SelectCommand ? -1 : (Integer)this._colIdToFieldMap.get(col);
        }
        return selectedIds;
    }

    private final void setCurrentRow(Row row) throws AxionException {
        this._currentRow = new RowView(row, row.getIdentifier(), this._selectedColIndex);
        this._decorator.setRow(this.currentIndex(), row);
        int I = this._currentRow.size();
        for (int i = 0; i < I; ++i) {
            Selectable sel = (Selectable)this._selected.get(i);
            this._currentRow.set(i, sel.evaluate(this._decorator));
        }
    }
}

