/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.rowiterators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.axiondb.AxionException;
import org.axiondb.Row;
import org.axiondb.RowDecorator;
import org.axiondb.RowIterator;
import org.axiondb.Selectable;
import org.axiondb.engine.rowiterators.AbstractAcceptingRowIterator;
import org.axiondb.util.ValuePool;

public class DistinctRowIterator
extends AbstractAcceptingRowIterator {
    private RowDecorator _decorator = null;
    private Selectable[] _selectables = null;
    private Map _timesEncountered = null;

    public DistinctRowIterator(RowIterator iter, Map selectableMap, Selectable[] selectables) {
        super(iter);
        this._decorator = new RowDecorator(selectableMap);
        this._selectables = selectables;
        this._timesEncountered = new HashMap();
    }

    public void set(Row row) throws AxionException {
        throw new UnsupportedOperationException();
    }

    public void remove() throws AxionException {
        throw new UnsupportedOperationException();
    }

    public void reset() throws AxionException {
        super.reset();
        this._timesEncountered.clear();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(20);
        buf.append("Distinct (");
        for (int i = 0; i < this._selectables.length; ++i) {
            buf.append(this._selectables[i] + (i != 0 ? "," : ""));
        }
        buf.append(")");
        return buf.toString();
    }

    protected boolean acceptable(int rowindex, Row row) throws AxionException {
        List values = this.populateValueList(row);
        Integer count = (Integer)this._timesEncountered.get(values);
        if (null == count) {
            count = ValuePool.getInt(0);
        }
        if (rowindex > this.previousIndex()) {
            this._timesEncountered.put(values, ValuePool.getInt(count + 1));
            return 0 == count;
        }
        if (1 == count) {
            this._timesEncountered.remove(values);
        } else {
            this._timesEncountered.put(values, ValuePool.getInt(count - 1));
        }
        return 1 == count;
    }

    private List populateValueList(Row row) throws AxionException {
        this._decorator.setRow(row);
        ArrayList<Object> values = new ArrayList<Object>(this._selectables.length);
        for (int i = 0; i < this._selectables.length; ++i) {
            values.add(this._selectables[i].evaluate(this._decorator));
        }
        return values;
    }
}

