/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.metaupdaters;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.axiondb.AxionException;
import org.axiondb.ColumnIdentifier;
import org.axiondb.Database;
import org.axiondb.Literal;
import org.axiondb.Row;
import org.axiondb.Selectable;
import org.axiondb.Table;
import org.axiondb.engine.commands.DeleteCommand;
import org.axiondb.engine.rows.SimpleRow;
import org.axiondb.event.BaseDatabaseModificationListener;
import org.axiondb.event.DatabaseModificationListener;
import org.axiondb.event.DatabaseModifiedEvent;
import org.axiondb.functions.FunctionIdentifier;

public class AxionTablesMetaTableUpdater
extends BaseDatabaseModificationListener
implements DatabaseModificationListener {
    private static Logger _log = Logger.getLogger(AxionTablesMetaTableUpdater.class.getName());
    private Database _db = null;

    public AxionTablesMetaTableUpdater(Database db) {
        this._db = db;
    }

    public void tableAdded(DatabaseModifiedEvent e) {
        Row row = this.createRowForAddedTable(e.getTable());
        try {
            this._db.getTable("AXION_TABLES").addRow(row);
        }
        catch (AxionException ex) {
            _log.log(Level.SEVERE, "Unable to mention table in system tables", ex);
        }
    }

    public void tableDropped(DatabaseModifiedEvent e) {
        FunctionIdentifier fn = new FunctionIdentifier("=");
        fn.addArgument(new ColumnIdentifier("TABLE_NAME"));
        fn.addArgument(new Literal(e.getTable().getName()));
        DeleteCommand cmd = new DeleteCommand("AXION_TABLES", (Selectable)fn);
        try {
            cmd.execute(this._db);
        }
        catch (AxionException ex) {
            _log.log(Level.SEVERE, "Unable to remove mention of table in system tables", ex);
        }
    }

    public Row createRowForAddedTable(Table table) {
        String tableName = table.getName();
        String tableType = table.getType();
        SimpleRow row = new SimpleRow(5);
        row.set(0, "");
        row.set(1, "");
        row.set(2, tableName);
        row.set(3, tableType);
        row.set(4, null);
        return row;
    }
}

