/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.indexes;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.collections.primitives.ArrayIntList;
import org.apache.commons.collections.primitives.IntList;
import org.apache.commons.collections.primitives.IntListIterator;
import org.axiondb.AxionException;
import org.axiondb.Column;
import org.axiondb.Function;
import org.axiondb.Index;
import org.axiondb.IndexLoader;
import org.axiondb.Row;
import org.axiondb.RowIterator;
import org.axiondb.RowSource;
import org.axiondb.Table;
import org.axiondb.engine.indexes.BaseIndex;
import org.axiondb.engine.rowiterators.EmptyRowIterator;
import org.axiondb.engine.rowiterators.LazyRowRowIterator;
import org.axiondb.event.RowEvent;
import org.axiondb.functions.EqualFunction;
import org.axiondb.functions.GreaterThanFunction;
import org.axiondb.functions.GreaterThanOrEqualFunction;
import org.axiondb.functions.LessThanFunction;
import org.axiondb.functions.LessThanOrEqualFunction;

public abstract class BaseArrayIndex
extends BaseIndex
implements Index {
    private IntList _rowIds = new ArrayIntList();

    public BaseArrayIndex(String name, Column column, boolean unique) {
        super(name, column, unique);
    }

    public BaseArrayIndex(String name, Column column, boolean unique, IntList values) {
        super(name, column, unique);
        this._rowIds = values;
    }

    public void changeRowId(Table table, Row row, int oldId, int newId) throws AxionException {
        int colnum = table.getColumnIndex(this.getIndexedColumn().getName());
        Object key = row.get(colnum);
        if (null != key) {
            int index;
            int I = this._rowIds.size();
            for (int i = index = this.find(key, true); i < I; ++i) {
                if (oldId != this._rowIds.get(i)) continue;
                this._rowIds.set(i, newId);
                break;
            }
        }
    }

    public abstract IndexLoader getIndexLoader();

    public RowIterator getInorderRowIterator(RowSource source) throws AxionException {
        int minindex = 0;
        int maxindex = this._rowIds.size();
        return new LazyRowRowIterator(source, this._rowIds.subList(minindex, maxindex).listIterator(), source.getColumnIndex(this.getIndexedColumn().getName()), this.getKeyList(minindex, maxindex).listIterator(), maxindex);
    }

    public abstract List getKeyList();

    public RowIterator getRowIterator(RowSource source, Function fn, Object value) throws AxionException {
        Object convertedValue = this.getIndexedColumn().getDataType().convert(value);
        if (null == convertedValue) {
            return EmptyRowIterator.INSTANCE;
        }
        int minindex = 0;
        int maxindex = this._rowIds.size();
        if (fn instanceof EqualFunction) {
            minindex = this.find(convertedValue, true);
            maxindex = minindex >= 0 ? (!this.isUnique() ? this.find(this.getIndexedColumn().getDataType().successor(convertedValue), false) : minindex + 1) : -1;
        } else if (fn instanceof GreaterThanFunction) {
            minindex = this.find(this.getIndexedColumn().getDataType().successor(convertedValue), false);
        } else if (fn instanceof GreaterThanOrEqualFunction) {
            minindex = this.find(convertedValue, false);
        } else if (fn instanceof LessThanFunction) {
            maxindex = this.find(convertedValue, false);
        } else if (fn instanceof LessThanOrEqualFunction) {
            maxindex = this.find(this.getIndexedColumn().getDataType().successor(convertedValue), false);
        } else {
            throw new AxionException("Unsupported function" + fn);
        }
        if (minindex < 0 || minindex >= this._rowIds.size() || maxindex <= 0 || minindex == maxindex) {
            return EmptyRowIterator.INSTANCE;
        }
        IntListIterator resultIds = this._rowIds.subList(minindex, maxindex).listIterator();
        ArrayIntList ids = new ArrayIntList();
        while (resultIds.hasNext()) {
            ids.add(resultIds.next());
        }
        ListIterator keyResult = this.getKeyList(minindex, maxindex).listIterator();
        ArrayList keys = new ArrayList();
        while (keyResult.hasNext()) {
            keys.add(keyResult.next());
        }
        return new LazyRowRowIterator(source, ids.listIterator(), source.getColumnIndex(this.getIndexedColumn().getName()), keys.listIterator(), ids.size());
    }

    public String getType() {
        return "array";
    }

    public void rowDeleted(RowEvent event) throws AxionException {
        int colnum = event.getTable().getColumnIndex(this.getIndexedColumn().getName());
        Object key = event.getOldRow().get(colnum);
        if (null != key) {
            if (this.isUnique()) {
                int index = this.removeKey(key);
                if (-1 != index) {
                    this._rowIds.removeElementAt(index);
                }
            } else {
                int index = this.find(key, true);
                if (-1 != index) {
                    while (this._rowIds.get(index) != event.getOldRow().getIdentifier()) {
                        ++index;
                    }
                    this._rowIds.removeElementAt(index);
                    this.removeKeyAt(index);
                }
            }
        }
    }

    public void rowInserted(RowEvent event) throws AxionException {
        int colnum = event.getTable().getColumnIndex(this.getIndexedColumn().getName());
        Object key = event.getNewRow().get(colnum);
        if (null != key) {
            int index = this.insertKey(key);
            this._rowIds.add(index, event.getNewRow().getIdentifier());
        }
    }

    public void rowUpdated(RowEvent event) throws AxionException {
        int colnum = event.getTable().getColumnIndex(this.getIndexedColumn().getName());
        Object newkey = event.getNewRow().get(colnum);
        Object oldkey = event.getOldRow().get(colnum);
        if (null == newkey ? null == oldkey : newkey.equals(oldkey)) {
            return;
        }
        this.rowDeleted(event);
        this.rowInserted(event);
    }

    public void save(File dataDirectory) throws AxionException {
        this.getIndexLoader().saveIndex(this, dataDirectory);
    }

    public void saveAfterTruncate(File dataDirectory) throws AxionException {
        this.getIndexLoader().saveIndexAfterTruncate(this, dataDirectory);
    }

    public boolean supportsFunction(Function fn) {
        if (fn instanceof EqualFunction) {
            if (this.isUnique()) {
                return true;
            }
            return this.getIndexedColumn().getDataType().supportsSuccessor();
        }
        if (fn instanceof GreaterThanFunction) {
            return this.getIndexedColumn().getDataType().supportsSuccessor();
        }
        if (fn instanceof GreaterThanOrEqualFunction) {
            return true;
        }
        if (fn instanceof LessThanFunction) {
            return true;
        }
        if (fn instanceof LessThanOrEqualFunction) {
            return this.getIndexedColumn().getDataType().supportsSuccessor();
        }
        return false;
    }

    public void truncate() throws AxionException {
        if (this._rowIds != null) {
            this._rowIds.clear();
        }
    }

    protected abstract int find(Object var1, boolean var2);

    protected abstract List getKeyList(int var1, int var2);

    protected IntList getValueList() {
        return this._rowIds;
    }

    protected abstract int insertKey(Object var1) throws AxionException;

    protected abstract int removeKey(Object var1) throws AxionException;

    protected abstract void removeKeyAt(int var1) throws AxionException;
}

