/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.commands;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.axiondb.AxionCommand;
import org.axiondb.AxionException;
import org.axiondb.BindVariable;
import org.axiondb.Column;
import org.axiondb.ColumnIdentifier;
import org.axiondb.DataType;
import org.axiondb.Database;
import org.axiondb.Function;
import org.axiondb.Row;
import org.axiondb.RowDecorator;
import org.axiondb.RowIterator;
import org.axiondb.Selectable;
import org.axiondb.Sequence;
import org.axiondb.Table;
import org.axiondb.TableIdentifier;
import org.axiondb.engine.commands.AxionQueryOptimizer;
import org.axiondb.engine.rowiterators.FilteringRowIterator;
import org.axiondb.engine.visitors.FindBindVariableVisitor;
import org.axiondb.engine.visitors.ResolveSelectableVisitor;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.FunctionIdentifier;
import org.axiondb.jdbc.AxionResultSet;

public abstract class BaseAxionCommand
implements AxionCommand {
    private FindBindVariableVisitor _bvisitor;
    private int _commitSize = -1;
    private ResolveSelectableVisitor _resolveSel;
    private int _rowCount = -1;
    private ResultSet _rset;

    public void bindAll(Object[] vals) throws AxionException {
        int index = 0;
        Iterator iter = this.getBindVariableIterator();
        while (iter.hasNext()) {
            BindVariable var = (BindVariable)iter.next();
            var.setValue(vals[index]);
            ++index;
        }
    }

    public void clearBindings() throws AxionException {
        Iterator iter = this.getBindVariableIterator();
        while (iter.hasNext()) {
            BindVariable var = (BindVariable)iter.next();
            var.clearBoundValue();
        }
    }

    public AxionResultSet executeQuery(Database db, boolean isReadOnly) throws AxionException {
        return this.executeQuery(db);
    }

    public List getBindVariables() {
        if (this.getBindVariableVisitor() == null) {
            this.buildBindVariables();
        }
        return this.getBindVariableVisitor().getBindVariables();
    }

    public final int getEffectedRowCount() {
        return this._rowCount;
    }

    public final ResultSet getResultSet() {
        return this._rset;
    }

    protected void assertNotReadOnly(Database db) throws AxionException {
        if (db.isReadOnly()) {
            throw new AxionException("The database is read only.");
        }
    }

    protected Object attemptToConvertValue(Object val, DataType type, ColumnIdentifier colid) throws AxionException {
        try {
            return type.convert(val);
        }
        catch (AxionException e) {
            throw new AxionException("Invalid value \"" + val + "\"" + " for column " + colid + ", expected " + type + " : " + e.getMessage(), e.getVendorCode());
        }
    }

    protected void buildBindVariables() {
        this.setBindVariableVisitor(new FindBindVariableVisitor());
    }

    protected final void createResolveSelectableVisitor(Database db) {
        if (this._resolveSel == null) {
            this._resolveSel = new ResolveSelectableVisitor(db);
        }
    }

    protected Iterator getBindVariableIterator() {
        if (this.getBindVariableVisitor() == null) {
            this.buildBindVariables();
        }
        return this.getBindVariableVisitor().getBindVariableIterator();
    }

    protected Iterator getBindVariableIterator(Selectable sel) {
        if (this.getBindVariableVisitor() == null) {
            this.setBindVariableVisitor(new FindBindVariableVisitor());
            this.getBindVariableVisitor().visit(sel);
        }
        return this._bvisitor.getBindVariableIterator();
    }

    protected final FindBindVariableVisitor getBindVariableVisitor() {
        return this._bvisitor;
    }

    protected List getColIdentifierList(Table table, TableIdentifier tid) throws AxionException {
        int size = table.getColumnCount();
        ArrayList<ColumnIdentifier> colids = new ArrayList<ColumnIdentifier>(size);
        for (int i = 0; i < size; ++i) {
            Column col = table.getColumn(i);
            colids.add(new ColumnIdentifier(tid, col.getName(), null, col.getDataType()));
        }
        return colids;
    }

    protected int getCommitSize(Database db) {
        if (this._commitSize == -1) {
            int commitSize = 0;
            try {
                String size = (String)db.getGlobalVariable("COMMITSIZE");
                commitSize = Integer.parseInt(size);
                commitSize = Math.abs(commitSize);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this._commitSize = commitSize;
        }
        return this._commitSize;
    }

    protected RowIterator getRowIterator(Database db, TableIdentifier tid, Table table, Selectable whereNode, boolean readOnly, RowDecorator dec) throws AxionException {
        RowIterator rows = null;
        Set whereNodes = AxionQueryOptimizer.flatConditionTree(whereNode);
        Function searchNode = AxionQueryOptimizer.findColumnLiteralFunction(tid, table, whereNodes, true);
        if (searchNode != null && (rows = table.getIndexedRows(searchNode, readOnly)) != null) {
            whereNodes.remove(searchNode);
        }
        if (rows == null) {
            rows = table.getRowIterator(readOnly);
        }
        if (!whereNodes.isEmpty()) {
            rows = new FilteringRowIterator(rows, dec, whereNode);
        }
        return rows;
    }

    protected final RowDecorator makeRowDecorator(Table table) {
        return table.makeRowDecorator();
    }

    protected void populateDefaultValues(Database db, Table table, TableIdentifier tableId, RowDecorator dec) throws AxionException {
        this.createResolveSelectableVisitor(db);
        Row row = dec.getRow();
        int I = row.size();
        for (int i = 0; i < I; ++i) {
            Column col = table.getColumn(i);
            if (null != row.get(i) && !col.isDerivedColumn()) continue;
            if (col.hasDefault()) {
                Selectable sel = this.getCanonicalDefault(db, col.getDefault());
                sel = this._resolveSel.visit(sel, null, new TableIdentifier[]{tableId});
                Object val = sel.evaluate(dec);
                DataType type = col.isDerivedColumn() ? sel.getDataType() : col.getDataType();
                val = this.attemptToConvertValue(val, type, null);
                row.set(i, val);
                continue;
            }
            if (!col.isIdentityColumn() || !col.isGeneratedByDefault()) continue;
            Sequence seq = table.getSequence();
            row.set(i, seq.evaluate());
        }
    }

    protected boolean populateSequenceColumns(Database db, Table table, Row row) throws AxionException {
        boolean result = false;
        this.createResolveSelectableVisitor(db);
        int size = row.size();
        for (int i = 0; i < size; ++i) {
            Column col = table.getColumn(i);
            if (!col.isGeneratedAlways() || !col.isIdentityColumn()) continue;
            Sequence seq = table.getSequence();
            row.set(i, seq.evaluate());
            result = true;
        }
        return result;
    }

    protected void resolveGeneratedColumns(Table table, TableIdentifier tableId, List cols) throws AxionException {
        this.resolveGeneratedColumns(table, tableId, cols, false);
    }

    protected void resolveGeneratedColumns(Table table, TableIdentifier tableId, List cols, boolean useDefaultValues) throws AxionException {
        boolean buildColList = cols.isEmpty();
        int count = table.getColumnCount();
        for (int i = 0; i < count; ++i) {
            Column col = table.getColumn(i);
            ColumnIdentifier colid = new ColumnIdentifier(tableId, col.getName(), null, col.getDataType());
            if (col.isGeneratedAlways() || col.isDerivedColumn()) {
                if (!cols.contains(colid) || useDefaultValues) continue;
                String msg = "Can't insert value to generated/derived column " + col.getName();
                throw new AxionException(msg);
            }
            if (!buildColList) continue;
            cols.add(colid);
        }
    }

    protected Selectable resolveSelectable(Selectable sel, Database db, List selected, TableIdentifier[] tables) throws AxionException {
        this.createResolveSelectableVisitor(db);
        return this._resolveSel.visit(sel, selected, tables);
    }

    protected Selectable resolveSelectable(Selectable sel, Database db, TableIdentifier[] tables) throws AxionException {
        this.createResolveSelectableVisitor(db);
        return this._resolveSel.visit(sel, null, tables);
    }

    protected void resolveSelectableList(List list, Database db, TableIdentifier table) throws AxionException {
        this.resolveSelectableList(list, db, new TableIdentifier[]{table});
    }

    protected void resolveSelectableList(List list, Database db, TableIdentifier[] tables) throws AxionException {
        this.createResolveSelectableVisitor(db);
        int I = list.size();
        for (int i = 0; i < I; ++i) {
            list.set(i, this._resolveSel.visit((Selectable)list.get(i), null, tables));
        }
    }

    protected final void setBindVariableVisitor(FindBindVariableVisitor visitor) {
        this._bvisitor = visitor;
    }

    protected void setDeferAllConstraintIfRequired(Table table) {
        if (this.getBindVariables().size() > 0) {
            table.setDeferAllConstraints(true);
        }
    }

    protected final void setEffectedRowCount(int count) {
        this._rowCount = count;
    }

    protected final void setResultSet(ResultSet rset) {
        this._rset = rset;
    }

    protected void updateGeneratedValues(Database db, Table table, TableIdentifier tableId, Row row) throws AxionException {
        RowDecorator dec = null;
        this.createResolveSelectableVisitor(db);
        int size = row.size();
        for (int i = 0; i < size; ++i) {
            Column col = table.getColumn(i);
            if (!col.isDerivedColumn()) continue;
            Selectable sel = this.getCanonicalDefault(db, col.getDefault());
            sel = this._resolveSel.visit(sel, null, new TableIdentifier[]{tableId});
            if (dec == null) {
                dec = this.makeRowDecorator(table);
                dec.setRow(row);
            }
            Object val = sel.evaluate(dec);
            val = this.attemptToConvertValue(val, col.getDataType(), null);
            row.set(i, val);
        }
    }

    private Selectable getCanonicalDefault(Database db, Selectable sel) {
        if (sel instanceof ColumnIdentifier) {
            ColumnIdentifier col = (ColumnIdentifier)sel;
            if (col.getTableName() == null || db.getSequence(col.getTableName()) == null) {
                return new ColumnIdentifier(sel.getName());
            }
        } else if (sel instanceof ConcreteFunction || sel instanceof FunctionIdentifier) {
            Function fn = (Function)sel;
            FunctionIdentifier fnid = new FunctionIdentifier(fn.getName());
            int I = fn.getArgumentCount();
            for (int i = 0; i < I; ++i) {
                fnid.addArgument(this.getCanonicalDefault(db, fn.getArgument(i)));
            }
            return fnid;
        }
        return sel;
    }
}

