/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.axiondb.AxionException;
import org.axiondb.Index;
import org.axiondb.Table;
import org.axiondb.engine.ObjectBTreeIndexLoader;
import org.axiondb.engine.indexes.ObjectBTreeIndex;
import org.axiondb.engine.indexes.StringBTreeIndex;
import org.axiondb.io.AxionFileSystem;

public class StringBTreeIndexLoader
extends ObjectBTreeIndexLoader {
    private static final int VERSION_NUMBER = 2;

    public Index loadIndex(Table table, File dataDirectory) throws AxionException {
        ObjectInputStream in = null;
        AxionFileSystem fs = new AxionFileSystem();
        try {
            String name = dataDirectory.getName();
            File file = new File(dataDirectory, name + ".data");
            in = fs.openObjectInputSteam(file);
            int ver = in.readInt();
            if (ver != 2) {
                throw new AxionException("Can't parse data file " + file + " for index " + name + ", unrecognized data file version " + ver);
            }
            String col = in.readUTF();
            boolean unique = in.readBoolean();
            int minimizationFactor = in.readInt();
            StringBTreeIndex stringBTreeIndex = new StringBTreeIndex(name, table.getColumn(col), unique, minimizationFactor, dataDirectory);
            fs.closeInputStream(in);
            return stringBTreeIndex;
        }
        catch (IOException e) {
            try {
                throw new AxionException(e);
            }
            catch (Throwable throwable) {
                fs.closeInputStream(in);
                throw throwable;
            }
        }
    }

    public void saveIndex(Index ndx, File dataDirectory) throws AxionException {
        ObjectBTreeIndex index = (ObjectBTreeIndex)ndx;
        ObjectOutputStream out = null;
        try {
            String name = index.getName();
            File file = new File(dataDirectory, name + ".data");
            out = FS.createObjectOutputSteam(file);
            out.writeInt(2);
            out.writeUTF(index.getIndexedColumn().getName());
            out.writeBoolean(index.isUnique());
            out.writeInt(((StringBTreeIndex)index).getMinimizationFactor());
            FS.closeOutputStream(out);
        }
        catch (IOException e) {
            try {
                throw new AxionException(e);
            }
            catch (Throwable throwable) {
                FS.closeOutputStream(out);
                throw throwable;
            }
        }
        this.save(ndx, dataDirectory);
    }
}

