/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine;

import java.io.File;
import java.io.IOException;
import org.axiondb.AxionException;
import org.axiondb.Column;
import org.axiondb.Index;
import org.axiondb.IndexLoader;
import org.axiondb.engine.indexes.BaseBTreeIndexLoader;
import org.axiondb.engine.indexes.ObjectBTreeIndex;

public class ObjectBTreeIndexLoader
extends BaseBTreeIndexLoader
implements IndexLoader {
    protected Index makeIndex(String name, Column col, boolean unique, File dataDirectory) throws AxionException {
        return new ObjectBTreeIndex(name, col, unique, dataDirectory);
    }

    public void save(Index ndx, File dataDirectory) throws AxionException {
        ObjectBTreeIndex index = (ObjectBTreeIndex)ndx;
        try {
            index.getBTree().save(dataDirectory);
        }
        catch (IOException e) {
            throw new AxionException(e);
        }
        catch (ClassNotFoundException e) {
            throw new AxionException(e);
        }
    }

    public void saveIndexAfterTruncate(Index ndx, File dataDirectory) throws AxionException {
        ObjectBTreeIndex index = (ObjectBTreeIndex)ndx;
        try {
            index.getBTree().saveAfterTruncate();
        }
        catch (IOException e) {
            throw new AxionException(e);
        }
        catch (ClassNotFoundException e) {
            throw new AxionException(e);
        }
    }
}

