/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.constraints;

import org.axiondb.AxionException;
import org.axiondb.Constraint;
import org.axiondb.Database;
import org.axiondb.TableIdentifier;
import org.axiondb.event.RowEvent;
import org.axiondb.util.StringIdentifierGenerator;

public abstract class BaseConstraint
implements Constraint {
    private String _name;
    private String _type;
    private boolean _deferred = false;
    private boolean _deferrable = false;
    private static final long serialVersionUID = 4423282446007162270L;

    public BaseConstraint(String name, String type) {
        this.setName(name);
        this._type = type;
    }

    public abstract boolean evaluate(RowEvent var1) throws AxionException;

    public void resolve(Database db, TableIdentifier table) throws AxionException {
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = null == name ? StringIdentifierGenerator.INSTANCE.next16DigitIdentifier("C") : name;
    }

    public String getType() {
        return this._type;
    }

    public boolean isDeferred() {
        return this._deferred;
    }

    public void setDeferred(boolean deferred) throws AxionException {
        if (deferred && !this._deferrable) {
            throw new AxionException("Not deferrable.");
        }
        this._deferred = deferred;
    }

    public boolean isDeferrable() {
        return this._deferrable;
    }

    public void setDeferrable(boolean deferrable) {
        this._deferrable = deferrable;
        if (!this._deferrable) {
            this._deferred = false;
        }
    }

    protected TableIdentifier[] toArray(TableIdentifier table) {
        TableIdentifier[] tables = null;
        tables = null != table ? new TableIdentifier[]{table} : new TableIdentifier[]{};
        return tables;
    }
}

