/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.webservice.generator.bcm;

import it.imolinfo.jbi4corba.Logger;
import it.imolinfo.jbi4corba.LoggerFactory;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.commons.EmptyVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorbaOnewayMethodVisitor
extends EmptyVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(CorbaOnewayMethodVisitor.class);
    protected String internalStubName = null;
    protected String methodName = null;
    protected List<String> onewayOperationList = new ArrayList<String>();
    protected boolean zero = false;

    public CorbaOnewayMethodVisitor(String stub, String aMethodName, List<String> aOnewayOperationList) {
        this.internalStubName = stub;
        this.methodName = aMethodName;
        this.onewayOperationList = aOnewayOperationList;
    }

    public void visitInsn(int opcode) {
        super.visitInsn(opcode);
        this.zero = 3 == opcode;
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        LOG.debug("CorbaOnewayMethodVisitor.visitMethodInsn. opcode=" + opcode + "; owner=" + owner + "; name=" + name + "; desc=" + desc);
        String corbaOutputStream = "(Ljava/lang/String;Z)Lorg/omg/CORBA/portable/OutputStream;";
        if (182 == opcode && owner.equals(this.internalStubName) && "_request".equals(name) && "(Ljava/lang/String;Z)Lorg/omg/CORBA/portable/OutputStream;".equals(desc) && this.zero) {
            LOG.debug("The method " + this.methodName + " is a oneway corba request.");
            this.onewayOperationList.add(this.methodName);
        } else {
            LOG.debug("The method " + this.methodName + " is NOT a oneway corba request.");
        }
        super.visitMethodInsn(opcode, owner, name, desc);
    }
}

