/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.webservice.generator;

import com.sun.tools.javac.Main;
import it.imolinfo.jbi4corba.Logger;
import it.imolinfo.jbi4corba.LoggerFactory;
import it.imolinfo.jbi4corba.exception.ClassGenerationException;
import it.imolinfo.jbi4corba.exception.Jbi4CorbaException;
import it.imolinfo.jbi4corba.webservice.generator.ClassMetaInfo;
import it.imolinfo.jbi4corba.webservice.generator.MethodSignature;
import it.imolinfo.jbi4corba.webservice.generator.UtilClassCollector;
import it.imolinfo.jbi4corba.webservice.generator.UtilJavaSourceParsing;
import it.imolinfo.jbi4corba.webservice.generator.bcm.CorbaEnumAdapter;
import it.imolinfo.jbi4corba.webservice.generator.bcm.CorbaOnewayAdapter;
import it.imolinfo.jbi4corba.webservice.generator.bcm.SerializableDecorationAdapter;
import it.imolinfo.jbi4corba.webservice.generator.bcm.SerializableInspectorAdapter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.util.CheckClassAdapter;
import org.objectweb.asm.util.TraceClassVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static final String PROTOCOL;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final Logger LOG;

    public static void compileRemoteClassesNoValueMethodsON(String classesDir, String className, List<String> extraClasspath) throws ClassGenerationException {
        LOG.debug(">>>>> compileRemoteClassesNoValueMethodsON - begin");
        String cp = classesDir;
        if (extraClasspath != null) {
            for (String i : extraClasspath) {
                cp = cp + File.pathSeparator + i;
            }
        }
        ArrayList<String> params = new ArrayList<String>(Arrays.asList("-classpath", classesDir, "-d", classesDir, "-idl", "-always", "-factory", "-iiop", "-nolocalstubs", "-noValueMethods", "-poa", "-verbose", className));
        Util.compileRemoteClasses(classesDir, className, params);
        LOG.debug("<<<<< compileRemoteClassesNoValueMethodsON - end");
    }

    public static void compileRemoteClassesNoValueMethodsOFF(String classesDir, String className, List<String> extraClasspath) throws ClassGenerationException {
        LOG.debug(">>>>> compileRemoteClassesNoValueMethodsOFF - begin");
        String cp = classesDir;
        if (extraClasspath != null) {
            for (String i : extraClasspath) {
                cp = cp + File.pathSeparator + i;
            }
        }
        ArrayList<String> params = new ArrayList<String>(Arrays.asList("-classpath", cp, "-d", classesDir, "-idl", "-always", "-iiop", "-nolocalstubs", "-verbose", className));
        Util.compileRemoteClasses(classesDir, className, params);
        LOG.debug("<<<<< compileRemoteClassesNoValueMethodsOFF - end");
    }

    private static void compileRemoteClasses(String classesDir, String className, List<String> params) throws ClassGenerationException {
        LOG.debug(">>>>> compileRemoteClasses - begin");
        LOG.debug("compileRemoteClasses - classesDir=" + classesDir + "; className=" + className);
        ByteArrayOutputStream BAOS = new ByteArrayOutputStream();
        PrintStream printstream = new PrintStream(BAOS);
        sun.rmi.rmic.Main main = new sun.rmi.rmic.Main((OutputStream)printstream, "rmic");
        boolean result = main.compile(params.toArray(new String[0]));
        LOG.debug("compilation output: \n" + BAOS.toString());
        if (!result) {
            Object[] args = new Object[]{params, result, BAOS.toString()};
            LOG.error("CRB000528_Error_compiling_classes", args);
            throw new ClassGenerationException("CRB000528_Error_compiling_classes", args, null);
        }
        LOG.debug("compilation ok");
        LOG.debug("<<<<< compileRemoteClasses - end");
    }

    public static List<String> findJavaSources(String basedir) throws Jbi4CorbaException {
        LOG.debug(">>>>> findJavaSources(String) - begin");
        List<String> javaSourcesNames = Util.findJavaSources(basedir, null);
        LOG.debug("<<<<< findJavaSources(String) - end");
        return javaSourcesNames;
    }

    private static boolean containsIgnoreSlashes(List<String> list, String x) {
        if (x == null) {
            return false;
        }
        if (list == null) {
            return false;
        }
        String xrr = x.replace('\\', ' ').replace('/', ' ');
        for (String c : list) {
            String crr = c.replace('\\', ' ').replace('/', ' ');
            if (!xrr.equalsIgnoreCase(crr)) continue;
            return true;
        }
        return false;
    }

    public static List<String> findJavaSources(String basedir, List<String> exclude) throws Jbi4CorbaException {
        LOG.debug(">>>>> findJavaSources(String, List<String>) - begin");
        ArrayList<String> javaSourcesNames = new ArrayList<String>();
        List<File> sourceFiles = Util.findFilesFromSourceDirectory(basedir, ".java");
        for (File source : sourceFiles) {
            String src = null;
            try {
                src = source.getCanonicalPath();
            }
            catch (IOException e) {
                Object[] args = new Object[]{basedir};
                LOG.error("CRB000529_Unexpected_error", args, e);
                throw new Jbi4CorbaException("CRB000529_Unexpected_error", args, e);
            }
            if (src.endsWith("src")) {
                LOG.debug("The file " + src + " won't be compile.");
                continue;
            }
            if (Util.containsIgnoreSlashes(exclude, src)) {
                LOG.debug("The file " + src + " won't be compile.");
                continue;
            }
            LOG.debug("The file " + src + " will be compiled.");
            javaSourcesNames.add(src);
        }
        LOG.debug("<<<<< findJavaSources(String, List<String>) - end");
        return javaSourcesNames;
    }

    public static List<String> findAllDefaultFactory(String basedir) throws IOException {
        String suffix = "DefaultFactory.java";
        LOG.debug(">>>>> findAllDefaultFactory - begin");
        ArrayList<String> javaSourcesNames = new ArrayList<String>();
        List<File> sourceFiles = Util.findFilesFromSourceDirectory(basedir, "DefaultFactory.java");
        for (File source : sourceFiles) {
            javaSourcesNames.add(source.getAbsolutePath());
            LOG.debug("findAllDefaultFactory + " + source.getCanonicalPath());
        }
        LOG.debug("<<<<< findAllDefaultFactory - end");
        return javaSourcesNames;
    }

    public static List<String> findIdlFiles(String basedir) throws Jbi4CorbaException {
        LOG.debug(">>>>> findIdlFiles - begin");
        ArrayList<String> javaSourcesNames = new ArrayList<String>();
        List<File> sourceFiles = Util.findFilesFromSourceDirectory(basedir, ".idl");
        for (File source : sourceFiles) {
            String src = null;
            try {
                src = source.getCanonicalPath();
            }
            catch (IOException e) {
                Object[] args = new Object[]{basedir};
                LOG.error("CRB000530_Unexpected_error", args, e);
                throw new Jbi4CorbaException("CRB000530_Unexpected_error", args, e);
            }
            javaSourcesNames.add(src);
            LOG.debug("findIdlFiles + " + src);
        }
        LOG.debug("<<<<< findIdlFiles - end");
        return javaSourcesNames;
    }

    public static List<File> findFilesFromSourceDirectory(String basedirString, final String extensionFilter) {
        LOG.debug(">>>>> findFilesFromSourceDirectory - begin");
        File basedir = new File(basedirString);
        FileFilter filter = new FileFilter(){

            public boolean accept(File file) {
                boolean filterAccept = file.getName().endsWith(extensionFilter);
                return filterAccept;
            }
        };
        LOG.debug("findFilesFromSourceDirectory; basedir=" + basedir + "; FileFilter=" + filter);
        List<File> directories = Util.findDirectories(basedir);
        LOG.debug("directories: " + directories);
        ArrayList<File> filterdFiles = new ArrayList<File>();
        for (File dir : directories) {
            File[] innerFilteredFiles = dir.listFiles(filter);
            LOG.debug("inner filtered files: " + Arrays.asList(innerFilteredFiles));
            filterdFiles.addAll(Arrays.asList(innerFilteredFiles));
        }
        LOG.debug("<<<<< findFilesFromSourceDirectory - end");
        return filterdFiles;
    }

    private static List<File> findDirectories(File basedir) {
        ArrayList<File> directories = new ArrayList<File>();
        if (basedir == null || "".equals(basedir)) {
            return directories;
        }
        FileFilter directoryFilter = new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        };
        File[] files = basedir.listFiles(directoryFilter);
        if (files == null) {
            return directories;
        }
        for (int i = 0; i < files.length; ++i) {
            List<File> innerDirectories = Util.findDirectories(files[i]);
            directories.addAll(innerDirectories);
            directories.add(files[i]);
        }
        return directories;
    }

    public static void compileJavaClasses(String workdirsrc, String workdirclasses, List<String> javaSources, List<String> jarFiles, List<String> extraClassPath) throws ClassGenerationException {
        LOG.debug(">>>>> compileJavaClasses - begin");
        LOG.debug("compileJavaClasses.\n workdirsrc=" + workdirsrc + ";\n workdirclasses=" + workdirclasses + ";\n javaSources=" + javaSources + ";\n jarFiles=" + jarFiles + ";\n extraClassPath=" + extraClassPath);
        ArrayList<String> params = new ArrayList<String>(Arrays.asList("-d", workdirclasses, "-sourcepath", workdirsrc));
        LOG.debug("creating classpath - begin");
        String classpath = "";
        if (jarFiles != null) {
            for (String jarFileName : jarFiles) {
                classpath = classpath + jarFileName + File.pathSeparator;
                LOG.debug("ClassPath + (jar) " + jarFileName);
            }
        }
        if (extraClassPath != null) {
            for (String extra : extraClassPath) {
                File f = new File(extra);
                if (!f.isDirectory()) {
                    extra = f.getParent();
                    LOG.debug("-----> EXTRA=[" + extra + "]");
                }
                classpath = classpath + extra + File.pathSeparator;
                LOG.debug("ClassPath + (extra) " + extra);
            }
        } else {
            LOG.debug("No extra classpath.");
        }
        if (!"".equals(classpath)) {
            LOG.debug("Final ClassPath=" + classpath);
            params.add("-cp");
            params.add(classpath);
        } else {
            LOG.debug("Final ClassPath=<<EMPTY>>");
        }
        LOG.debug("creating classpath - end.");
        params.addAll(javaSources);
        LOG.debug("command line: " + Arrays.toString(params.toArray()));
        File classesdir = new File(workdirclasses);
        if (!classesdir.exists()) {
            boolean result = classesdir.mkdirs();
            if (!result) {
                Object[] args = new Object[]{classesdir};
                LOG.error("CRB000531_Unable_to_create_compilation_directory", args);
                throw new ClassGenerationException("CRB000531_Unable_to_create_compilation_directory", args, null);
            }
            LOG.debug("Classes Dir Created:" + classesdir);
        } else {
            LOG.debug("Classes Dir Already Exists:" + classesdir);
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printstream = new PrintWriter(stringWriter);
        LOG.debug("Compiling - begin");
        int result = Main.compile(params.toArray(new String[0]), printstream);
        LOG.debug("Compiling - end. result=" + result);
        LOG.debug("compilation output: \n" + stringWriter.toString());
        if (result != 0) {
            Object[] args = new Object[]{params, result, stringWriter.toString()};
            LOG.error("CRB000528_Error_compiling_classes", args);
            throw new ClassGenerationException("CRB000528_Error_compiling_classes", args, null);
        }
        LOG.debug("Compilation OK.");
        LOG.debug("<<<<< compileJavaClasses - end");
    }

    public static Map<String, List<MethodSignature>> extractMethodSignatureOfTheCorbaOperations(String sourceDir) throws ClassGenerationException {
        List<File> corbaOperationsSourceFileList = Util.findFilesFromSourceDirectory(sourceDir, "Operations.java");
        HashMap<String, List<MethodSignature>> map = new HashMap<String, List<MethodSignature>>();
        if (corbaOperationsSourceFileList == null || corbaOperationsSourceFileList.size() == 0) {
            LOG.debug("No files found with the suffix 'Operations.java'");
            return map;
        }
        UtilJavaSourceParsing parser = new UtilJavaSourceParsing();
        for (File operationFile : corbaOperationsSourceFileList) {
            String absPath = operationFile.getAbsolutePath();
            LOG.debug("parsing ... " + absPath);
            List<MethodSignature> methodSignatureList = parser.extractMethodSignature(absPath);
            String fullQualifiedName = Util.extractJavaQualifiedName(sourceDir, absPath, ".java");
            map.put(fullQualifiedName, methodSignatureList);
        }
        return map;
    }

    public static Set<Class> findClassUsedInTheOperations(String dir) throws ClassGenerationException {
        LOG.debug(">>>>> findClassUsedInTheOperations - begin");
        List<File> operationsClass = Util.findFilesFromSourceDirectory(dir, "Operations.class");
        Set<Class> result = Util.findClassUsed(dir, operationsClass);
        LOG.debug("<<<<< findClassUsedInTheOperations - end:" + result);
        return result;
    }

    public static Set<Class> findClassUsed(String dir, List<File> classList) throws ClassGenerationException {
        LOG.debug(">>>>> findClassUsedInTheOperations - begin");
        LOG.debug("operationsClass=" + classList);
        if (classList == null || classList.size() == 0) {
            LOG.info("CRB000532_Operations_class_not_found");
            return new HashSet<Class>();
        }
        Set<Class> result = new HashSet<Class>();
        for (int i = 0; i < classList.size(); ++i) {
            Class clazz = Util.classLoad(dir, classList.get(i));
            LOG.debug("classLoad:" + clazz);
            List<Class> types = UtilClassCollector.extractTypes(clazz);
            for (Class currType : types) {
                result = UtilClassCollector.visitClassCollector(result, currType);
            }
        }
        LOG.debug("<<<<< findClassUsedInTheOperations - end:" + result);
        return result;
    }

    private static Class classLoad(String dir, File classAsFile) throws ClassGenerationException {
        URLClassLoader urlClassLoader = null;
        try {
            File fcd = new File(dir);
            if (LOG.isDebugEnabled()) {
                LOG.debug("ClassesDir.getAbsolutePath=" + fcd.getAbsolutePath());
            }
            URL u = new URL(PROTOCOL + fcd.getAbsolutePath() + "/");
            urlClassLoader = new URLClassLoader(new URL[]{u}, Util.class.getClassLoader());
            LOG.debug("url classloader: " + Arrays.asList(urlClassLoader.getURLs()));
            String className = Util.getClassName(classAsFile, dir);
            LOG.debug("class name: " + className);
            return urlClassLoader.loadClass(className);
        }
        catch (MalformedURLException e) {
            Object[] args = new Object[]{PROTOCOL + new File(dir).getAbsolutePath() + "/"};
            LOG.error("CRB000533_Could_not_instantiate_url_class_loader", args, e);
            throw new ClassGenerationException("CRB000533_Could_not_instantiate_url_class_loader", args, e);
        }
        catch (ClassNotFoundException e) {
            Object[] args = new Object[]{PROTOCOL + new File(dir).getAbsolutePath() + "/"};
            LOG.error("CRB000533_Could_not_instantiate_url_class_loader", args, e);
            throw new ClassGenerationException("CRB000533_Could_not_instantiate_url_class_loader", args, e);
        }
    }

    public static List<Class> findGeneratedClasses(String classesDir, ClassLoader classLoader) throws ClassGenerationException {
        LOG.debug(">>>>> findGeneratedClasses - begin");
        LOG.debug("INPUT. classesDir=" + classesDir + "; classLoader" + classLoader);
        ArrayList<Class> classes = new ArrayList<Class>();
        List<File> classFiles = Util.findFilesFromSourceDirectory(classesDir, ".class");
        LOG.debug("class files: " + classFiles);
        for (File classFile : classFiles) {
            String className = Util.getClassName(classFile, classesDir);
            LOG.debug("class name: " + className);
            try {
                Class<?> clazz = classLoader.loadClass(className);
                LOG.debug("clazz=" + clazz + " ... ");
                classes.add(clazz);
                LOG.debug("... clazz=" + clazz + " added.");
            }
            catch (ClassNotFoundException e) {
                Object[] args = new Object[]{className};
                LOG.error("CRB000534_Could_not_instantiate_class", args, e);
                throw new ClassGenerationException("CRB000534_Could_not_instantiate_class", args, e);
            }
            catch (ClassFormatError e) {
                Object[] args = new Object[]{className};
                LOG.error("CRB000534_Could_not_instantiate_class", args, e);
                throw new ClassGenerationException("CRB000534_Could_not_instantiate_class", args, e);
            }
        }
        LOG.debug("<<<<< findGeneratedClasses - end");
        return classes;
    }

    private static String getClassName(File file, String basedir) throws ClassGenerationException {
        LOG.debug(">>>>> getClassName - begin");
        String absoluteFileName = file.getAbsolutePath();
        String absoulteBaseDir = new File(basedir).getAbsolutePath();
        LOG.debug("absoluteFileName: " + absoluteFileName + "; absoulteBaseDir: " + absoulteBaseDir);
        if (!absoluteFileName.startsWith(absoulteBaseDir)) {
            Object[] args = new Object[]{file.getAbsolutePath(), absoulteBaseDir};
            LOG.error("CRB000535_Classfile_is_not_under_dir", args);
            throw new ClassGenerationException("CRB000535_Classfile_is_not_under_dir", args, null);
        }
        String relativeFileName = absoluteFileName.substring(absoulteBaseDir.length() + 1);
        LOG.debug("relativeFileName.class=" + relativeFileName);
        if (relativeFileName.endsWith(".class")) {
            relativeFileName = relativeFileName.substring(0, relativeFileName.length() - 6);
            LOG.debug("relativeFileName=" + relativeFileName);
        }
        String className = relativeFileName.replace(File.separator, ".");
        LOG.debug("className=" + className);
        LOG.debug("<<<<< getClassName - end");
        return className;
    }

    public static ClassReader getAsmCLassReader(String classesDirName, String className) throws ClassGenerationException {
        LOG.debug(">>>>> getAsmCLassReader - begin");
        ClassReader cr = Util.getAsmCLassReader(classesDirName + File.separator + className);
        LOG.debug("<<<<< getAsmCLassReader - end. ClassReader=" + cr);
        return cr;
    }

    public static ClassReader getAsmCLassReader(String className) throws ClassGenerationException {
        LOG.debug(">>>>> getAsmCLassReader - begin");
        ClassReader cr = null;
        try {
            cr = new ClassReader((InputStream)new FileInputStream(className));
        }
        catch (IOException e) {
            Object[] args = new Object[]{className};
            LOG.error("CRB000536_Could_not_instantiate_class_reader_for_class", args, e);
            throw new ClassGenerationException("CRB000536_Could_not_instantiate_class_reader_for_class", args, e);
        }
        LOG.debug("<<<<< getAsmCLassReader - end. ClassReader=" + cr);
        return cr;
    }

    public static void saveAsJavaClass(String classesDirName, String relativeFileName, byte[] newBytecode) throws ClassGenerationException {
        LOG.debug(">>>>> saveAs - begin");
        Util.saveAsJavaClass(classesDirName + File.separator + relativeFileName, newBytecode);
        LOG.debug("<<<<< saveAs - end");
    }

    public static void saveAsJavaClass(String absoluteFileName, byte[] newBytecode) throws ClassGenerationException {
        LOG.debug(">>>>> saveAs - begin:" + absoluteFileName);
        try {
            FileOutputStream fos = new FileOutputStream(absoluteFileName);
            fos.write(newBytecode);
            fos.close();
        }
        catch (FileNotFoundException e) {
            Object[] args = new Object[]{absoluteFileName};
            LOG.error("CRB000537_Could_not_instantiate_file_writer_for_class", args, e);
            throw new ClassGenerationException("CRB000537_Could_not_instantiate_file_writer_for_class", args, e);
        }
        catch (IOException e) {
            Object[] args = new Object[]{absoluteFileName};
            LOG.error("CRB000538_Could_not_save_class", args, e);
            throw new ClassGenerationException("CRB000538_Could_not_save_class", args, e);
        }
        LOG.debug("<<<<< saveAs - end");
    }

    public static File saveAsJavaSource(String code, String dir, String name) throws ClassGenerationException {
        LOG.debug(">>>>> saveAsJavaSource - begin");
        File newFile = new File(dir + File.separator + name + ".java");
        FileWriter fw = null;
        try {
            fw = new FileWriter(newFile);
            fw.write(code.toCharArray());
            fw.close();
        }
        catch (IOException e) {
            Object[] args = new Object[]{name};
            LOG.error("CRB000539_Saving_file_problem", args, e);
            throw new ClassGenerationException("CRB000539_Saving_file_problem", args, e);
        }
        LOG.debug("<<<<< saveAsJavaSource - end");
        return newFile;
    }

    public static List<String> valueTypesImpl(String workdirsrc, boolean addToStringEquals) throws ClassGenerationException {
        LOG.debug(">>>>> valueTypesImpl - begin");
        ArrayList<String> vtList = new ArrayList<String>();
        if (workdirsrc == null) {
            LOG.warn("CRB000540_ValueTypesImpl_cannot_work_workdirsrc_is_null");
            LOG.debug("<<<<< valueTypesImpl - end");
            return vtList;
        }
        try {
            int suffixLen = "DefaultFactory.java".length();
            List<String> valueTypes = Util.findAllDefaultFactory(workdirsrc);
            for (int i = 0; i < valueTypes.size(); ++i) {
                String item = valueTypes.get(i);
                String itemBase = item.substring(0, item.length() - suffixLen);
                String x = Util.replaceSeparatorWithDot(itemBase);
                String pkg = Util.extractPackage(workdirsrc, x.substring(0, x.lastIndexOf(".")));
                String clsSuper = x.substring(x.lastIndexOf(".") + 1);
                String cls = clsSuper + "Impl";
                String pt = workdirsrc + File.separator + Util.replaceDotWithSeparator(pkg);
                LOG.debug("valueTypesImpl;\n PACKAGE = " + pkg + ";\n CLASS   = " + cls + ";\n PATH    = " + pt);
                String jsf = Util.generateJavaSourceFile(pkg, cls, clsSuper, addToStringEquals);
                Util.saveAsJavaSource(jsf, pt, cls);
                vtList.add(pkg + "." + clsSuper);
            }
        }
        catch (IOException ioe) {
            LOG.error("CRB000541_Error_during_generation_the_implementation_class_of_the_valuetype", ioe);
            throw new ClassGenerationException("CRB000541_Error_during_generation_the_implementation_class_of_the_valuetype", ioe);
        }
        LOG.debug("<<<<< valueTypesImpl - end. #valueTypes:" + vtList.size());
        return vtList;
    }

    private static String generateJavaSourceFile(String pkg, String className, String parent, boolean addToStringEquals) {
        LOG.debug(">>>>> generateJavaSourceFile - begin");
        String code = null;
        if (addToStringEquals) {
            String importString = "import org.apache.commons.lang.builder.EqualsBuilder;\nimport org.apache.commons.lang.builder.ReflectionToStringBuilder;\n";
            String toStringMethod = "public String toString() {\nreturn ReflectionToStringBuilder.toString(this);\n}\n";
            String equalsMethod = "public boolean equals(Object obj) {\nreturn EqualsBuilder.reflectionEquals(this, obj);\n}\n";
            code = "//it.imolinfo.jbi4corba - auto generated code\npackage " + pkg + ";\n" + importString + "public class " + className + " extends " + parent + " {\n " + toStringMethod + equalsMethod + "}\n";
        } else {
            code = "//it.imolinfo.jbi4corba - auto generated code\npackage " + pkg + ";\n" + "public class " + className + " extends " + parent + " {\n " + "}\n";
        }
        LOG.debug("<<<<< generateJavaSourceFile - end. code:" + code);
        return code;
    }

    public static String replaceSeparatorWithDot(String s) {
        LOG.info("replaceSeparatorWithDot. the input is " + s);
        if (s == null) {
            LOG.debug("replaceSeparatorWithDot. the input is null. returning empty String");
            return "";
        }
        if ("".equals(s)) {
            LOG.debug("replaceSeparatorWithDot. the input is an empty String. returning empty String");
            return "";
        }
        String res = s.replace('\\', '.').replace('/', '.');
        LOG.info("replaceSeparatorWithDot. the input is " + s + " returning " + res);
        return res;
    }

    private static String replaceDotWithSeparator(String s) {
        LOG.debug("replaceDotWithSeparator. the input is " + s);
        if (s == null) {
            LOG.debug("replaceDotWithSeparator. the input is null. returning empty String");
            return "";
        }
        if ("".equals(s)) {
            LOG.debug("replaceDotWithSeparator. the input is an empty String. returning empty String");
            return "";
        }
        String rep = "\\".equals(File.separator) ? "\\\\" : File.separator;
        String res = s.replaceAll("\\.", rep);
        LOG.debug("replaceDotWithSeparator. the input is " + s + " returning " + res);
        return res;
    }

    private static String extractPackage(String basedir, String filename) {
        LOG.debug(">>>>> extractPackage - begin");
        String bd = Util.replaceSeparatorWithDot(basedir);
        String fn = Util.replaceSeparatorWithDot(filename);
        LOG.debug("\nbasedir  =" + bd + ";\nfilename =" + fn);
        LOG.debug("fn.indexOf(bd)=" + fn.indexOf(bd));
        LOG.debug("fn.substring(fn.indexOf(bd))=" + fn.substring(fn.indexOf(bd)));
        LOG.debug("bd.length() + 1=" + (bd.length() + 1));
        LOG.debug("fn.substring(fn.indexOf(bd)).substring(bd.length() + 1)=" + fn.substring(fn.indexOf(bd)).substring(bd.length() + 1));
        String pack = fn.substring(fn.indexOf(bd)).substring(bd.length() + 1);
        LOG.debug("PACK=" + pack);
        LOG.debug("<<<<< extractPackage - end");
        return pack;
    }

    private static String extractJavaQualifiedName(String basedir, String filename, String extension) {
        LOG.debug(">>>>> extractJavaQualifiedName - begin");
        int extLen = extension == null ? 0 : extension.length();
        String bd = Util.replaceSeparatorWithDot(basedir);
        String fn = Util.replaceSeparatorWithDot(filename);
        LOG.debug("\nbasedir  =" + bd + ";\nfilename =" + fn);
        int bdIndex = fn.indexOf(bd) + bd.length() + 1;
        String full = fn.substring(bdIndex, fn.length() - extLen);
        LOG.debug("<<<<< extractJavaQualifiedName - end. return=" + full);
        return full;
    }

    public static Map<String, Object> valueTypeMapHandler(List<String> vtList, String classesDirName, ClassLoader cl) throws ClassGenerationException {
        LOG.debug(">>>>> valueTypeMapHandler - begin");
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String vt : vtList) {
            String valueTypeId = Util.getValueTypeIdFromHelperClass(vt + "Helper", cl);
            Object valueTypeDefaultFactoryInstance = Util.getValueTypeDefaultFactoryInstance(vt + "DefaultFactory", cl);
            if (valueTypeId == null) {
                LOG.warn("CRB000523_ID_null_for_valuetype", vt);
                continue;
            }
            map.put(valueTypeId, valueTypeDefaultFactoryInstance);
        }
        LOG.debug("<<<<< valueTypeMapHandler - end");
        return map;
    }

    public static Map<String, Object> valueTypeMapHandlerWithJbi4corbaFactory(List<String> vtList, String classesDirName, ClassLoader cl) throws ClassGenerationException {
        LOG.debug(">>>>> valueTypeMapHandler - begin");
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String vt : vtList) {
            String valueTypeId = Util.getValueTypeIdFromHelperClass(vt + "Helper", cl);
            Object valueTypeDefaultFactoryInstance = Util.getValueTypeDefaultFactoryInstance(vt + "DefaultFactoryJbi4corba", cl);
            if (valueTypeId == null) {
                LOG.warn("CRB000523_ID_null_for_valuetype", vt);
                continue;
            }
            map.put(valueTypeId, valueTypeDefaultFactoryInstance);
        }
        LOG.debug("<<<<< valueTypeMapHandler - end");
        return map;
    }

    private static Object getValueTypeDefaultFactoryInstance(String factory, ClassLoader cl) throws ClassGenerationException {
        LOG.debug(">>>>> getValueTypeDefaultFactoryInstance - begin:" + factory);
        Class<?> c = null;
        try {
            c = cl.loadClass(factory);
        }
        catch (ClassNotFoundException e) {
            Object[] args = new Object[]{c};
            LOG.error("CRB000524_Error_creating_an_instance_of", args, e);
            throw new ClassGenerationException("CRB000524_Error_creating_an_instance_of", args, e);
        }
        LOG.debug("FactoryClass:" + c);
        Object o = null;
        try {
            o = c.newInstance();
        }
        catch (InstantiationException e) {
            Object[] args = new Object[]{c};
            LOG.error("CRB000524_Error_creating_an_instance_of", args, e);
            throw new ClassGenerationException("CRB000524_Error_creating_an_instance_of", args, e);
        }
        catch (IllegalAccessException e) {
            Object[] args = new Object[]{c};
            LOG.error("CRB000524_Error_creating_an_instance_of", args, e);
            throw new ClassGenerationException("CRB000524_Error_creating_an_instance_of", args, e);
        }
        LOG.debug("<<<<< getValueTypeDefaultFactoryInstance - end:" + o);
        return o;
    }

    public static String getValueTypeIdFromHelperClass(String helper, ClassLoader cl) throws ClassGenerationException {
        LOG.debug(">>>>> getValueTypeIdFromHelperClass - begin:" + helper);
        Class<?> c = null;
        try {
            c = cl.loadClass(helper);
        }
        catch (ClassNotFoundException e) {
            Object[] args = new Object[]{c};
            LOG.error("CRB000525_Error_getting_the_value_type_id_from_class", args, e);
            throw new ClassGenerationException("CRB000525_Error_getting_the_value_type_id_from_class", args, e);
        }
        LOG.debug("HelperClass:" + c);
        Object o = null;
        try {
            o = c.getMethod("id", null).invoke(null, (Object[])null);
        }
        catch (IllegalArgumentException e) {
            Object[] args = new Object[]{c};
            LOG.error("CRB000525_Error_getting_the_value_type_id_from_class", args, e);
            throw new ClassGenerationException("CRB000525_Error_getting_the_value_type_id_from_class", args, e);
        }
        catch (SecurityException e) {
            Object[] args = new Object[]{c};
            LOG.error("CRB000525_Error_getting_the_value_type_id_from_class", args, e);
            throw new ClassGenerationException("CRB000525_Error_getting_the_value_type_id_from_class", args, e);
        }
        catch (IllegalAccessException e) {
            Object[] args = new Object[]{c};
            LOG.error("CRB000525_Error_getting_the_value_type_id_from_class", args, e);
            throw new ClassGenerationException("CRB000525_Error_getting_the_value_type_id_from_class", args, e);
        }
        catch (InvocationTargetException e) {
            Object[] args = new Object[]{c};
            LOG.error("CRB000525_Error_getting_the_value_type_id_from_class", args, e);
            throw new ClassGenerationException("CRB000525_Error_getting_the_value_type_id_from_class", args, e);
        }
        catch (NoSuchMethodException e) {
            Object[] args = new Object[]{c};
            LOG.error("CRB000525_Error_getting_the_value_type_id_from_class", args, e);
            throw new ClassGenerationException("CRB000525_Error_getting_the_value_type_id_from_class", args, e);
        }
        LOG.debug("<<<<< getValueTypeIdFromHelperClass - end:" + o);
        return (String)o;
    }

    public static List<String> prepareClassPath(String libDirName) throws ClassGenerationException {
        LOG.debug(">>>>> prepareClassPath - begin");
        List<File> jarFiles = Util.findFilesFromSourceDirectory(libDirName, ".jar");
        ArrayList<String> jarFilesName = new ArrayList<String>();
        for (File jarFile : jarFiles) {
            try {
                LOG.debug("Adding jar " + jarFile.getCanonicalPath() + " ... ");
                jarFilesName.add(jarFile.getCanonicalPath());
                LOG.debug("... jar " + jarFile.getCanonicalPath() + " added.");
            }
            catch (IOException e) {
                Object[] args = new Object[]{jarFile, e.getMessage()};
                LOG.error("CRB000507_Error_getting_canonicalPath_from_file", args, e);
                throw new ClassGenerationException("CRB000507_Error_getting_canonicalPath_from_file", args, e);
            }
        }
        LOG.debug("<<<<< prepareClassPath - end");
        return jarFilesName;
    }

    public static List<String> generateValueTypeFactoryJbi4corba(List<String> vtList, String basedir) throws ClassGenerationException {
        LOG.debug(">>>>> generateValueTypeFactoryJbi4corba - begin");
        ArrayList<String> newFactoryList = new ArrayList<String>();
        if (vtList == null || vtList.size() == 0) {
            LOG.debug("No factory to create.");
            return newFactoryList;
        }
        for (String vt : vtList) {
            int lastDot = vt.lastIndexOf(".");
            String factoryPackage = vt.substring(0, lastDot);
            String factoryName = vt.substring(lastDot + 1) + "DefaultFactory";
            String newFactoryName = factoryName + "Jbi4corba";
            String newFactorySource = "// JBI4CORBA - Code Generation\npackage " + factoryPackage + ";\n" + "public class " + newFactoryName + " extends " + factoryName + " {\n\n" + "}\n";
            newFactoryList.add(factoryPackage + "." + newFactoryName);
            String targetDir = basedir + File.separator + factoryPackage.replace('.', File.separatorChar);
            Util.saveAsJavaSource(newFactorySource, targetDir, newFactoryName);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Generated a new factory:" + factoryPackage + "." + newFactoryName);
        }
        LOG.debug("<<<<< generateValueTypeFactoryJbi4corba - end.Number of new factory generated:" + newFactoryList.size());
        return newFactoryList;
    }

    public static void tweakSerializableDecoration(String absPath, Long newSerialVersionUid) throws ClassGenerationException {
        ClassWriter cw = new ClassWriter(true);
        CheckClassAdapter cc = new CheckClassAdapter((ClassVisitor)cw);
        StringWriter sw = new StringWriter();
        TraceClassVisitor tv = new TraceClassVisitor((ClassVisitor)cc, new PrintWriter(sw));
        SerializableDecorationAdapter cv = new SerializableDecorationAdapter((ClassVisitor)tv, newSerialVersionUid);
        ClassReader cr = Util.getAsmCLassReader(absPath);
        cr.accept((ClassVisitor)cv, true);
        LOG.debug("ClassReader.accept ... done");
        LOG.debug("output of tracer during creation of class: " + absPath + "\n" + sw.toString());
        byte[] newBytecode = cw.toByteArray();
        Util.saveAsJavaClass(absPath, newBytecode);
    }

    public static ClassMetaInfo tweakSerializableInspection(String absPath) throws ClassGenerationException {
        ClassWriter cw = new ClassWriter(true);
        CheckClassAdapter cc = new CheckClassAdapter((ClassVisitor)cw);
        StringWriter sw = new StringWriter();
        TraceClassVisitor tv = new TraceClassVisitor((ClassVisitor)cc, new PrintWriter(sw));
        SerializableInspectorAdapter cv = new SerializableInspectorAdapter((ClassVisitor)tv);
        ClassReader cr = Util.getAsmCLassReader(absPath);
        cr.accept((ClassVisitor)cv, true);
        LOG.debug("ClassReader.accept ... done");
        return cv.getClassMetaInfo();
    }

    public static Map<String, List<String>> findOnewayOperations(String bin) throws ClassGenerationException {
        List<File> binList = Util.findFilesFromSourceDirectory(bin, "Stub.class");
        HashMap<String, List<String>> global = new HashMap<String, List<String>>();
        for (File stubFile : binList) {
            String absPath = stubFile.getAbsolutePath();
            Map<String, List<String>> map = Util.tweakOnewayInspection(absPath);
            if (map.size() == 0) {
                LOG.debug("No 'oneway' operations for " + absPath);
                continue;
            }
            global.putAll(map);
        }
        return global;
    }

    public static Map<String, List<String>> tweakOnewayInspection(String absPath) throws ClassGenerationException {
        ClassWriter cw = new ClassWriter(true);
        CheckClassAdapter cc = new CheckClassAdapter((ClassVisitor)cw);
        StringWriter sw = new StringWriter();
        TraceClassVisitor cv = new TraceClassVisitor((ClassVisitor)cc, new PrintWriter(sw));
        CorbaOnewayAdapter ca = new CorbaOnewayAdapter((ClassVisitor)cv, sw);
        ClassReader cr = Util.getAsmCLassReader(absPath);
        cr.accept((ClassVisitor)ca, true);
        LOG.debug("ClassReader.accept ... done");
        LOG.debug("Class=" + ca.getAssociatedInterface() + "; Oneway operations:" + ca.getOnewayOperationList().size());
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        if (ca.getOnewayOperationList().size() != 0) {
            map.put(ca.getAssociatedInterface(), ca.getOnewayOperationList());
        }
        return map;
    }

    public static Map<String, List<String>> replaceCorbaEnumaration(String src, String bin) throws ClassGenerationException {
        Map<String, List<String>> corbaEnumMap = Util.findCorbaEnum(bin);
        for (String corbaEnum : corbaEnumMap.keySet()) {
            LOG.debug("corbaEnum=" + corbaEnum);
            List<String> labelList = corbaEnumMap.get(corbaEnum);
            int lastDot = corbaEnum.lastIndexOf(46);
            String aPack = corbaEnum.substring(0, lastDot);
            String aClas = corbaEnum.substring(lastDot + 1);
            String newEnumSource = Util.generateSpecialEnumClass(aPack, aClas, labelList);
            String dir = src + File.separator + aPack.replace('.', File.separatorChar);
            Util.saveAsJavaSource(newEnumSource, dir, aClas);
            String flatBin = bin.replace('/', File.separatorChar).replace('\\', File.separatorChar);
            String zombie = flatBin + File.separator + corbaEnum.replace('.', File.separatorChar) + ".class";
            File zombieFile = new File(zombie);
            if (zombieFile.exists()) {
                LOG.debug("The file " + zombie + " exists.");
            } else {
                LOG.debug("The file " + zombie + " does NOT exists.");
            }
            boolean deleteResult = zombieFile.delete();
            if (deleteResult) {
                LOG.debug("Removing file " + zombie + " ... ok");
                continue;
            }
            LOG.debug("Removing file " + zombie + " ... failure");
        }
        return corbaEnumMap;
    }

    public static String generateSpecialEnumClass(String aPackage, String aClassName, List<String> labelList) {
        String labelSource = "    ";
        if (labelList == null || labelList.size() == 0) {
            String enumClass = aPackage + "." + aClassName;
            Object[] args = new Object[]{enumClass};
            LOG.warn("CRB000549_EmptyEnum", args);
            labelSource = labelSource + ";";
        } else {
            for (int i = 0; i < labelList.size(); ++i) {
                labelSource = i == labelList.size() - 1 ? labelSource + labelList.get(i) + ";" : labelSource + labelList.get(i) + ",";
            }
        }
        String source = "package " + aPackage + ";" + "\n\n" + "public enum " + aClassName + " implements org.omg.CORBA.portable.IDLEntity { " + "\n\n" + labelSource + "\n\n" + "public int value() {return ordinal();} " + "\n\n" + "public static " + aClassName + " from_int (int value) { return " + aClassName + ".values()[value]; } " + "\n\n" + "}";
        return source;
    }

    protected static Map<String, List<String>> findCorbaEnum(String bin) throws ClassGenerationException {
        HashMap<String, List<String>> corbaEnumMap = new HashMap<String, List<String>>();
        List<File> binList = Util.findFilesFromSourceDirectory(bin, ".class");
        for (File currentFile : binList) {
            String absPath = currentFile.getAbsolutePath();
            ClassWriter cw = new ClassWriter(true);
            CheckClassAdapter cc = new CheckClassAdapter((ClassVisitor)cw);
            StringWriter sw = new StringWriter();
            TraceClassVisitor cv = new TraceClassVisitor((ClassVisitor)cc, new PrintWriter(sw));
            CorbaEnumAdapter ca = new CorbaEnumAdapter((ClassVisitor)cv);
            ClassReader cr = Util.getAsmCLassReader(absPath);
            cr.accept((ClassVisitor)ca, true);
            LOG.debug("ClassReader.accept ... done");
            String className = ca.getInternalClassName().replace('/', '.');
            if (ca.isCorbaEnum()) {
                LOG.debug("The class " + className + " is a corba enum.");
                corbaEnumMap.put(className, ca.getEnumLabelList());
                continue;
            }
            LOG.debug("The class " + className + " is NOT a corba enum.");
        }
        return corbaEnumMap;
    }

    public static String generateImplementationClass(ClassLoader urlClassLoader, String remoteClassName) throws ClassGenerationException {
        Method[] arrayOfMethod;
        LOG.debug("generateRemoteClassImplementation; ClassLoader=" + urlClassLoader + "; remoteClassName=" + remoteClassName);
        if (remoteClassName == null || "".equals(remoteClassName)) {
            Object[] arg = new Object[]{"remoteClassName"};
            LOG.error("CRB000551_NotEmptyJavaClassName", arg);
            throw new ClassGenerationException("CRB000551_NotEmptyJavaClassName", arg);
        }
        Class<?> remoteClass = null;
        try {
            remoteClass = urlClassLoader.loadClass(remoteClassName);
        }
        catch (ClassNotFoundException e) {
            Object[] arg = new Object[]{"remoteClassName"};
            LOG.error("CRB000552_ClassNotFound", arg, e);
            throw new ClassGenerationException("CRB000552_ClassNotFound", arg, e);
        }
        if (remoteClass == null) {
            Object[] arg = new Object[]{"remoteClassName"};
            LOG.error("CRB000552_ClassNotFound", arg);
            throw new ClassGenerationException("CRB000552_ClassNotFound", arg);
        }
        String pack = remoteClass.getPackage().getName();
        String name = remoteClass.getSimpleName() + "Impl";
        LOG.debug("The name of the Implementation Class:" + pack + "." + name);
        ArrayList<MethodSignature> msList = new ArrayList<MethodSignature>();
        for (Method method : arrayOfMethod = remoteClass.getMethods()) {
            Class<?>[] arrayOfType;
            int mod = method.getModifiers();
            if (!Modifier.isAbstract(mod)) {
                Object[] arg = new Object[]{method.getName()};
                LOG.warn("CRB000553_UnexpectedNonAbstractMethod", arg);
                continue;
            }
            MethodSignature ms = new MethodSignature();
            ms.setMethodName(method.getName());
            ArrayList<String> typeList = new ArrayList<String>();
            for (Class<?> type : arrayOfType = method.getParameterTypes()) {
                String canonical = type.getCanonicalName();
                typeList.add(canonical);
                LOG.debug("Parameter=" + canonical);
            }
            ms.setParametersType(typeList);
            arrayOfType = null;
            Class<?> returnClass = method.getReturnType();
            ms.setReturnType(returnClass.getCanonicalName());
            ArrayList<String> exceptions = new ArrayList<String>();
            for (Class<?> type : arrayOfType = method.getExceptionTypes()) {
                String canonical = type.getCanonicalName();
                exceptions.add(canonical);
                LOG.debug("Exception=" + canonical);
            }
            ms.setExceptionsType(exceptions);
            msList.add(ms);
        }
        String cihFullname = "it.imolinfo.jbi4corba.webservice.runtime.ConsumerInvocationHandler";
        String implSource = "package " + pack + ";" + "\n\n" + "public class " + name + " implements " + remoteClassName + ", java.rmi.Remote {" + "\n\n" + " protected " + cihFullname + " consumerInvocationHandler;" + "\n\n" + "\n  public " + name + "() {" + "\n    // NOP" + "\n  }" + "\n\n" + "\n  public " + name + "(" + cihFullname + " cih) {" + "\n    consumerInvocationHandler = cih;" + "\n  }" + "\n\n" + Util.methodImplementation(msList) + "\n\n" + "}\n";
        if (LOG.isDebugEnabled()) {
            LOG.debug("\n--------\n" + implSource + "\n--------\n");
        }
        return implSource;
    }

    protected static String methodImplementation(List<MethodSignature> msList) {
        if (msList == null || msList.isEmpty()) {
            return "";
        }
        String src = "";
        for (MethodSignature ms : msList) {
            String paramSource = "";
            for (int i = 0; i < ms.getParametersType().size(); ++i) {
                paramSource = i == 0 ? ms.getParametersType().get(i) + " param" + i : paramSource + ", " + ms.getParametersType().get(i) + " param" + i;
            }
            String exceptionSource = "";
            for (int i = 0; i < ms.getExceptionsType().size(); ++i) {
                exceptionSource = i == 0 ? "throws " + ms.getExceptionsType().get(i) : exceptionSource + ", " + ms.getExceptionsType().get(i);
            }
            String methodSource = "public " + ms.getReturnType() + " " + ms.getMethodName() + "(" + paramSource + ") " + exceptionSource + " { " + Util.generateTheBodyOfTheMethodForImplTie(ms) + " }";
            src = src + methodSource + "\n\n";
        }
        return src;
    }

    protected static String generateTheBodyOfTheMethodForImplTie(MethodSignature methodSignature) {
        String arrayOfParamValue = "new Object [] {";
        String arrayOfParamType = "new Class [] {";
        int paramSize = methodSignature.getParametersType().size();
        for (int iParam = 0; iParam < paramSize; ++iParam) {
            if (iParam == 0) {
                arrayOfParamValue = arrayOfParamValue + "param" + iParam;
                arrayOfParamType = arrayOfParamType + methodSignature.getParametersType().get(iParam) + ".class";
                continue;
            }
            arrayOfParamValue = arrayOfParamValue + ", param" + iParam;
            arrayOfParamType = arrayOfParamType + ", " + methodSignature.getParametersType().get(iParam) + ".class";
        }
        arrayOfParamValue = arrayOfParamValue + "}";
        arrayOfParamType = arrayOfParamType + "}";
        LOG.debug("arrayOfParamValue=[" + arrayOfParamValue + "]");
        LOG.debug("arrayOfParamType=[" + arrayOfParamType + "]");
        String getMethodAsString = "\n java.lang.reflect.Method method = null;\n try {\n   method = this.getClass().getMethod(\"" + methodSignature.getMethodName() + "\", " + arrayOfParamType + ");" + "\n } catch (SecurityException e) {" + "\n   throw new java.rmi.RemoteException(e.getMessage());" + "\n } catch (NoSuchMethodException e) {" + "\n   throw new java.rmi.RemoteException(e.getMessage());" + "\n }" + "\n\n";
        String allEx = "";
        for (String exceptionType : methodSignature.getExceptionsType()) {
            String ex = "\nif (t instanceof " + exceptionType + ") {" + "  throw (" + exceptionType + ") t;" + "}";
            if ("".equals(allEx)) {
                allEx = allEx + ex;
                continue;
            }
            allEx = allEx + "\n else " + ex;
        }
        String returnCast = null;
        returnCast = "double".equals(methodSignature.getReturnType()) ? "return (Double) cih;" : ("byte".equals(methodSignature.getReturnType()) ? "return (Byte) cih;" : ("short".equals(methodSignature.getReturnType()) ? "return (Short) cih;" : ("int".equals(methodSignature.getReturnType()) ? "return (Integer) cih;" : ("long".equals(methodSignature.getReturnType()) ? "return (Long) cih;" : ("float".equals(methodSignature.getReturnType()) ? "return (Float) cih;" : ("boolean".equals(methodSignature.getReturnType()) ? "return (Boolean) cih;" : ("char".equals(methodSignature.getReturnType()) ? "return (Character) cih;" : ("char".equals(methodSignature.getReturnType()) ? "return (Character) cih;" : ("void".equals(methodSignature.getReturnType()) ? "return;" : "return (" + methodSignature.getReturnType() + ") cih;")))))))));
        String runtime = "it.imolinfo.jbi4corba.exception.Jbi4CorbaRuntimeException";
        String invokeAsString = "\n Object cih = null;\n try {\n   cih = consumerInvocationHandler.invoke(this, method, " + arrayOfParamValue + ");" + "\n } catch (Throwable tx) {" + "\n   if (tx instanceof " + runtime + ") {" + "\n     String message = tx.getMessage();" + "\n     throw new java.rmi.RemoteException(message);" + "\n   } else {" + "\n     Throwable t = tx.getCause();" + allEx + "\n   }" + "\n }" + "\n\n" + returnCast;
        return getMethodAsString + invokeAsString;
    }

    public static Map<Long, String> extractSerialVersionUid(String classesDir, List<String> pathList) throws ClassGenerationException {
        HashMap<Long, String> uidMap = new HashMap<Long, String>();
        if (pathList == null) {
            // empty if block
        }
        for (String path : pathList) {
            File file = new File(path);
            Class clazz = Util.classLoad(classesDir, file);
            Long uid = Util.extractSerialVersionUid(clazz);
            if (uid == null) continue;
            uidMap.put(uid, path);
        }
        return uidMap;
    }

    public static Long extractSerialVersionUid(Class classToSerialize) {
        Long uid = null;
        if (classToSerialize == null) {
            return uid;
        }
        LOG.debug("Looking for class: " + classToSerialize.getName());
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(classToSerialize);
        if (objectStreamClass == null) {
            LOG.warn("The objectStreamClass is null for class: " + classToSerialize.getName() + " the class is Serializable? ... I will return an UID = null.");
        } else {
            uid = objectStreamClass.getSerialVersionUID();
            LOG.debug(classToSerialize.getName() + " uid: " + uid);
        }
        return uid;
    }

    public static void debug(String message, Collection collection) {
        String msg;
        if (!LOG.isDebugEnabled()) {
            return;
        }
        String string = msg = message == null ? "" : message;
        if (collection == null) {
            LOG.debug(msg + "; Collection is null.");
            return;
        }
        if (collection.size() == 0) {
            LOG.debug(msg + "; Collection is empty.");
            return;
        }
        int counter = 0;
        for (Object o : collection) {
            LOG.debug(msg + "; Collection[" + counter++ + "]=" + o);
        }
    }

    public static void debug(String message, Map map) {
        String msg;
        if (!LOG.isDebugEnabled()) {
            return;
        }
        String string = msg = message == null ? "" : message;
        if (map == null) {
            LOG.debug(msg + "; Map is null.");
            return;
        }
        if (map.size() == 0) {
            LOG.debug(msg + "; Map is empty.");
            return;
        }
        for (Object k : map.keySet()) {
            LOG.debug(msg + "; Collection[" + k + "]=" + map.get(k));
        }
    }

    public static synchronized File createUniqueDirectory(File rootDir, String seed) throws IOException {
        int index = seed.lastIndexOf(46);
        if (index > 0) {
            seed = seed.substring(0, index);
        }
        File result = null;
        int count = 0;
        while (result == null) {
            String name = seed + "." + count + ".tmp";
            File file = new File(rootDir, name);
            if (!file.exists()) {
                file.mkdirs();
                result = file;
            }
            ++count;
        }
        return result;
    }

    public static boolean buildDirectory(File file) {
        return file.exists() || file.mkdirs();
    }

    public static void copyInputStream(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[4096];
        int len = in.read(buffer);
        while (len >= 0) {
            out.write(buffer, 0, len);
            len = in.read(buffer);
        }
        in.close();
        out.close();
    }

    static {
        LOG = LoggerFactory.getLogger(Util.class);
        PROTOCOL = System.getProperty("os.name").indexOf("Win") >= 0 ? "file:///" : "file://";
    }
}

