/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.webservice.generator;

import it.imolinfo.jbi4corba.Logger;
import it.imolinfo.jbi4corba.LoggerFactory;
import it.imolinfo.jbi4corba.exception.ClassGenerationException;
import it.imolinfo.jbi4corba.exception.Jbi4CorbaException;
import it.imolinfo.jbi4corba.webservice.generator.ServerCorbaClassesHolder;
import it.imolinfo.jbi4corba.webservice.generator.Util;
import it.imolinfo.jbi4corba.webservice.generator.WsdlInformation;
import it.imolinfo.jbi4corba.webservice.generator.bcm.AddExceptionSuperclass;
import it.imolinfo.jbi4corba.webservice.generator.bcm.RemoteEnhancerAdapter;
import it.imolinfo.jbi4corba.webservice.generator.bcm.TweakRemoteInterfaceException;
import it.imolinfo.jbi4corba.webservice.generator.bcm.UIDAdapter;
import it.imolinfo.jbi4corba.webservice.generator.bcm.ValueTypeAdapter;
import it.imolinfo.jbi4corba.webservice.generator.bcm.WsdlToCorbaAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;
import org.codehaus.xfire.gen.Wsdl11Generator;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.wsdl11.parser.WSDLServiceBuilder;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.util.CheckClassAdapter;
import org.objectweb.asm.util.TraceClassVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsumerServiceClassesGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(ConsumerServiceClassesGenerator.class);

    public ServerCorbaClassesHolder generateConsumerServiceClasses(String wsdlStringUrl, String workdir, String libDirName) throws ClassGenerationException {
        LOG.debug(">>>>> generateConsumerServiceClasses - begin");
        List<String> jars = Util.prepareClassPath(libDirName);
        ServerCorbaClassesHolder s = this.generateConsumerServiceClassesDirect(wsdlStringUrl, workdir, jars);
        LOG.debug("<<<<< generateConsumerServiceClasses - end");
        return s;
    }

    public ServerCorbaClassesHolder generateConsumerServiceClassesDirect(String wsdlStringUrl, String workdir, List<String> jars) throws ClassGenerationException {
        LOG.debug(">>>>> generateConsumerServiceClasses - begin");
        LOG.debug("generateConsumerServiceClasses. wsdlStringUrl=" + wsdlStringUrl + "; workdir=" + workdir + "; jars=" + jars);
        File wsdlDirFile = this.copyWsdlTo(workdir, wsdlStringUrl);
        String wsdlDirName = null;
        try {
            wsdlDirName = wsdlDirFile.getCanonicalPath();
        }
        catch (IOException ioe) {
            LOG.error("CRB000500_Error_accessing_the_WSDL_directory", ioe);
            throw new ClassGenerationException("CRB000500_Error_accessing_the_WSDL_directory", ioe);
        }
        this.copyOrbIrIdl(wsdlDirName);
        String sourceDirName = this.mkdir(wsdlDirFile, "src");
        String classesDirName = this.mkdir(wsdlDirFile, "classes");
        WsdlInformation wsdlInformation = this.wsdlToJava(wsdlDirName, sourceDirName);
        List<QName> portTypeList = wsdlInformation.getPortTypeList();
        this.javac(sourceDirName, classesDirName, jars);
        String portTypeClassName = this.findingPortTypeClassName(portTypeList, classesDirName);
        String remoteClassName = this.tweakInterfaceClasses(portTypeClassName, classesDirName);
        List<String> modifiedClassNames = this.tweakValueType(remoteClassName, classesDirName);
        URLClassLoader urlClassLoader = this.getURLClassLoader(classesDirName);
        LOG.debug("instantiate class loader ... done");
        String newSourceCode = Util.generateImplementationClass(urlClassLoader, remoteClassName);
        String newSourcePath = remoteClassName.replace('.', File.separatorChar) + "Impl";
        LOG.debug("newSourcePath=[" + sourceDirName + File.separatorChar + newSourcePath + "]");
        File newSourceFile = Util.saveAsJavaSource(newSourceCode, sourceDirName, newSourcePath);
        ArrayList<String> extra = new ArrayList<String>();
        extra.add(classesDirName);
        ArrayList<String> newSourceList = new ArrayList<String>();
        newSourceList.add(newSourceFile.getAbsolutePath());
        Util.compileJavaClasses(sourceDirName, classesDirName, newSourceList, jars, extra);
        Util.compileRemoteClassesNoValueMethodsON(classesDirName, remoteClassName + "Impl", extra);
        List<String> newPathList = this.add(classesDirName, modifiedClassNames);
        Map<Long, String> uidMap = Util.extractSerialVersionUid(classesDirName, newPathList);
        this.tweakWsdlToCorba(modifiedClassNames, classesDirName);
        LOG.debug("end creating java sources implementation for value types.");
        this.tweakUID(uidMap);
        int lastDot = remoteClassName.lastIndexOf(".");
        String poaPackage = remoteClassName.substring(0, lastDot);
        String poaName = "_" + remoteClassName.substring(lastDot + 1) + "Impl_Tie";
        String poaTie = poaPackage + "." + poaName;
        String serviceName = this.extractServiceNameFromPortType(wsdlDirName, portTypeList.get(0));
        String portTypePackage = portTypeClassName.substring(0, portTypeClassName.lastIndexOf(46));
        String serviceImpl = portTypePackage + "." + serviceName + "Impl";
        LOG.debug("poaTie=" + poaTie + "; serviceImpl=" + serviceImpl);
        ServerCorbaClassesHolder serverCorbaClassesHolder = new ServerCorbaClassesHolder();
        urlClassLoader = this.getURLClassLoader(classesDirName);
        LOG.debug("instantiate class loader ... done");
        this.setCorbaOperations(serverCorbaClassesHolder, urlClassLoader, remoteClassName);
        this.setCorbaPOATie(serverCorbaClassesHolder, urlClassLoader, poaTie);
        this.setCorbaImpl(serverCorbaClassesHolder, urlClassLoader, remoteClassName + "Impl");
        this.setWebServiceInterface(serverCorbaClassesHolder, urlClassLoader, portTypeClassName);
        serverCorbaClassesHolder.setUrlClassLoader(urlClassLoader);
        this.setWebServiceImpl(serverCorbaClassesHolder, urlClassLoader, serviceImpl);
        serverCorbaClassesHolder.setWsdlInformation(wsdlInformation);
        LOG.debug("<<<<< generateConsumerServiceClasses - end");
        return serverCorbaClassesHolder;
    }

    private List<String> add(String dir, List<String> pathList) {
        LOG.debug("MIRCO 0");
        ArrayList<String> newPathList = new ArrayList<String>();
        if (pathList == null || pathList.size() == 0) {
            LOG.debug("MIRCO 1");
            return newPathList;
        }
        String basedir = null;
        basedir = dir == null ? "" : dir;
        for (String path : pathList) {
            String np = basedir + File.separator + path.replace('.', File.separatorChar) + ".class";
            newPathList.add(np);
            LOG.debug("NEWPATH=" + np);
        }
        return newPathList;
    }

    private List<String> tweakValueType(String remoteClassName, String classesDirName) throws ClassGenerationException {
        LOG.debug(">>>>> tweakValueType - begin");
        ArrayList<String> javaClassNameOfTheModifiedClasses = new ArrayList<String>();
        String cn = remoteClassName.replace('.', File.separator.charAt(0));
        ArrayList<File> classList = new ArrayList<File>();
        classList.add(new File(classesDirName + File.separator + cn));
        Set<Class> classesToChange = Util.findClassUsed(classesDirName, classList);
        for (Class c : classesToChange) {
            String className = classesDirName + File.separator + c.getName().replace('.', '/') + ".class";
            LOG.debug("tweakValueType for " + className);
            javaClassNameOfTheModifiedClasses.add(c.getName());
            ClassWriter cw = new ClassWriter(true);
            CheckClassAdapter cc = new CheckClassAdapter((ClassVisitor)cw);
            StringWriter sw = new StringWriter();
            TraceClassVisitor tv = new TraceClassVisitor((ClassVisitor)cc, new PrintWriter(sw));
            ValueTypeAdapter cv = new ValueTypeAdapter((ClassVisitor)tv, cw, className);
            ClassReader cr = Util.getAsmCLassReader(className);
            LOG.debug("getAsmCLassReader ... done");
            cr.accept((ClassVisitor)cv, true);
            LOG.debug("ClassReader.accept ... done");
            if (LOG.isDebugEnabled()) {
                LOG.debug("output of tracer during creation of class: " + className + "\n" + sw.toString());
            }
            byte[] newBytecode = cw.toByteArray();
            String relativeFileName = className.replace('/', File.separatorChar);
            Util.saveAsJavaClass(relativeFileName, newBytecode);
        }
        LOG.debug("<<<<< tweakValueType - end");
        return javaClassNameOfTheModifiedClasses;
    }

    private void tweakWsdlToCorba(List<String> files, String classesDirName) throws ClassGenerationException {
        LOG.debug(">>>>>>>>>> tweakAdapting - begin");
        if (files == null || files.size() == 0) {
            LOG.debug("<<<<<<<<<< tweakAdapting - end.No files to manipulate.");
            return;
        }
        for (String vt : files) {
            String className = classesDirName + File.separator + vt.replace('.', '/') + ".class";
            ClassWriter cw = new ClassWriter(true);
            CheckClassAdapter cc = new CheckClassAdapter((ClassVisitor)cw);
            StringWriter sw = new StringWriter();
            TraceClassVisitor tv = new TraceClassVisitor((ClassVisitor)cc, new PrintWriter(sw));
            WsdlToCorbaAdapter cv = new WsdlToCorbaAdapter((ClassVisitor)tv, cw, className, classesDirName);
            ClassReader cr = Util.getAsmCLassReader(className);
            LOG.debug("getAsmCLassReader ... done");
            cr.accept((ClassVisitor)cv, true);
            LOG.debug("ClassReader.accept ... done");
            LOG.debug("output of tracer during creation of class: " + className + "\n" + sw.toString());
            byte[] newBytecode = cw.toByteArray();
            String relativeFileName = className.replace('/', File.separatorChar);
            Util.saveAsJavaClass(relativeFileName, newBytecode);
        }
        LOG.debug("<<<<<<<<<< tweakAdapting - end");
    }

    private void tweakUID(Map<Long, String> uidPathMap) throws ClassGenerationException {
        LOG.debug(">>>>>>>>>> tweakUID - begin");
        if (uidPathMap == null || uidPathMap.size() == 0) {
            LOG.debug("<<<<<<<<<< tweakUID - end.No files to manipulate.");
            return;
        }
        for (Long uid : uidPathMap.keySet()) {
            String path = uidPathMap.get(uid);
            LOG.debug("tweakUID. path=" + path + "; uid=" + uid);
            ClassWriter cw = new ClassWriter(true);
            CheckClassAdapter cc = new CheckClassAdapter((ClassVisitor)cw);
            StringWriter sw = new StringWriter();
            TraceClassVisitor tv = new TraceClassVisitor((ClassVisitor)cc, new PrintWriter(sw));
            UIDAdapter cv = new UIDAdapter((ClassVisitor)tv, cw, uid);
            ClassReader cr = Util.getAsmCLassReader(path);
            LOG.debug("tweakUID. getAsmCLassReader ... done");
            cr.accept((ClassVisitor)cv, true);
            LOG.debug("tweakUID. ClassReader.accept ... done");
            LOG.debug("tweakUID. output of tracer during creation of class: " + path + "\n" + sw.toString());
            byte[] newBytecode = cw.toByteArray();
            Util.saveAsJavaClass(path, newBytecode);
        }
        LOG.debug("<<<<<<<<<< tweakAdapting - end");
    }

    public List<String> copyIDLs(String classesDirName, String wsdlDirName, String remoteClassName) throws ClassGenerationException {
        LOG.debug(">>>>> copyIDLs - begin");
        String idlFilename = classesDirName + File.separator + remoteClassName.replace('.', File.separatorChar) + ".idl";
        String destIdlFileName = wsdlDirName + File.separator + remoteClassName.substring(remoteClassName.lastIndexOf(46) + 1) + ".idl";
        this.copyFile(idlFilename, destIdlFileName);
        List<String> idls = null;
        try {
            idls = Util.findIdlFiles(classesDirName);
        }
        catch (Jbi4CorbaException e) {
            LOG.error(e.getMessage(), e);
            throw new ClassGenerationException(e);
        }
        File wf = new File(wsdlDirName);
        for (int i = 0; i < (idls == null ? 0 : idls.size()); ++i) {
            LOG.debug("copying idls[" + i + "]=" + idls.get(i));
            if (idls.get(i).equals(idlFilename)) {
                LOG.debug("already copied:" + idls.get(i));
                continue;
            }
            String pkgAsDir = this.subBasedir(idls.get(i), classesDirName);
            this.mkdir(wf, pkgAsDir);
            String fn = pkgAsDir + File.separator + new File(idls.get(i)).getName();
            this.copyFile(classesDirName + File.separator + fn, wsdlDirName + File.separator + fn);
        }
        LOG.debug("<<<<< copyIDLs - end");
        return idls;
    }

    private String subBasedir(String fullFilename, String basedir) {
        LOG.debug(">>>>> subBasedir - begin");
        String s = fullFilename.substring(basedir.length() + 1);
        int limit = s.lastIndexOf(File.separator);
        s = s.substring(0, limit);
        LOG.debug("<<<<< subBasedir - end:" + s);
        return s;
    }

    private String findingPortTypeClassName(List<QName> portTypesList, String classesDirName) throws ClassGenerationException {
        String portTypeClassName;
        int size;
        LOG.debug(">>>>> finding portTypeClassName - begin");
        int n = size = portTypesList == null ? 0 : portTypesList.size();
        if (size != 1) {
            LOG.error("CRB000504_Expected_exactly_one_class", size);
            throw new ClassGenerationException("CRB000504_Expected_exactly_one_class", new Object[]{size}, null);
        }
        String c = portTypesList.get(0).getLocalPart() + ".class";
        List<File> portTypeClasses = Util.findFilesFromSourceDirectory(classesDirName, c);
        if (portTypeClasses.size() != 1) {
            LOG.error("CRB000505_PortType_class_not_found", c);
            throw new ClassGenerationException("CRB000505_PortType_class_not_found", new Object[]{c}, null);
        }
        LOG.debug("PortType class not found:" + portTypeClasses.get(0));
        try {
            portTypeClassName = portTypeClasses.get(0).getCanonicalPath();
            portTypeClassName = portTypeClasses.get(0).getCanonicalPath().substring(classesDirName.length() + 1, portTypeClassName.length() - ".class".length());
            portTypeClassName = portTypeClassName.replace('/', '.').replace('\\', '.');
            LOG.debug("finding PortType class - " + portTypeClassName);
        }
        catch (IOException e) {
            Object[] args = new Object[]{portTypeClasses.get(0)};
            LOG.error("CRB000503_Error_getting_name", args, e);
            throw new ClassGenerationException("CRB000503_Error_getting_name", args, e);
        }
        LOG.debug("<<<<< finding portTypeClassName - end");
        return portTypeClassName;
    }

    private List<String> javac(String sourceDirName, String classesDirName, List<String> jarFilesName) throws ClassGenerationException {
        List<String> sources;
        LOG.debug(">>>>> javac - begin");
        try {
            sources = Util.findJavaSources(sourceDirName);
        }
        catch (Jbi4CorbaException e) {
            Object[] args = new Object[]{sourceDirName, e.getMessage()};
            LOG.error("CRB000501_Error_generating_sources_list", args, e);
            throw new ClassGenerationException("CRB000501_Error_generating_sources_list", args, e);
        }
        LOG.debug("compiling java classes - sources found");
        Util.compileJavaClasses(sourceDirName, classesDirName, sources, jarFilesName, null);
        LOG.debug("<<<<< javac - end");
        return sources;
    }

    private void setWebServiceInterface(ServerCorbaClassesHolder serverCorbaClassesHolder, URLClassLoader urlClassLoader, String portType) throws ClassGenerationException {
        LOG.debug(">>>>> setWebServiceInterface - begin");
        try {
            serverCorbaClassesHolder.setWebServiceInterface(urlClassLoader.loadClass(portType));
        }
        catch (ClassNotFoundException e) {
            Object[] args = new Object[]{"setWebServiceInterface", portType, urlClassLoader};
            LOG.error("CRB000506_Error_during_method", args, e);
            throw new ClassGenerationException("CRB000506_Error_during_method", args, e);
        }
        LOG.debug("<<<<< setWebServiceInterface - end");
    }

    private void setWebServiceImpl(ServerCorbaClassesHolder serverCorbaClassesHolder, URLClassLoader urlClassLoader, String implClass) throws ClassGenerationException {
        LOG.debug(">>>>> setWebServiceImpl - begin");
        try {
            serverCorbaClassesHolder.setWebServiceImpl(urlClassLoader.loadClass(implClass));
        }
        catch (ClassNotFoundException e) {
            Object[] args = new Object[]{"setWebServiceImplementation", implClass, urlClassLoader};
            LOG.error("CRB000506_Error_during_method", args, e);
            throw new ClassGenerationException("CRB000506_Error_during_method", args, e);
        }
        LOG.debug("<<<<< setWebServiceImplementation - end");
    }

    private void setCorbaPOATie(ServerCorbaClassesHolder serverCorbaClassesHolder, URLClassLoader urlClassLoader, String poaTie) throws ClassGenerationException {
        LOG.debug(">>>>> setCorbaPOATie - begin");
        try {
            serverCorbaClassesHolder.setCorbaPOATie(urlClassLoader.loadClass(poaTie));
        }
        catch (ClassNotFoundException e) {
            Object[] args = new Object[]{"setCorbaPOATie", poaTie, urlClassLoader};
            LOG.error("CRB000506_Error_during_method", args, e);
            throw new ClassGenerationException("CRB000506_Error_during_method", args, e);
        }
        LOG.debug("<<<<< setCorbaPOATie - end");
    }

    private void setCorbaImpl(ServerCorbaClassesHolder serverCorbaClassesHolder, URLClassLoader urlClassLoader, String corbaImpl) throws ClassGenerationException {
        LOG.debug(">>>>> setCorbaImpl - begin");
        try {
            serverCorbaClassesHolder.setCorbaImplClass(urlClassLoader.loadClass(corbaImpl));
        }
        catch (ClassNotFoundException e) {
            Object[] args = new Object[]{"setCorbaImpl", corbaImpl, urlClassLoader};
            LOG.error("CRB000506_Error_during_method", args, e);
            throw new ClassGenerationException("CRB000506_Error_during_method", args, e);
        }
        LOG.debug("<<<<< setCorbaImpl - end");
    }

    private void setCorbaOperations(ServerCorbaClassesHolder serverCorbaClassesHolder, URLClassLoader urlClassLoader, String operations) throws ClassGenerationException {
        LOG.debug(">>>>> setCorbaOperations - begin");
        try {
            serverCorbaClassesHolder.setCorbaOperations(urlClassLoader.loadClass(operations));
        }
        catch (ClassNotFoundException e) {
            Object[] args = new Object[]{"setCorbaOperations", operations, urlClassLoader};
            LOG.debug("urlClassLoader.getURLs()=" + Arrays.asList(urlClassLoader.getURLs()));
            LOG.error("CRB000506_Error_during_method", args, e);
            throw new ClassGenerationException("CRB000506_Error_during_method", args, e);
        }
        LOG.debug("<<<<< setCorbaOperations - end");
    }

    private void copyOrbIrIdl(String wsdlDirName) throws ClassGenerationException {
        LOG.debug(">>>>> copyOrbIrIdl - begin");
        InputStream orbis = this.getClass().getClassLoader().getResourceAsStream("orb.idl");
        if (orbis == null) {
            LOG.error("CRB000508_Could_not_find_orb.idl_in_path");
            throw new ClassGenerationException("CRB000508_Could_not_find_orb.idl_in_path");
        }
        LOG.debug("orbis not null ... orb.idl found");
        InputStream iris = this.getClass().getClassLoader().getResourceAsStream("ir.idl");
        if (iris == null) {
            LOG.error("CRB000509_Could_not_find_ir.idl_in_path");
            throw new ClassGenerationException("CRB000509_Could_not_find_ir.idl_in_path");
        }
        LOG.debug("iris not null ... ir.idl found");
        String orbFileName = wsdlDirName + File.separator + "orb.idl";
        String irFileName = wsdlDirName + File.separator + "ir.idl";
        this.copyFile(orbis, orbFileName);
        this.copyFile(iris, irFileName);
        LOG.debug("copyFile (orb.idl and ir.idl) to " + wsdlDirName + " ...ok");
        LOG.debug("<<<<< copyOrbIrIdl - end");
    }

    private String tweakInterfaceClasses(String portTypeClassName, String classesDirName) throws ClassGenerationException {
        ClassReader cr;
        LOG.debug(">>>>>>>>>> tweakInterfaceClasses - begin");
        LOG.debug("remotizing class: " + portTypeClassName + " in dir: " + classesDirName);
        ClassWriter cw = new ClassWriter(true);
        CheckClassAdapter cc = new CheckClassAdapter((ClassVisitor)cw);
        StringWriter sw = new StringWriter();
        TraceClassVisitor tv = new TraceClassVisitor((ClassVisitor)cc, new PrintWriter(sw));
        RemoteEnhancerAdapter cv = new RemoteEnhancerAdapter((ClassVisitor)tv, this.getAsFullyQualifiedNameInternalForm(portTypeClassName));
        LOG.debug("new ClassReader - Begin");
        try {
            cr = new ClassReader((InputStream)new FileInputStream(this.getAsFileName(classesDirName, portTypeClassName, ".class")));
        }
        catch (IOException e) {
            Object[] args = new Object[]{portTypeClassName, classesDirName};
            LOG.error("CRB000510_Could_not_instantiate_class_reader", args, e);
            throw new ClassGenerationException("CRB000510_Could_not_instantiate_class_reader", args, e);
        }
        LOG.debug("new ClassReader - End");
        cr.accept((ClassVisitor)cv, true);
        LOG.debug("output of tracer during creation of class: " + portTypeClassName + "\n" + sw.toString());
        byte[] newBytecode = cw.toByteArray();
        String relativeFileName = cv.getCompleteName().replace('/', File.separatorChar);
        LOG.debug("relativeFileName=" + relativeFileName + "; cv.getCompleteName()=" + cv.getCompleteName());
        Util.saveAsJavaClass(classesDirName + File.separator + relativeFileName + ".class", newBytecode);
        String remoteClassName = cv.getCompleteName().replace('/', '.');
        LOG.debug("<<<<<<<<<< tweakInterfaceClasses - end:" + remoteClassName);
        return remoteClassName;
    }

    private void copyFile(String sourceFileName, String destFileName) throws ClassGenerationException {
        FileInputStream is;
        LOG.debug(">>>>>>>>>> copyFile(String, String) - begin");
        LOG.debug("copying: " + sourceFileName + " to: " + destFileName);
        try {
            is = new FileInputStream(sourceFileName);
        }
        catch (FileNotFoundException e) {
            Object[] args = new Object[]{sourceFileName, e.getMessage()};
            LOG.error("CRB000511_Error_opening", args, e);
            throw new ClassGenerationException("CRB000511_Error_opening", args, e);
        }
        this.copyFile(is, destFileName);
        LOG.debug("<<<<<<<<<< copyFile(String, String) - end");
    }

    private void copyFile(InputStream sourceInputStream, String destFileName) throws ClassGenerationException {
        FileOutputStream fos;
        LOG.debug(">>>>>>>>>> copyFile(InputStream, String) - begin");
        LOG.debug("copying: " + sourceInputStream + " to: " + destFileName);
        try {
            fos = new FileOutputStream(new File(destFileName));
        }
        catch (FileNotFoundException e) {
            Object[] args = new Object[]{destFileName, e.getMessage()};
            LOG.error("CRB000512_Error_creating", args, e);
            throw new ClassGenerationException("CRB000512_Error_creating", args, e);
        }
        LOG.debug("FileUtil.copyInputStream");
        try {
            Util.copyInputStream(sourceInputStream, fos);
        }
        catch (IOException e) {
            Object[] args = new Object[]{sourceInputStream, destFileName, e.getMessage()};
            LOG.error("CRB000513_Error_copying_input_stream", args, e);
            throw new ClassGenerationException("CRB000513_Error_copying_input_stream", args, e);
        }
        LOG.debug("<<<<<<<<<< copyFile(InputStream, String) - end");
    }

    private FileSystemManager getFileSystemManager() throws ClassGenerationException {
        try {
            return VFS.getManager();
        }
        catch (FileSystemException e) {
            Object[] args = new Object[]{e.getMessage()};
            LOG.error("CRB000514_Error_inizializing_virtual_filesystem", args, e);
            throw new ClassGenerationException("CRB000514_Error_inizializing_virtual_filesystem", args, e);
        }
    }

    private URLClassLoader getURLClassLoader(String classesDirName) throws ClassGenerationException {
        LOG.debug(">>>>>>>>>> getURLClassLoader - begin");
        URLClassLoader urlClassLoader = null;
        String protocol = null;
        try {
            protocol = System.getProperty("os.name").indexOf("Win") >= 0 ? "file:///" : "file://";
            urlClassLoader = new URLClassLoader(new URL[]{new URL(protocol + classesDirName + "/")}, this.getClass().getClassLoader());
            LOG.debug("url classloader: " + Arrays.asList(urlClassLoader.getURLs()));
        }
        catch (MalformedURLException e) {
            Object[] args = new Object[]{protocol + classesDirName + "/"};
            LOG.error("CRB000515_Could_not_instantiate_url_class_loader", args, e);
            throw new ClassGenerationException("CRB000515_Could_not_instantiate_url_class_loader", args, e);
        }
        LOG.debug("<<<<<<<<<< getURLClassLoader - end");
        return urlClassLoader;
    }

    private File copyWsdlTo(String workdir, String wsdlStringUrl) throws ClassGenerationException {
        String wsdlDirName;
        File wsdlDirFile;
        InputStream wsdlInputStream;
        FileObject wsdlFile;
        LOG.debug(">>>>>>>>>> copyWsdlTo - begin");
        LOG.debug("workdir=" + workdir + "; wsdlStringUrl=" + wsdlStringUrl);
        File workdirFile = new File(workdir);
        FileSystemManager fsManager = this.getFileSystemManager();
        try {
            wsdlFile = fsManager.resolveFile(wsdlStringUrl);
        }
        catch (FileSystemException e) {
            Object[] args = new Object[]{wsdlStringUrl, e.getMessage()};
            LOG.error("CRB000516_Error_resolving_file", args, e);
            throw new ClassGenerationException("CRB000516_Error_resolving_file", args, e);
        }
        LOG.debug("wsdl location resolved");
        try {
            wsdlInputStream = wsdlFile.getContent().getInputStream();
        }
        catch (IOException e) {
            Object[] args = new Object[]{wsdlFile, e.getMessage()};
            LOG.error("CRB000517_Error_opening_url_inputstream", args, e);
            throw new ClassGenerationException("CRB000517_Error_opening_url_inputstream", args, e);
        }
        LOG.debug("wsdl content extracted");
        try {
            wsdlDirFile = Util.createUniqueDirectory(workdirFile, "wsdl");
            wsdlDirName = wsdlDirFile.getCanonicalPath();
        }
        catch (IOException e) {
            Object[] args = new Object[]{e.getMessage()};
            LOG.error("CRB000518_Error_creating_dir_for_wsdl", args, e);
            throw new ClassGenerationException("CRB000518_Error_creating_dir_for_wsdl", args, e);
        }
        LOG.debug("wsdl dir created:" + wsdlDirName);
        String wsdlFileName = this.getWsdlFileName(wsdlDirName);
        this.copyFile(wsdlInputStream, wsdlFileName);
        LOG.debug("wsdl copied: " + wsdlFileName);
        LOG.debug("<<<<<<<<<< copyWsdlTo - end");
        return wsdlDirFile;
    }

    private String getWsdlFileName(String wsdlDirName) {
        return wsdlDirName + File.separator + "service.wsdl";
    }

    private String mkdir(File basedir, String newdir) throws ClassGenerationException {
        String sourceDirName;
        LOG.debug(">>>>> mkdir - begin");
        File sourceDir = new File(basedir, newdir);
        Util.buildDirectory(sourceDir);
        try {
            sourceDirName = sourceDir.getCanonicalPath();
        }
        catch (IOException e) {
            Object[] args = new Object[]{sourceDir, e.getMessage()};
            LOG.error("CRB000519_Error_getting_canonical_path", args, e);
            throw new ClassGenerationException("CRB000519_Error_getting_canonical_path", args, e);
        }
        LOG.debug("<<<<< mkdir - end. newdir=" + sourceDirName);
        return sourceDirName;
    }

    private WsdlInformation wsdlToJava(String wsdlDirName, String sourceDirName) throws ClassGenerationException {
        LOG.debug(">>>>> wsdlToJava - begin");
        Wsdl11Generator gen = new Wsdl11Generator();
        String wsdlFileName = this.getWsdlFileName(wsdlDirName);
        WsdlInformation wsdlInformation = this.extractWsdlInformation(wsdlFileName);
        gen.setWsdl(wsdlFileName);
        gen.setOutputDirectory(sourceDirName);
        LOG.debug("wsdlDirName=" + wsdlDirName + "; wsdlFileName=" + wsdlFileName + "; OutputDirectory=" + sourceDirName);
        try {
            gen.generate();
        }
        catch (Exception e) {
            Object[] args = new Object[]{wsdlFileName, e.getMessage()};
            LOG.error("CRB000520_Error_generating_source_file", args, e);
            throw new ClassGenerationException("CRB000520_Error_generating_source_file", args, e);
        }
        LOG.debug("<<<<< wsdlToJava - end");
        return wsdlInformation;
    }

    private WsdlInformation extractWsdlInformation(String wsdlFileName) throws ClassGenerationException {
        LOG.debug(">>>>> extractWsdlInformation - begin");
        WsdlInformation wi = new WsdlInformation();
        try {
            FileInputStream is = new FileInputStream(wsdlFileName);
            WSDLServiceBuilder b = new WSDLServiceBuilder("", (InputStream)is);
            b.build();
            List ss = b.getAllServices();
            for (Object o : ss) {
                Service service = (Service)o;
                QName pt = service.getServiceInfo().getPortType();
                wi.getPortTypeList().add(pt);
                LOG.debug("PortType[" + pt + "] in WsdlFile=" + wsdlFileName);
                wi.getServiceAndPortType().put(service.getName(), pt);
                wi = this.findOperationByMEP(service, pt, wi);
            }
        }
        catch (Exception e) {
            LOG.error("CRB000521_Extracting_PortTypes_error", e);
            throw new ClassGenerationException("CRB000521_Extracting_PortTypes_error", null, e);
        }
        LOG.debug("<<<< extractWsdlInformation - end");
        return wi;
    }

    protected WsdlInformation findOperationByMEP(Service service, QName portType, WsdlInformation wi) {
        if (wi == null) {
            wi = new WsdlInformation();
        }
        if (portType == null) {
            LOG.debug("No operations for a nillable PortType!");
            return wi;
        }
        ArrayList asyncList = new ArrayList();
        ArrayList syncList = new ArrayList();
        wi.getAsynchOperationMap().put(portType, asyncList);
        wi.getSynchOperationMap().put(portType, syncList);
        if (service == null) {
            LOG.debug("No operations for a nillable service!");
            return wi;
        }
        for (OperationInfo op : service.getServiceInfo().getOperations()) {
            LOG.debug("OperationInfo.isAsync:" + op.isAsync() + "; OperationInfo.hasInput()=" + op.hasInput() + "; OperationInfo.hasOutput()=" + op.hasOutput());
            if (!op.hasOutput()) {
                LOG.debug("Asynchronous Operation. MEP=" + op.getMEP() + "; operationName=" + op.getName());
                wi.getAsynchOperationMap().get(portType).add(op.getName());
                continue;
            }
            LOG.debug("Synchronous Operation. MEP=" + op.getMEP() + "; operationName=" + op.getName());
            wi.getSynchOperationMap().get(portType).add(op.getName());
        }
        return wi;
    }

    private String extractServiceNameFromPortType(String wsdlDirName, QName portType) throws ClassGenerationException {
        LOG.debug(">>>>> extractPortTypes - begin");
        String wsdlFileName = this.getWsdlFileName(wsdlDirName);
        try {
            FileInputStream is = new FileInputStream(wsdlFileName);
            WSDLServiceBuilder b = new WSDLServiceBuilder("", (InputStream)is);
            b.build();
            List ss = b.getAllServices();
            for (Object o : ss) {
                QName pt = ((Service)o).getServiceInfo().getPortType();
                if (!pt.equals(portType)) continue;
                String serviceName = ((Service)o).getSimpleName();
                LOG.debug("Service[" + serviceName + "] found in WsdlFile=" + wsdlFileName + " for portType:" + portType);
                return serviceName;
            }
            LOG.error("CRB000542_Error_during_service_name_lookup", String.valueOf(portType));
            throw new ClassGenerationException("CRB000542_Error_during_service_name_lookup", new Object[]{String.valueOf(portType)});
        }
        catch (Exception e) {
            LOG.error("CRB000542_Error_during_service_name_lookup", e);
            throw new ClassGenerationException("CRB000542_Error_during_service_name_lookup", null, e);
        }
    }

    private String getAsFileName(String basedir, String javaName, String ext) {
        char sep = File.separator.charAt(0);
        basedir = basedir.replace('\\', sep).replace('/', sep);
        return basedir + sep + javaName.replace('.', sep) + ext;
    }

    private String getAsFullyQualifiedNameInternalForm(String javaName) {
        return javaName.replace('.', '/');
    }

    public void tweakRemoteInterfaceGeneratedFromWSDL(String portTypeClassName, String classesDirName) throws ClassGenerationException {
        ClassReader cr;
        LOG.debug("Adding the application exceptions to interface: " + portTypeClassName);
        ClassWriter cw = new ClassWriter(true);
        CheckClassAdapter cc = new CheckClassAdapter((ClassVisitor)cw);
        StringWriter sw = new StringWriter();
        TraceClassVisitor tv = new TraceClassVisitor((ClassVisitor)cc, new PrintWriter(sw));
        URLClassLoader classLoader = this.getURLClassLoader(classesDirName);
        TweakRemoteInterfaceException cv = new TweakRemoteInterfaceException((ClassVisitor)tv, classLoader);
        LOG.debug("new ClassReader - Begin");
        try {
            cr = new ClassReader((InputStream)new FileInputStream(this.getAsFileName(classesDirName, portTypeClassName, ".class")));
        }
        catch (IOException e) {
            String msg = e.getMessage();
            LOG.error(msg);
            throw new ClassGenerationException(e);
        }
        cr.accept((ClassVisitor)cv, true);
        LOG.debug("output of tracer during creation of class: " + portTypeClassName + "\n" + sw.toString());
        byte[] newBytecode = cw.toByteArray();
        String relativeFileName = portTypeClassName.replace('.', File.separatorChar);
        LOG.debug("FileName=" + relativeFileName);
        Util.saveAsJavaClass(classesDirName + File.separator + relativeFileName + ".class", newBytecode);
        List<String> exceptions = cv.getExceptionsAdded();
        this.addExceptionSuperclass(exceptions, classesDirName);
    }

    private void addExceptionSuperclass(List<String> exceptions, String classesDirName) throws ClassGenerationException {
        for (int i = 0; i < exceptions.size(); ++i) {
            ClassReader cr;
            String exception = exceptions.get(i);
            LOG.debug("Adding Exception superclass to exception: " + exception);
            ClassWriter cw = new ClassWriter(true);
            CheckClassAdapter cc = new CheckClassAdapter((ClassVisitor)cw);
            StringWriter sw = new StringWriter();
            TraceClassVisitor tv = new TraceClassVisitor((ClassVisitor)cc, new PrintWriter(sw));
            AddExceptionSuperclass cv = new AddExceptionSuperclass((ClassVisitor)tv);
            try {
                cr = new ClassReader((InputStream)new FileInputStream(this.getAsFileName(classesDirName, exception, ".class")));
            }
            catch (IOException e) {
                String msg = e.getMessage();
                LOG.error(msg);
                throw new ClassGenerationException(e);
            }
            cr.accept((ClassVisitor)cv, true);
            byte[] newBytecode = cw.toByteArray();
            String relativeFileName = exception.replace('.', File.separatorChar);
            Util.saveAsJavaClass(classesDirName + File.separator + relativeFileName + ".class", newBytecode);
        }
    }
}

