/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.jbi.endpoint;

import it.imolinfo.jbi4corba.Logger;
import it.imolinfo.jbi4corba.LoggerFactory;
import it.imolinfo.jbi4corba.exception.Jbi4CorbaDeployException;
import it.imolinfo.jbi4corba.exception.Jbi4CorbaException;
import it.imolinfo.jbi4corba.jbi.Messages;
import it.imolinfo.jbi4corba.jbi.component.runtime.RuntimeContext;
import it.imolinfo.jbi4corba.jbi.endpoint.Jbi4CorbaEndpoint;
import it.imolinfo.jbi4corba.jbi.processor.ExchangeProcessor;
import it.imolinfo.jbi4corba.jbi.processor.ProviderExchangeProcessor;
import it.imolinfo.jbi4corba.webservice.descriptor.ProviderServiceDescriptor;
import it.imolinfo.jbi4corba.webservice.runtime.ProviderServiceCreator;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import javax.jbi.messaging.MessageExchange;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.service.Service;
import org.omg.CORBA.Any;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.CORBA_2_3.ORB;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ProviderEndpoint
extends Jbi4CorbaEndpoint {
    private static final long serialVersionUID = -7829120677780408268L;
    private static final Logger LOG = LoggerFactory.getLogger(ProviderEndpoint.class);
    private static final Messages MESSAGES = Messages.getMessages(ProviderEndpoint.class);
    private ProviderServiceDescriptor serviceDescriptor;
    private Service xfireService;
    private ExchangeProcessor processor;
    private org.omg.CORBA.ORB orb;

    public ProviderEndpoint(QName serviceName, String endpointName, ProviderServiceDescriptor serviceDescriptor) throws Jbi4CorbaException {
        super(serviceName, endpointName);
        this.serviceDescriptor = serviceDescriptor;
        this.setExchangeProcessor(new ProviderExchangeProcessor(this));
    }

    public void activate() throws Jbi4CorbaException {
        LOG.debug(">>>>> activate - begin");
        this.locateCorbaService();
        LOG.debug("<<<<< activate - end");
    }

    public void registerService() throws Jbi4CorbaDeployException {
        Transformer transformer;
        FileWriter fr;
        LOG.debug("registering service for service descriptor: " + this.serviceDescriptor);
        XFire xfire = this.getSuManager().getLifeCycle().getXfire();
        this.serviceDescriptor.setComponentRootPath(RuntimeContext.getInstance().getComponentContext().getInstallRoot());
        ProviderServiceCreator serviceCreator = new ProviderServiceCreator();
        this.xfireService = serviceCreator.createJbiService(this.serviceDescriptor, xfire, this.serviceDescriptor.getPortTypeName());
        xfire.getServiceRegistry().register(this.xfireService);
        LOG.debug("Registering xfire service for: " + this.getServiceName());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        LOG.debug("xfireService:" + this.xfireService);
        xfire.generateWSDL(this.xfireService.getSimpleName(), (OutputStream)baos);
        if (LOG.isDebugEnabled()) {
            LOG.debug("WSDL:\n------------------\n" + baos.toString() + "\n------------------");
        }
        DOMSource domSource = new DOMSource(this.generateWsdl(serviceCreator, this.serviceDescriptor, xfire, this.serviceDescriptor.getPortTypeName()));
        String wsdlFilename = null;
        wsdlFilename = this.serviceDescriptor.getWsdlRootDirectory() + "/" + this.xfireService.getSimpleName() + ".wsdl.debug.xfire";
        LOG.info("CRB000127_Producing_service_wsdl_to", wsdlFilename);
        try {
            fr = new FileWriter(wsdlFilename);
        }
        catch (IOException e) {
            String msg = MESSAGES.getString("CRB000105_Unable_to_open_filename", wsdlFilename, e.getMessage());
            LOG.error(msg, e);
            throw new Jbi4CorbaDeployException(msg, e);
        }
        StreamResult streamResult = new StreamResult(fr);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            String msg = MESSAGES.getString("CRB000106_Unable_to_create_default_transformer", transformerFactory, e.getMessage());
            LOG.error(msg, e);
            throw new Jbi4CorbaDeployException(msg, e);
        }
        try {
            transformer.transform(domSource, streamResult);
        }
        catch (TransformerException e) {
            String msg = MESSAGES.getString("CRB000107_Unable_to_create_transform", domSource, streamResult, transformer, e.getMessage());
            LOG.error(msg, e);
            throw new Jbi4CorbaDeployException(msg, e);
        }
        try {
            fr.close();
        }
        catch (IOException e) {
            String msg = MESSAGES.getString("CRB000108_Unable_to_close_fileWriter", fr, e.getMessage());
            LOG.error(msg, e);
            throw new Jbi4CorbaDeployException(msg, e);
        }
    }

    public void unregisterService() throws Jbi4CorbaException {
        LOG.info("Service: " + this.getServiceName() + "/" + this.getEndpointName() + " unregistered");
    }

    public void validate() throws Jbi4CorbaException {
    }

    public ProviderServiceDescriptor getServiceDescriptor() {
        return this.serviceDescriptor;
    }

    public void setServiceDescriptor(ProviderServiceDescriptor serviceDescriptor) {
        this.serviceDescriptor = serviceDescriptor;
    }

    public Service getXfireService() {
        return this.xfireService;
    }

    protected Document generateWsdl(ProviderServiceCreator serviceCreator, ProviderServiceDescriptor sd, XFire xfire, QName interfaceName) throws Jbi4CorbaDeployException {
        Document doc;
        DocumentBuilder documentBuilder;
        LOG.debug(">>>>> generateWsdl - begin");
        Service xfireService = serviceCreator.createServiceUtility(sd, xfire, interfaceName);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        LOG.debug("xfireService:" + xfireService);
        xfire.generateWSDL(xfireService.getSimpleName(), (OutputStream)baos);
        if (LOG.isDebugEnabled()) {
            LOG.debug("WSDL:\n------------------\n" + baos.toString() + "\n------------------");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            documentBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            String msg = MESSAGES.getString("CRB000128_Unable_to_create_documentBuilder", factory, e.getMessage());
            LOG.error(msg, e);
            throw new Jbi4CorbaDeployException(msg, e);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        try {
            doc = documentBuilder.parse(bais);
        }
        catch (SAXException e) {
            String m = MESSAGES.getString("CRB000129_Unable_to_parse_document", bais, documentBuilder, e.getMessage());
            LOG.error(m, e);
            throw new Jbi4CorbaDeployException(m, e);
        }
        catch (IOException e) {
            String m = MESSAGES.getString("CRB000129_Unable_to_parse_document", bais, documentBuilder, e.getMessage());
            LOG.error(m, e);
            throw new Jbi4CorbaDeployException(m, e);
        }
        LOG.debug("<<<<< generateWsdl - end");
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void locateCorbaService() throws Jbi4CorbaException {
        LOG.debug(">>>>> locateCorbaService - begin");
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.serviceDescriptor.getUrlClassLoader());
        if (this.serviceDescriptor != null) {
            this.debugProperties(this.serviceDescriptor.getOrbProperties());
        }
        try {
            LOG.debug("locating service for serviceDescriptor: " + this.serviceDescriptor);
            this.orb = org.omg.CORBA.ORB.init((String[])new String[0], (Properties)this.serviceDescriptor.getOrbProperties());
            LOG.debug("orb: " + this.orb + " created for service: " + this.serviceDescriptor);
            Map<String, java.lang.Object> map = this.serviceDescriptor.getValueTypeIdAndInstance();
            if (map == null || map.size() == 0) {
                LOG.info("CRB000130_No_value_type_factory_to_register_using_the_ORB");
            } else {
                LOG.debug("ValueTypeFactoryMap.size=" + map.size());
                for (String id : map.keySet()) {
                    ValueFactory vf = (ValueFactory)map.get(id);
                    LOG.debug("Provider. Registering a ValueType Factory. id=" + id + "; instance=" + vf);
                    ((ORB)this.orb).register_value_factory(id, vf);
                }
            }
            Class helperClass = this.serviceDescriptor.getCorbaHelperClass();
            Method narrowMethod = this.getNarrowMethod(helperClass);
            Method typeMethod = this.getTypeMethod(helperClass);
            Method extractMethod = this.getExtractMethod(helperClass);
            java.lang.Object retrievedObject = null;
            Object corbaObjectReference = null;
            LOG.info("CRB000140_LocalizationType", this.serviceDescriptor.getLocalizationType());
            if ("NameService".equalsIgnoreCase(this.serviceDescriptor.getLocalizationType())) {
                retrievedObject = this.localizationViaNameService();
                corbaObjectReference = this.getCorbaObjectReference(helperClass, narrowMethod, retrievedObject);
            } else if ("corbaloc".equalsIgnoreCase(this.serviceDescriptor.getLocalizationType())) {
                retrievedObject = this.localizationViaCorbaloc();
                corbaObjectReference = this.getCorbaObjectReference(helperClass, narrowMethod, retrievedObject);
            } else if ("corbaname".equalsIgnoreCase(this.serviceDescriptor.getLocalizationType())) {
                retrievedObject = this.localizationViaCorbaname();
                corbaObjectReference = this.getCorbaObjectReference(helperClass, narrowMethod, retrievedObject);
            } else if ("IOR".equalsIgnoreCase(this.serviceDescriptor.getLocalizationType())) {
                retrievedObject = this.localizationViaIOR();
                corbaObjectReference = this.getCorbaObjectReference(helperClass, narrowMethod, retrievedObject);
            } else {
                throw new IllegalArgumentException(MESSAGES.getString("CRB000137_Localization_type_not_supported", this.serviceDescriptor.getLocalizationType()));
            }
            this.serviceDescriptor.setCorbaObjectReference(corbaObjectReference);
            LOG.debug("service reference found: " + corbaObjectReference);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
            LOG.debug("<<<<< locateCorbaService - end");
        }
    }

    protected java.lang.Object localizationViaCorbaloc() throws Jbi4CorbaException {
        String corbalocUrl = this.serviceDescriptor.getCorbaUrl();
        LOG.debug("corbalocUrl=" + corbalocUrl);
        if (corbalocUrl == null || "".equals(corbalocUrl)) {
            LOG.error("CRB000141_CorbalocURL_NotFound");
            throw new Jbi4CorbaException("CRB000141_CorbalocURL_NotFound");
        }
        Object retrievedObject = this.orb.string_to_object(corbalocUrl);
        LOG.debug("retrievedObject=" + retrievedObject);
        return retrievedObject;
    }

    protected java.lang.Object localizationViaCorbaname() throws Jbi4CorbaException {
        String corbanameUrl = this.serviceDescriptor.getCorbaUrl();
        LOG.debug("corbanameUrl=" + corbanameUrl);
        if (corbanameUrl == null || "".equals(corbanameUrl)) {
            LOG.error("CRB000142_CorbanameURL_NotFound");
            throw new Jbi4CorbaException("CRB000142_CorbanameURL_NotFound");
        }
        Object retrievedObject = this.orb.string_to_object(corbanameUrl);
        LOG.debug("retrievedObject=" + retrievedObject);
        return retrievedObject;
    }

    protected java.lang.Object localizationViaIOR() throws Jbi4CorbaException {
        String filename = this.serviceDescriptor.getCorbaUrl();
        LOG.debug("filename=" + filename);
        if (filename == null || "".equals(filename)) {
            LOG.error("CRB000143_IOR_NotFound");
            throw new Jbi4CorbaException("CRB000143_IOR_NotFound");
        }
        File iorFile = new File(filename);
        if (!iorFile.exists()) {
            LOG.error("CRB000143_IOR_NotFound");
            throw new Jbi4CorbaException("CRB000143_IOR_NotFound");
        }
        String ior = this.readIorFromFile(filename);
        LOG.debug("File.IOR=" + ior);
        if (ior == null || "".equals(ior)) {
            LOG.error("CRB000143_IOR_NotFound");
            throw new Jbi4CorbaException("CRB000143_IOR_NotFound");
        }
        Object retrievedObject = this.orb.string_to_object(ior);
        LOG.debug("retrievedObject=" + retrievedObject);
        return retrievedObject;
    }

    protected String readIorFromFile(String filename) throws Jbi4CorbaException {
        String ior = null;
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(filename));
            ior = br.readLine();
        }
        catch (IOException e) {
            java.lang.Object[] args = new java.lang.Object[]{filename};
            LOG.error("CRB000144_ReadingFileError", args, e);
            throw new Jbi4CorbaException("CRB000144_ReadingFileError", args, e);
        }
        return ior;
    }

    protected java.lang.Object localizationViaNameService() throws Jbi4CorbaException {
        Object objRef;
        try {
            objRef = this.orb.resolve_initial_references("NameService");
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName e) {
            java.lang.Object[] args = new java.lang.Object[]{"NameService", this.orb, e.getMessage()};
            LOG.error("CRB000131_Invalid_initial_reference_name", args, e);
            throw new Jbi4CorbaException("CRB000131_Invalid_initial_reference_name", args, e);
        }
        NamingContextExt ncRef = NamingContextExtHelper.narrow((Object)objRef);
        LOG.debug("name service: " + ncRef);
        if (ncRef == null) {
            throw new Jbi4CorbaException("CRB000132_Name_service_context_null");
        }
        Object retrievedObject = null;
        try {
            retrievedObject = ncRef.resolve_str(this.serviceDescriptor.getCorbaServiceName());
        }
        catch (NotFound e) {
            java.lang.Object[] args = new java.lang.Object[]{"NotFound", this.serviceDescriptor.getCorbaServiceName(), ncRef, e.getMessage()};
            LOG.error("CRB000134_Exception_retrieving_corba_object_reference", args, e);
            throw new Jbi4CorbaException("CRB000134_Exception_retrieving_corba_object_reference", args, e);
        }
        catch (CannotProceed e) {
            java.lang.Object[] args = new java.lang.Object[]{"CannotProceed", this.serviceDescriptor.getCorbaServiceName(), ncRef, e.getMessage()};
            LOG.error("CRB000134_Exception_retrieving_corba_object_reference", args, e);
            throw new Jbi4CorbaException("CRB000134_Exception_retrieving_corba_object_reference", args, e);
        }
        catch (InvalidName e) {
            java.lang.Object[] args = new java.lang.Object[]{"InvalidName", this.serviceDescriptor.getCorbaServiceName(), ncRef, e.getMessage()};
            LOG.error("CRB000134_Exception_retrieving_corba_object_reference", args, e);
            throw new Jbi4CorbaException("CRB000134_Exception_retrieving_corba_object_reference", args, e);
        }
        LOG.debug("retrievedObject=" + retrievedObject);
        return retrievedObject;
    }

    protected Method getNarrowMethod(Class helperClass) throws Jbi4CorbaException {
        Method narrowMethod;
        try {
            narrowMethod = helperClass.getDeclaredMethod("narrow", Object.class);
        }
        catch (SecurityException e) {
            java.lang.Object[] args = new java.lang.Object[]{"SecurityException", helperClass, e.getMessage()};
            LOG.error("CRB000133_Exception_retrieving_narrow_method", args, e);
            throw new Jbi4CorbaException("CRB000133_Exception_retrieving_narrow_method", args, e);
        }
        catch (NoSuchMethodException e) {
            java.lang.Object[] args = new java.lang.Object[]{"NoSuchMethodException", helperClass, e.getMessage()};
            LOG.error("CRB000133_Exception_retrieving_narrow_method", args, e);
            throw new Jbi4CorbaException("CRB000133_Exception_retrieving_narrow_method", args, e);
        }
        return narrowMethod;
    }

    protected Method getExtractMethod(Class helperClass) throws Jbi4CorbaException {
        Method extractMethod = null;
        try {
            extractMethod = helperClass.getDeclaredMethod("extract", Any.class);
        }
        catch (SecurityException e) {
            java.lang.Object[] args = new java.lang.Object[]{"SecurityException", helperClass, e.getMessage()};
            LOG.error("CRB000133_Exception_retrieving_extractMethod", args, e);
            throw new Jbi4CorbaException("CRB000133_Exception_retrieving_extractMethod", args, e);
        }
        catch (NoSuchMethodException e) {
            java.lang.Object[] args = new java.lang.Object[]{"NoSuchMethodException", helperClass, e.getMessage()};
            LOG.error("CRB000133_Exception_retrieving_extractMethod", args, e);
            throw new Jbi4CorbaException("CRB000133_Exception_retrieving_extractMethod", args, e);
        }
        return extractMethod;
    }

    protected Method getTypeMethod(Class helperClass) throws Jbi4CorbaException {
        Method typeMethod = null;
        try {
            typeMethod = helperClass.getDeclaredMethod("type", new Class[0]);
        }
        catch (SecurityException e) {
            java.lang.Object[] args = new java.lang.Object[]{"SecurityException", helperClass, e.getMessage()};
            LOG.error("CRB000133_Exception_retrieving_typeMethod", args, e);
            throw new Jbi4CorbaException("CRB000133_Exception_retrieving_typeMethod", args, e);
        }
        catch (NoSuchMethodException e) {
            java.lang.Object[] args = new java.lang.Object[]{"NoSuchMethodException", helperClass, e.getMessage()};
            LOG.error("CRB000133_Exception_retrieving_typeMethod", args, e);
            throw new Jbi4CorbaException("CRB000133_Exception_retrieving_typeMethod", args, e);
        }
        return typeMethod;
    }

    private void debugProperties(Properties prop) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        if (prop == null || prop.size() == 0) {
            LOG.debug("No properties found.");
            return;
        }
        for (java.lang.Object k : prop.keySet()) {
            LOG.debug("Properties[" + k + "]=" + prop.getProperty((String)k));
        }
    }

    protected Object getCorbaObjectReference(Class helperClass, Method narrowMethod, java.lang.Object retrievedObject) throws Jbi4CorbaException {
        LOG.debug("helperClass=" + helperClass + "; narrowMethod=" + narrowMethod + "; retrievedObject=" + retrievedObject);
        Object corbaObjectReference = null;
        try {
            Object retrievedObjectAsCorbaObject = (Object)retrievedObject;
            corbaObjectReference = (Object)narrowMethod.invoke((java.lang.Object)helperClass, retrievedObjectAsCorbaObject);
        }
        catch (IllegalArgumentException e) {
            java.lang.Object[] args = new java.lang.Object[]{"IllegalArgumentException", retrievedObject, e.getMessage()};
            LOG.error("CRB000135_Exception_calling_narrow_method", args, e);
            throw new Jbi4CorbaException("CRB000135_Exception_calling_narrow_method", args, e);
        }
        catch (IllegalAccessException e) {
            java.lang.Object[] args = new java.lang.Object[]{"IllegalAccessException", retrievedObject, e.getMessage()};
            LOG.error("CRB000135_Exception_calling_narrow_method", args, e);
            throw new Jbi4CorbaException("CRB000135_Exception_calling_narrow_method", args, e);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            LOG.error("CRB000135_Exception_calling_narrow_method", new java.lang.Object[]{"InvocationTargetException", retrievedObject, e.getMessage()}, e);
            LOG.error("CRB000136_Real_error_message_is", new java.lang.Object[]{target.getMessage()}, target);
            throw new Jbi4CorbaException("CRB000135_Exception_calling_narrow_method", new java.lang.Object[]{"Exception", retrievedObject, target.getMessage()}, target);
        }
        LOG.debug("corbaObjectReference=" + corbaObjectReference);
        return corbaObjectReference;
    }

    public MessageExchange.Role getRole() {
        return MessageExchange.Role.PROVIDER;
    }
}

