/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.jbi.component;

import it.imolinfo.jbi4corba.Logger;
import it.imolinfo.jbi4corba.LoggerFactory;
import it.imolinfo.jbi4corba.jbi.component.Jbi4CorbaMessageExchangeHandlerFactory;
import it.imolinfo.jbi4corba.jbi.component.Jbi4CorbaSUManager;
import it.imolinfo.jbi4corba.jbi.component.runtime.AbstractComponentLifeCycle;
import it.imolinfo.jbi4corba.jbi.component.runtime.ComponentRuntime;
import it.imolinfo.jbi4corba.jbi.component.runtime.MessageExchangeReceiver;
import it.imolinfo.jbi4corba.jbi.component.runtime.RuntimeContext;
import it.imolinfo.jbi4corba.jbi.xfire.JbiTransport;
import javax.jbi.JBIException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.codehaus.xfire.DefaultXFire;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.transport.Transport;

public class Jbi4CorbaLifeCycle
extends AbstractComponentLifeCycle {
    private static final Logger LOG = LoggerFactory.getLogger(Jbi4CorbaLifeCycle.class);
    private XFire xfire;

    public Jbi4CorbaLifeCycle(ComponentRuntime compRuntime) {
        super(compRuntime);
    }

    protected void onInit() throws JBIException {
        this.xfire = Jbi4CorbaLifeCycle.createXFire();
    }

    protected void initMessageExchangeHandlerFactory() throws JBIException {
        if (!(this.getComponentRuntime().getServiceUnitManager() instanceof Jbi4CorbaSUManager)) {
            String msg = "Service Unit Manager wrong type";
            LOG.error(msg);
            throw new JBIException(msg);
        }
        Jbi4CorbaSUManager suManager = (Jbi4CorbaSUManager)this.getComponentRuntime().getServiceUnitManager();
        RuntimeContext.getInstance().setMessageExchangeHandlerFactory(new Jbi4CorbaMessageExchangeHandlerFactory(suManager));
    }

    protected MessageExchangeReceiver createMessageExchangeReceiver() throws Exception {
        return new MessageExchangeReceiver();
    }

    protected void activateServiceConsumers() throws JBIException {
    }

    protected void deactivateServiceConsumers() throws JBIException {
    }

    protected void activateServiceProviders() throws JBIException {
    }

    protected void deactivateServiceProviders() throws JBIException {
    }

    protected ObjectName createExtensionMBeanName() {
        return null;
    }

    protected StandardMBean createExtensionMBean() {
        return null;
    }

    public XFire getXfire() {
        return this.xfire;
    }

    private static XFire createXFire() {
        DefaultXFire xfire = new DefaultXFire();
        Object[] transports = xfire.getTransportManager().getTransports().toArray();
        for (int i = 0; i < transports.length; ++i) {
            xfire.getTransportManager().unregister((Transport)transports[i]);
        }
        xfire.getTransportManager().register((Transport)new JbiTransport());
        return xfire;
    }
}

