/*
 * Decompiled with CFR 0.152.
 */
package com.sun.sql.framework.jdbc;

import com.sun.mashup.engine.spi.DBConnectionProvider;
import com.sun.sql.framework.exception.BaseException;
import com.sun.sql.framework.jdbc.DBConnectionParameters;
import com.sun.sql.framework.utils.Logger;
import com.sun.sql.framework.utils.StringUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Properties;
import javax.imageio.spi.ServiceRegistry;

public class DBConnectionFactory {
    public static final String PROP_DBTYPE = "dbType";
    public static final String PROP_DRIVERCLASS = "DRIVER";
    public static final String PROP_DS_JNDI_PATH = "dsJndiPath";
    public static final String PROP_OTD_PATH = "otdPathName";
    public static final String PROP_PASSWORD = "password";
    public static final String PROP_URL = "url";
    public static final String PROP_USERNAME = "username";
    private static volatile DBConnectionFactory INSTANCE = null;
    private static final String LOG_CATEGORY = DBConnectionFactory.class.getName();
    private static final String PREFIX_LDAPS = "ldaps:";
    private static final String PREFIX_LDAP = "ldap:";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DBConnectionFactory getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<DBConnectionFactory> clazz = DBConnectionFactory.class;
        synchronized (DBConnectionFactory.class) {
            if (INSTANCE != null || INSTANCE != null) return INSTANCE;
            INSTANCE = new DBConnectionFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public static boolean isLDAPQuery(String ldapQueryStr) {
        boolean ret = false;
        String tmpStr = null;
        if (ldapQueryStr != null && ((tmpStr = ldapQueryStr.trim().toLowerCase()).startsWith(PREFIX_LDAP) || tmpStr.startsWith(PREFIX_LDAPS))) {
            ret = true;
        }
        return ret;
    }

    protected DBConnectionFactory() {
    }

    public void closeConnection(Connection con) {
        DBConnectionProvider connectionProvider = this.findDBConnectionProvider();
        if (connectionProvider != null) {
            connectionProvider.closeConnection(con);
        }
    }

    public void closeDBResources(Connection con, Statement stmnt, ResultSet rs, boolean forceRollback) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception e) {
                Logger.printThrowable(40000, LOG_CATEGORY, "DBConnectionFactory", "Could not close ResultSet ", e);
            }
        }
        if (stmnt != null) {
            try {
                stmnt.close();
            }
            catch (Exception e) {
                Logger.printThrowable(30000, LOG_CATEGORY, "DBConnectionFactory", "Could not close Statement ", e);
            }
        }
        if (con != null) {
            try {
                if (forceRollback) {
                    try {
                        con.rollback();
                    }
                    catch (Exception ex) {
                        Logger.printThrowable(30000, LOG_CATEGORY, "DBConnectionFactory", "Could not rollback. ", ex);
                    }
                }
                con.close();
            }
            catch (Exception e) {
                Logger.printThrowable(30000, LOG_CATEGORY, "DBConnectionFactory", "Could not close connection ", e);
            }
        }
    }

    public void closeDBResources(Connection con, Statement stmnt, ResultSet rs) {
        this.closeDBResources(con, stmnt, rs, false);
    }

    private int getDatabaseVersionBasedOnURL(Properties connProps, boolean needLDAPLookup) throws BaseException {
        String jdbcURL = connProps.getProperty(PROP_URL);
        if (jdbcURL != null) {
            if ((jdbcURL = jdbcURL.toLowerCase()).indexOf("jdbc:oracle:") != -1) {
                return 30;
            }
            if (jdbcURL.indexOf(":db2:") != -1) {
                return this.getDB2Version(connProps, needLDAPLookup);
            }
            if (jdbcURL.indexOf(":sqlserver:") != -1) {
                return 60;
            }
            if (jdbcURL.indexOf("jdbc:axiondb:") != -1) {
                return 50;
            }
            if (jdbcURL.indexOf(":sybase:") != -1) {
                return 70;
            }
            if (jdbcURL.indexOf("jdbc:derby:") != -1) {
                return 80;
            }
            return 15;
        }
        return 15;
    }

    public int getDatabaseVersion(Properties connProps) throws BaseException {
        String strDBType = connProps.getProperty(PROP_DBTYPE);
        boolean needLDAPLookup = false;
        if (DBConnectionFactory.isLDAPQuery(connProps.getProperty(PROP_USERNAME)) || DBConnectionFactory.isLDAPQuery(connProps.getProperty(PROP_PASSWORD))) {
            needLDAPLookup = true;
        }
        if (StringUtil.isNullString(strDBType)) {
            throw new BaseException("dbType string cannot be null");
        }
        if ((strDBType = strDBType.toUpperCase()).indexOf("ORACLE") != -1) {
            return this.getOracleVersion(connProps, needLDAPLookup);
        }
        if (strDBType.indexOf("DB2") != -1) {
            return this.getDB2Version(connProps, needLDAPLookup);
        }
        if (strDBType.indexOf("SQLSERVER") != -1) {
            return 60;
        }
        if (strDBType.indexOf("INTERNAL") != -1) {
            return 50;
        }
        if (strDBType.indexOf("SYBASE") != -1) {
            return 70;
        }
        if (strDBType.indexOf("DERBY") != -1) {
            return 80;
        }
        return this.getDatabaseVersionBasedOnURL(connProps, needLDAPLookup);
    }

    public Connection getConnection(DBConnectionParameters conDef) throws BaseException {
        DBConnectionProvider connectionProvider = this.findDBConnectionProvider();
        if (connectionProvider != null) {
            return connectionProvider.getConnection(conDef);
        }
        return null;
    }

    public Connection getConnection(Properties connProps) throws BaseException {
        DBConnectionProvider connectionProvider = this.findDBConnectionProvider();
        if (connectionProvider != null) {
            return connectionProvider.getConnection(connProps);
        }
        return null;
    }

    public boolean isAxionConnection(Connection con) throws SQLException {
        return con.getMetaData().getURL().toLowerCase().indexOf("axiondb") != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(Connection con, boolean defragFlag, String defragStmt) {
        if (con == null || !defragFlag || defragStmt == null) {
            return;
        }
        Statement stmt = null;
        try {
            if (!con.isClosed() && this.isAxionConnection(con)) {
                stmt = con.createStatement();
                stmt.execute(defragStmt);
            }
        }
        catch (Exception ignore) {
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ignore) {}
            }
        }
    }

    public void setAutoCommit(Connection conn, boolean val) throws SQLException {
        String jdbcUrl = conn.getMetaData().getURL();
        if (jdbcUrl != null && (jdbcUrl = jdbcUrl.toLowerCase()).indexOf(":sybase:") > -1) {
            conn.commit();
        }
        conn.setAutoCommit(val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDB2Version(Properties connProps, boolean needLDAPLookup) {
        if (needLDAPLookup) {
            return 40;
        }
        Connection conn = null;
        try {
            conn = this.getConnection(connProps);
            if (conn.getMetaData().getDatabaseMajorVersion() >= 8 && conn.getMetaData().getDatabaseMinorVersion() >= 1) {
                int n = 45;
                return n;
            }
            if (conn.getMetaData().getDatabaseMajorVersion() == 5) {
                int n = 42;
                return n;
            }
            int n = 40;
            return n;
        }
        catch (Exception ex) {
            int n = 40;
            return n;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getOracleVersion(Properties connProps, boolean needLDAPLookup) {
        if (needLDAPLookup) {
            return 30;
        }
        Connection conn = null;
        try {
            conn = this.getConnection(connProps);
            Statement stmt = conn.createStatement();
            String oracleVersionSQL = "select VALUE from nls_database_parameters  where parameter ='NLS_RDBMS_VERSION'";
            ResultSet rs = stmt.executeQuery(oracleVersionSQL);
            if (rs.next()) {
                int index;
                String version = rs.getString("VALUE");
                String majorVersion = version.substring(0, index = version.indexOf("."));
                int intVersion = StringUtil.getInt(majorVersion);
                int n = intVersion >= 9 ? 30 : 20;
                return n;
            }
            int n = 20;
            return n;
        }
        catch (Exception ex) {
            int n = 30;
            return n;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    private DBConnectionProvider findDBConnectionProvider() {
        Iterator<DBConnectionProvider> it = ServiceRegistry.lookupProviders(DBConnectionProvider.class);
        if (it.hasNext()) {
            return it.next();
        }
        ClassLoader loader = DBConnectionFactory.class.getClassLoader();
        it = ServiceRegistry.lookupProviders(DBConnectionProvider.class, loader);
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }
}

