/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoRectangle;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;

public abstract class JGoDrawable
extends JGoObject {
    private JGoPen myCurrentPen = JGoPen.black;
    private JGoBrush myCurrentBrush = null;

    public JGoDrawable() {
    }

    public JGoDrawable(Rectangle rect) {
        super(rect);
    }

    public JGoDrawable(Point location, Dimension size) {
        super(location, size);
    }

    public JGoObject copyObject(JGoCopyEnvironment env) {
        JGoDrawable newobj = (JGoDrawable)super.copyObject(env);
        if (newobj != null) {
            newobj.myCurrentPen = this.myCurrentPen;
            newobj.myCurrentBrush = this.myCurrentBrush;
        }
        return newobj;
    }

    public void setPen(JGoPen pen) {
        JGoPen oldPen = this.myCurrentPen;
        if (oldPen != pen) {
            this.update();
            this.myCurrentPen = pen;
            this.update(11, 0, oldPen);
        }
    }

    public JGoPen getPen() {
        return this.myCurrentPen;
    }

    public void setBrush(JGoBrush b) {
        JGoBrush oldBrush = this.myCurrentBrush;
        if (oldBrush != b) {
            this.myCurrentBrush = b;
            this.update(12, 0, oldBrush);
        }
    }

    public JGoBrush getBrush() {
        return this.myCurrentBrush;
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit e) {
        switch (e.getFlags()) {
            case 11: {
                e.setNewValue(this.getPen());
                return;
            }
            case 12: {
                e.setNewValue(this.getBrush());
                return;
            }
        }
        super.copyNewValueForRedo(e);
    }

    public void changeValue(JGoDocumentChangedEdit e, boolean undo) {
        switch (e.getFlags()) {
            case 11: {
                this.setPen((JGoPen)e.getValue(undo));
                return;
            }
            case 12: {
                this.setBrush((JGoBrush)e.getValue(undo));
                return;
            }
        }
        super.changeValue(e, undo);
    }

    public void expandRectByPenWidth(Rectangle rect) {
        if (this.getPen() != null) {
            int penWidth = this.getPen().getWidth();
            rect.x -= penWidth;
            rect.y -= penWidth;
            rect.width += penWidth * 2;
            rect.height += penWidth * 2;
        }
    }

    public boolean getNearestIntersectionPoint(int px, int py, int cx, int cy, Point result) {
        Rectangle r = this.getBoundingRect();
        int penw = 1;
        if (this.getPen() != null) {
            penw = this.getPen().getWidth();
        }
        return JGoRectangle.getNearestIntersectionPoint(r.x - penw, r.y - penw, r.width + 2 * penw, r.height + 2 * penw, px, py, cx, cy, result);
    }

    public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup) {
        if (svgDoc.JGoXMLOutputEnabled()) {
            DomElement subGroup;
            DomElement jGoDrawable = svgDoc.createJGoClassElement("com.nwoods.jgo.JGoDrawable", jGoElementGroup);
            if (this.getBrush() != null) {
                if (!svgDoc.isRegisteredReference(this.getBrush())) {
                    jGoDrawable.setAttribute("embeddedpenbrush", "true");
                    subGroup = svgDoc.createElement("g");
                    jGoDrawable.appendChild(subGroup);
                    this.getBrush().SVGWriteObject(svgDoc, subGroup);
                }
                svgDoc.registerReferencingNode(jGoDrawable, "drawablebrush", this.getBrush());
            }
            if (this.getPen() != null) {
                if (!svgDoc.isRegisteredReference(this.getPen())) {
                    jGoDrawable.setAttribute("embeddedpenbrush", "true");
                    subGroup = svgDoc.createElement("g");
                    jGoDrawable.appendChild(subGroup);
                    this.getPen().SVGWriteObject(svgDoc, subGroup);
                }
                svgDoc.registerReferencingNode(jGoDrawable, "drawablepen", this.getPen());
            }
        }
        super.SVGWriteObject(svgDoc, jGoElementGroup);
    }

    public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement) {
        if (jGoChildElement != null) {
            if (jGoChildElement.getAttribute("embeddedpenbrush").equals("true")) {
                svgDoc.SVGTraverseChildren(jGoDoc, jGoChildElement, null, false);
            }
            String pen = jGoChildElement.getAttribute("drawablepen");
            svgDoc.registerReferencingObject(this, "drawablepen", pen);
            String brush = jGoChildElement.getAttribute("drawablebrush");
            if (brush.length() > 0) {
                svgDoc.registerReferencingObject(this, "drawablebrush", brush);
            } else {
                this.setBrush(null);
            }
            super.SVGReadObject(svgDoc, jGoDoc, svgElement, jGoChildElement.getNextSiblingJGoClassElement());
        }
        return svgElement.getNextSibling();
    }

    public void SVGWriteAttributes(DomElement svgElement) {
        JGoBrush brush;
        JGoPen pen = this.getPen();
        if (pen != null) {
            pen.SVGWriteAttributes(svgElement);
        }
        if ((brush = this.getBrush()) != null) {
            brush.SVGWriteAttributes(svgElement);
        } else {
            String style = svgElement.getAttribute("style");
            style = style + "fill:none;";
            svgElement.setAttribute("style", style);
        }
    }

    public void SVGReadAttributes(DomElement svgElement) {
        this.setPen(new JGoPen());
        this.getPen().SVGReadAttributes(svgElement);
        this.setBrush(new JGoBrush());
        this.getBrush().SVGReadAttributes(svgElement);
    }

    public void SVGUpdateReference(String attr, Object referencedObject) {
        super.SVGUpdateReference(attr, referencedObject);
        if (attr.equals("drawablepen")) {
            this.setPen((JGoPen)referencedObject);
        } else if (attr.equals("drawablebrush")) {
            this.setBrush((JGoBrush)referencedObject);
        }
    }

    public static void drawLine(Graphics2D g, JGoPen pen, int x1, int y1, int x2, int y2) {
        if (pen != null && pen.getStyle() != 0) {
            Stroke stroke = pen.getStroke();
            if (stroke == null) {
                return;
            }
            g.setStroke(stroke);
            g.setColor(pen.getColor());
            g.drawLine(x1, y1, x2, y2);
        }
    }

    public void drawLine(Graphics2D g, int x1, int y1, int x2, int y2) {
        JGoDrawable.drawLine(g, this.getPen(), x1, y1, x2, y2);
    }

    public static void drawEllipse(Graphics2D g, JGoPen pen, JGoBrush brush, int x, int y, int width, int height) {
        Stroke stroke;
        Paint paint;
        if (brush != null && (paint = brush.getPaint()) != null) {
            g.setPaint(paint);
            g.fillOval(x, y, width, height);
        }
        if (pen != null && (stroke = pen.getStroke()) != null) {
            g.setStroke(stroke);
            g.setColor(pen.getColor());
            g.drawOval(x, y, width, height);
        }
    }

    public void drawEllipse(Graphics2D g, int x, int y, int width, int height) {
        JGoDrawable.drawEllipse(g, this.getPen(), this.getBrush(), x, y, width, height);
    }

    public void drawEllipse(Graphics2D g, Rectangle rect) {
        JGoDrawable.drawEllipse(g, this.getPen(), this.getBrush(), rect.x, rect.y, rect.width, rect.height);
    }

    public static void drawRect(Graphics2D g, JGoPen pen, JGoBrush brush, int x, int y, int width, int height) {
        Stroke stroke;
        Paint paint;
        if (brush != null && (paint = brush.getPaint()) != null) {
            g.setPaint(paint);
            g.fillRect(x, y, width, height);
        }
        if (pen != null && (stroke = pen.getStroke()) != null) {
            g.setStroke(stroke);
            g.setColor(pen.getColor());
            g.drawRect(x, y, width, height);
        }
    }

    public void drawRect(Graphics2D g, int x, int y, int width, int height) {
        JGoDrawable.drawRect(g, this.getPen(), this.getBrush(), x, y, width, height);
    }

    public void drawRect(Graphics2D g, Rectangle rect) {
        JGoDrawable.drawRect(g, this.getPen(), this.getBrush(), rect.x, rect.y, rect.width, rect.height);
    }

    public static void drawRoundRect(Graphics2D g, JGoPen pen, JGoBrush brush, int x, int y, int width, int height, int arcWidth, int arcHeight) {
        Stroke stroke;
        Paint paint;
        if (brush != null && (paint = brush.getPaint()) != null) {
            g.setPaint(paint);
            g.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
        }
        if (pen != null && pen.getStyle() != 0 && (stroke = pen.getStroke()) != null) {
            g.setStroke(stroke);
            g.setColor(pen.getColor());
            g.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
        }
    }

    public void drawRoundRect(Graphics2D g, int x, int y, int width, int height, int arcWidth, int arcHeight) {
        JGoDrawable.drawRoundRect(g, this.getPen(), this.getBrush(), x, y, width, height, arcWidth, arcHeight);
    }

    public static void draw3DRect(Graphics2D g, JGoPen pen, JGoBrush brush, int x, int y, int width, int height, boolean raised) {
        Stroke stroke;
        Paint paint;
        if (brush != null && (paint = brush.getPaint()) != null) {
            g.setPaint(paint);
            g.fill3DRect(x, y, width, height, raised);
        }
        if (pen != null && pen.getStyle() == 65535 && (stroke = pen.getStroke()) != null) {
            g.setStroke(stroke);
            g.setColor(pen.getColor());
            g.draw3DRect(x, y, width, height, raised);
        }
    }

    public void draw3DRect(Graphics2D g, int x, int y, int width, int height, boolean raised) {
        JGoDrawable.draw3DRect(g, this.getPen(), this.getBrush(), x, y, width, height, raised);
    }

    public static void drawPolygon(Graphics2D g, JGoPen pen, JGoBrush brush, int[] xpoints, int[] ypoints, int npoints) {
        Stroke stroke;
        Paint paint;
        if (brush != null && (paint = brush.getPaint()) != null) {
            g.setPaint(paint);
            g.fillPolygon(xpoints, ypoints, npoints);
        }
        if (pen != null && (stroke = pen.getStroke()) != null) {
            g.setStroke(stroke);
            g.setColor(pen.getColor());
            g.drawPolygon(xpoints, ypoints, npoints);
        }
    }

    public void drawPolygon(Graphics2D g, int[] xpoints, int[] ypoints, int npoints) {
        JGoDrawable.drawPolygon(g, this.getPen(), this.getBrush(), xpoints, ypoints, npoints);
    }

    public static void drawPath(Graphics2D g, JGoPen pen, JGoBrush brush, GeneralPath path) {
        Stroke stroke;
        Paint paint;
        if (brush != null && (paint = brush.getPaint()) != null) {
            g.setPaint(paint);
            g.fill(path);
        }
        if (pen != null && (stroke = pen.getStroke()) != null) {
            g.setStroke(stroke);
            g.setColor(pen.getColor());
            g.draw(path);
        }
    }

    public static void SVGAddPathArgs(DomElement svgElement, GeneralPath path) {
        String pathArgs = "";
        Point point1 = null;
        Point point2 = null;
        Point point3 = null;
        PathIterator pi = path.getPathIterator(null);
        while (!pi.isDone()) {
            double[] coords = new double[6];
            switch (pi.currentSegment(coords)) {
                case 0: {
                    point1 = new Point((int)coords[0], (int)coords[1]);
                    pathArgs = pathArgs + " M";
                    pathArgs = pathArgs + " " + Integer.toString(point1.x);
                    pathArgs = pathArgs + " " + Integer.toString(point1.y);
                    break;
                }
                case 1: {
                    point1 = new Point((int)coords[0], (int)coords[1]);
                    pathArgs = pathArgs + " L ";
                    pathArgs = pathArgs + " " + Integer.toString(point1.x);
                    pathArgs = pathArgs + " " + Integer.toString(point1.y);
                    break;
                }
                case 2: {
                    point1 = new Point((int)coords[0], (int)coords[1]);
                    point2 = new Point((int)coords[2], (int)coords[3]);
                    pathArgs = pathArgs + " Q ";
                    pathArgs = pathArgs + " " + Integer.toString(point1.x);
                    pathArgs = pathArgs + " " + Integer.toString(point1.y);
                    pathArgs = pathArgs + " " + Integer.toString(point2.x);
                    pathArgs = pathArgs + " " + Integer.toString(point2.y);
                    break;
                }
                case 3: {
                    point1 = new Point((int)coords[0], (int)coords[1]);
                    point2 = new Point((int)coords[2], (int)coords[3]);
                    point3 = new Point((int)coords[4], (int)coords[5]);
                    pathArgs = pathArgs + " C ";
                    pathArgs = pathArgs + " " + Integer.toString(point1.x);
                    pathArgs = pathArgs + " " + Integer.toString(point1.y);
                    pathArgs = pathArgs + " " + Integer.toString(point2.x);
                    pathArgs = pathArgs + " " + Integer.toString(point2.y);
                    pathArgs = pathArgs + " " + Integer.toString(point3.x);
                    pathArgs = pathArgs + " " + Integer.toString(point3.y);
                }
            }
            svgElement.setAttribute("d", pathArgs);
            pi.next();
        }
    }
}

