/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debuggerbdi.rmi.wp.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.bpel.debuggerbdi.rmi.api.DebugListener;
import org.netbeans.modules.bpel.debuggerbdi.rmi.wp.ObjectAdapter;
import org.netbeans.modules.bpel.debuggerbdi.rmi.wp.RMIClient;
import org.netbeans.modules.bpel.debuggerbdi.rmi.wp.RMILocationForwardException;
import org.netbeans.modules.bpel.debuggerbdi.rmi.wp.RMIServer;
import org.netbeans.modules.bpel.debuggerbdi.rmi.wp.RMIService;

public class DefaultRMIService
implements RMIService {
    private static final Logger LOGGER = Logger.getLogger(DefaultRMIService.class.getName());
    private static boolean isDebuggable = LOGGER.isLoggable(Level.FINE);
    static final Object[] PRIMITIVES = new Object[]{Boolean.TYPE, "Z", Byte.TYPE, "B", Character.TYPE, "C", Double.TYPE, "D", Float.TYPE, "F", Integer.TYPE, "I", Long.TYPE, "J", Short.TYPE, "S", Void.TYPE, "V"};
    static final Object[] BOXED = new Object[]{Boolean.class, "Z", Byte.class, "B", Character.class, "C", Double.class, "D", Float.class, "F", Integer.class, "I", Long.class, "J", Short.class, "S", Void.class, "V"};
    static final int METHOD_REQ = 1;
    static final int METHOD_RESULT = 2;
    static final int METHOD_EXCEPTION = 3;
    static HashMap clientSessionPool = new HashMap();
    static HashMap methodCache = new HashMap();
    ResourceBundle rb = ResourceBundle.getBundle("org.netbeans.modules.bpel.debuggerbdi.rmi.wp.impl.Bundle");
    ClassLoader classLoader;
    HashMap servers = new HashMap();
    ExecutorService threadPool = Executors.newFixedThreadPool(20);
    boolean alive = true;

    public DefaultRMIService(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static String getParameterTypes(Method m) {
        Class<?>[] params = m.getParameterTypes();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < params.length; ++i) {
            DefaultRMIService.addParam(params[i], buf);
        }
        buf.append(0);
        return buf.toString();
    }

    public static Class[] getParameterTypes(String sig, ClassLoader classLoader) {
        LinkedList<Class> list = new LinkedList<Class>();
        StringReader reader = new StringReader(sig);
        try {
            Class c;
            while ((c = DefaultRMIService.getParam(reader, classLoader)) != null) {
                list.add(c);
            }
        }
        catch (Exception exc) {
            LOGGER.log(Level.WARNING, exc.getMessage());
        }
        Class[] result = new Class[list.size()];
        list.toArray(result);
        return result;
    }

    public static boolean isPrimitiveArray(Object obj) {
        Class<?> clazz = obj.getClass();
        return DefaultRMIService.isPrimitiveArray(clazz);
    }

    public static boolean isPrimitiveArray(Class clazz) {
        if (clazz.isArray()) {
            int i;
            Class<?> compType = clazz.getComponentType();
            if (compType.equals(String.class)) {
                return true;
            }
            for (i = 0; i < PRIMITIVES.length; i += 2) {
                if (!compType.equals(PRIMITIVES[i])) continue;
                return true;
            }
            for (i = 0; i < BOXED.length; i += 2) {
                if (!compType.equals(BOXED[i])) continue;
                return true;
            }
        }
        return false;
    }

    public RMIClient createClient(String host, int port) throws IOException {
        RMIClient client = null;
        client = !host.equalsIgnoreCase("localhost") ? this.createClient(InetAddress.getByName(host), port) : this.createClient(InetAddress.getLocalHost(), port);
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RMIClient createClient(InetAddress hostAddress, int port) throws IOException {
        RMIServer server;
        HashMap hashMap = this.servers;
        synchronized (hashMap) {
            if (this.servers.size() == 0) {
                this.createServer(0);
            }
            server = (RMIServer)this.servers.values().iterator().next();
        }
        return server.createClient(hostAddress, port);
    }

    public RMIServer createServer(int port) throws IOException {
        if (port == 0) {
            return new RMIServerImpl();
        }
        return this.createServer((String)null, port);
    }

    public RMIServer createServer(String host, int port) throws IOException {
        InetAddress address = null;
        address = host == null || host.equalsIgnoreCase("localhost") ? InetAddress.getLocalHost() : InetAddress.getByName(host);
        return this.createServer(address, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RMIServer createServer(InetAddress hostAddress, int port) throws IOException {
        RMIServer result;
        RMIConnectionFactory fac = new RMIConnectionFactory(hostAddress, port);
        HashMap hashMap = this.servers;
        synchronized (hashMap) {
            result = (RMIServer)this.servers.get(fac);
            if (result == null) {
                result = new RMIServerImpl(hostAddress, port);
            }
            this.servers.put(fac, result);
        }
        return result;
    }

    public void destroy() {
        this.alive = false;
        try {
            this.threadPool.shutdownNow();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ClientSession getClientSession(RMIConnectionFactory factory) {
        ClientSession e;
        HashMap hashMap = clientSessionPool;
        synchronized (hashMap) {
            e = (ClientSession)clientSessionPool.get(factory);
            if (e == null) {
                e = new ClientSession(factory);
                clientSessionPool.put(factory, e);
            }
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Method findMethod(Class c, String methodName, String sig) throws NoSuchMethodException {
        Method result;
        String key = c.getName() + "." + methodName + "#" + sig;
        HashMap hashMap = methodCache;
        synchronized (hashMap) {
            result = (Method)methodCache.get(key);
            if (result == null) {
                try {
                    Class[] parameterTypes = DefaultRMIService.getParameterTypes(sig, c.getClassLoader());
                    result = c.getMethod(methodName, parameterTypes);
                    methodCache.put(key, result);
                }
                catch (NoSuchMethodException exc) {
                    throw new NoSuchMethodException(c.getName() + "." + methodName + "(" + sig + ")");
                }
            }
        }
        return result;
    }

    private static Class getParam(Reader reader, ClassLoader classLoader) throws Exception {
        char ch = (char)reader.read();
        switch (ch) {
            case 'Z': {
                return Boolean.TYPE;
            }
            case 'B': {
                return Byte.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'L': {
                StringBuffer buf = new StringBuffer();
                ch = (char)reader.read();
                while (ch != ';') {
                    if (ch == '/') {
                        ch = '.';
                    }
                    buf.append(ch);
                    ch = (char)reader.read();
                }
                return classLoader.loadClass(buf.toString());
            }
            case '[': {
                Class componentType = DefaultRMIService.getParam(reader, classLoader);
                return Array.newInstance(componentType, 0).getClass();
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'V': {
                return Void.TYPE;
            }
        }
        return null;
    }

    private static void addParam(Class param, StringBuffer buf) {
        if (param.isArray()) {
            buf.append('[');
            DefaultRMIService.addParam(param.getComponentType(), buf);
        } else {
            int i;
            for (i = 0; i < PRIMITIVES.length; i += 2) {
                if (!param.equals(PRIMITIVES[i])) continue;
                buf.append(PRIMITIVES[i + 1].toString());
                break;
            }
            if (i == PRIMITIVES.length) {
                buf.append('L');
                buf.append(param.getName().replace('.', '/'));
                buf.append(';');
            }
        }
    }

    class RMIServerImpl
    implements RMIServer {
        HashMap adapters = new HashMap();
        ObjectAdapter defaultObjectAdapter;
        RMIClient cli;
        RMIConnectionFactory factory;
        Server serverThread = null;

        public RMIServerImpl(InetAddress hostName, int port) throws UnknownHostException, IOException {
            if (isDebuggable) {
                LOGGER.log(Level.FINE, "Creating RMIServerImpl");
            }
            this.factory = new RMIConnectionFactory(hostName, port);
            this.serverThread = new Server(hostName, port);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RMIServerImpl() throws UnknownHostException, IOException {
            InetAddress inetAddr = InetAddress.getLocalHost();
            ServerSocket sock = new ServerSocket(0, 0, inetAddr);
            this.factory = new RMIConnectionFactory(sock.getInetAddress(), sock.getLocalPort());
            HashMap hashMap = DefaultRMIService.this.servers;
            synchronized (hashMap) {
                DefaultRMIService.this.servers.put(this.factory, this);
            }
            this.serverThread = null;
        }

        public Server getServerThread() {
            return this.serverThread;
        }

        public RMIClient getClient() throws IOException {
            if (this.cli == null) {
                this.cli = DefaultRMIService.this.createClient(this.factory.serverHost, this.factory.serverPort);
            }
            return this.cli;
        }

        public void setDefaultAdaptor(ObjectAdapter oa) {
            this.defaultObjectAdapter = oa;
        }

        public InetAddress getLocalAddress() {
            return this.factory.serverHost;
        }

        public int getLocalPort() {
            return this.factory.serverPort;
        }

        public RMIService getService() {
            return DefaultRMIService.this;
        }

        public RMIClient createClient(String host, int port) throws IOException {
            return this.createClient(InetAddress.getByName(host), port);
        }

        public RMIClient createClient(InetAddress host, int port) throws IOException {
            RMIClientImpl result = new RMIClientImpl(host, port);
            result.setObjectAdapter(this.defaultObjectAdapter);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ObjectAdapter createObjectAdapter(String adapterName) throws IOException {
            ObjectAdapterImpl result = (ObjectAdapterImpl)this.adapters.get(adapterName);
            if (result == null) {
                result = new ObjectAdapterImpl(adapterName);
                HashMap hashMap = this.adapters;
                synchronized (hashMap) {
                    this.adapters.put(adapterName, result);
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void closeClients() {
            if (isDebuggable) {
                LOGGER.log(Level.FINE, "Closing client connections ...");
            }
            if (this.serverThread != null) {
                this.serverThread.closeClientConnection();
            }
            HashMap hashMap = clientSessionPool;
            synchronized (hashMap) {
                clientSessionPool.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            if (isDebuggable) {
                LOGGER.log(Level.FINE, "destroy RMIServerImpl = " + this);
            }
            HashMap hashMap = DefaultRMIService.this.servers;
            synchronized (hashMap) {
                DefaultRMIService.this.servers.remove(this.factory);
            }
            if (this.serverThread != null) {
                this.serverThread.closeClientConnection();
                this.serverThread.closeServerConnection();
                this.serverThread.interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.serverThread != null) {
                this.serverThread.setDaemon(true);
                this.serverThread.start();
            }
            HashMap hashMap = this.adapters;
            synchronized (hashMap) {
                while (DefaultRMIService.this.alive && this.adapters.size() > 0) {
                    try {
                        this.adapters.wait();
                    }
                    catch (InterruptedException exc) {
                        return;
                    }
                }
            }
        }

        public SocketResponseListener createListener(RMISocket sock, ObjectAdapter adapter) {
            return new SocketResponseListener(sock, adapter);
        }

        class Server
        extends Thread {
            ServerSocket serverSock;
            Vector clients = new Vector();
            Vector opennedSocks = new Vector();

            Server(ServerSocket sock) {
                this.serverSock = sock;
            }

            Server(InetAddress address, int port) {
                try {
                    this.serverSock = new ServerSocket(port, 1000, address);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, e.getMessage());
                    throw new RuntimeException("Unable to open socket: host--" + address + " port--" + port + ". You might have more than one project deployed in debug mode!");
                }
            }

            Server(String host, int port) throws IOException {
                this(InetAddress.getByName(host), port);
            }

            public synchronized void closeClientConnection() {
                Vector clientsCopy = new Vector(this.clients);
                for (Thread t : clientsCopy) {
                    t.interrupt();
                }
                Vector opennedSocksCopy = new Vector(this.opennedSocks);
                for (Socket s : opennedSocksCopy) {
                    try {
                        s.close();
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, e.getMessage());
                    }
                }
                this.clients.clear();
                this.opennedSocks.clear();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void closeServerConnection() {
                if (this.serverSock != null) {
                    try {
                        this.serverSock.close();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, e.getMessage(), e);
                    }
                    finally {
                        this.serverSock = null;
                    }
                }
            }

            public void run() {
                if (isDebuggable) {
                    LOGGER.log(Level.INFO, "listening to socket =" + this.serverSock);
                }
                try {
                    while (DefaultRMIService.this.alive) {
                        Socket sock = null;
                        sock = this.serverSock.accept();
                        this.opennedSocks.add(sock);
                        sock.setTcpNoDelay(true);
                        RMISocket rmiSock = new RMISocket(sock);
                        rmiSock.setObjectAdapter(RMIServerImpl.this.defaultObjectAdapter);
                        rmiSock.setClassLoader(DefaultRMIService.this.classLoader);
                        Thread clientThread = new Thread(new ClientWorker(rmiSock));
                        this.clients.add(clientThread);
                        clientThread.setDaemon(true);
                        clientThread.start();
                    }
                }
                catch (SocketException e) {
                    LOGGER.log(Level.WARNING, e.getMessage());
                }
                catch (Exception exc) {
                    LOGGER.log(Level.WARNING, exc.getMessage());
                }
                if (isDebuggable) {
                    LOGGER.log(Level.FINE, "ending server thread = " + this);
                }
            }
        }

        class ClientWorker
        implements Runnable {
            RMISocket sock;

            ClientWorker(RMISocket sock) {
                this.sock = sock;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    while (DefaultRMIService.this.alive) {
                        ObjectAdapterImpl adapter;
                        Indication ind = this.sock.nextIndication();
                        if (ind == null) continue;
                        HashMap hashMap = RMIServerImpl.this.adapters;
                        synchronized (hashMap) {
                            adapter = (ObjectAdapterImpl)RMIServerImpl.this.adapters.get(ind.getAdapterName());
                            if (adapter == null) {
                                ind.raiseException(new RuntimeException(DefaultRMIService.this.rb.getString("STR_UNKNOWN_ADAPT") + ": " + RMIServerImpl.this.factory + "/" + ind.getAdapterName()));
                                continue;
                            }
                        }
                        adapter.indicate(ind);
                    }
                }
                catch (Exception exc) {
                    LOGGER.log(Level.WARNING, exc.getMessage());
                }
            }
        }

        public class ObjectAdapterImpl
        implements ObjectAdapter {
            DebugListener[] listeners = new DebugListener[1];
            HashMap servants = new HashMap();
            LinkedList indicationQueue = new LinkedList();
            LinkedList invokers = new LinkedList();
            RMIClient cli;
            ReferenceQueue transientRefQueue = new ReferenceQueue();
            String adapterName;
            Thread mThread;

            public ObjectAdapterImpl(String adapterName) throws IOException {
                this.adapterName = adapterName;
                this.cli = (RMIClientImpl)this.getServer().getClient();
                this.cli.setObjectAdapter(this);
            }

            public String getAdapterName() {
                return this.adapterName;
            }

            public synchronized Object getObject(String objectKey) {
                try {
                    return this.getObjectWithKey(objectKey);
                }
                catch (Exception exc) {
                    LOGGER.log(Level.WARNING, exc.getMessage());
                    return null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String[] getObjectKeys(Object servant) {
                LinkedList result = new LinkedList();
                HashMap hashMap = this.servants;
                synchronized (hashMap) {
                    for (Map.Entry e : this.servants.entrySet()) {
                        Object value = e.getValue();
                        if (value instanceof TransientRef) {
                            value = ((TransientRef)value).get();
                        }
                        if (value != servant) continue;
                        result.add(e.getKey());
                    }
                }
                String[] arr = new String[result.size()];
                result.toArray(arr);
                return arr;
            }

            public Object getObjectWithKey(String objectKey) throws IOException {
                Object res = this.findServant(objectKey);
                if (res == null) {
                    throw new IOException(DefaultRMIService.this.rb.getString("STR_NO_SUCH_OBJ") + ": " + objectKey);
                }
                return res;
            }

            public RMIServer getServer() {
                return RMIServerImpl.this;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Invoker createInvoker(Object target, Method method, Indication ind) {
                InvokerImpl inv;
                LinkedList linkedList = this.invokers;
                synchronized (linkedList) {
                    inv = this.invokers.size() == 0 ? new InvokerImpl() : (InvokerImpl)this.invokers.removeFirst();
                }
                final InvokerImpl finalInv = inv;
                inv.init(target, method, ind);
                return new Invoker(){

                    public void start() {
                        DefaultRMIService.this.threadPool.execute(finalInv);
                    }
                };
            }

            public void destroy() {
                this.mThread.interrupt();
            }

            public Object exportObject(Object servant) throws IOException {
                String key = "" + System.identityHashCode(servant);
                return this.exportObject0(key, servant, servant);
            }

            public Object exportObject(String objectKey, Object servant) throws IOException {
                return this.exportObject0(objectKey, servant, servant);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void indicate(Indication ind) {
                LinkedList linkedList = this.indicationQueue;
                synchronized (linkedList) {
                    this.indicationQueue.addLast(ind);
                    if (this.indicationQueue.size() == 1) {
                        this.indicationQueue.notify();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block14: while (true) {
                    try {
                        while (DefaultRMIService.this.alive) {
                            Indication ind;
                            this.pollRefs();
                            LinkedList linkedList = this.indicationQueue;
                            synchronized (linkedList) {
                                while (DefaultRMIService.this.alive && this.indicationQueue.size() == 0) {
                                    this.indicationQueue.wait();
                                }
                                ind = (Indication)this.indicationQueue.removeFirst();
                            }
                            try {
                                String objectKey = ind.getObjectKey();
                                Object target = this.findServant(objectKey);
                                if (target == null) {
                                    ind.raiseException(new RuntimeException(DefaultRMIService.this.rb.getString("STR_NO_SUCH_OBJ") + ": " + RMIServerImpl.this.factory + "/" + "/" + this.adapterName + "#" + objectKey));
                                    continue;
                                }
                                Method method = DefaultRMIService.findMethod(target.getClass(), ind.getMethodName(), ind.getMethodSignature());
                                this.createInvoker(target, method, ind).start();
                                continue block14;
                            }
                            catch (Throwable t) {
                                LOGGER.log(Level.WARNING, t.getMessage(), t);
                                ind.raiseException(t);
                            }
                        }
                        break;
                    }
                    catch (InterruptedException exc) {
                        HashMap hashMap = RMIServerImpl.this.adapters;
                        synchronized (hashMap) {
                            RMIServerImpl.this.adapters.remove(this.adapterName);
                            if (RMIServerImpl.this.adapters.size() == 0) {
                                RMIServerImpl.this.adapters.notify();
                            }
                            break;
                        }
                    }
                    catch (Exception exc) {
                        LOGGER.log(Level.WARNING, exc.getMessage(), exc);
                        HashMap hashMap = RMIServerImpl.this.adapters;
                        synchronized (hashMap) {
                            RMIServerImpl.this.adapters.remove(this.adapterName);
                            if (RMIServerImpl.this.adapters.size() == 0) {
                                RMIServerImpl.this.adapters.notify();
                            }
                            break;
                        }
                    }
                }
            }

            public void start() {
                this.mThread = new Thread(this);
                this.mThread.setDaemon(true);
                this.mThread.start();
            }

            public String[] unexportObject(Object servant) {
                return this.removeServant(servant);
            }

            public Object unexportObjectWithKey(String objectKey) {
                return this.removeServantWithKey(objectKey);
            }

            void pollRefs() {
                TransientRef ref;
                while ((ref = (TransientRef)this.transientRefQueue.poll()) != null) {
                    this.removeServantWithKey(ref.key);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void addServant(String key, Object obj) {
                HashMap hashMap = this.servants;
                synchronized (hashMap) {
                    this.servants.put(key, obj);
                }
            }

            private Object exportObject0(String objectKey, Object servant, Object ref) throws IOException {
                this.addServant(objectKey, ref);
                return ((RMIClientImpl)this.cli).createProxy(servant.getClass().getClassLoader(), servant.getClass().getInterfaces(), this.adapterName, objectKey, servant);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object findServant(String key) {
                HashMap hashMap = this.servants;
                synchronized (hashMap) {
                    TransientRef ref;
                    Object result = this.servants.get(key);
                    if (result != null && result instanceof TransientRef && (result = (ref = (TransientRef)result).get()) == null) {
                        this.servants.remove(key);
                    }
                    return result;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private String[] removeServant(Object servant) {
                LinkedList<String> result = new LinkedList<String>();
                HashMap hashMap = this.servants;
                synchronized (hashMap) {
                    Iterator iter = this.servants.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry e = iter.next();
                        Object value = e.getValue();
                        if (value instanceof TransientRef) {
                            value = ((TransientRef)value).get();
                        }
                        if (value != servant) continue;
                        String key = (String)e.getKey();
                        result.add(key);
                        iter.remove();
                    }
                }
                String[] arr = new String[result.size()];
                result.toArray(arr);
                return arr;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object removeServantWithKey(String key) {
                HashMap hashMap = this.servants;
                synchronized (hashMap) {
                    return this.servants.remove(key);
                }
            }

            public void setClient(RMIClient client) {
                this.cli = client;
            }

            public void registerListerner(DebugListener listener) {
                this.listeners[0] = listener;
            }

            public void notifyClose(Object socket) {
                LOGGER.log(Level.FINE, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
                LOGGER.log(Level.FINE, "Socket: " + socket + " is closed");
                LOGGER.log(Level.FINE, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
                if (this.listeners.length > 0) {
                    this.listeners[0].socketClosed(socket);
                }
            }

            public class InvokerImpl
            implements Runnable {
                Indication ind;
                Method method;
                Object target;

                public void run() {
                    Object[] args = this.ind.getArguments();
                    try {
                        try {
                            this.method.setAccessible(true);
                            Object result = this.method.invoke(this.target, args);
                            if (!(result == null || result instanceof Proxy || result instanceof String || result instanceof Number || result instanceof Boolean || DefaultRMIService.isPrimitiveArray(result))) {
                                result = ObjectAdapterImpl.this.exportObject(result);
                            }
                            this.ind.sendResponse(result);
                        }
                        catch (InvocationTargetException exc) {
                            LOGGER.log(Level.WARNING, exc.getTargetException().getMessage());
                            this.ind.raiseException(exc.getTargetException());
                        }
                        catch (Throwable t) {
                            LOGGER.log(Level.WARNING, t.getMessage());
                            this.ind.raiseException(t);
                        }
                    }
                    catch (IOException exc) {
                        LOGGER.log(Level.WARNING, exc.getMessage());
                    }
                }

                void init(Object target, Method method, Indication ind) {
                    this.target = target;
                    this.method = method;
                    this.ind = ind;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                void release() {
                    this.ind = null;
                    this.target = null;
                    LinkedList linkedList = ObjectAdapterImpl.this.invokers;
                    synchronized (linkedList) {
                        ObjectAdapterImpl.this.invokers.addLast(this);
                    }
                }
            }
        }

        class SocketResponseListener
        implements Runnable {
            RMISocket sock;
            ObjectAdapter adapter;

            SocketResponseListener(RMISocket sock, ObjectAdapter adapter) {
                this.sock = sock;
                this.adapter = adapter;
            }

            public void run() {
                try {
                    while (DefaultRMIService.this.alive) {
                        Indication ind = this.sock.nextIndication();
                        ((ObjectAdapterImpl)this.adapter).indicate(ind);
                    }
                }
                catch (Exception exc) {
                    LOGGER.log(Level.WARNING, exc.getMessage());
                }
            }
        }
    }

    class RMIClientImpl
    implements RMIClient {
        ObjectAdapter oa;
        RMIConnectionFactory factory;

        RMIClientImpl(InetAddress serverHost, int serverPort) throws IOException {
            this.factory = new RMIConnectionFactory(serverHost, serverPort);
        }

        public void setObjectAdapter(ObjectAdapter oa) {
            this.oa = oa;
            if (oa != null) {
                oa.setClient(this);
            }
        }

        public InetAddress getRemoteAddress() {
            return this.factory.serverHost;
        }

        public int getRemotePort() {
            return this.factory.serverPort;
        }

        public RMIService getService() {
            return DefaultRMIService.this;
        }

        public void destroy() {
        }

        public Object importObject(String adapterName, String objectKey) throws IOException {
            return null;
        }

        public Object importObject(Class clazz, String adapterName, String objectKey) throws IOException {
            Class[] ifaces = clazz.getInterfaces();
            if (clazz.isInterface()) {
                Class[] arr = new Class[ifaces.length + 1];
                System.arraycopy(ifaces, 0, arr, 1, ifaces.length);
                arr[0] = clazz;
                ifaces = arr;
            }
            return this.importObject(clazz.getClassLoader(), ifaces, adapterName, objectKey);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object importObject(ClassLoader classLoader, Class[] interfaces, String adapterName, String objectKey) throws IOException {
            Object localRef = null;
            HashMap hashMap = DefaultRMIService.this.servers;
            synchronized (hashMap) {
                RMIServer server = (RMIServer)DefaultRMIService.this.servers.get(this.factory);
                if (server != null) {
                    ObjectAdapter adapter = server.createObjectAdapter(adapterName);
                    localRef = adapter.getObjectWithKey(objectKey);
                }
            }
            Object result = this.createProxy(classLoader, interfaces, adapterName, objectKey, localRef);
            return result;
        }

        private Object createProxy(ClassLoader classLoader, Class[] interfaces, String queueName, String objectKey, Object localRef) throws IOException {
            ClientProxy clientProxy = new ClientProxy(this.factory, queueName, objectKey, localRef, this.oa);
            clientProxy.setClassLoader(classLoader);
            Object result = Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)clientProxy);
            return result;
        }
    }

    static class TransientRef
    extends WeakReference {
        final String key;

        public TransientRef(String key, Object obj, ReferenceQueue queue) {
            super(obj, queue);
            this.key = key;
        }
    }

    static class RMISocket {
        final int MAX_METHOD_REQUESTS = 128;
        ClassLoader classLoader;
        HashMap indications = new HashMap();
        HashMap requests = new HashMap();
        LinkedList indicationQueue = new LinkedList();
        ObjectAdapter oa;
        ObjectInputStream objIn;
        ObjectOutputStream objOut;
        Socket socket;
        Thread readerThread;
        boolean closed;
        int requestId;

        RMISocket(Socket sock) throws IOException {
            this.socket = sock;
            this.objOut = new ObjectOutputStream(new BufferedOutputStream(sock.getOutputStream(), 8192));
            this.readerThread = new Thread(){

                public void run() {
                    RMISocket.this.runReader();
                }
            };
            this.readerThread.setDaemon(true);
            this.readerThread.start();
        }

        public String toString() {
            if (this.socket != null) {
                return this.socket.toString();
            }
            return super.toString();
        }

        public boolean isClosed() {
            return this.closed || this.socket.isClosed();
        }

        void setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        void setObjectAdapter(ObjectAdapter oa) {
            this.oa = oa;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Request createRequest() {
            RequestImpl result;
            HashMap hashMap = this.requests;
            synchronized (hashMap) {
                while (this.requests.size() > 128) {
                    try {
                        this.requests.wait();
                    }
                    catch (InterruptedException exc) {
                        return null;
                    }
                }
                result = new RequestImpl(this.requestId++);
                this.requests.put(new Integer(result.requestId), result);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Indication nextIndication() {
            Indication result;
            LinkedList linkedList = this.indicationQueue;
            synchronized (linkedList) {
                while (this.indicationQueue.size() == 0) {
                    try {
                        this.indicationQueue.wait();
                    }
                    catch (InterruptedException exc) {
                        return null;
                    }
                }
                result = (Indication)this.indicationQueue.removeFirst();
                if (this.indicationQueue.size() > 0) {
                    this.indicationQueue.notify();
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void runReader() {
            try {
                class IStrm
                extends ObjectInputStream {
                    IStrm(InputStream stream) throws IOException {
                        super(stream);
                        this.enableResolveObject(true);
                    }

                    public Class resolveClass(ObjectStreamClass osc) throws ClassNotFoundException, IOException {
                        try {
                            if (RMISocket.this.classLoader != null) {
                                return RMISocket.this.classLoader.loadClass(osc.getName());
                            }
                        }
                        catch (ClassNotFoundException exc) {
                            LOGGER.log(Level.WARNING, exc.getMessage());
                        }
                        return super.resolveClass(osc);
                    }

                    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
                        if (RMISocket.this.classLoader != null) {
                            Class[] classes = new Class[interfaces.length];
                            for (int i = 0; i < classes.length; ++i) {
                                classes[i] = RMISocket.this.classLoader.loadClass(interfaces[i]);
                            }
                            return Proxy.getProxyClass(RMISocket.this.classLoader, classes);
                        }
                        return super.resolveProxyClass(interfaces);
                    }

                    public Object resolveObject(Object obj) {
                        if (obj instanceof ClientProxy) {
                            ((ClientProxy)obj).setObjectAdapter(RMISocket.this.oa);
                            ((ClientProxy)obj).setClassLoader(RMISocket.this.classLoader);
                        } else if (obj instanceof Proxy && Proxy.getInvocationHandler(obj) instanceof ClientProxy) {
                            ((ClientProxy)Proxy.getInvocationHandler(obj)).setObjectAdapter(RMISocket.this.oa);
                            ((ClientProxy)Proxy.getInvocationHandler(obj)).setClassLoader(RMISocket.this.classLoader);
                        }
                        return obj;
                    }
                }
                this.objIn = new IStrm(new BufferedInputStream(this.socket.getInputStream(), 8192));
                block19: while (true) {
                    if (this.socket.isClosed() || this.closed) {
                        if (this.oa != null) {
                            this.oa.notifyClose(this.socket);
                        }
                        break;
                    }
                    byte t = 0;
                    int reqId = 0;
                    try {
                        t = this.objIn.readByte();
                        reqId = this.objIn.readInt();
                        switch (t) {
                            case 1: {
                                if (isDebuggable) {
                                    LOGGER.log(Level.FINE, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
                                    LOGGER.log(Level.FINE, "RMI socket: " + this.socket + "  reqID:" + reqId);
                                    LOGGER.log(Level.FINE, "Received Request: ");
                                    LOGGER.log(Level.FINE, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
                                }
                                IndicationImpl ind = new IndicationImpl(reqId);
                                ind.setSocket(this);
                                ind.readIndication();
                                Integer key = new Integer(reqId);
                                Cloneable cloneable = this.indicationQueue;
                                synchronized (cloneable) {
                                    this.indications.put(key, ind);
                                    this.indicationQueue.addLast(ind);
                                    if (this.indicationQueue.size() == 1) {
                                        this.indicationQueue.notify();
                                    }
                                    break;
                                }
                            }
                            case 2: {
                                if (isDebuggable) {
                                    LOGGER.log(Level.FINE, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
                                    LOGGER.log(Level.FINE, "RMI socket: " + this.socket + "  reqID:" + reqId);
                                    LOGGER.log(Level.FINE, "Received Result: ");
                                    LOGGER.log(Level.FINE, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
                                }
                                Integer key = new Integer(reqId);
                                RequestImpl reqImpl = null;
                                Cloneable cloneable = this.requests;
                                synchronized (cloneable) {
                                    reqImpl = (RequestImpl)this.requests.remove(key);
                                    if (this.requests.size() == 127) {
                                        this.requests.notify();
                                    }
                                }
                                if (reqImpl == null) continue block19;
                                reqImpl.readResponse();
                                break;
                            }
                            case 3: {
                                if (isDebuggable) {
                                    LOGGER.log(Level.FINE, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
                                    LOGGER.log(Level.FINE, "RMI socket: " + this.socket + "  reqID:" + reqId);
                                    LOGGER.log(Level.FINE, "Received Exception: ");
                                    LOGGER.log(Level.FINE, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
                                }
                                Integer key = new Integer(reqId);
                                RequestImpl reqImpl = null;
                                Cloneable cloneable = this.requests;
                                synchronized (cloneable) {
                                    reqImpl = (RequestImpl)this.requests.remove(key);
                                    if (this.requests.size() == 127) {
                                        this.requests.notify();
                                    }
                                }
                                if (reqImpl == null) break;
                                reqImpl.readException();
                            }
                        }
                    }
                    catch (IOException ioexc) {
                        this.closed = true;
                    }
                }
            }
            catch (ClassNotFoundException exc) {
                LOGGER.log(Level.WARNING, exc.getMessage());
                this.closed = true;
            }
            catch (IOException exc) {
                LOGGER.log(Level.WARNING, exc.getMessage());
            }
        }

        class RequestImpl
        implements Request {
            Method method;
            Object monitor = new Object();
            Object result;
            String adapterName;
            String objectKey;
            Object[] arguments;
            int requestId;
            int resultFlag;

            RequestImpl(int requestId) {
                this.requestId = requestId;
            }

            public void setAdapterName(String adapterName) {
                this.adapterName = adapterName;
            }

            public void setArguments(Object[] arguments) {
                this.arguments = arguments;
            }

            public void setMethod(Method method) {
                this.method = method;
            }

            public void setObjectKey(String objectKey) {
                this.objectKey = objectKey;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object getResult() throws Throwable {
                if (isDebuggable) {
                    LOGGER.log(Level.FINE, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
                    LOGGER.log(Level.FINE, "Sending request :");
                    LOGGER.log(Level.FINE, "requstId: " + this.requestId);
                    LOGGER.log(Level.FINE, "method name: " + this.method.getName());
                    LOGGER.log(Level.FINE, "method name: " + this.method.getName());
                    LOGGER.log(Level.FINE, "object key: " + this.objectKey);
                    LOGGER.log(Level.FINE, "sending to: " + RMISocket.this.socket);
                    LOGGER.log(Level.FINE, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
                }
                this.resultFlag = 1;
                Object object = RMISocket.this.objOut;
                synchronized (object) {
                    RMISocket.this.objOut.reset();
                    RMISocket.this.objOut.writeByte(1);
                    RMISocket.this.objOut.writeInt(this.requestId);
                    RMISocket.this.objOut.writeUTF(this.adapterName);
                    RMISocket.this.objOut.writeUTF(this.objectKey);
                    RMISocket.this.objOut.writeUTF(this.method.getName());
                    RMISocket.this.objOut.writeUTF(DefaultRMIService.getParameterTypes(this.method));
                    int len = this.arguments == null ? 0 : this.arguments.length;
                    RMISocket.this.objOut.writeByte(len);
                    for (int i = 0; i < len; ++i) {
                        RMISocket.this.objOut.writeObject(this.arguments[i]);
                    }
                    RMISocket.this.objOut.flush();
                }
                object = this.monitor;
                synchronized (object) {
                    while (this.resultFlag == 1) {
                        this.monitor.wait();
                    }
                }
                if (this.resultFlag == 3) {
                    throw (Throwable)this.result;
                }
                return this.result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void readException() throws IOException, ClassNotFoundException {
                this.result = RMISocket.this.objIn.readObject();
                Object object = this.monitor;
                synchronized (object) {
                    this.resultFlag = 3;
                    this.monitor.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void readResponse() throws IOException, ClassNotFoundException {
                this.result = RMISocket.this.objIn.readObject();
                if (this.result instanceof Proxy) {
                    ((ClientProxy)Proxy.getInvocationHandler((Object)this.result)).socket = RMISocket.this;
                }
                Object object = this.monitor;
                synchronized (object) {
                    this.resultFlag = 2;
                    this.monitor.notify();
                }
            }
        }

        class IndicationImpl
        implements Indication {
            RMISocket rmiSocket;
            String adapterName;
            String methodName;
            String methodSig;
            String objectKey;
            Object[] arguments;
            int requestId;

            IndicationImpl(int reqId) {
                this.requestId = reqId;
            }

            public String getAdapterName() {
                return this.adapterName;
            }

            public Object[] getArguments() {
                return this.arguments;
            }

            public String getMethodName() {
                return this.methodName;
            }

            public String getMethodSignature() {
                return this.methodSig;
            }

            public String getObjectKey() {
                return this.objectKey;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void raiseException(Throwable exc) throws IOException {
                Object object = RMISocket.this.indicationQueue;
                synchronized (object) {
                    RMISocket.this.indications.remove(new Integer(this.requestId));
                }
                object = RMISocket.this.objOut;
                synchronized (object) {
                    RMISocket.this.objOut.reset();
                    RMISocket.this.objOut.writeByte(3);
                    RMISocket.this.objOut.writeInt(this.requestId);
                    RMISocket.this.objOut.writeObject(exc);
                    RMISocket.this.objOut.flush();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void sendResponse(Object result) throws IOException {
                Object object = RMISocket.this.indicationQueue;
                synchronized (object) {
                    RMISocket.this.indications.remove(new Integer(this.requestId));
                }
                if (isDebuggable) {
                    LOGGER.log(Level.FINE, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
                    LOGGER.log(Level.FINE, "Sending response :");
                    LOGGER.log(Level.FINE, "requstid:" + this.requestId);
                    LOGGER.log(Level.FINE, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
                }
                object = RMISocket.this.objOut;
                synchronized (object) {
                    RMISocket.this.objOut.reset();
                    RMISocket.this.objOut.writeByte(2);
                    RMISocket.this.objOut.writeInt(this.requestId);
                    RMISocket.this.objOut.writeObject(result);
                    RMISocket.this.objOut.flush();
                }
            }

            void readIndication() throws IOException, ClassNotFoundException {
                this.adapterName = RMISocket.this.objIn.readUTF();
                this.objectKey = RMISocket.this.objIn.readUTF();
                this.methodName = RMISocket.this.objIn.readUTF();
                if (isDebuggable) {
                    LOGGER.log(Level.FINE, "method name :" + this.methodName);
                    LOGGER.log(Level.FINE, "object key :" + this.objectKey);
                }
                this.methodSig = RMISocket.this.objIn.readUTF();
                int len = RMISocket.this.objIn.readUnsignedByte();
                this.arguments = new Object[len];
                for (int i = 0; i < len; ++i) {
                    this.arguments[i] = RMISocket.this.objIn.readObject();
                    if (this.arguments[i] != null && this.arguments[i] instanceof Proxy) {
                        ((ClientProxy)Proxy.getInvocationHandler((Object)this.arguments[i])).socket = this.rmiSocket;
                        continue;
                    }
                    if (this.arguments[i] == null || !isDebuggable) continue;
                    LOGGER.log(Level.FINE, "arguments[i]" + this.arguments[i]);
                }
            }

            public void setSocket(RMISocket socket) {
                this.rmiSocket = socket;
            }
        }
    }

    static class ClientSession {
        RMIConnectionFactory factory;
        RMISocket socket;

        public ClientSession(RMIConnectionFactory factory) {
            this.factory = factory;
        }

        public synchronized RMISocket getSocket(ObjectAdapter oa, ClassLoader cl) throws IOException {
            if (this.socket == null || this.socket.isClosed()) {
                Socket sock = new Socket(this.factory.serverHost, this.factory.serverPort);
                sock.setTcpNoDelay(true);
                this.socket = new RMISocket(sock);
                this.socket.setObjectAdapter(oa);
                this.socket.setClassLoader(cl);
                RMIServerImpl serverImpl = (RMIServerImpl)oa.getServer();
                if (serverImpl.getServerThread() == null) {
                    Thread t = new Thread(serverImpl.createListener(this.socket, oa));
                    t.setDaemon(true);
                    t.start();
                }
            }
            return this.socket;
        }
    }

    public static class RMIConnectionFactory
    implements Serializable {
        InetAddress serverHost;
        int serverPort;

        public RMIConnectionFactory(String serverHost, int serverPort) throws UnknownHostException {
            this(InetAddress.getByName(serverHost), serverPort);
        }

        public RMIConnectionFactory(InetAddress serverHost, int serverPort) throws UnknownHostException {
            this.serverHost = serverHost;
            this.serverPort = serverPort;
        }

        public boolean equals(Object obj) {
            RMIConnectionFactory other = (RMIConnectionFactory)obj;
            return other.serverHost.equals(this.serverHost) && other.serverPort == this.serverPort;
        }

        public int hashCode() {
            return this.serverHost.hashCode() ^ this.serverPort;
        }

        public String toString() {
            String hostStr = this.serverHost.getHostName();
            return "rmi:" + hostStr + ":" + this.serverPort;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeUTF(this.serverHost.getCanonicalHostName());
            out.writeInt(this.serverPort);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            String hostAddress = in.readUTF();
            this.serverHost = InetAddress.getByName(hostAddress);
            this.serverPort = in.readInt();
        }
    }

    public static class ClientProxy
    implements InvocationHandler,
    Serializable {
        transient ClassLoader classLoader;
        transient ClientSession clientSession;
        transient RMISocket socket;
        transient ClientSession forwardSession;
        transient Object localRef;
        transient ObjectAdapter oa;
        RMIConnectionFactory factory;
        String adapterName;
        String objectKey;

        public ClientProxy(RMIConnectionFactory factory, String adapterName, String objectKey, Object localRef, ObjectAdapter oa) {
            if (isDebuggable) {
                LOGGER.log(Level.FINE, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
                LOGGER.log(Level.FINE, "Making proxy:" + localRef);
                LOGGER.log(Level.FINE, "objectKey:" + objectKey);
                LOGGER.log(Level.FINE, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
            }
            this.factory = factory;
            this.adapterName = adapterName;
            this.objectKey = objectKey;
            this.clientSession = DefaultRMIService.getClientSession(factory);
            this.oa = oa;
        }

        public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
            RMISocket sock;
            Object returnObj = null;
            if (this.localRef != null) {
                m.setAccessible(true);
                return m.invoke(this.localRef, args);
            }
            boolean retry = false;
            if (this.socket == null) {
                ClientSession session = this.forwardSession != null ? this.forwardSession : this.clientSession;
                try {
                    sock = session.getSocket(this.oa, this.classLoader);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, e.getMessage());
                    throw e;
                }
            } else {
                sock = this.socket;
            }
            while (!sock.isClosed()) {
                Request req = sock.createRequest();
                try {
                    req.setAdapterName(this.adapterName);
                    req.setObjectKey(this.objectKey);
                    req.setMethod(m);
                    if (args != null) {
                        Object[] newArgs = new Object[args.length];
                        for (int i = 0; i < args.length; ++i) {
                            Object arg = args[i];
                            if (!(arg == null || arg instanceof Proxy || arg instanceof String || arg instanceof Number || arg instanceof Boolean || DefaultRMIService.isPrimitiveArray(arg))) {
                                arg = this.oa.exportObject(arg);
                            }
                            newArgs[i] = arg;
                        }
                        args = newArgs;
                    }
                    req.setArguments(args);
                    returnObj = req.getResult();
                    break;
                }
                catch (SocketException exc) {
                    LOGGER.log(Level.WARNING, exc.getMessage());
                    if (retry) {
                        throw exc.fillInStackTrace();
                    }
                    sock = this.clientSession.getSocket(this.oa, this.classLoader);
                    this.forwardSession = null;
                    retry = true;
                }
                catch (RMILocationForwardException exc) {
                    LOGGER.log(Level.WARNING, exc.getMessage());
                    RMIConnectionFactory fac = new RMIConnectionFactory(exc.getForwardHost(), exc.getForwardPort());
                    this.forwardSession = DefaultRMIService.getClientSession(fac);
                    sock = this.forwardSession.getSocket(this.oa, this.classLoader);
                }
                catch (Throwable t) {
                    LOGGER.log(Level.WARNING, t.getMessage());
                    throw t;
                }
            }
            return returnObj;
        }

        void setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        void setObjectAdapter(ObjectAdapter oa) {
            this.oa = oa;
        }

        private void readObject(ObjectInputStream strm) throws IOException, ClassNotFoundException {
            strm.defaultReadObject();
            this.clientSession = DefaultRMIService.getClientSession(this.factory);
            this.localRef = null;
        }
    }

    static interface Request {
        public void setAdapterName(String var1);

        public void setArguments(Object[] var1);

        public void setMethod(Method var1);

        public void setObjectKey(String var1);

        public Object getResult() throws Throwable;
    }

    static interface Invoker {
        public void start();
    }

    static interface Indication {
        public void setSocket(RMISocket var1);

        public String getAdapterName();

        public Object[] getArguments();

        public String getMethodName();

        public String getMethodSignature();

        public String getObjectKey();

        public void raiseException(Throwable var1) throws IOException;

        public void sendResponse(Object var1) throws IOException;
    }
}

