/*
 * Decompiled with CFR 0.152.
 */
package com4j;

import com4j.ErrorInfo;
import com4j.Native;

public class ComException
extends RuntimeException {
    private final int hresult;
    private final String fileName;
    private final int line;
    private ErrorInfo errorInfo;

    public ComException(String msg, int hresult, String fileName, int line) {
        super(Integer.toHexString(hresult) + ' ' + ComException.cutEOL(msg));
        this.hresult = hresult;
        this.fileName = fileName;
        this.line = line;
    }

    public ComException(String msg, String fileName, int line) {
        super(msg);
        this.hresult = -1;
        this.fileName = fileName;
        this.line = line;
    }

    public ComException(String msg, int hresult) {
        this(msg, hresult, null, -1);
    }

    void setErrorInfo(ErrorInfo errorInfo) {
        this.errorInfo = errorInfo;
    }

    public ErrorInfo getErrorInfo() {
        return this.errorInfo;
    }

    public int getHRESULT() {
        return this.hresult;
    }

    private static String cutEOL(String s) {
        if (s == null) {
            return "(Unknown error)";
        }
        if (s.endsWith("\r\n")) {
            return s.substring(0, s.length() - 2);
        }
        return s;
    }

    public String getMessage() {
        if (this.errorInfo != null && this.errorInfo.getDescription() != null) {
            return super.getMessage() + " : " + this.errorInfo.getDescription();
        }
        String s = Native.getErrorMessage(this.hresult);
        if (s != null) {
            return super.getMessage() + " : " + s;
        }
        return super.getMessage();
    }

    public String toString() {
        String s = super.toString();
        if (this.fileName != null) {
            s = s + " : " + this.fileName + ':' + this.line;
        }
        return s;
    }
}

