/*
 * Decompiled with CFR 0.152.
 */
package com4j;

import com4j.ComEnum;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class EnumDictionary<T extends Enum<T>> {
    protected final Class<T> clazz;
    private static final Map<Class<? extends Enum>, EnumDictionary> registry = Collections.synchronizedMap(new WeakHashMap());

    private EnumDictionary(Class<T> clazz) {
        this.clazz = clazz;
        assert (clazz.isEnum());
    }

    public static <T extends Enum<T>> EnumDictionary<T> get(Class<T> clazz) {
        EnumDictionary dic = registry.get(clazz);
        if (dic == null) {
            boolean sparse = ComEnum.class.isAssignableFrom(clazz);
            dic = sparse ? new Sparse(clazz) : new Continuous(clazz);
            registry.put(clazz, dic);
        }
        return dic;
    }

    static <T extends Enum<T>> T get(Class<T> clazz, int v) {
        return EnumDictionary.get(clazz).constant(v);
    }

    abstract int value(Enum var1);

    abstract T constant(int var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Sparse<T extends Enum<T>>
    extends EnumDictionary<T> {
        private final Map<Integer, T> fromValue = new HashMap<Integer, T>();

        private Sparse(Class<T> clazz) {
            super(clazz);
            Enum[] consts;
            for (Enum v : consts = (Enum[])clazz.getEnumConstants()) {
                this.fromValue.put(((ComEnum)((Object)v)).comEnumValue(), v);
            }
        }

        @Override
        public int value(Enum t) {
            return ((ComEnum)((Object)t)).comEnumValue();
        }

        @Override
        public T constant(int v) {
            Enum t = (Enum)this.fromValue.get(v);
            if (t == null) {
                throw new IllegalArgumentException(this.clazz.getName() + " has no constant of the value " + v);
            }
            return (T)t;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Continuous<T extends Enum<T>>
    extends EnumDictionary<T> {
        private T[] consts;

        private Continuous(Class<T> clazz) {
            super(clazz);
            this.consts = (Enum[])clazz.getEnumConstants();
        }

        @Override
        public int value(Enum t) {
            return t.ordinal();
        }

        @Override
        public T constant(int v) {
            return this.consts[v];
        }
    }
}

