/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.typemapping.cobol;

import it.imolinfo.jbi4cics.Logger;
import it.imolinfo.jbi4cics.LoggerFactory;
import it.imolinfo.jbi4cics.exception.FormatException;
import it.imolinfo.jbi4cics.messageformat.FieldDescriptor;
import it.imolinfo.jbi4cics.messageformat.commarea.CommareaBeanMappingDescriptor;
import it.imolinfo.jbi4cics.typemapping.cobol.CobolType;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;

public class CobolTypeDescriptor
implements FieldDescriptor {
    public static final int STRING_JUSTIFICATION_LEFT = 0;
    public static final int STRING_JUSTIFICATION_RIGHT = 1;
    public static final int STRING_JUSTIFICATION_CENTER = 2;
    public static final int SIGN_FORMAT_LEADING = 0;
    public static final int SIGN_FORMAT_TRAILING = 1;
    public static final int SIGN_FORMAT_LEADING_SEPARATE = 2;
    private static final Logger LOG = LoggerFactory.getLogger(CobolTypeDescriptor.class);
    private String name;
    private CobolType type;
    private int justification = 0;
    private String padCharacter = " ";
    private int stringLength;
    private String codePage;
    private boolean signed;
    private boolean bigEndian;
    private int integerPartLength;
    private int decimalPartLength;
    private int zonedSignFormat = 0;
    private int level;
    private CommareaBeanMappingDescriptor nestedCommarea;
    private int occursSize;

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CobolTypeDescriptor)) {
            return false;
        }
        CobolTypeDescriptor that = (CobolTypeDescriptor)obj;
        return new EqualsBuilder().append(this.bigEndian, that.bigEndian).append((Object)this.codePage, (Object)that.codePage).append(this.decimalPartLength, that.decimalPartLength).append(this.integerPartLength, that.integerPartLength).append(this.justification, that.justification).append(this.level, that.level).append((Object)this.name, (Object)that.name).append((Object)this.nestedCommarea, (Object)that.nestedCommarea).append(this.occursSize, that.occursSize).append((Object)this.padCharacter, (Object)that.padCharacter).append(this.signed, that.signed).append(this.stringLength, that.stringLength).append((Object)this.type, (Object)that.type).append(this.zonedSignFormat, that.zonedSignFormat).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.bigEndian).append((Object)this.codePage).append(this.decimalPartLength).append(this.integerPartLength).append(this.justification).append(this.level).append((Object)this.name).append((Object)this.nestedCommarea).append(this.occursSize).append((Object)this.padCharacter).append(this.signed).append(this.stringLength).append((Object)this.type).append(this.zonedSignFormat).toHashCode();
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public void setSigned(boolean signed) {
        this.signed = signed;
    }

    public int getJustification() {
        return this.justification;
    }

    public void setJustification(int justification) {
        this.justification = justification;
    }

    public String getPadCharacter() {
        return this.padCharacter;
    }

    public void setPadCharacter(String padCharacter) {
        this.padCharacter = padCharacter;
    }

    public int getDecimalPartLength() {
        return this.decimalPartLength;
    }

    public void setDecimalPartLength(int decimalPartLength) {
        this.decimalPartLength = decimalPartLength;
    }

    public int getIntegerPartLength() {
        return this.integerPartLength;
    }

    public void setIntegerPartLength(int integerPartLength) {
        this.integerPartLength = integerPartLength;
    }

    public int getStringLength() {
        return this.stringLength;
    }

    public void setStringLength(int stringLength) {
        this.stringLength = stringLength;
    }

    public CobolType getType() {
        return this.type;
    }

    public void setType(CobolType type) {
        this.type = type;
    }

    public int getVirtualDecimalPoint() {
        return this.getDecimalPartLength();
    }

    public int getBufferedLength() throws FormatException {
        CobolType ct = this.getType();
        if (ct == null) {
            LOG.error("CIC002110_Unknown_cobol_type", (Object)ct);
            throw new FormatException("CIC002110_Unknown_cobol_type", new Object[]{ct});
        }
        return ct.getBufferedLength(this);
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public void setBigEndian(boolean bigEndian) {
        this.bigEndian = bigEndian;
    }

    public String getCodePage() {
        return this.codePage;
    }

    public void setCodePage(String codePage) {
        CobolType ct = this.getType();
        this.codePage = codePage;
        if (ct == CobolType.NESTED_COMMAREA || ct == CobolType.OCCURS) {
            this.nestedCommarea.setCodePage(codePage);
        }
    }

    public int getZonedSignFormat() {
        return this.zonedSignFormat;
    }

    public void setZonedSignFormat(int zonedSignFormat) {
        this.zonedSignFormat = zonedSignFormat;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Class getPreferredJavaType() throws FormatException {
        CobolType ct = this.getType();
        if (ct == null) {
            LOG.error("CIC002111_Unexpected_cobol_type", (Object)ct);
            throw new FormatException("CIC002111_Unexpected_cobol_type", new Object[]{ct});
        }
        return ct.getPreferredJavaType(this);
    }

    public CommareaBeanMappingDescriptor getNestedCommarea() {
        return this.nestedCommarea;
    }

    public void setNestedCommarea(CommareaBeanMappingDescriptor nestedCommarea) {
        this.nestedCommarea = nestedCommarea;
    }

    public int getOccursSize() {
        return this.occursSize;
    }

    public void setOccursSize(int occursSize) {
        this.occursSize = occursSize;
    }
}

