/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.messageformat.commarea;

import it.imolinfo.jbi4cics.exception.FormatException;
import it.imolinfo.jbi4cics.messageformat.FieldDescriptor;
import it.imolinfo.jbi4cics.messageformat.MappingDescriptor;
import it.imolinfo.jbi4cics.typemapping.cobol.CobolTypeDescriptor;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommareaBeanMappingDescriptor
implements MappingDescriptor {
    private Map<String, FieldDescriptor> fieldMap = new ListOrderedMap();
    private Class beanClass;

    @Override
    public Class getBeanClass() {
        return this.beanClass;
    }

    @Override
    public void setBeanClass(Class beanClass) {
        this.beanClass = beanClass;
    }

    @Override
    public void addFieldMapping(String propertyName, String fieldName, FieldDescriptor fieldDescriptor) throws FormatException {
        if (!(fieldDescriptor instanceof CobolTypeDescriptor)) {
            throw new FormatException("CIC001700_Expected_cobol_type_descriptor", new Object[]{fieldDescriptor.getClass()});
        }
        this.fieldMap.put(propertyName, fieldDescriptor);
    }

    @Override
    public void addFieldMapping(String propertyName, Integer fieldIndex, FieldDescriptor fieldDescriptor) throws FormatException {
        throw new FormatException("CIC001701_Error_adding_field_mapping");
    }

    public int getBufferedLength() throws FormatException {
        int size = 0;
        for (FieldDescriptor desc : this.fieldMap.values()) {
            CobolTypeDescriptor cobolDesc = (CobolTypeDescriptor)desc;
            size += cobolDesc.getBufferedLength();
        }
        return size;
    }

    @Override
    public Map<String, FieldDescriptor> getFieldMap() {
        return Collections.unmodifiableMap(this.fieldMap);
    }

    @Override
    public void setCodePage(String codePage) {
        for (FieldDescriptor desc : this.fieldMap.values()) {
            CobolTypeDescriptor cobolDesc = (CobolTypeDescriptor)desc;
            cobolDesc.setCodePage(codePage);
        }
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }

    public int hashCode() {
        return ((Object)this.fieldMap).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CommareaBeanMappingDescriptor) {
            CommareaBeanMappingDescriptor that = (CommareaBeanMappingDescriptor)obj;
            return ((Object)this.fieldMap).equals(that.fieldMap);
        }
        return false;
    }
}

