/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.jbi.xfire;

import it.imolinfo.jbi4cics.Logger;
import it.imolinfo.jbi4cics.LoggerFactory;
import it.imolinfo.jbi4cics.jbi.xfire.JbiChannel;
import javax.jbi.component.ComponentContext;
import org.codehaus.xfire.handler.Handler;
import org.codehaus.xfire.handler.LocateBindingHandler;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.soap.SoapTransport;
import org.codehaus.xfire.soap.handler.SoapBodyHandler;
import org.codehaus.xfire.transport.AbstractTransport;
import org.codehaus.xfire.transport.Channel;
import org.codehaus.xfire.transport.ChannelEndpoint;
import org.codehaus.xfire.transport.DefaultEndpoint;
import org.codehaus.xfire.wsdl11.WSDL11Transport;

public class JbiTransport
extends AbstractTransport
implements WSDL11Transport,
SoapTransport {
    public static final String JBI_BINDING = "http://java.sun.com/xml/ns/jbi/binding/service+engine";
    private static final Logger LOG = LoggerFactory.getLogger(JbiTransport.class);
    private static final String URI_PREFIX = "urn:xfire:transport:jbi:";
    private static final int HASH_CODE = 61;
    private ComponentContext context;

    public JbiTransport(ComponentContext context) {
        this.addInHandler((Handler)new LocateBindingHandler());
        this.addInHandler((Handler)new SoapBodyHandler());
        this.context = context;
    }

    public String getName() {
        return "JBI";
    }

    public String getServiceURL(Service service) {
        return "jbi://" + service.getName();
    }

    protected Channel createNewChannel(String uri) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating new channel for uri: " + uri);
        }
        JbiChannel c = new JbiChannel(uri, this);
        c.setEndpoint((ChannelEndpoint)new DefaultEndpoint());
        return c;
    }

    protected String getUriPrefix() {
        return URI_PREFIX;
    }

    public String[] getSupportedBindings() {
        return new String[]{JBI_BINDING};
    }

    public String[] getKnownUriSchemes() {
        return new String[]{"jbi://"};
    }

    public ComponentContext getContext() {
        return this.context;
    }

    public boolean equals(Object obj) {
        return obj instanceof JbiTransport;
    }

    public int hashCode() {
        return 61;
    }
}

