/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.tests.jfluid.memory;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.tests.jfluid.memory.MemoryTestCase;

public class BasicTest
extends MemoryTestCase {
    public BasicTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(BasicTest.class);
        return suite;
    }

    public void testSettingsAllocations() {
        ProfilerEngineSettings settings = this.initMemoryTest("j2se-simple", "simple.memory.Memory1");
        settings.setAllocStackTraceLimit(0);
        this.startMemoryTest(settings, 4, new String[]{"simple"});
    }

    public void testSettingsAllocationsServer() {
        ProfilerEngineSettings settings = this.initMemoryTest("j2se-simple", "simple.memory.Memory1");
        this.addJVMArgs(settings, "-server");
        settings.setAllocStackTraceLimit(0);
        this.startMemoryTest(settings, 4, new String[]{"simple"});
    }

    public void testSettingsAllocationsStackTraces() {
        ProfilerEngineSettings settings = this.initMemoryTest("j2se-simple", "simple.memory.Memory1");
        settings.setAllocStackTraceLimit(-1);
        this.startMemoryTest(settings, 4, new String[]{"simple"});
    }

    public void testSettingsAllocationsStackTracesServer() {
        ProfilerEngineSettings settings = this.initMemoryTest("j2se-simple", "simple.memory.Memory1");
        settings.setAllocStackTraceLimit(-1);
        this.addJVMArgs(settings, "-server");
        this.startMemoryTest(settings, 4, new String[]{"simple"});
    }

    public void testSettingsDefault() {
        ProfilerEngineSettings settings = this.initMemoryTest("j2se-simple", "simple.Memory");
        this.startMemoryTest(settings, 4, new String[]{"simple"});
    }

    public void testSettingsLiveness() {
        ProfilerEngineSettings settings = this.initMemoryTest("j2se-simple", "simple.memory.Memory1");
        settings.setAllocStackTraceLimit(0);
        this.startMemoryTest(settings, 5, new String[]{"simple"});
    }

    public void testSettingsLivenessServer() {
        ProfilerEngineSettings settings = this.initMemoryTest("j2se-simple", "simple.memory.Memory1");
        settings.setAllocStackTraceLimit(0);
        this.addJVMArgs(settings, "-server");
        this.startMemoryTest(settings, 5, new String[]{"simple"});
    }

    public void testSettingsLivenessStackTraces() {
        ProfilerEngineSettings settings = this.initMemoryTest("j2se-simple", "simple.memory.Memory1");
        settings.setAllocStackTraceLimit(-1);
        this.startMemoryTest(settings, 5, new String[]{"simple"});
    }

    public void testSettingsLivenessStackTracesServer() {
        ProfilerEngineSettings settings = this.initMemoryTest("j2se-simple", "simple.memory.Memory1");
        settings.setAllocStackTraceLimit(-1);
        this.addJVMArgs(settings, "-server");
        this.startMemoryTest(settings, 5, new String[]{"simple"});
    }
}

