/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ShortValue;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.PrimitiveValueImpl;

public class ShortValueImpl
extends PrimitiveValueImpl
implements ShortValue {
    private short value;

    ShortValueImpl(VirtualMachine virtualMachine, short s) {
        super(virtualMachine);
        this.value = s;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof ShortValue) {
            return this.value == ((ShortValue)object).value() && super.equals(object);
        }
        return false;
    }

    public int hashCode() {
        return this.intValue();
    }

    public int compareTo(ShortValue shortValue) {
        short s = shortValue.value();
        return this.value() - s;
    }

    public Type type() {
        return this.vm.theShortType();
    }

    public short value() {
        return this.value;
    }

    public boolean booleanValue() {
        return this.value != 0;
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public char charValue() {
        return (char)this.value;
    }

    public short shortValue() {
        return this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    byte checkedByteValue() throws InvalidTypeException {
        if (this.value > 127 || this.value < -128) {
            throw new InvalidTypeException("Can't convert " + this.value + " to byte");
        }
        return super.checkedByteValue();
    }

    char checkedCharValue() throws InvalidTypeException {
        if (this.value > 65535 || this.value < 0) {
            throw new InvalidTypeException("Can't convert " + this.value + " to char");
        }
        return super.checkedCharValue();
    }

    public String toString() {
        return "" + this.value;
    }

    byte typeValueKey() {
        return 83;
    }
}

