/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import proguard.io.DataEntry;
import proguard.io.DataEntryWriter;
import proguard.io.Finisher;

public class JarWriter
implements DataEntryWriter,
Finisher {
    private DataEntryWriter dataEntryWriter;
    private Manifest manifest;
    private String comment;
    private OutputStream currentParentOutputStream;
    private ZipOutputStream currentJarOutputStream;
    private Finisher currentFinisher;
    private String currentEntryName;
    private Set jarEntryNames = new HashSet();

    public JarWriter(DataEntryWriter dataEntryWriter) {
        this(dataEntryWriter, null, null);
    }

    public JarWriter(DataEntryWriter dataEntryWriter, Manifest manifest, String string) {
        this.dataEntryWriter = dataEntryWriter;
        this.manifest = manifest;
        this.comment = string;
    }

    public OutputStream getOutputStream(DataEntry dataEntry) throws IOException {
        return this.getOutputStream(dataEntry, null);
    }

    public OutputStream getOutputStream(DataEntry dataEntry, Finisher finisher) throws IOException {
        String string;
        OutputStream outputStream = this.dataEntryWriter.getOutputStream(dataEntry.getParent(), this);
        if (outputStream == null) {
            return null;
        }
        if (this.currentParentOutputStream == null) {
            this.currentParentOutputStream = outputStream;
            ZipOutputStream zipOutputStream = this.currentJarOutputStream = this.manifest != null ? new JarOutputStream(outputStream, this.manifest) : new ZipOutputStream(outputStream);
            if (this.comment != null) {
                this.currentJarOutputStream.setComment(this.comment);
            }
        }
        if (!(string = dataEntry.getName()).equals(this.currentEntryName)) {
            this.closeEntry();
            if (!this.jarEntryNames.add(string)) {
                throw new IOException("Duplicate zip entry [" + dataEntry + "]");
            }
            this.currentJarOutputStream.putNextEntry(new ZipEntry(string));
            this.currentFinisher = finisher;
            this.currentEntryName = string;
        }
        return this.currentJarOutputStream;
    }

    public void finish() throws IOException {
        if (this.currentJarOutputStream != null) {
            this.closeEntry();
            this.currentJarOutputStream.finish();
            this.currentJarOutputStream = null;
            this.currentParentOutputStream = null;
            this.jarEntryNames.clear();
        }
    }

    public void close() throws IOException {
        this.dataEntryWriter.close();
    }

    private void closeEntry() throws IOException {
        if (this.currentEntryName != null) {
            if (this.currentFinisher != null) {
                this.currentFinisher.finish();
                this.currentFinisher = null;
            }
            this.currentJarOutputStream.closeEntry();
            this.currentEntryName = null;
        }
    }
}

