/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.ClassCpInfo;
import proguard.classfile.ClassFile;
import proguard.classfile.DoubleCpInfo;
import proguard.classfile.FieldInfo;
import proguard.classfile.FieldrefCpInfo;
import proguard.classfile.FloatCpInfo;
import proguard.classfile.IntegerCpInfo;
import proguard.classfile.InterfaceMethodrefCpInfo;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.LongCpInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.MethodrefCpInfo;
import proguard.classfile.NameAndTypeCpInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.StringCpInfo;
import proguard.classfile.Utf8CpInfo;
import proguard.classfile.attribute.AttrInfoVisitor;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.attribute.ConstantValueAttrInfo;
import proguard.classfile.attribute.DeprecatedAttrInfo;
import proguard.classfile.attribute.EnclosingMethodAttrInfo;
import proguard.classfile.attribute.ExceptionsAttrInfo;
import proguard.classfile.attribute.InnerClassesAttrInfo;
import proguard.classfile.attribute.LineNumberTableAttrInfo;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableInfoVisitor;
import proguard.classfile.attribute.LocalVariableTableAttrInfo;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeInfoVisitor;
import proguard.classfile.attribute.LocalVariableTypeTableAttrInfo;
import proguard.classfile.attribute.SignatureAttrInfo;
import proguard.classfile.attribute.SourceDirAttrInfo;
import proguard.classfile.attribute.SourceFileAttrInfo;
import proguard.classfile.attribute.SyntheticAttrInfo;
import proguard.classfile.attribute.UnknownAttrInfo;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttrInfo;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationVisitor;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.ElementValueVisitor;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.RuntimeInvisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeInvisibleParameterAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleParameterAnnotationsAttrInfo;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.DescriptorClassEnumeration;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.CpInfoVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;

public class ClassFileReferenceFixer
implements ClassFileVisitor,
CpInfoVisitor,
MemberInfoVisitor,
AttrInfoVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor,
AnnotationVisitor,
ElementValueVisitor {
    private boolean ensureUniqueMemberNames;
    private ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor();

    public ClassFileReferenceFixer(boolean bl) {
        this.ensureUniqueMemberNames = bl;
    }

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        programClassFile.constantPoolEntriesAccept(this);
        programClassFile.fieldsAccept(this);
        programClassFile.methodsAccept(this);
        programClassFile.attributesAccept(this);
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
        libraryClassFile.fieldsAccept(this);
        libraryClassFile.methodsAccept(this);
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
        String string;
        String string2 = programFieldInfo.getDescriptor(programClassFile);
        if (!string2.equals(string = ClassFileReferenceFixer.newDescriptor(string2, programFieldInfo.referencedClassFile))) {
            programFieldInfo.u2descriptorIndex = this.constantPoolEditor.addUtf8CpInfo(programClassFile, string);
            if (this.ensureUniqueMemberNames) {
                String string3 = programFieldInfo.getName(programClassFile);
                String string4 = this.newUniqueMemberName(string3, string2);
                programFieldInfo.u2nameIndex = this.constantPoolEditor.addUtf8CpInfo(programClassFile, string4);
            }
        }
        programFieldInfo.attributesAccept(programClassFile, this);
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        String string;
        String string2 = programMethodInfo.getDescriptor(programClassFile);
        if (!string2.equals(string = ClassFileReferenceFixer.newDescriptor(string2, programMethodInfo.referencedClassFiles))) {
            programMethodInfo.u2descriptorIndex = this.constantPoolEditor.addUtf8CpInfo(programClassFile, string);
            if (this.ensureUniqueMemberNames) {
                String string3 = programMethodInfo.getName(programClassFile);
                String string4 = this.newUniqueMemberName(string3, string2);
                programMethodInfo.u2nameIndex = this.constantPoolEditor.addUtf8CpInfo(programClassFile, string4);
            }
        }
        programMethodInfo.attributesAccept(programClassFile, this);
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
        String string;
        String string2 = libraryFieldInfo.getDescriptor(libraryClassFile);
        libraryFieldInfo.descriptor = string = ClassFileReferenceFixer.newDescriptor(string2, libraryFieldInfo.referencedClassFile);
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
        String string;
        String string2 = libraryMethodInfo.getDescriptor(libraryClassFile);
        libraryMethodInfo.descriptor = string = ClassFileReferenceFixer.newDescriptor(string2, libraryMethodInfo.referencedClassFiles);
    }

    public void visitIntegerCpInfo(ClassFile classFile, IntegerCpInfo integerCpInfo) {
    }

    public void visitLongCpInfo(ClassFile classFile, LongCpInfo longCpInfo) {
    }

    public void visitFloatCpInfo(ClassFile classFile, FloatCpInfo floatCpInfo) {
    }

    public void visitDoubleCpInfo(ClassFile classFile, DoubleCpInfo doubleCpInfo) {
    }

    public void visitFieldrefCpInfo(ClassFile classFile, FieldrefCpInfo fieldrefCpInfo) {
    }

    public void visitInterfaceMethodrefCpInfo(ClassFile classFile, InterfaceMethodrefCpInfo interfaceMethodrefCpInfo) {
    }

    public void visitMethodrefCpInfo(ClassFile classFile, MethodrefCpInfo methodrefCpInfo) {
    }

    public void visitNameAndTypeCpInfo(ClassFile classFile, NameAndTypeCpInfo nameAndTypeCpInfo) {
    }

    public void visitUtf8CpInfo(ClassFile classFile, Utf8CpInfo utf8CpInfo) {
    }

    public void visitStringCpInfo(ClassFile classFile, StringCpInfo stringCpInfo) {
        String string;
        String string2;
        String string3;
        ClassFile classFile2 = stringCpInfo.referencedClassFile;
        if (classFile2 != null && !(string3 = ClassFileReferenceFixer.newClassName(string2 = ClassUtil.internalClassName(string = stringCpInfo.getString(classFile)), classFile2)).equals(string2)) {
            String string4 = ClassUtil.externalClassName(string3);
            stringCpInfo.u2stringIndex = this.constantPoolEditor.addUtf8CpInfo((ProgramClassFile)classFile, string4);
        }
    }

    public void visitClassCpInfo(ClassFile classFile, ClassCpInfo classCpInfo) {
        String string;
        String string2;
        ClassFile classFile2 = classCpInfo.referencedClassFile;
        if (classFile2 != null && !(string2 = classCpInfo.getName(classFile)).equals(string = ClassFileReferenceFixer.newClassName(string2, classFile2))) {
            classCpInfo.u2nameIndex = this.constantPoolEditor.addUtf8CpInfo((ProgramClassFile)classFile, string);
        }
    }

    public void visitUnknownAttrInfo(ClassFile classFile, UnknownAttrInfo unknownAttrInfo) {
    }

    public void visitInnerClassesAttrInfo(ClassFile classFile, InnerClassesAttrInfo innerClassesAttrInfo) {
    }

    public void visitEnclosingMethodAttrInfo(ClassFile classFile, EnclosingMethodAttrInfo enclosingMethodAttrInfo) {
    }

    public void visitConstantValueAttrInfo(ClassFile classFile, FieldInfo fieldInfo, ConstantValueAttrInfo constantValueAttrInfo) {
    }

    public void visitExceptionsAttrInfo(ClassFile classFile, MethodInfo methodInfo, ExceptionsAttrInfo exceptionsAttrInfo) {
    }

    public void visitLineNumberTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LineNumberTableAttrInfo lineNumberTableAttrInfo) {
    }

    public void visitSourceFileAttrInfo(ClassFile classFile, SourceFileAttrInfo sourceFileAttrInfo) {
    }

    public void visitSourceDirAttrInfo(ClassFile classFile, SourceDirAttrInfo sourceDirAttrInfo) {
    }

    public void visitDeprecatedAttrInfo(ClassFile classFile, DeprecatedAttrInfo deprecatedAttrInfo) {
    }

    public void visitSyntheticAttrInfo(ClassFile classFile, SyntheticAttrInfo syntheticAttrInfo) {
    }

    public void visitCodeAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo) {
        codeAttrInfo.attributesAccept(classFile, methodInfo, this);
    }

    public void visitLocalVariableTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTableAttrInfo localVariableTableAttrInfo) {
        localVariableTableAttrInfo.localVariablesAccept(classFile, methodInfo, codeAttrInfo, this);
    }

    public void visitLocalVariableTypeTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTypeTableAttrInfo localVariableTypeTableAttrInfo) {
        localVariableTypeTableAttrInfo.localVariablesAccept(classFile, methodInfo, codeAttrInfo, this);
    }

    public void visitSignatureAttrInfo(ClassFile classFile, SignatureAttrInfo signatureAttrInfo) {
        String string;
        String string2 = classFile.getCpString(signatureAttrInfo.u2signatureIndex);
        if (!string2.equals(string = ClassFileReferenceFixer.newDescriptor(string2, signatureAttrInfo.referencedClassFiles))) {
            signatureAttrInfo.u2signatureIndex = this.constantPoolEditor.addUtf8CpInfo((ProgramClassFile)classFile, string);
        }
    }

    public void visitRuntimeVisibleAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleAnnotationsAttrInfo runtimeVisibleAnnotationsAttrInfo) {
        runtimeVisibleAnnotationsAttrInfo.annotationsAccept(classFile, this);
    }

    public void visitRuntimeInvisibleAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleAnnotationsAttrInfo runtimeInvisibleAnnotationsAttrInfo) {
        runtimeInvisibleAnnotationsAttrInfo.annotationsAccept(classFile, this);
    }

    public void visitRuntimeVisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleParameterAnnotationsAttrInfo runtimeVisibleParameterAnnotationsAttrInfo) {
        runtimeVisibleParameterAnnotationsAttrInfo.annotationsAccept(classFile, this);
    }

    public void visitRuntimeInvisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleParameterAnnotationsAttrInfo runtimeInvisibleParameterAnnotationsAttrInfo) {
        runtimeInvisibleParameterAnnotationsAttrInfo.annotationsAccept(classFile, this);
    }

    public void visitAnnotationDefaultAttrInfo(ClassFile classFile, AnnotationDefaultAttrInfo annotationDefaultAttrInfo) {
        annotationDefaultAttrInfo.defaultValueAccept(classFile, this);
    }

    public void visitLocalVariableInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableInfo localVariableInfo) {
        String string;
        String string2 = classFile.getCpString(localVariableInfo.u2descriptorIndex);
        if (!string2.equals(string = ClassFileReferenceFixer.newDescriptor(string2, localVariableInfo.referencedClassFile))) {
            localVariableInfo.u2descriptorIndex = this.constantPoolEditor.addUtf8CpInfo((ProgramClassFile)classFile, string);
        }
    }

    public void visitLocalVariableTypeInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTypeInfo localVariableTypeInfo) {
        String string;
        String string2 = classFile.getCpString(localVariableTypeInfo.u2signatureIndex);
        if (!string2.equals(string = ClassFileReferenceFixer.newDescriptor(string2, localVariableTypeInfo.referencedClassFiles))) {
            localVariableTypeInfo.u2signatureIndex = this.constantPoolEditor.addUtf8CpInfo((ProgramClassFile)classFile, string);
        }
    }

    public void visitAnnotation(ClassFile classFile, Annotation annotation) {
        String string;
        String string2 = classFile.getCpString(annotation.u2typeIndex);
        if (!string2.equals(string = ClassFileReferenceFixer.newDescriptor(string2, annotation.referencedClassFiles))) {
            annotation.u2typeIndex = this.constantPoolEditor.addUtf8CpInfo((ProgramClassFile)classFile, string);
        }
        annotation.elementValuesAccept(classFile, this);
    }

    public void visitConstantElementValue(ClassFile classFile, Annotation annotation, ConstantElementValue constantElementValue) {
    }

    public void visitEnumConstantElementValue(ClassFile classFile, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
        String string;
        String string2 = classFile.getCpString(enumConstantElementValue.u2typeNameIndex);
        if (!string2.equals(string = ClassFileReferenceFixer.newDescriptor(string2, enumConstantElementValue.referencedClassFiles))) {
            enumConstantElementValue.u2typeNameIndex = this.constantPoolEditor.addUtf8CpInfo((ProgramClassFile)classFile, string);
        }
    }

    public void visitClassElementValue(ClassFile classFile, Annotation annotation, ClassElementValue classElementValue) {
        String string;
        String string2 = classFile.getCpString(classElementValue.u2classInfoIndex);
        if (!string2.equals(string = ClassFileReferenceFixer.newDescriptor(string2, classElementValue.referencedClassFiles))) {
            classElementValue.u2classInfoIndex = this.constantPoolEditor.addUtf8CpInfo((ProgramClassFile)classFile, string);
        }
    }

    public void visitAnnotationElementValue(ClassFile classFile, Annotation annotation, AnnotationElementValue annotationElementValue) {
        annotationElementValue.annotationAccept(classFile, this);
    }

    public void visitArrayElementValue(ClassFile classFile, Annotation annotation, ArrayElementValue arrayElementValue) {
        arrayElementValue.elementValuesAccept(classFile, annotation, this);
    }

    private static String newDescriptor(String string, ClassFile classFile) {
        if (classFile == null) {
            return string;
        }
        DescriptorClassEnumeration descriptorClassEnumeration = new DescriptorClassEnumeration(string);
        StringBuffer stringBuffer = new StringBuffer(string.length());
        stringBuffer.append(descriptorClassEnumeration.nextFluff());
        if (descriptorClassEnumeration.hasMoreClassNames()) {
            String string2 = descriptorClassEnumeration.nextClassName();
            String string3 = descriptorClassEnumeration.nextFluff();
            String string4 = ClassFileReferenceFixer.newClassName(string2, classFile);
            stringBuffer.append(string4);
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    private static String newDescriptor(String string, ClassFile[] classFileArray) {
        if (classFileArray == null || classFileArray.length == 0) {
            return string;
        }
        DescriptorClassEnumeration descriptorClassEnumeration = new DescriptorClassEnumeration(string);
        StringBuffer stringBuffer = new StringBuffer(string.length());
        stringBuffer.append(descriptorClassEnumeration.nextFluff());
        int n = 0;
        while (descriptorClassEnumeration.hasMoreClassNames()) {
            String string2 = descriptorClassEnumeration.nextClassName();
            String string3 = descriptorClassEnumeration.nextFluff();
            String string4 = ClassFileReferenceFixer.newClassName(string2, classFileArray[n++]);
            stringBuffer.append(string4);
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    private String newUniqueMemberName(String string, String string2) {
        return string.equals("<init>") ? "<init>" : string + '$' + Long.toHexString(Math.abs(string2.hashCode()));
    }

    private static String newClassName(String string, ClassFile classFile) {
        if (classFile == null) {
            return string;
        }
        String string2 = classFile.getName();
        if (string.charAt(0) == '[') {
            string2 = string.substring(0, string.indexOf(76) + 1) + string2 + ';';
        }
        return string2;
    }
}

