/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import proguard.classfile.ClassCpInfo;
import proguard.classfile.ClassFile;
import proguard.classfile.CpInfo;
import proguard.classfile.FieldInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.NameAndTypeCpInfo;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.Utf8CpInfo;
import proguard.classfile.attribute.AttrInfo;
import proguard.classfile.attribute.AttrInfoVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.CpInfoVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;

public class ProgramClassFile
implements ClassFile {
    public int u4magic;
    public int u2minorVersion;
    public int u2majorVersion;
    public int u2constantPoolCount;
    public CpInfo[] constantPool;
    public int u2accessFlags;
    public int u2thisClass;
    public int u2superClass;
    public int u2interfacesCount;
    public int[] u2interfaces;
    public int u2fieldsCount;
    public ProgramFieldInfo[] fields;
    public int u2methodsCount;
    public ProgramMethodInfo[] methods;
    public int u2attributesCount;
    public AttrInfo[] attributes;
    public ClassFile[] subClasses = null;
    public Object visitorInfo;

    public static ClassFile create(DataInput dataInput) throws IOException {
        ProgramClassFile programClassFile = new ProgramClassFile();
        programClassFile.read(dataInput);
        return programClassFile;
    }

    private ProgramClassFile() {
    }

    private void read(DataInput dataInput) throws IOException {
        int n;
        this.u4magic = dataInput.readInt();
        ClassUtil.checkMagicNumber(this.u4magic);
        this.u2minorVersion = dataInput.readUnsignedShort();
        this.u2majorVersion = dataInput.readUnsignedShort();
        ClassUtil.checkVersionNumbers(this.u2majorVersion, this.u2minorVersion);
        this.u2constantPoolCount = dataInput.readUnsignedShort();
        this.constantPool = new CpInfo[this.u2constantPoolCount];
        for (n = 1; n < this.u2constantPoolCount; ++n) {
            this.constantPool[n] = CpInfo.create(dataInput);
            int n2 = this.constantPool[n].getTag();
            if (n2 != 5 && n2 != 6) continue;
            ++n;
        }
        this.u2accessFlags = dataInput.readUnsignedShort();
        this.u2thisClass = dataInput.readUnsignedShort();
        this.u2superClass = dataInput.readUnsignedShort();
        this.u2interfacesCount = dataInput.readUnsignedShort();
        if (this.u2interfacesCount > 0) {
            this.u2interfaces = new int[this.u2interfacesCount];
            for (n = 0; n < this.u2interfacesCount; ++n) {
                this.u2interfaces[n] = dataInput.readUnsignedShort();
            }
        }
        this.u2fieldsCount = dataInput.readUnsignedShort();
        if (this.u2fieldsCount > 0) {
            this.fields = new ProgramFieldInfo[this.u2fieldsCount];
            for (n = 0; n < this.u2fieldsCount; ++n) {
                this.fields[n] = ProgramFieldInfo.create(dataInput, this);
            }
        }
        this.u2methodsCount = dataInput.readUnsignedShort();
        if (this.u2methodsCount > 0) {
            this.methods = new ProgramMethodInfo[this.u2methodsCount];
            for (n = 0; n < this.u2methodsCount; ++n) {
                this.methods[n] = ProgramMethodInfo.create(dataInput, this);
            }
        }
        this.u2attributesCount = dataInput.readUnsignedShort();
        if (this.u2attributesCount > 0) {
            this.attributes = new AttrInfo[this.u2attributesCount];
            for (n = 0; n < this.u2attributesCount; ++n) {
                this.attributes[n] = AttrInfo.create(dataInput, this);
            }
        }
    }

    public void write(DataOutput dataOutput) throws IOException {
        int n;
        dataOutput.writeInt(this.u4magic);
        dataOutput.writeShort(this.u2minorVersion);
        dataOutput.writeShort(this.u2majorVersion);
        dataOutput.writeShort(this.u2constantPoolCount);
        for (n = 1; n < this.u2constantPoolCount; ++n) {
            CpInfo cpInfo = this.constantPool[n];
            if (cpInfo == null) continue;
            cpInfo.write(dataOutput);
        }
        dataOutput.writeShort(this.u2accessFlags);
        dataOutput.writeShort(this.u2thisClass);
        dataOutput.writeShort(this.u2superClass);
        dataOutput.writeShort(this.u2interfacesCount);
        for (n = 0; n < this.u2interfacesCount; ++n) {
            dataOutput.writeShort(this.u2interfaces[n]);
        }
        dataOutput.writeShort(this.u2fieldsCount);
        for (n = 0; n < this.u2fieldsCount; ++n) {
            this.fields[n].write(dataOutput);
        }
        dataOutput.writeShort(this.u2methodsCount);
        for (n = 0; n < this.u2methodsCount; ++n) {
            this.methods[n].write(dataOutput);
        }
        dataOutput.writeShort(this.u2attributesCount);
        for (n = 0; n < this.u2attributesCount; ++n) {
            this.attributes[n].write(dataOutput);
        }
    }

    public CpInfo getCpEntry(int n) {
        return this.constantPool[n];
    }

    AttrInfo getAttribute(String string) {
        for (int i = 0; i < this.u2attributesCount; ++i) {
            AttrInfo attrInfo = this.attributes[i];
            if (!attrInfo.getAttributeName(this).equals(string)) continue;
            return attrInfo;
        }
        return null;
    }

    public int getAccessFlags() {
        return this.u2accessFlags;
    }

    public String getName() {
        return this.getCpClassNameString(this.u2thisClass);
    }

    public String getSuperName() {
        return this.u2superClass == 0 ? null : this.getCpClassNameString(this.u2superClass);
    }

    public int getInterfaceCount() {
        return this.u2interfacesCount;
    }

    public String getInterfaceName(int n) {
        return this.getCpClassNameString(this.u2interfaces[n]);
    }

    public int getCpTag(int n) {
        return this.constantPool[n].getTag();
    }

    public String getCpString(int n) {
        return ((Utf8CpInfo)this.constantPool[n]).getString();
    }

    public String getCpClassNameString(int n) {
        ClassCpInfo classCpInfo = (ClassCpInfo)this.constantPool[n];
        Utf8CpInfo utf8CpInfo = (Utf8CpInfo)this.constantPool[classCpInfo.getNameIndex()];
        return utf8CpInfo.getString();
    }

    public String getCpNameString(int n) {
        return ((NameAndTypeCpInfo)this.constantPool[n]).getName(this);
    }

    public String getCpTypeString(int n) {
        return ((NameAndTypeCpInfo)this.constantPool[n]).getType(this);
    }

    public void addSubClass(ClassFile classFile) {
        if (this.subClasses == null) {
            this.subClasses = new ClassFile[1];
        } else {
            ClassFile[] classFileArray = new ClassFile[this.subClasses.length + 1];
            System.arraycopy(this.subClasses, 0, classFileArray, 0, this.subClasses.length);
            this.subClasses = classFileArray;
        }
        this.subClasses[this.subClasses.length - 1] = classFile;
    }

    public ClassFile getSuperClass() {
        return this.u2superClass != 0 ? ((ClassCpInfo)this.constantPool[this.u2superClass]).referencedClassFile : null;
    }

    public ClassFile getInterface(int n) {
        return ((ClassCpInfo)this.constantPool[this.u2interfaces[n]]).referencedClassFile;
    }

    public boolean extends_(ClassFile classFile) {
        if (this.equals(classFile)) {
            return true;
        }
        ClassFile classFile2 = this.getSuperClass();
        return classFile2 != null && classFile2.extends_(classFile);
    }

    public boolean implements_(ClassFile classFile) {
        if (this.equals(classFile)) {
            return true;
        }
        for (int i = 0; i < this.u2interfacesCount; ++i) {
            ClassFile classFile2 = this.getInterface(i);
            if (classFile2 == null || !classFile2.implements_(classFile)) continue;
            return true;
        }
        return false;
    }

    public FieldInfo findField(String string, String string2) {
        for (int i = 0; i < this.u2fieldsCount; ++i) {
            ProgramFieldInfo programFieldInfo = this.fields[i];
            if (string != null && !programFieldInfo.getName(this).equals(string) || string2 != null && !programFieldInfo.getDescriptor(this).equals(string2)) continue;
            return programFieldInfo;
        }
        return null;
    }

    public MethodInfo findMethod(String string, String string2) {
        for (int i = 0; i < this.u2methodsCount; ++i) {
            ProgramMethodInfo programMethodInfo = this.methods[i];
            if (string != null && !programMethodInfo.getName(this).equals(string) || string2 != null && !programMethodInfo.getDescriptor(this).equals(string2)) continue;
            return programMethodInfo;
        }
        return null;
    }

    public void accept(ClassFileVisitor classFileVisitor) {
        classFileVisitor.visitProgramClassFile(this);
    }

    public void hierarchyAccept(boolean bl, boolean bl2, boolean bl3, boolean bl4, ClassFileVisitor classFileVisitor) {
        ClassFile classFile;
        ClassFile classFile2;
        if (bl) {
            this.accept(classFileVisitor);
        }
        if (bl2 && (classFile2 = this.getSuperClass()) != null) {
            classFile2.hierarchyAccept(true, true, bl3, false, classFileVisitor);
        }
        if (bl3) {
            for (int i = 0; i < this.u2interfacesCount; ++i) {
                classFile = this.getInterface(i);
                if (classFile == null) continue;
                classFile.hierarchyAccept(true, true, true, false, classFileVisitor);
            }
        }
        if (bl4 && this.subClasses != null) {
            for (int i = 0; i < this.subClasses.length; ++i) {
                classFile = this.subClasses[i];
                classFile.hierarchyAccept(true, false, false, true, classFileVisitor);
            }
        }
    }

    public void constantPoolEntriesAccept(CpInfoVisitor cpInfoVisitor) {
        for (int i = 1; i < this.u2constantPoolCount; ++i) {
            if (this.constantPool[i] == null) continue;
            this.constantPool[i].accept(this, cpInfoVisitor);
        }
    }

    public void constantPoolEntryAccept(int n, CpInfoVisitor cpInfoVisitor) {
        this.constantPool[n].accept(this, cpInfoVisitor);
    }

    public void fieldsAccept(MemberInfoVisitor memberInfoVisitor) {
        for (int i = 0; i < this.u2fieldsCount; ++i) {
            this.fields[i].accept(this, memberInfoVisitor);
        }
    }

    public void fieldAccept(String string, String string2, MemberInfoVisitor memberInfoVisitor) {
        FieldInfo fieldInfo = this.findField(string, string2);
        if (fieldInfo != null) {
            fieldInfo.accept(this, memberInfoVisitor);
        }
    }

    public void methodsAccept(MemberInfoVisitor memberInfoVisitor) {
        for (int i = 0; i < this.u2methodsCount; ++i) {
            this.methods[i].accept(this, memberInfoVisitor);
        }
    }

    public void methodAccept(String string, String string2, MemberInfoVisitor memberInfoVisitor) {
        MethodInfo methodInfo = this.findMethod(string, string2);
        if (methodInfo != null) {
            methodInfo.accept(this, memberInfoVisitor);
        }
    }

    public boolean mayHaveImplementations(MethodInfo methodInfo) {
        return (this.u2accessFlags & 0x10) == 0 && (methodInfo == null || (methodInfo.getAccessFlags() & 0x1A) == 0 && !methodInfo.getName(this).equals("<init>"));
    }

    private boolean isSpecial(MethodInfo methodInfo) {
        return (methodInfo.getAccessFlags() & 0xA) != 0 || methodInfo.getName(this).equals("<init>");
    }

    public void methodImplementationsAccept(MethodInfo methodInfo, boolean bl, MemberInfoVisitor memberInfoVisitor) {
        this.methodImplementationsAccept(methodInfo.getName(this), methodInfo.getDescriptor(this), methodInfo, bl, true, true, true, memberInfoVisitor);
    }

    public void methodImplementationsAccept(String string, String string2, boolean bl, MemberInfoVisitor memberInfoVisitor) {
        this.methodImplementationsAccept(string, string2, bl, true, true, true, memberInfoVisitor);
    }

    public void methodImplementationsAccept(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, MemberInfoVisitor memberInfoVisitor) {
        this.methodImplementationsAccept(string, string2, this.findMethod(string, string2), bl, bl2, bl3, bl4, memberInfoVisitor);
    }

    public void methodImplementationsAccept(String string, String string2, MethodInfo methodInfo, boolean bl, boolean bl2, boolean bl3, boolean bl4, MemberInfoVisitor memberInfoVisitor) {
        ClassFile classFile;
        if (methodInfo != null) {
            if (this.isSpecial(methodInfo)) {
                if (bl2) {
                    methodInfo.accept(this, memberInfoVisitor);
                    return;
                }
            } else {
                if (bl) {
                    methodInfo.accept(this, memberInfoVisitor);
                }
                if (!this.mayHaveImplementations(methodInfo)) {
                    bl4 = false;
                }
                if ((methodInfo.getAccessFlags() & 0x400) == 0) {
                    bl3 = false;
                }
            }
        }
        if (bl4) {
            if (this.subClasses != null) {
                for (int i = 0; i < this.subClasses.length; ++i) {
                    ClassFile classFile2 = this.subClasses[i];
                    classFile2.methodImplementationsAccept(string, string2, true, false, bl3, true, memberInfoVisitor);
                }
            }
            if ((this.u2accessFlags & 0x600) != 0) {
                bl3 = false;
            }
        }
        if (bl3 && (classFile = this.getSuperClass()) != null) {
            classFile.methodImplementationsAccept(string, string2, true, false, true, false, memberInfoVisitor);
        }
    }

    public void attributesAccept(AttrInfoVisitor attrInfoVisitor) {
        for (int i = 0; i < this.u2attributesCount; ++i) {
            this.attributes[i].accept(this, attrInfoVisitor);
        }
    }

    public Object getVisitorInfo() {
        return this.visitorInfo;
    }

    public void setVisitorInfo(Object object) {
        this.visitorInfo = object;
    }
}

