/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy.model.project;

import javax.swing.tree.TreePath;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.modules.visualweb.gravy.Bundle;
import org.netbeans.modules.visualweb.gravy.ProjectNavigatorOperator;
import org.netbeans.modules.visualweb.gravy.TestUtils;
import org.netbeans.modules.visualweb.gravy.model.project.Folder;
import org.netbeans.modules.visualweb.gravy.model.project.ProjectEntry;
import org.netbeans.modules.visualweb.gravy.model.project.RootEntry;
import org.netbeans.modules.visualweb.gravy.model.project.SourceFolder;
import org.netbeans.modules.visualweb.gravy.model.project.WebPage;

public class WebPageFolder
extends Folder {
    private static final String bundle = "org.netbeans.modules.visualweb.gravy.model.project.Bundle";
    private static final String popupNew = Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.model.project.Bundle", "New");
    private static final String popupFolder = Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.model.project.Bundle", "Folder");
    private static final String popupNewFolder = popupNew + "|" + popupFolder + "...";
    private static final String dlgNewFolder = popupNew + " " + popupFolder;
    private static final String popupPage = Bundle.getStringTrimmed(Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.model.project.Bundle", "JSFResBundle"), Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.model.project.Bundle", "Page"));
    private static final String popupNewPage = popupNew + "|" + popupPage + "...";
    private static final String dlgNewPage = popupNew + " " + popupPage;
    private static final String btnFinish = Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.model.project.Bundle", "FinishButton");
    private static final String btnCancel = Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.model.project.Bundle", "CancelButton");
    private SourceFolder sf;

    WebPageFolder(TreePath path, String name, ProjectEntry parent) {
        super(path, name, parent);
        if (parent instanceof RootEntry) {
            RootEntry root = (RootEntry)parent;
            SourceFolder srf = new SourceFolder(new TreePath(root.getProject().getName()), RootEntry.sourcePackagesName, root);
            SourceFolder sf = new SourceFolder(new TreePath(root.getProject().getName() + "|" + RootEntry.sourcePackagesName), root.getProject().getName().toLowerCase(), srf);
            srf.childList.add(sf);
            root.childList.add(srf);
            this.sf = sf;
        } else {
            this.sf = ((WebPageFolder)parent).getSourceFolder().addSourceSubFolder(name);
        }
    }

    public WebPage addWebPage(String name) {
        if (this.getWebPage(name) == null) {
            ProjectNavigatorOperator prjNav = ProjectNavigatorOperator.showProjectNavigator();
            TestUtils.wait(4000);
            String full_path = this.path.toString().substring(1, this.path.toString().length() - 1) + "|" + this.name;
            try {
                ProjectNavigatorOperator.pressPopupItemOnNode(full_path, popupNewPage, (Operator.StringComparator)new Operator.DefaultStringComparator(true, true));
            }
            catch (Exception e) {
                throw new JemmyException(popupNewPage + " item in popup menu of " + full_path + " node can't be found!", (Throwable)e);
            }
            TestUtils.wait(1000);
            try {
                JDialogOperator jdo = new JDialogOperator(dlgNewPage);
                new JTextFieldOperator((ContainerOperator)jdo, 0).setText(name);
                TestUtils.wait(500);
                new JButtonOperator((ContainerOperator)jdo, btnFinish).pushNoBlock();
            }
            catch (Exception e) {
                throw new JemmyException("Error occurs in " + dlgNewPage + " dialog!", (Throwable)e);
            }
            TestUtils.wait(1000);
            WebPage newWebPage = new WebPage(new TreePath(full_path), name, this);
            this.childList.add(newWebPage);
            return newWebPage;
        }
        return this.getWebPage(name);
    }

    public WebPage getWebPage(String name) {
        for (int i = 0; i < this.childList.size(); ++i) {
            if (!(this.childList.get(i) instanceof WebPage) || !((WebPage)this.childList.get(i)).getName().equals(name)) continue;
            return (WebPage)this.childList.get(i);
        }
        if (this.getParent() instanceof RootEntry && name.equals("Page1")) {
            String full_path = this.path.toString().substring(1, this.path.toString().length() - 1) + "|" + this.name;
            WebPage newWebPage = new WebPage(new TreePath(full_path), name, this);
            this.childList.add(newWebPage);
            return newWebPage;
        }
        return null;
    }

    public WebPageFolder addWebPageSubFolder(String name) {
        ProjectNavigatorOperator prjNav = ProjectNavigatorOperator.showProjectNavigator();
        TestUtils.wait(1000);
        String full_path = this.path.toString().substring(1, this.path.toString().length() - 1) + "|" + this.name;
        try {
            ProjectNavigatorOperator.pressPopupItemOnNode(full_path, popupNewFolder, (Operator.StringComparator)new Operator.DefaultStringComparator(true, true));
        }
        catch (Exception e) {
            throw new JemmyException(popupNewFolder + " item in popup menu of " + full_path + " node can't be found!", (Throwable)e);
        }
        TestUtils.wait(1000);
        try {
            JDialogOperator jdo = new JDialogOperator(dlgNewFolder);
            new JTextFieldOperator((ContainerOperator)jdo, 0).setText(name);
            TestUtils.wait(500);
            new JButtonOperator((ContainerOperator)jdo, btnFinish).pushNoBlock();
        }
        catch (Exception e) {
            throw new JemmyException("Error occurs in " + dlgNewFolder + " dialog!", (Throwable)e);
        }
        TestUtils.wait(1000);
        WebPageFolder newWebPageFolder = new WebPageFolder(new TreePath(full_path), name, this);
        this.childList.add(newWebPageFolder);
        return newWebPageFolder;
    }

    public WebPageFolder getWebPageSubFolder(String name) {
        for (int i = 0; i < this.childList.size(); ++i) {
            if (!(this.childList.get(i) instanceof WebPageFolder) || !((WebPageFolder)this.childList.get(i)).getName().equals(name)) continue;
            return (WebPageFolder)this.childList.get(i);
        }
        return null;
    }

    public SourceFolder getSourceFolder() {
        return this.sf;
    }
}

