/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy.dataconnectivity;

import java.awt.Point;
import java.util.Hashtable;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.NbDialogOperator;
import org.netbeans.jellytools.WizardOperator;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JCheckBoxOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JLabelOperator;
import org.netbeans.jemmy.operators.JListOperator;
import org.netbeans.jemmy.operators.JMenuItemOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.modules.visualweb.gravy.DNDDriver;
import org.netbeans.modules.visualweb.gravy.TestUtils;
import org.netbeans.modules.visualweb.gravy.TopComponentOperator;
import org.netbeans.modules.visualweb.gravy.Util;
import org.netbeans.modules.visualweb.gravy.actions.ActionNoBlock;
import org.netbeans.modules.visualweb.gravy.dataconnectivity.ServerNavigatorOperator;
import org.netbeans.modules.visualweb.gravy.designer.DesignerPaneOperator;
import org.netbeans.modules.visualweb.gravy.model.deployment.DeploymentTargetDescriptor;
import org.netbeans.modules.visualweb.gravy.nodes.WebServicesNode;
import org.netbeans.modules.visualweb.gravy.websvc.AddWebServiceOperator;

public class ServerExplorerOperator
extends TopComponentOperator {
    public static final String STR_NAME_WEBLOGIC = "BEA WebLogic Server";
    public static final String STR_NAME_JBOSS = "JBoss Application Server";
    public static final String STR_NAME_APPSERVER = "Sun Java System Application Server";
    public static final String STR_NAME_GLASSFISH_V1 = "GlassFish V1";
    public static final String STR_NAME_GLASSFISH_V2 = "GlassFish V2";
    public static final String STR_NAME_TOMCAT50 = "Tomcat 5.0";
    public static final String STR_NAME_TOMCAT55 = "Tomcat 5.5";
    public static final String STR_NAME_TOMCAT60 = "Tomcat 6.0";
    public static final String STR_MENU_ITEM_SERVER_MANAGER = "Tools|Servers";
    public static final String STR_DIALOG_TITLE_SERVER_MANAGER = "Servers";
    public static final String STR_WIZARD_TITLE_ADD_SERVER = "Add Server Instance";
    public static final String STR_BUTTON_TITLE_ADD_SERVER = "Add Server...";
    public static final String STR_BUTTON_TITLE_CLOSE = "Close";
    public static final String STR_BUTTON_TITLE_CHOOSE = "Choose";
    public static final String STR_MENU_ITEM_START = "Start";
    public static final String STR_MENU_ITEM_STOP = "Stop";
    public static final String STR_SERVERS_PATH = "Servers|";
    public static final String STR_SERVER_START = "Starting ";
    public static final String STR_SERVER_STOP = "Stopping ";
    JTreeOperator tree = null;

    public ServerExplorerOperator(ContainerOperator parent) {
        super(parent, "Services");
    }

    public ServerExplorerOperator() {
        this((ContainerOperator)Util.getMainWindow());
    }

    public JTreeOperator getTree() {
        if (this.tree == null) {
            this.makeComponentVisible();
            this.tree = new JTreeOperator((ContainerOperator)this);
        }
        return this.tree;
    }

    public void selectPath(String treePath) {
        this.makeComponentVisible();
        TestUtils.wait(500);
        TreePath path = this.getTree().findPath(treePath);
        TestUtils.wait(500);
        this.tree.selectPath(path);
    }

    public void pushPopup(String treePath, String menu) {
        this.pushPopup(this.getTree(), treePath, menu);
    }

    public void pushPopup(JTreeOperator tree, String treePath, String menu) {
        new JPopupMenuOperator(this.getTree().callPopupOnPath(this.getTree().findPath(treePath))).pushMenuNoBlock(menu);
        new QueueTool().waitEmpty();
        TestUtils.wait(100);
    }

    public void pushPopup(String[] treePath, String menu) {
        new JPopupMenuOperator(this.getTree().callPopupOnPath(this.getTree().findPath(treePath))).pushMenuNoBlock(menu);
        new QueueTool().waitEmpty();
        TestUtils.wait(100);
    }

    public void addTable(String treePath) {
        this.selectPath(treePath);
        this.pushPopup(this.getTree(), treePath, "Add to Form");
    }

    public void addTable(String treePath, DesignerPaneOperator designer) {
        this.addTable(treePath, designer, new Point(1, 1));
    }

    public void addTable(TreePath treePath, DesignerPaneOperator designer) {
        this.addTable(treePath, designer, new Point(1, 1));
    }

    public void addTable(String treePath, DesignerPaneOperator designer, Point location) {
        this.addTable(this.tree.findPath(treePath), designer, location);
    }

    public void addTable(TreePath treePath, DesignerPaneOperator designer, Point location) {
        this.makeComponentVisible();
        TestUtils.wait(2000);
        TestUtils.wait(500);
        this.tree.selectPath(treePath);
        TestUtils.wait(3000);
        new DNDDriver().dnd((ComponentOperator)this.tree, this.tree.getPointToClick(treePath), (ComponentOperator)designer, location);
        TestUtils.wait(3000);
    }

    public static void undeployProject(String server, String prj, boolean parse) {
        String serverPath = null;
        serverPath = "Deployment Server";
        System.out.println("default is " + serverPath);
        new QueueTool().waitEmpty(100L);
        ServerNavigatorOperator explorer = ServerNavigatorOperator.showNavigatorOperator();
        explorer.makeComponentVisible();
        JTreeOperator tree = explorer.getTree();
        Util.wait(4000);
        explorer.pushPopup(tree, serverPath, "Refresh");
        tree.getTimeouts().setTimeout("JTreeOperator.WaitNodeExpandedTimeout", 60000L);
        tree.getTimeouts().setTimeout("JTreeOperator.WaitNextNodeTimeout", 60000L);
        tree.getTimeouts().setTimeout("JTreeOperator.WaitNodeVisibleTimeout", 60000L);
        TestUtils.wait(1000);
        explorer.selectPath(serverPath + "|Deployed Components");
        explorer.getTree().expandPath(explorer.getTree().findPath(serverPath + "|Deployed Components"));
        System.out.println("TRACE: Path =" + serverPath + "|Deployed Components");
        TestUtils.wait(1000);
        explorer.pushPopup(tree, serverPath, "Refresh");
        TestUtils.wait(1000);
        explorer.selectPath(serverPath + "|Deployed Components");
        explorer.getTree().expandPath(explorer.getTree().findPath(serverPath + "|Deployed Components"));
        System.out.println("TRACE: Path =" + serverPath + "|Deployed Components");
        TestUtils.wait(1000);
        explorer.selectPath(serverPath + "|Deployed Components|/" + prj);
        System.out.println("TRACE: Path =" + serverPath + "|Deployed Components|/" + prj);
        TestUtils.wait(1000);
        System.out.println("TRACE: Push Menu Undeploy...");
        explorer.pushPopup(explorer.getTree(), serverPath + "|Deployed Components|/" + prj, "Undeploy");
    }

    public static boolean verifyUndeployment(String server, String prj, boolean parse) {
        TreePath deployedComps;
        System.out.println("Started!");
        String serverPath = null;
        String pePath = "Deployment Server";
        Object deploymentPath = null;
        Object defaultServer = null;
        serverPath = pePath;
        serverPath = "Deployment Server";
        new QueueTool().waitEmpty(100L);
        ServerNavigatorOperator explorer = ServerNavigatorOperator.showNavigatorOperator();
        explorer.makeComponentVisible();
        JTreeOperator tree = explorer.getTree();
        explorer.pushPopup(tree, serverPath, "Refresh");
        tree.getTimeouts().setTimeout("JTreeOperator.WaitNodeExpandedTimeout", 60000L);
        tree.getTimeouts().setTimeout("JTreeOperator.WaitNextNodeTimeout", 60000L);
        tree.getTimeouts().setTimeout("JTreeOperator.WaitNodeVisibleTimeout", 60000L);
        JTreeOperator oldTree = tree;
        tree = new JTreeOperator((JTree)tree.getSource());
        tree.copyEnvironment((Operator)oldTree);
        try {
            deployedComps = tree.findPath(serverPath + "|Deployed Components");
        }
        catch (TimeoutExpiredException e) {
            deployedComps = tree.findPath(serverPath + "|Deployed Components");
        }
        explorer.getTree().selectPath(deployedComps);
        explorer.getTree().expandPath(deployedComps);
        Util.wait(1000);
        new QueueTool().waitEmpty(100L);
        TreePath[] aDeployedComps = tree.getChildPaths(deployedComps);
        boolean undeployed = true;
        for (int i = 0; i < aDeployedComps.length; ++i) {
            String prjNode = aDeployedComps[i].getLastPathComponent().toString();
            if (parse) {
                prjNode = prjNode.substring(0, 3);
            }
            JemmyProperties.getCurrentOutput().printLine(aDeployedComps[i].toString());
            JemmyProperties.getCurrentOutput().printLine(aDeployedComps[i].getLastPathComponent().toString());
            if (!prjNode.equals("/" + prj)) continue;
            Util.wait(1000);
            undeployed = false;
            new QueueTool().waitEmpty(100L);
        }
        return undeployed;
    }

    public static void deleteResource(String resource) {
        System.out.println("Started!");
        String serverPath = null;
        String pePath = "Deployment Server";
        TreePath resourcePath = null;
        Object defaultServer = null;
        serverPath = pePath;
        serverPath = "Deployment Server";
        new QueueTool().waitEmpty(100L);
        ServerNavigatorOperator explorer = ServerNavigatorOperator.showNavigatorOperator();
        explorer.makeComponentVisible();
        JTreeOperator tree = explorer.getTree();
        explorer.pushPopup(tree, serverPath, "Refresh");
        tree.getTimeouts().setTimeout("JTreeOperator.WaitNodeExpandedTimeout", 60000L);
        tree.getTimeouts().setTimeout("JTreeOperator.WaitNextNodeTimeout", 60000L);
        tree.getTimeouts().setTimeout("JTreeOperator.WaitNodeVisibleTimeout", 60000L);
        JTreeOperator oldTree = tree;
        tree = new JTreeOperator((JTree)tree.getSource());
        tree.copyEnvironment((Operator)oldTree);
        try {
            explorer.makeComponentVisible();
            TestUtils.wait(500);
            resourcePath = tree.findPath(serverPath + "|Resources");
        }
        catch (TimeoutExpiredException e) {
            explorer.makeComponentVisible();
            TestUtils.wait(500);
            resourcePath = tree.findPath(serverPath + "|Resources");
        }
        TestUtils.wait(500);
        explorer.getTree().selectPath(resourcePath);
        explorer.getTree().expandPath(resourcePath);
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        new QueueTool().waitEmpty(100L);
        TreePath[] aResources = tree.getChildPaths(resourcePath);
        for (int i = 0; i < aResources.length; ++i) {
            String resNode = aResources[i].getLastPathComponent().toString();
            JemmyProperties.getCurrentOutput().printLine(aResources[i].toString());
            JemmyProperties.getCurrentOutput().printLine(aResources[i].getLastPathComponent().toString());
            if (!resNode.equals(resource)) continue;
            Util.wait(1000);
            new QueueTool().waitEmpty(100L);
            explorer.pushPopup(tree, serverPath + "|Resources|" + resource, "Delete");
            new QueueTool().waitEmpty(100L);
        }
    }

    public static void stopServer(String server) {
        new QueueTool().waitEmpty(100L);
        ServerNavigatorOperator explorer = ServerNavigatorOperator.showNavigatorOperator();
        TestUtils.wait(2000);
        JTreeOperator tree = explorer.getTree();
        TestUtils.wait(1000);
        tree.selectPath(tree.findPath(STR_SERVERS_PATH + server));
        TestUtils.wait(5000);
        new QueueTool().waitEmpty(100L);
        tree.callPopupOnPath(tree.findPath(STR_SERVERS_PATH + server));
        TestUtils.wait(500);
        JPopupMenuOperator snpm = new JPopupMenuOperator();
        TestUtils.wait(1000);
        if (!new JMenuItemOperator((ContainerOperator)snpm, STR_MENU_ITEM_STOP).isEnabled()) {
            tree.pushKey(27);
        } else {
            JLabelOperator jlo = new JLabelOperator((ContainerOperator)Util.getMainWindow(), 1);
            new JMenuItemOperator((ContainerOperator)snpm, STR_MENU_ITEM_STOP).push();
            while (jlo.getText() == null || !jlo.getText().equals(STR_SERVER_STOP + server)) {
                jlo = new JLabelOperator((ContainerOperator)Util.getMainWindow(), 1);
                System.out.println("label in first cycle = " + jlo.getText());
                TestUtils.wait(1000);
            }
            while (jlo.getText() != null && jlo.getText().equals(STR_SERVER_STOP + server)) {
                jlo = new JLabelOperator((ContainerOperator)Util.getMainWindow(), 1);
                TestUtils.wait(1000);
            }
            TestUtils.wait(1000);
        }
        new QueueTool().waitEmpty(100L);
        TestUtils.wait(5000);
    }

    public static boolean isServerStarted(String server) throws Exception {
        String serverPath = null;
        String pePath = "Deployment Server";
        Object deploymentPath = null;
        new QueueTool().waitEmpty(100L);
        ServerNavigatorOperator explorer = ServerNavigatorOperator.showNavigatorOperator();
        explorer.makeComponentVisible();
        JTreeOperator tree = explorer.getTree();
        Util.wait(1000);
        serverPath = pePath;
        TreePath serverNode = tree.findPath(serverPath);
        explorer.getTree().selectPath(serverNode);
        explorer.getTree().expandPath(serverNode);
        TreePath serverSubNode = tree.findPath(serverPath);
        explorer.getTree().selectPath(serverSubNode);
        new QueueTool().waitEmpty(100L);
        explorer.pushPopup(tree, serverPath, Bundle.getStringTrimmed((String)"org.netbeans.modules.j2ee.deployment.impl.ui.actions.Bundle", (String)"LBL_StartStopServer"));
        JDialogOperator serverStatusDialog = new JDialogOperator("Server Status");
        new JCheckBoxOperator((ContainerOperator)serverStatusDialog, Bundle.getStringTrimmed((String)"org.netbeans.modules.j2ee.deployment.impl.ui.Bundle", (String)"LBL_Close_When_Finished")).changeSelection(true);
        final JButtonOperator buttonStart = new JButtonOperator((ContainerOperator)serverStatusDialog, "Start Server");
        final JButtonOperator buttonStop = new JButtonOperator((ContainerOperator)serverStatusDialog, "Stop Server");
        new Waiter(new Waitable(){

            public Object actionProduced(Object obj) {
                return buttonStart != null && buttonStart.isEnabled() || buttonStop != null && buttonStop.isEnabled() ? this : null;
            }

            public String getDescription() {
                return "One of Start/Stop buttons to enable";
            }
        }).waitAction(null);
        boolean started = buttonStart == null || !buttonStart.isEnabled();
        serverStatusDialog.close();
        serverStatusDialog.dispose();
        new QueueTool().waitEmpty(100L);
        return started;
    }

    public static void startServer(String server) throws Exception {
        new QueueTool().waitEmpty(100L);
        ServerNavigatorOperator explorer = ServerNavigatorOperator.showNavigatorOperator();
        TestUtils.wait(2000);
        JTreeOperator tree = explorer.getTree();
        TestUtils.wait(1000);
        tree.selectPath(tree.findPath(STR_SERVERS_PATH + server));
        TestUtils.wait(5000);
        new QueueTool().waitEmpty(100L);
        tree.callPopupOnPath(tree.findPath(STR_SERVERS_PATH + server));
        TestUtils.wait(500);
        JPopupMenuOperator snpm = new JPopupMenuOperator();
        TestUtils.wait(1000);
        if (!new JMenuItemOperator((ContainerOperator)snpm, STR_MENU_ITEM_START).isEnabled()) {
            tree.pushKey(27);
        } else {
            JLabelOperator jlo = new JLabelOperator((ContainerOperator)Util.getMainWindow(), 1);
            new JMenuItemOperator((ContainerOperator)snpm, STR_MENU_ITEM_START).push();
            while (jlo.getText() == null || !jlo.getText().equals(STR_SERVER_START + server)) {
                jlo = new JLabelOperator((ContainerOperator)Util.getMainWindow(), 1);
                System.out.println("label in first cycle = " + jlo.getText());
                TestUtils.wait(1000);
            }
            while (jlo.getText() != null && jlo.getText().equals(STR_SERVER_START + server)) {
                jlo = new JLabelOperator((ContainerOperator)Util.getMainWindow(), 1);
                TestUtils.wait(1000);
            }
            TestUtils.wait(1000);
        }
        new QueueTool().waitEmpty(100L);
        TestUtils.wait(5000);
    }

    public static void addDeploymentTarget(DeploymentTargetDescriptor DTDescriptor) {
        Hashtable properties = DTDescriptor.getProperties();
        String serverType = properties.get("deployment.target.type").toString();
        ActionNoBlock srv = new ActionNoBlock(STR_MENU_ITEM_SERVER_MANAGER, "", "");
        srv.performMenu();
        TestUtils.wait(500);
        NbDialogOperator serverManager = new NbDialogOperator(STR_DIALOG_TITLE_SERVER_MANAGER);
        JTreeOperator jto = new JTreeOperator((ContainerOperator)serverManager);
        int length = ((TreeNode)jto.getChild(jto.getRoot(), 0)).getChildCount();
        String addServerName = properties.get("deployment.target.name." + serverType).toString();
        for (int i = 0; i < length; ++i) {
            String currentServerName = ((TreeNode)jto.getChild(jto.getRoot(), 0)).getChildAt(i).toString();
            if (!currentServerName.equals(addServerName)) continue;
            JButtonOperator close = new JButtonOperator((ContainerOperator)serverManager, STR_BUTTON_TITLE_CLOSE);
            close.pushNoBlock();
            TestUtils.wait(500);
            return;
        }
        JButtonOperator addServer = new JButtonOperator((ContainerOperator)serverManager, STR_BUTTON_TITLE_ADD_SERVER);
        addServer.pushNoBlock();
        TestUtils.wait(500);
        WizardOperator serverInstance = new WizardOperator(STR_WIZARD_TITLE_ADD_SERVER);
        JListOperator jlo = new JListOperator((ContainerOperator)serverInstance, 1);
        jlo.selectItem(serverType);
        TestUtils.wait(500);
        JTextFieldOperator tfName = new JTextFieldOperator((ContainerOperator)serverInstance);
        tfName.setText(properties.get("deployment.target.name." + serverType).toString());
        TestUtils.wait(500);
        serverInstance.next();
        TestUtils.wait(500);
        String projectPath = properties.get("deployment.target.path." + serverType).toString();
        JTextFieldOperator fileName = serverType.equals(STR_NAME_TOMCAT50) || serverType.equals(STR_NAME_TOMCAT55) || serverType.equals(STR_NAME_TOMCAT60) ? new JTextFieldOperator((ContainerOperator)serverInstance, 1) : new JTextFieldOperator((ContainerOperator)serverInstance, 0);
        fileName.setText(projectPath);
        TestUtils.wait(5000);
        if (serverType.equals(STR_NAME_WEBLOGIC)) {
            ServerExplorerOperator.addWebLogic(serverType, properties, serverInstance);
        }
        if (serverType.equals(STR_NAME_JBOSS)) {
            ServerExplorerOperator.addJBoss(serverType, properties, serverInstance);
        }
        if (serverType.equals(STR_NAME_APPSERVER) || serverType.equals(STR_NAME_GLASSFISH_V1) || serverType.equals(STR_NAME_GLASSFISH_V2)) {
            ServerExplorerOperator.addAppServer(serverType, properties, serverInstance);
        }
        if (serverType.equals(STR_NAME_TOMCAT50) || serverType.equals(STR_NAME_TOMCAT55) || serverType.equals(STR_NAME_TOMCAT60)) {
            ServerExplorerOperator.addTomcat(serverType, properties, serverInstance);
        }
        serverInstance.finish();
        TestUtils.wait(500);
        JButtonOperator close = new JButtonOperator((ContainerOperator)serverManager, STR_BUTTON_TITLE_CLOSE);
        close.pushNoBlock();
        TestUtils.wait(5000);
    }

    private static void addWebLogic(String serverType, Hashtable properties, WizardOperator serverInstance) {
        serverInstance.pushKey(37);
        serverInstance.next();
        TestUtils.wait(500);
        JComboBoxOperator cbInstance = new JComboBoxOperator((ContainerOperator)serverInstance);
        cbInstance.selectItem(properties.get("deployment.target.domain." + serverType).toString());
        TestUtils.wait(500);
        JTextFieldOperator tfLogin = new JTextFieldOperator((ContainerOperator)serverInstance, 3);
        tfLogin.setText(properties.get("deployment.target.login." + serverType).toString());
        TestUtils.wait(500);
        JTextFieldOperator tfPassword = new JTextFieldOperator((ContainerOperator)serverInstance, 4);
        tfPassword.setText(properties.get("deployment.target.password." + serverType).toString());
        TestUtils.wait(500);
    }

    private static void addJBoss(String serverType, Hashtable properties, WizardOperator serverInstance) {
        serverInstance.next();
        TestUtils.wait(500);
        JComboBoxOperator cbInstance = new JComboBoxOperator((ContainerOperator)serverInstance);
        cbInstance.selectItem(properties.get("deployment.target.domain." + serverType).toString());
        TestUtils.wait(500);
    }

    private static void addAppServer(String serverType, Hashtable properties, WizardOperator serverInstance) {
        JComboBoxOperator cbInstance = new JComboBoxOperator((ContainerOperator)serverInstance);
        TestUtils.wait(500);
        serverInstance.next();
        TestUtils.wait(2000);
        JTextFieldOperator tfLogin = new JTextFieldOperator((ContainerOperator)serverInstance, 0);
        tfLogin.setText(properties.get("deployment.target.login." + serverType).toString());
        TestUtils.wait(500);
        JTextFieldOperator tfPassword = new JTextFieldOperator((ContainerOperator)serverInstance, 1);
        tfPassword.setText(properties.get("deployment.target.password." + serverType).toString());
        TestUtils.wait(500);
    }

    private static void addTomcat(String serverType, Hashtable properties, WizardOperator serverInstance) {
        JTextFieldOperator tfLogin = new JTextFieldOperator((ContainerOperator)serverInstance, 3);
        tfLogin.setText(properties.get("deployment.target.login." + serverType).toString());
        TestUtils.wait(500);
        JTextFieldOperator tfPassword = new JTextFieldOperator((ContainerOperator)serverInstance, 2);
        tfPassword.setText(properties.get("deployment.target.password." + serverType).toString());
        TestUtils.wait(500);
    }

    public String addWebServiceUrl(String url) {
        new WebServicesNode(this.getTree(), "Web Services").addWebService();
        AddWebServiceOperator addWs = new AddWebServiceOperator();
        String wsName = addWs.addWebService(url);
        addWs.btAdd().pushNoBlock();
        TestUtils.wait(1000);
        return wsName;
    }

    public String addWebServiceUrl(String url, String proxyHost, String proxyPort) {
        new WebServicesNode(this.getTree(), "Web Services").addWebService();
        AddWebServiceOperator addWs = new AddWebServiceOperator();
        addWs.setProxy(proxyHost, proxyPort);
        String wsName = addWs.addWebService(url);
        addWs.btAdd().pushNoBlock();
        TestUtils.wait(1000);
        return wsName;
    }

    public String addWebServiceLocal(String wsName) {
        new WebServicesNode(this.getTree(), "Web Services").addWebService();
        AddWebServiceOperator addWs = new AddWebServiceOperator();
        String wsDisplayName = addWs.addLocalWebService(wsName);
        addWs.btAdd().pushNoBlock();
        TestUtils.wait(1000);
        return wsDisplayName;
    }
}

