/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.runtime;

import com.sun.encoder.runtime.CoderException;
import com.sun.encoder.runtime.StringCoder;
import com.sun.encoder.runtime.TransCoder;
import com.sun.encoder.runtime.provider.BuiltInStringCoder;
import com.sun.encoder.runtime.provider.MultiByteCoder;
import com.sun.encoder.runtime.provider.SharedCoder;
import com.sun.encoder.runtime.provider.SingleByteCoder;
import com.sun.encoder.runtime.provider.Utf16Coder;
import com.sun.encoder.runtime.provider.Utf8Coder;
import com.sun.encoder.util.UnicodeFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CoderFactory {
    private static final List mNames = new ArrayList();
    private static final Map mAlias = new HashMap();
    private static StringCoder mLatin1Coder = null;
    private static boolean mLatin1Share = false;
    private static StringCoder mAsciiCoder = null;
    private static final String CODE_DIR = "com/sun/encoder/runtime/provider/code/";
    private static final String CODE_MAP = "com/sun/encoder/runtime/provider/code/code.map";
    private static final String CODE_SUFFIX = ".code";
    private static final Map mSingleCoders = new HashMap();
    private static final Map mMultiCoders = new HashMap();
    public static final String SBC_FILE = "[sb]";
    public static final String MBC_FILE = "[mb]";
    public static final String BUILT_IN = "[jc]";
    public static final String FQ_CLASS = "[cc]";
    private static final TransCoder mSame;

    private static void sbc(String name) {
        mSingleCoders.put(name, null);
        mNames.add(name);
    }

    private static void mbc(String name) {
        mMultiCoders.put(name, null);
        mNames.add(name);
    }

    private static void alias(String also, String name) {
        if (!mNames.contains(name)) {
            throw new RuntimeException("alias '" + also + "' refers to unknown '" + name + "'");
        }
        if (mAlias.containsKey(also)) {
            throw new RuntimeException("alias '" + also + "' already refers to '" + (String)mAlias.get(also) + "'");
        }
        mAlias.put(also, name);
        mNames.add(also);
    }

    public static boolean hasCoder(String name) {
        if (name == null) {
            throw new NullPointerException("no name");
        }
        if (name.startsWith(SBC_FILE) || name.startsWith(MBC_FILE) || name.startsWith(BUILT_IN) || name.startsWith(FQ_CLASS)) {
            return true;
        }
        return mNames.contains(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringCoder getCoder(String name) {
        if (name == null) {
            throw new NullPointerException("no name");
        }
        String ref = (String)mAlias.get(name);
        if (ref == null) {
            ref = name;
        }
        if (ref.equals("iso-8859-1")) {
            if (mLatin1Coder == null) {
                mLatin1Coder = new Latin1Coder();
                mLatin1Share = CoderFactory.share(mLatin1Coder);
            }
            return mLatin1Share ? mLatin1Coder : new Latin1Coder();
        }
        if (ref.equals("ascii")) {
            if (mAsciiCoder == null) {
                int[] ascii = new int[256];
                for (int i = 0; i < ascii.length; ++i) {
                    ascii[i] = i < 128 ? i : -1;
                }
                mAsciiCoder = new SingleByteCoder(ascii, -1, -1);
            }
            return mAsciiCoder;
        }
        if (ref.equals("utf-8")) {
            return new Utf8Coder(false, false);
        }
        if (ref.equals("utf-8-strict")) {
            return new Utf8Coder(true, false);
        }
        if (ref.equals("utf-8-valid")) {
            return new Utf8Coder(false, true);
        }
        if (ref.equals("utf-8-strict-valid")) {
            return new Utf8Coder(true, true);
        }
        if (ref.equals("utf-16")) {
            return new Utf16Coder(false, false);
        }
        if (ref.equals("utf-16-little")) {
            return new Utf16Coder(true, false);
        }
        if (ref.equals("utf-16-valid")) {
            return new Utf16Coder(false, true);
        }
        if (ref.equals("utf-16-little-valid")) {
            return new Utf16Coder(true, true);
        }
        if (mSingleCoders.containsKey(ref)) {
            StringCoder coder = (StringCoder)mSingleCoders.get(ref);
            if (coder == null) {
                Map i = mSingleCoders;
                synchronized (i) {
                    String res = CODE_DIR + ref + CODE_SUFFIX;
                    try {
                        coder = new SingleByteCoder(res);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("can't get encoding '" + ref + "' using resource '" + res + "': " + e.getMessage());
                    }
                    mSingleCoders.put(ref, coder);
                }
            }
            return coder;
        }
        if (mMultiCoders.containsKey(ref)) {
            StringCoder coder = (StringCoder)mMultiCoders.get(ref);
            if (coder == null) {
                Map i = mMultiCoders;
                synchronized (i) {
                    String res = CODE_DIR + ref + CODE_SUFFIX;
                    try {
                        coder = new MultiByteCoder(res);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("can't get encoding '" + ref + "' using resource '" + res + "': " + e.getMessage());
                    }
                    mMultiCoders.put(ref, coder);
                }
            }
            return coder;
        }
        if (ref.startsWith(SBC_FILE)) {
            StringCoder coder = (StringCoder)mSingleCoders.get(ref);
            if (coder == null) {
                Map i = mSingleCoders;
                synchronized (i) {
                    String file = ref.substring(SBC_FILE.length());
                    try {
                        coder = new SingleByteCoder(new File(file));
                    }
                    catch (IOException e) {
                        throw new RuntimeException("can't get SBC encoding '" + ref + "' using file '" + file + "': " + e.getMessage());
                    }
                    mSingleCoders.put(ref, coder);
                }
            }
            return coder;
        }
        if (ref.startsWith(MBC_FILE)) {
            StringCoder coder = (StringCoder)mMultiCoders.get(ref);
            if (coder == null) {
                Map i = mMultiCoders;
                synchronized (i) {
                    String file = ref.substring(MBC_FILE.length());
                    try {
                        coder = new MultiByteCoder(new File(file));
                    }
                    catch (IOException e) {
                        throw new RuntimeException("can't get MBC encoding '" + ref + "' using file '" + file + "': " + e.getMessage());
                    }
                    mMultiCoders.put(ref, coder);
                }
            }
            return coder;
        }
        if (ref.startsWith(BUILT_IN)) {
            String jtag = ref.substring(BUILT_IN.length());
            try {
                return new BuiltInStringCoder(jtag);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("can't get built-in encoding '" + ref + "' using name '" + jtag + "': " + e.getMessage());
            }
        }
        if (ref.startsWith(FQ_CLASS)) {
            String fqName = ref.substring(FQ_CLASS.length());
            try {
                Object obj = CoderFactory.class.getClassLoader().loadClass(fqName).newInstance();
                if (obj instanceof StringCoder) {
                    return (StringCoder)obj;
                }
                throw new RuntimeException("non-coder class for encoding '" + ref + "' using name '" + fqName + "'");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("can't load class for encoding '" + ref + "' using name '" + fqName + "': " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("can't access class for encoding '" + ref + "' using name '" + fqName + "': " + e.getMessage());
            }
            catch (InstantiationException e) {
                throw new RuntimeException("can't instantiate for encoding '" + ref + "' using name '" + fqName + "': " + e.getMessage());
            }
            catch (ExceptionInInitializerError e) {
                throw new RuntimeException("can't initialize for encoding '" + ref + "' using name '" + fqName + "': " + e.getMessage());
            }
            catch (SecurityException e) {
                throw new RuntimeException("can't secure class for encoding '" + ref + "' using name '" + fqName + "': " + e.getMessage());
            }
        }
        throw new IllegalArgumentException("unknown encoding name '" + name + "'");
    }

    public static TransCoder getTrans(String from, String to) {
        String oref;
        if (from == null) {
            throw new NullPointerException("no input name");
        }
        if (to == null) {
            throw new NullPointerException("no output name");
        }
        String iref = (String)mAlias.get(from);
        if (iref == null) {
            iref = from;
        }
        if ((oref = (String)mAlias.get(to)) == null) {
            oref = to;
        }
        if (iref.equals(oref)) {
            return mSame;
        }
        return new SimpleTransCoder(CoderFactory.getCoder(from), CoderFactory.getCoder(to));
    }

    public static TransCoder getEcho() {
        return mSame;
    }

    public static boolean share(StringCoder coder) {
        if (coder == null) {
            throw new NullPointerException("no coder");
        }
        try {
            Object share = coder.getProperty("share");
            return (Boolean)share;
        }
        catch (IllegalArgumentException ia) {
            return false;
        }
        catch (ClassCastException cc) {
            return false;
        }
    }

    public static String[] getCoderNameList() {
        return mNames.toArray(new String[mNames.size()]);
    }

    private static void init(String path, InputStream in) throws IOException {
        String line;
        LineNumberReader r = new LineNumberReader(UnicodeFile.makeInputReader(in));
        block6: while ((line = r.readLine()) != null) {
            if ((line = line.trim()).equals("") || line.startsWith("#")) continue;
            String s1 = line.substring(1).trim();
            switch (line.charAt(0)) {
                case 'a': {
                    int pos = s1.indexOf(32);
                    if (pos < 0) {
                        throw new RuntimeException(path + " line " + r.getLineNumber() + ": no aliased name: " + line);
                    }
                    String s2 = s1.substring(pos + 1).trim();
                    s1 = s1.substring(0, pos).trim();
                    CoderFactory.alias(s1, s2);
                    continue block6;
                }
                case 'k': {
                    mNames.add(s1);
                    continue block6;
                }
                case 's': {
                    CoderFactory.sbc(s1);
                    continue block6;
                }
                case 'm': {
                    CoderFactory.mbc(s1);
                    continue block6;
                }
            }
            throw new RuntimeException(path + " line " + r.getLineNumber() + ": weird line: " + line);
        }
        in.close();
    }

    private static void initFromResource(String path) {
        ClassLoader loader = CoderFactory.class.getClassLoader();
        InputStream is = loader.getResourceAsStream(path);
        if (is == null) {
            throw new RuntimeException("can't find code map resource '" + path + "'");
        }
        try {
            CoderFactory.init(path, is);
        }
        catch (IOException ie) {
            throw new RuntimeException("can't read code map '" + path + "': " + ie.getMessage());
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                String[] codes = CoderFactory.getCoderNameList();
                for (int i = 0; i < codes.length; ++i) {
                    System.out.println(codes[i]);
                }
            } else {
                String name = args[0];
                StringCoder coder = CoderFactory.getCoder(name);
                System.out.println("coder class " + coder.getClass().getName());
                System.out.println("coder " + (CoderFactory.share(coder) ? "is" : "not") + " shared");
                if (args.length > 1) {
                    File input = new File(args[1]);
                    byte[] data = new byte[(int)input.length()];
                    FileInputStream fis = new FileInputStream(input);
                    fis.read(data);
                    fis.close();
                    String s = coder.decode(data);
                    System.out.println("decoded " + data.length + " bytes to " + s.length() + " chars");
                    byte[] made = coder.encode(s);
                    System.out.println("encoded " + s.length() + " chars to " + made.length + " bytes");
                    if (args.length > 2) {
                        File output = new File(args[2]);
                        FileOutputStream fos = new FileOutputStream(output);
                        fos.write(made);
                        fos.close();
                    }
                    if (data.length != made.length) {
                        throw new RuntimeException("length differs: " + data.length + " bytes in, out " + made.length);
                    }
                    for (int i = 0; i < data.length; ++i) {
                        if (data[i] == made[i]) continue;
                        throw new RuntimeException("data differs, byte #" + i + ": " + data[i] + " versus " + made[i]);
                    }
                }
            }
        }
        catch (Exception all) {
            all.printStackTrace(System.err);
            System.exit(1);
        }
    }

    static {
        CoderFactory.initFromResource(CODE_MAP);
        mSame = new SameTransCoder();
    }

    public static class Latin1Coder
    extends SharedCoder {
        public static final String CALLS = "calls";
        private int mCalls = 0;

        public byte[] encode(String s, int min, int max) throws CoderException {
            ++this.mCalls;
            if (s == null) {
                return null;
            }
            if (0 <= min && 0 <= max && max < min) {
                throw new IllegalArgumentException("max (" + max + ") < min (" + min + ")");
            }
            int len = s.length();
            int size = len;
            if (size < min) {
                size = min;
            }
            if (0 <= max && max < size) {
                throw new CoderException("too big: " + size + ", max=" + max);
            }
            byte[] b = new byte[size];
            for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                if ('\u00ff' < c) {
                    throw new CoderException("char #" + i + " = " + Latin1Coder.uname(c) + ", not encodable");
                }
                b[i] = (byte)c;
            }
            while (len < size) {
                b[len++] = 32;
            }
            return b;
        }

        public String decode(byte[] b, int from, int length) {
            ++this.mCalls;
            if (b == null) {
                return null;
            }
            if (from < 0 || b.length < from || length < 0 || b.length < from + length) {
                throw new CoderException("invalid size/from/length: " + b.length + "/" + from + "/" + length);
            }
            char[] c = new char[length];
            for (int i = 0; i < length; ++i) {
                c[i] = (char)(b[from + i] & 0xFF);
            }
            return new String(c);
        }

        public void setProperty(String name, Object value) {
            if (CALLS.equals(name)) {
                if (!(value instanceof Integer)) {
                    throw new IllegalArgumentException("'calls' requires Integer, not " + (value == null ? "null" : value.getClass().getName()));
                }
                this.mCalls = (Integer)value;
            }
            super.setProperty(name, value);
        }

        public Object getProperty(String name) {
            if (CALLS.equals(name)) {
                return new Integer(this.mCalls);
            }
            return super.getProperty(name);
        }
    }

    private static class SimpleTransCoder
    implements TransCoder {
        private final StringCoder mInCoder;
        private final StringCoder mOutCoder;

        public SimpleTransCoder(StringCoder in, StringCoder out) {
            this.mInCoder = in;
            this.mOutCoder = out;
        }

        public byte[] recode(byte[] data, boolean readOnly) throws CoderException {
            return this.mOutCoder.encode(this.mInCoder.decode(data));
        }
    }

    private static class SameTransCoder
    implements TransCoder {
        private SameTransCoder() {
        }

        public byte[] recode(byte[] data, boolean readOnly) throws CoderException {
            byte[] copy = data;
            if (readOnly && data != null) {
                copy = new byte[data.length];
                System.arraycopy(data, 0, copy, 0, data.length);
            }
            return copy;
        }
    }
}

