/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.layout;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.css.style.EmptyStyle;
import org.xhtmlrenderer.layout.BlockFormattingContext;
import org.xhtmlrenderer.layout.BoxCollector;
import org.xhtmlrenderer.layout.CollapsedBorderSide;
import org.xhtmlrenderer.layout.InlinePaintable;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.layout.LayoutState;
import org.xhtmlrenderer.layout.PaintingInfo;
import org.xhtmlrenderer.newtable.TableBox;
import org.xhtmlrenderer.newtable.TableCellBox;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.BoxDimensions;
import org.xhtmlrenderer.render.MarginBox;
import org.xhtmlrenderer.render.PageBox;
import org.xhtmlrenderer.render.RenderingContext;
import org.xhtmlrenderer.render.ViewportBox;

public class Layer {
    public static final short PAGED_MODE_SCREEN = 1;
    public static final short PAGED_MODE_PRINT = 2;
    private Layer _parent;
    private boolean _stackingContext;
    private List _children;
    private Box _master;
    private Box _end;
    private List _floats;
    private boolean _fixedBackground;
    private boolean _inline;
    private boolean _requiresLayout;
    private List _pages;
    private static final int POSITIVE = 1;
    private static final int ZERO = 2;
    private static final int NEGATIVE = 3;
    private static final int AUTO = 4;

    public Layer(Box master) {
        this(null, master);
        this.setStackingContext(true);
    }

    public Layer(Layer parent, Box master) {
        this._parent = parent;
        this._master = master;
        this.setStackingContext(master.getStyle().isPositioned() && !master.getStyle().isAutoZIndex());
        master.setLayer(this);
        master.setContainingLayer(this);
    }

    public Layer getParent() {
        return this._parent;
    }

    public boolean isStackingContext() {
        return this._stackingContext;
    }

    public void setStackingContext(boolean stackingContext) {
        this._stackingContext = stackingContext;
    }

    public int getZIndex() {
        return (int)this._master.getStyle().asFloat(CSSName.Z_INDEX);
    }

    public boolean isAlternateFlow() {
        return this._master.getStyle().isAlternateFlow();
    }

    public Box getMaster() {
        return this._master;
    }

    public synchronized void addChild(Layer layer) {
        if (this._children == null) {
            this._children = new ArrayList();
        }
        this._children.add(layer);
    }

    public void addFloat(BlockBox floater, BlockFormattingContext bfc) {
        if (this._floats == null) {
            this._floats = new ArrayList();
        }
        this._floats.add(floater);
        floater.getFloatedBoxData().setDrawingLayer(this);
    }

    public void removeFloat(BlockBox floater) {
        if (this._floats != null) {
            this._floats.remove(floater);
        }
    }

    private void paintFloats(RenderingContext c) {
        if (this._floats != null) {
            for (int i = this._floats.size() - 1; i >= 0; --i) {
                BlockBox floater = (BlockBox)this._floats.get(i);
                this.paintAsLayer(c, floater);
            }
        }
    }

    private void paintLayers(RenderingContext c, List layers) {
        for (int i = 0; i < layers.size(); ++i) {
            Layer layer = (Layer)layers.get(i);
            layer.paint(c, this.getMaster().getAbsX(), this.getMaster().getAbsY());
        }
    }

    private List collectLayers(int which) {
        ArrayList<Layer> result = new ArrayList<Layer>();
        if (which != 4) {
            result.addAll(this.getStackingContextLayers(which));
        }
        List children = this.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            Layer child = (Layer)children.get(i);
            if (this.isRootLayer() && child.isAlternateFlow() || child.isStackingContext()) continue;
            if (which == 4) {
                result.add(child);
            }
            result.addAll(child.collectLayers(which));
        }
        return result;
    }

    private List getStackingContextLayers(int which) {
        ArrayList<Layer> result = new ArrayList<Layer>();
        List children = this.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            Layer target = (Layer)children.get(i);
            if (this.isRootLayer() && target.isAlternateFlow() || !target.isStackingContext()) continue;
            int zIndex = target.getZIndex();
            if (which == 3 && zIndex < 0) {
                result.add(target);
                continue;
            }
            if (which == 1 && zIndex > 0) {
                result.add(target);
                continue;
            }
            if (which != 2 || zIndex != 0) continue;
            result.add(target);
        }
        return result;
    }

    private List getSortedLayers(int which) {
        List result = this.collectLayers(which);
        Collections.sort(result, new ZIndexComparator());
        return result;
    }

    private void paintBackgroundsAndBorders(RenderingContext c, List blocks, Map collapsedTableBorders) {
        Iterator i = blocks.iterator();
        while (i.hasNext()) {
            List borders;
            TableCellBox cell;
            BlockBox box = (BlockBox)i.next();
            box.paintBackground(c);
            box.paintBorder(c);
            if (c.debugDrawBoxes()) {
                box.paintDebugOutline(c);
            }
            if (collapsedTableBorders == null || !(box instanceof TableCellBox) || !(cell = (TableCellBox)box).hasCollapsedPaintingBorder() || (borders = (List)collapsedTableBorders.get(cell)) == null) continue;
            this.paintCollapsedTableBorders(c, borders);
        }
    }

    private void paintInlineContent(RenderingContext c, List lines) {
        Iterator i = lines.iterator();
        while (i.hasNext()) {
            InlinePaintable paintable = (InlinePaintable)i.next();
            paintable.paintInline(c);
        }
    }

    public Dimension getPaintingDimension(LayoutContext c) {
        return this.calcPaintingDimension(c).getOuterMarginCorner();
    }

    public void paint(RenderingContext c, int originX, int originY) {
        this.paint(c, originX, originY, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(RenderingContext c, int originX, int originY, boolean paintAlternateFlows) {
        if (!paintAlternateFlows && this.isAlternateFlow()) {
            return;
        }
        if (this.getMaster().getStyle().isFixed()) {
            this.positionFixedLayer(c);
        }
        if (this.isRootLayer()) {
            this.getMaster().paintRootElementBackground(c);
        }
        if (!this.isInline() && ((BlockBox)this.getMaster()).isReplaced()) {
            this.paintLayerBackgroundAndBorder(c);
            this.paintReplacedElement(c, (BlockBox)this.getMaster());
        } else {
            ArrayList blocks = new ArrayList();
            ArrayList lines = new ArrayList();
            BoxCollector collector = new BoxCollector();
            collector.collect(c, c.getOutputDevice().getClip(), this, blocks, lines);
            if (!this.isInline()) {
                this.paintLayerBackgroundAndBorder(c);
                if (c.debugDrawBoxes()) {
                    ((BlockBox)this.getMaster()).paintDebugOutline(c);
                }
            }
            boolean needClip = this.getMaster().getStyle().isOverflowApplies() && this.getMaster().getStyle().isIdent(CSSName.OVERFLOW, IdentValue.HIDDEN);
            Shape oldClip = null;
            if (needClip) {
                oldClip = c.getOutputDevice().getClip();
                c.getOutputDevice().clip(this.getMaster().getPaintingPaddingEdge(c));
            }
            try {
                if (this.isRootLayer() || this.isStackingContext() || this.isAlternateFlow()) {
                    this.paintLayers(c, this.getSortedLayers(3));
                }
                Map collapsedTableBorders = this.collectCollapsedTableBorders(c, blocks);
                this.paintBackgroundsAndBorders(c, blocks, collapsedTableBorders);
                this.paintFloats(c);
                this.paintListMarkers(c, blocks);
                this.paintInlineContent(c, lines);
                this.paintReplacedElements(c, blocks);
                if (this.isRootLayer() || this.isStackingContext() || this.isAlternateFlow()) {
                    this.paintLayers(c, this.collectLayers(4));
                    this.paintLayers(c, this.getSortedLayers(2));
                    this.paintLayers(c, this.getSortedLayers(1));
                }
            }
            finally {
                if (needClip) {
                    c.getOutputDevice().setClip(oldClip);
                }
            }
        }
    }

    private List getFloats() {
        return this._floats == null ? Collections.EMPTY_LIST : this._floats;
    }

    public Box find(CssContext cssCtx, int absX, int absY) {
        Box result = null;
        if (this.isRootLayer() || this.isStackingContext()) {
            result = this.find(cssCtx, absX, absY, this.getSortedLayers(1));
            if (result != null) {
                return result;
            }
            result = this.find(cssCtx, absX, absY, this.getSortedLayers(2));
            if (result != null) {
                return result;
            }
            result = this.find(cssCtx, absX, absY, this.collectLayers(4));
            if (result != null) {
                return result;
            }
        }
        for (int i = 0; i < this.getFloats().size(); ++i) {
            Box floater = (Box)this.getFloats().get(i);
            result = floater.find(cssCtx, absX, absY);
            if (result == null) continue;
            return result;
        }
        result = this.getMaster().find(cssCtx, absX, absY);
        if (result != null) {
            return result;
        }
        if ((this.isRootLayer() || this.isStackingContext()) && (result = this.find(cssCtx, absX, absY, this.getSortedLayers(3))) != null) {
            return result;
        }
        return null;
    }

    private Box find(CssContext cssCtx, int absX, int absY, List layers) {
        Box result = null;
        for (int i = layers.size() - 1; i >= 0; --i) {
            Layer l = (Layer)layers.get(i);
            result = l.find(cssCtx, absX, absY);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    private Map collectCollapsedTableBorders(RenderingContext c, List blocks) {
        ArrayList borders;
        TableCellBox cell;
        HashMap cellBordersByTable = new HashMap();
        HashMap<TableBox, TableCellBox> triggerCellsByTable = new HashMap<TableBox, TableCellBox>();
        HashSet all = new HashSet();
        Iterator i = blocks.iterator();
        while (i.hasNext()) {
            Box b = (Box)i.next();
            if (!(b instanceof TableCellBox) || !(cell = (TableCellBox)b).hasCollapsedPaintingBorder()) continue;
            borders = (ArrayList)cellBordersByTable.get(cell.getTable());
            if (borders == null) {
                borders = new ArrayList();
                cellBordersByTable.put(cell.getTable(), borders);
            }
            triggerCellsByTable.put(cell.getTable(), cell);
            cell.addCollapsedBorders(all, borders);
        }
        if (triggerCellsByTable.size() == 0) {
            return null;
        }
        HashMap result = new HashMap();
        Iterator i2 = triggerCellsByTable.values().iterator();
        while (i2.hasNext()) {
            cell = (TableCellBox)i2.next();
            borders = (List)cellBordersByTable.get(cell.getTable());
            Collections.sort(borders);
            result.put(cell, borders);
        }
        return result;
    }

    private void paintCollapsedTableBorders(RenderingContext c, List borders) {
        Iterator i = borders.iterator();
        while (i.hasNext()) {
            CollapsedBorderSide border = (CollapsedBorderSide)i.next();
            border.getCell().paintCollapsedBorder(c, border.getSide());
        }
    }

    public void paintAsLayer(RenderingContext c, BlockBox startingPoint) {
        ArrayList blocks = new ArrayList();
        ArrayList lines = new ArrayList();
        BoxCollector collector = new BoxCollector();
        collector.collect(c, c.getOutputDevice().getClip(), this, startingPoint, blocks, lines);
        Map collapsedTableBorders = this.collectCollapsedTableBorders(c, blocks);
        this.paintBackgroundsAndBorders(c, blocks, collapsedTableBorders);
        this.paintListMarkers(c, blocks);
        this.paintInlineContent(c, lines);
        this.paintReplacedElements(c, blocks);
    }

    private void paintListMarkers(RenderingContext c, List blocks) {
        Iterator i = blocks.iterator();
        while (i.hasNext()) {
            BlockBox box = (BlockBox)i.next();
            box.paintListMarker(c);
        }
    }

    private void paintReplacedElements(RenderingContext c, List blocks) {
        Iterator i = blocks.iterator();
        while (i.hasNext()) {
            BlockBox box = (BlockBox)i.next();
            if (!box.isReplaced()) continue;
            this.paintReplacedElement(c, box);
        }
    }

    private void positionFixedLayer(RenderingContext c) {
        Rectangle rect = c.getFixedRectangle();
        Box fixed = this.getMaster();
        fixed.setX(0);
        fixed.setY(0);
        fixed.setAbsX(0);
        fixed.setAbsY(0);
        fixed.setContainingBlock(new ViewportBox(rect));
        ((BlockBox)fixed).positionAbsolute(c, 3);
        fixed.calcPaintingInfo(c, false);
    }

    private void paintLayerBackgroundAndBorder(RenderingContext c) {
        if (this.getMaster() instanceof BlockBox) {
            BlockBox box = (BlockBox)this.getMaster();
            box.paintBackground(c);
            box.paintBorder(c);
        }
    }

    private void paintReplacedElement(RenderingContext c, BlockBox replaced) {
        Rectangle contentBounds = replaced.getContentAreaEdge(replaced.getAbsX(), replaced.getAbsY(), c);
        Point loc = replaced.getReplacedElement().getLocation();
        if (contentBounds.x != loc.x || contentBounds.y != loc.y) {
            replaced.getReplacedElement().setLocation(contentBounds.x, contentBounds.y);
        }
        if (!c.isInteractive() || replaced.getReplacedElement().isRequiresInteractivePaint()) {
            c.getOutputDevice().paintReplacedElement(c, replaced);
        }
    }

    public boolean isRootLayer() {
        return this.getParent() == null && this.isStackingContext();
    }

    private void moveIfGreater(Dimension result, Dimension test) {
        if (test.width > result.width) {
            result.width = test.width;
        }
        if (test.height > result.height) {
            result.height = test.height;
        }
    }

    private PaintingInfo calcPaintingDimension(LayoutContext c) {
        this.getMaster().calcPaintingInfo(c, true);
        PaintingInfo result = this.getMaster().getPaintingInfo().copyOf();
        List children = this.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            Layer child = (Layer)children.get(i);
            if (child.getMaster().getStyle().isFixed() || !child.getMaster().getStyle().isAbsolute()) continue;
            PaintingInfo info = child.calcPaintingDimension(c);
            this.moveIfGreater(result.getOuterMarginCorner(), info.getOuterMarginCorner());
        }
        return result;
    }

    public void positionChildren(LayoutContext c) {
        Iterator i = this.getChildren().iterator();
        while (i.hasNext()) {
            Layer child = (Layer)i.next();
            child.position(c);
        }
    }

    private void position(LayoutContext c) {
        if (this.getMaster().getStyle().isAbsolute() && !c.isPrint()) {
            ((BlockBox)this.getMaster()).positionAbsolute(c, 3);
        } else if (this.getMaster().getStyle().isRelative() && (this.isInline() || ((BlockBox)this.getMaster()).isInline())) {
            this.getMaster().positionRelative(c);
            if (!this.isInline()) {
                this.getMaster().calcCanvasLocation();
                this.getMaster().calcChildLocations();
            }
        }
    }

    private boolean containsFixedLayer() {
        Iterator i = this.getChildren().iterator();
        while (i.hasNext()) {
            Layer child = (Layer)i.next();
            if (!child.getMaster().getStyle().isFixed() && !child.containsFixedLayer()) continue;
            return true;
        }
        return false;
    }

    public boolean containsFixedContent() {
        return this._fixedBackground || this.containsFixedLayer();
    }

    public void setFixedBackground(boolean b) {
        this._fixedBackground = b;
    }

    public synchronized List getChildren() {
        return this._children == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this._children);
    }

    public Layer getAlternateFlow(String name) {
        List children = this.getChildren();
        Iterator i = children.iterator();
        while (i.hasNext()) {
            CalculatedStyle cs;
            Layer child = (Layer)i.next();
            if (!child.getMaster().getStyle().isAlternateFlow() || !(cs = child.getMaster().getStyle()).getStringProperty(CSSName.FS_MOVE_TO_FLOW).equals(name)) continue;
            return child;
        }
        return null;
    }

    private void remove(Layer layer) {
        boolean removed = false;
        if (this._children != null) {
            Iterator i = this._children.iterator();
            while (i.hasNext()) {
                Layer child = (Layer)i.next();
                if (child != layer) continue;
                removed = true;
                i.remove();
                break;
            }
        }
        if (!removed) {
            throw new RuntimeException("Could not find layer to remove");
        }
    }

    public void detach() {
        if (this.getParent() != null) {
            this.getParent().remove(this);
        }
    }

    public boolean isInline() {
        return this._inline;
    }

    public void setInline(boolean inline) {
        this._inline = inline;
    }

    public Box getEnd() {
        return this._end;
    }

    public void setEnd(Box end) {
        this._end = end;
    }

    public boolean isRequiresLayout() {
        return this._requiresLayout;
    }

    public void setRequiresLayout(boolean requiresLayout) {
        this._requiresLayout = requiresLayout;
    }

    public void finish(LayoutContext c) {
        if (c.isPrint()) {
            this.layoutAbsoluteChildren(c);
            if (this.isRootLayer()) {
                this.layoutAlternateFlows(c);
            }
        }
        if (!this.isInline()) {
            this.positionChildren(c);
        }
    }

    private void layoutAlternateFlows(LayoutContext c) {
        List children = this.getChildren();
        if (children.size() > 0) {
            LayoutState state = c.captureLayoutState();
            for (int i = 0; i < children.size(); ++i) {
                Layer child = (Layer)children.get(i);
                if (!child.isRequiresLayout() || !child.isAlternateFlow()) continue;
                CalculatedStyle cs = child.getMaster().getStyle();
                MarginBox cb = this.createMarginBox(c, cs.getStringProperty(CSSName.FS_MOVE_TO_FLOW));
                if (cb != null) {
                    child.getMaster().setContainingBlock(cb);
                    this.layoutAlternateFlowChild(c, child);
                    child.setRequiresLayout(false);
                    child.finish(c);
                    continue;
                }
                child.setRequiresLayout(false);
            }
            c.restoreLayoutState(state);
        }
    }

    private MarginBox createMarginBox(CssContext cssCtx, String flowName) {
        PageBox pageBox;
        List pages = this.getPages();
        Rectangle bounds = null;
        Iterator i = pages.iterator();
        while (i.hasNext() && (bounds = (pageBox = (PageBox)i.next()).getFlowBounds(cssCtx, flowName)) == null) {
        }
        return bounds == null ? null : new MarginBox(bounds);
    }

    private void layoutAbsoluteChildren(LayoutContext c) {
        List children = this.getChildren();
        if (children.size() > 0) {
            LayoutState state = c.captureLayoutState();
            for (int i = 0; i < children.size(); ++i) {
                Layer child = (Layer)children.get(i);
                if (!child.isRequiresLayout() || child.isAlternateFlow()) continue;
                this.layoutAbsoluteChild(c, child);
                if (child.getMaster().getStyle().isAvoidPageBreakInside() && child.getMaster().crossesPageBreak(c)) {
                    child.getMaster().reset(c);
                    ((BlockBox)child.getMaster()).setNeedPageClear(true);
                    this.layoutAbsoluteChild(c, child);
                    ((BlockBox)child.getMaster()).setNeedPageClear(false);
                    if (child.getMaster().crossesPageBreak(c)) {
                        child.getMaster().reset(c);
                        this.layoutAbsoluteChild(c, child);
                    }
                }
                child.setRequiresLayout(false);
                child.finish(c);
                c.getRootLayer().ensureHasPage(c, child.getMaster());
            }
            c.restoreLayoutState(state);
        }
    }

    private void layoutAbsoluteChild(LayoutContext c, Layer child) {
        BlockBox master = (BlockBox)child.getMaster();
        if (child.getMaster().getStyle().isBottomAuto()) {
            master.positionAbsolute(c, 3);
            master.positionAbsoluteOnPage(c);
            c.reInit();
            ((BlockBox)child.getMaster()).layout(c);
            master.positionAbsolute(c, 2);
        } else {
            c.reInit();
            master.layout(c);
            BoxDimensions before = master.getBoxDimensions();
            master.reset(c);
            BoxDimensions after = master.getBoxDimensions();
            master.setBoxDimensions(before);
            master.positionAbsolute(c, 3);
            master.positionAbsoluteOnPage(c);
            master.setBoxDimensions(after);
            c.reInit();
            ((BlockBox)child.getMaster()).layout(c);
        }
    }

    private void layoutAlternateFlowChild(LayoutContext c, Layer child) {
        BlockBox master = (BlockBox)child.getMaster();
        master.positionAbsolute(c, 3);
        c.reInit();
        ((BlockBox)child.getMaster()).layout(c);
        master.positionAbsolute(c, 3);
    }

    public List getPages() {
        return this._pages == null ? Collections.EMPTY_LIST : this._pages;
    }

    public void setPages(List pages) {
        this._pages = pages;
    }

    public boolean isLastPage(PageBox pageBox) {
        return this._pages.get(this._pages.size() - 1) == pageBox;
    }

    public void addPage(CssContext c) {
        List pages;
        String pseudoPage = null;
        if (this._pages == null) {
            this._pages = new ArrayList();
        }
        pseudoPage = (pages = this.getPages()).size() == 0 ? "first" : (pages.size() % 2 == 0 ? "left" : "right");
        PageBox pageBox = Layer.createPageBox(c, pseudoPage);
        if (pages.size() == 0) {
            pageBox.setTopAndBottom(c, 0);
        } else {
            PageBox previous = (PageBox)pages.get(pages.size() - 1);
            pageBox.setTopAndBottom(c, previous.getBottom());
        }
        pageBox.setPageNo(pages.size());
        pages.add(pageBox);
    }

    public static PageBox createPageBox(CssContext c, String pseudoPage) {
        PageBox result = new PageBox();
        CalculatedStyle cs = new EmptyStyle().deriveStyle(c.getCss().getPageStyle(pseudoPage));
        result.setStyle(cs);
        result.setOuterPageWidth(result.getWidth(c));
        return result;
    }

    public PageBox getFirstPage(CssContext c, Box box) {
        return this.getPage(c, box.getAbsY());
    }

    public PageBox getLastPage(CssContext c, Box box) {
        return this.getPage(c, box.getAbsY() + box.getHeight() - 1);
    }

    public void ensureHasPage(CssContext c, Box box) {
        this.getLastPage(c, box);
    }

    public PageBox getPage(CssContext c, int yOffset) {
        List pages = this.getPages();
        if (yOffset < 0) {
            return null;
        }
        PageBox last = (PageBox)pages.get(pages.size() - 1);
        if (yOffset < last.getBottom()) {
            int count = pages.size();
            for (int i = count - 1; i >= 0 && i >= count - 5; --i) {
                PageBox pageBox = (PageBox)pages.get(i);
                if (yOffset < pageBox.getTop() || yOffset >= pageBox.getBottom()) continue;
                return pageBox;
            }
            int low = 0;
            int high = count - 6;
            while (low <= high) {
                int mid = low + high >> 1;
                PageBox pageBox = (PageBox)pages.get(mid);
                if (yOffset >= pageBox.getTop() && yOffset < pageBox.getBottom()) {
                    return pageBox;
                }
                if (pageBox.getTop() < yOffset) {
                    low = mid + 1;
                    continue;
                }
                high = mid - 1;
            }
        } else {
            this.addPagesUntilPosition(c, yOffset);
            return (PageBox)pages.get(pages.size() - 1);
        }
        throw new RuntimeException("internal error");
    }

    private void addPagesUntilPosition(CssContext c, int position) {
        List pages = this.getPages();
        PageBox last = (PageBox)pages.get(pages.size() - 1);
        while (position >= last.getBottom()) {
            this.addPage(c);
            last = (PageBox)pages.get(pages.size() - 1);
        }
    }

    public void trimEmptyPages(CssContext c, int maxYHeight) {
        PageBox page;
        List pages = this.getPages();
        for (int i = pages.size() - 1; i >= 0 && (page = (PageBox)pages.get(i)).getTop() > maxYHeight; --i) {
            pages.remove(i);
        }
    }

    public void assignPagePaintingPositions(CssContext cssCtx, short mode) {
        this.assignPagePaintingPositions(cssCtx, mode, 0);
    }

    public void assignPagePaintingPositions(CssContext cssCtx, int mode, int additionalClearance) {
        List pages = this.getPages();
        int paintingTop = additionalClearance;
        Iterator i = pages.iterator();
        while (i.hasNext()) {
            PageBox page = (PageBox)i.next();
            page.setPaintingTop(paintingTop);
            if (mode == 1) {
                page.setPaintingBottom(paintingTop + page.getHeight(cssCtx));
            } else if (mode == 2) {
                page.setPaintingBottom(paintingTop + page.getContentHeight(cssCtx));
            } else {
                throw new IllegalArgumentException("Illegal mode");
            }
            paintingTop = page.getPaintingBottom() + additionalClearance;
        }
    }

    public int getMaxPageWidth(CssContext cssCtx, int additionalClearance) {
        List pages = this.getPages();
        int maxWidth = 0;
        Iterator i = pages.iterator();
        while (i.hasNext()) {
            PageBox page = (PageBox)i.next();
            int pageWidth = page.getWidth(cssCtx) + additionalClearance * 2;
            if (pageWidth <= maxWidth) continue;
            maxWidth = pageWidth;
        }
        return maxWidth;
    }

    public PageBox getLastPage() {
        List pages = this.getPages();
        return pages.size() == 0 ? null : (PageBox)pages.get(pages.size() - 1);
    }

    public boolean crossesPageBreak(LayoutContext c, int top, int bottom) {
        if (top < 0) {
            return false;
        }
        PageBox page = this.getPage(c, top);
        return bottom >= page.getBottom() - c.getExtraSpaceBottom();
    }

    public Layer findRoot() {
        if (this.isRootLayer()) {
            return this;
        }
        return this.getParent().findRoot();
    }

    private static class ZIndexComparator
    implements Comparator {
        private ZIndexComparator() {
        }

        public int compare(Object o1, Object o2) {
            Layer l1 = (Layer)o1;
            Layer l2 = (Layer)o2;
            return l1.getZIndex() - l2.getZIndex();
        }
    }
}

