/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4ejb.webservice.generator;

import it.imolinfo.jbi4ejb.Logger;
import it.imolinfo.jbi4ejb.LoggerFactory;
import it.imolinfo.jbi4ejb.exception.ClassGenerationException;
import it.imolinfo.jbi4ejb.exception.EJBDeployException;
import it.imolinfo.jbi4ejb.webservice.generator.Util;
import it.imolinfo.jbi4ejb.webservice.generator.bcm.AddExceptionSuperclass;
import it.imolinfo.jbi4ejb.webservice.generator.bcm.RemoteInterfaceExceptionAdapter;
import it.imolinfo.jbi4ejb.webservice.generator.bcm.RemoveEJBInterfaceAdapter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.util.CheckClassAdapter;
import org.objectweb.asm.util.TraceClassVisitor;
import sun.rmi.rmic.Main;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EJBUtils {
    static final Logger LOG = LoggerFactory.getLogger(EJBUtils.class);
    private static final int BUFFER_LENGTH = 1024;

    private EJBUtils() {
    }

    public static File createTempDir() throws IOException {
        File f = File.createTempFile("EJBGENERATION_", null);
        if (!f.delete()) {
            return null;
        }
        if (!f.mkdir()) {
            return null;
        }
        return f;
    }

    public static void createStub(String classesDir, String className, List<String> jarFilesName) throws EJBDeployException {
        StringBuffer classpathStr = new StringBuffer();
        for (int i = 0; i < jarFilesName.size(); ++i) {
            classpathStr.append(jarFilesName.get(i)).append(File.pathSeparator);
        }
        classpathStr.append(classesDir);
        String classpath = classpathStr.toString();
        LOG.debug("Create stub classpath: " + classpath);
        ArrayList<String> params = new ArrayList<String>(Arrays.asList("-classpath", classpath, "-d", classesDir, "-iiop", "-poa", "-verbose", className));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream printstream = new PrintStream(baos);
        Main main = new Main((OutputStream)printstream, "rmic");
        boolean result = main.compile(params.toArray(new String[0]));
        if (!result) {
            LOG.debug(baos.toString());
            throw new EJBDeployException("Errore nell'esecuzione di RMIC");
        }
        LOG.debug("<<<<< compileRemoteClasses - end");
    }

    public static void tweakRemoteInterfaceGeneratedFromWSDL(String portTypeClassName, String classesDirName) throws ClassGenerationException {
        ClassReader cr;
        LOG.debug("Adding the application exceptions to interface: " + portTypeClassName);
        ClassWriter cw = new ClassWriter(true);
        CheckClassAdapter cc = new CheckClassAdapter((ClassVisitor)cw);
        StringWriter sw = new StringWriter();
        TraceClassVisitor tv = new TraceClassVisitor((ClassVisitor)cc, new PrintWriter(sw));
        URLClassLoader classLoader = null;
        try {
            classLoader = Util.getURLClassLoader(classesDirName);
        }
        catch (MalformedURLException ex) {
            String msg = ex.getMessage();
            LOG.error(msg);
            throw new ClassGenerationException(msg);
        }
        RemoteInterfaceExceptionAdapter cv = new RemoteInterfaceExceptionAdapter((ClassVisitor)tv, classLoader);
        LOG.debug("new ClassReader - Begin");
        try {
            cr = new ClassReader((InputStream)new FileInputStream(EJBUtils.getAsFileName(classesDirName, portTypeClassName, ".class")));
        }
        catch (IOException e) {
            String msg = e.getMessage();
            LOG.error(msg);
            throw new ClassGenerationException(e);
        }
        cr.accept((ClassVisitor)cv, true);
        LOG.debug("output of tracer during creation of class: " + portTypeClassName + "\n" + sw.toString());
        byte[] newBytecode = cw.toByteArray();
        String relativeFileName = portTypeClassName.replace('.', File.separatorChar);
        LOG.debug("FileName=" + relativeFileName);
        Util.saveAsJavaClass(classesDirName + File.separator + relativeFileName + ".class", newBytecode);
        List<String> exceptions = cv.getExceptionsAdded();
        EJBUtils.addExceptionSuperclass(exceptions, classesDirName);
    }

    private static void addExceptionSuperclass(List<String> exceptions, String classesDirName) throws ClassGenerationException {
        for (int i = 0; i < exceptions.size(); ++i) {
            ClassReader cr;
            String exception = exceptions.get(i);
            LOG.debug("Adding Exception superclass to exception: " + exception);
            ClassWriter cw = new ClassWriter(true);
            CheckClassAdapter cc = new CheckClassAdapter((ClassVisitor)cw);
            StringWriter sw = new StringWriter();
            TraceClassVisitor tv = new TraceClassVisitor((ClassVisitor)cc, new PrintWriter(sw));
            AddExceptionSuperclass cv = new AddExceptionSuperclass((ClassVisitor)tv);
            try {
                cr = new ClassReader((InputStream)new FileInputStream(EJBUtils.getAsFileName(classesDirName, exception, ".class")));
            }
            catch (IOException e) {
                String msg = e.getMessage();
                LOG.error(msg);
                throw new ClassGenerationException(e);
            }
            cr.accept((ClassVisitor)cv, true);
            byte[] newBytecode = cw.toByteArray();
            String relativeFileName = exception.replace('.', File.separatorChar);
            Util.saveAsJavaClass(classesDirName + File.separator + relativeFileName + ".class", newBytecode);
        }
    }

    public static void removeEJBRemoteInterface(String interfaceClassName, String classesDirName) throws ClassGenerationException {
        ClassReader cr;
        LOG.debug("Removing the remote interface from: " + interfaceClassName + " in directory: " + classesDirName);
        ClassWriter cw = new ClassWriter(true);
        CheckClassAdapter cc = new CheckClassAdapter((ClassVisitor)cw);
        StringWriter sw = new StringWriter();
        TraceClassVisitor tv = new TraceClassVisitor((ClassVisitor)cc, new PrintWriter(sw));
        RemoveEJBInterfaceAdapter cv = new RemoveEJBInterfaceAdapter((ClassVisitor)tv, classesDirName);
        String classFileName = EJBUtils.getAsFileName(classesDirName, interfaceClassName, ".class");
        File classFile = new File(classFileName);
        if (!classFile.exists()) {
            String msg = "Class " + interfaceClassName + " not found in archive";
            throw new ClassGenerationException(msg);
        }
        try {
            cr = new ClassReader((InputStream)new FileInputStream(classFile));
        }
        catch (IOException e) {
            String msg = e.getMessage();
            LOG.error(msg);
            throw new ClassGenerationException(e);
        }
        cr.accept((ClassVisitor)cv, true);
        byte[] newBytecode = cw.toByteArray();
        String relativeFileName = interfaceClassName.replace('.', File.separatorChar);
        Util.saveAsJavaClass(classesDirName + File.separator + relativeFileName + ".class", newBytecode);
    }

    private static String getAsFileName(String basedir, String javaName, String ext) {
        char sep = File.separator.charAt(0);
        String basedirRep = basedir.replace('\\', sep).replace('/', sep);
        return basedirRep + sep + javaName.replace('.', sep) + ext;
    }

    public static void copyDirectory(File sourceLocation, File targetLocation) throws IOException {
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists()) {
                targetLocation.mkdir();
            }
            String[] children = sourceLocation.list();
            for (int i = 0; i < children.length; ++i) {
                EJBUtils.copyDirectory(new File(sourceLocation, children[i]), new File(targetLocation, children[i]));
            }
        } else {
            int len;
            FileInputStream in = new FileInputStream(sourceLocation);
            FileOutputStream out = new FileOutputStream(targetLocation);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }
}

