/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4ejb.webservice.generator;

import it.imolinfo.jbi4ejb.Logger;
import it.imolinfo.jbi4ejb.LoggerFactory;
import it.imolinfo.jbi4ejb.exception.ClassGenerationException;
import it.imolinfo.jbi4ejb.exception.EJBWSDLGenerationException;
import it.imolinfo.jbi4ejb.webservice.generator.EJBUtils;
import it.imolinfo.jbi4ejb.webservice.generator.JarUtil;
import it.imolinfo.jbi4ejb.webservice.generator.Util;
import it.imolinfo.jbi4ejb.webservice.generator.WSDLDescriptor;
import it.imolinfo.jbi4ejb.webservice.generator.WSDLGenerator;
import java.io.File;
import java.io.IOException;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;

public final class DynamicEJBWSDLGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicEJBWSDLGenerator.class);

    private DynamicEJBWSDLGenerator() {
    }

    public static String generateWSDLFromRemoteInterface(String remoteInterfaceClassName, String ejbJarPath, WSDLDescriptor descriptor) throws EJBWSDLGenerationException {
        File tempDir;
        try {
            tempDir = EJBUtils.createTempDir();
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            throw new EJBWSDLGenerationException(e);
        }
        String wsdlFileName = tempDir.getAbsolutePath() + File.separatorChar + remoteInterfaceClassName + ".wsdl";
        File interfaceWSDL = WSDLGenerator.createWsdlFromJar(remoteInterfaceClassName, ejbJarPath, wsdlFileName, descriptor, tempDir);
        return interfaceWSDL.getAbsolutePath();
    }

    public static Hashtable getClassesID(String remoteInterface, String ejbJarPath) throws EJBWSDLGenerationException {
        Set<Class> classesToSerialize;
        File tempDir;
        Hashtable<String, Long> classesID = new Hashtable<String, Long>();
        try {
            tempDir = File.createTempFile("EJBCLASSES_", null);
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            throw new EJBWSDLGenerationException(e);
        }
        tempDir.delete();
        tempDir.mkdir();
        try {
            JarUtil.unjar(new File(ejbJarPath), tempDir);
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            throw new EJBWSDLGenerationException(e);
        }
        String remoteInterfaceFileName = remoteInterface.replace('.', File.separatorChar);
        LOG.debug("remoteInterfaceFileName: " + remoteInterfaceFileName);
        ArrayList<File> list = new ArrayList<File>();
        list.add(new File(tempDir.getAbsolutePath() + File.separatorChar + remoteInterfaceFileName));
        try {
            classesToSerialize = Util.findClassUsed(tempDir.getAbsolutePath(), list);
        }
        catch (ClassGenerationException e) {
            LOG.error(e.getMessage());
            throw new EJBWSDLGenerationException(e);
        }
        for (Class classToSerialize : classesToSerialize) {
            LOG.debug(classToSerialize.getName());
            ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(classToSerialize);
            long uid = objectStreamClass.getSerialVersionUID();
            LOG.debug(classToSerialize.getName() + " uid: " + uid);
            classesID.put(classToSerialize.getName(), uid);
        }
        return classesID;
    }
}

