/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4ejb.jbi.wsdl;

import com.ibm.wsdl.factory.WSDLFactoryImpl;
import it.imolinfo.jbi4ejb.Logger;
import it.imolinfo.jbi4ejb.LoggerFactory;
import it.imolinfo.jbi4ejb.exception.EJBDeployException;
import it.imolinfo.jbi4ejb.jbi.wsdl.Jbi4EjbExtension;
import it.imolinfo.jbi4ejb.runtime.ejbproxy.EJBProxyUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;

public final class Jbi4EjbSOAPExtensionsUtils {
    private static final Logger LOG = LoggerFactory.getLogger(EJBProxyUtils.class);
    private static final String SOAP_NAMESPACE_URI = "http://schemas.xmlsoap.org/wsdl/soap/";
    private static final QName SOAP_ADDRESS_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "address");
    private static final QName SOAP_BINDING_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "binding");
    private static final QName SOAP_BODY_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "body");
    private static final QName SOAP_OPERATION_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "operation");

    private Jbi4EjbSOAPExtensionsUtils() {
    }

    public static File addSoapElements(File wsdl) throws EJBDeployException {
        File wsdlWithSoap = new File(wsdl.getAbsolutePath() + "_soap_");
        Definition wsdlDef = null;
        try {
            wsdlDef = Jbi4EjbSOAPExtensionsUtils.readWsdl(wsdl);
            Jbi4EjbSOAPExtensionsUtils.addSoapElements(wsdlDef);
            Jbi4EjbSOAPExtensionsUtils.writeWsdl(wsdlDef, wsdlWithSoap);
        }
        catch (WSDLException wex) {
            String msg = wex.getMessage();
            LOG.error(msg);
            throw new EJBDeployException(wex);
        }
        return wsdlWithSoap;
    }

    public static void addSoapElements(Definition def) throws WSDLException {
        boolean soapFound = false;
        Port port = null;
        WSDLFactory factory = WSDLFactory.newInstance();
        for (Object service : def.getServices().values()) {
            block1: for (Object obj : ((Service)service).getPorts().values()) {
                port = (Port)obj;
                for (Object element : port.getExtensibilityElements()) {
                    if (!(element instanceof SOAPAddress)) continue;
                    soapFound = true;
                    continue block1;
                }
            }
        }
        if (!soapFound) {
            ExtensionRegistry registry = factory.newPopulatedExtensionRegistry();
            SOAPAddress soapAddress = (SOAPAddress)registry.createExtension(Port.class, SOAP_ADDRESS_QNAME);
            SOAPBinding soapBinding = (SOAPBinding)registry.createExtension(Binding.class, SOAP_BINDING_QNAME);
            SOAPBody inputBody = (SOAPBody)registry.createExtension(BindingInput.class, SOAP_BODY_QNAME);
            SOAPOperation soapOperation = (SOAPOperation)registry.createExtension(BindingOperation.class, SOAP_OPERATION_QNAME);
            BindingOperation bo = (BindingOperation)port.getBinding().getBindingOperations().get(0);
            soapAddress.setLocationURI("http://localhost/fake_location");
            port.addExtensibilityElement((ExtensibilityElement)soapAddress);
            soapBinding.setTransportURI("http://schemas.xmlsoap.org/soap/http");
            soapBinding.setStyle("document");
            port.getBinding().addExtensibilityElement((ExtensibilityElement)soapBinding);
            soapOperation.setSoapActionURI("");
            bo.addExtensibilityElement((ExtensibilityElement)soapOperation);
            inputBody.setUse("literal");
            Jbi4EjbSOAPExtensionsUtils.addSoapBodyIfNotPresent(bo.getBindingInput(), inputBody);
            Jbi4EjbSOAPExtensionsUtils.addSoapBodyIfNotPresent(bo.getBindingOutput(), inputBody);
        }
    }

    private static void addSoapBodyIfNotPresent(BindingInput bindingInput, SOAPBody soapBody) {
        for (Object obj : bindingInput.getExtensibilityElements()) {
            if (!(obj instanceof SOAPBody)) continue;
            return;
        }
        bindingInput.addExtensibilityElement((ExtensibilityElement)soapBody);
    }

    private static void addSoapBodyIfNotPresent(BindingOutput bindingOutput, SOAPBody soapBody) {
        for (Object obj : bindingOutput.getExtensibilityElements()) {
            if (!(obj instanceof SOAPBody)) continue;
            return;
        }
        bindingOutput.addExtensibilityElement((ExtensibilityElement)soapBody);
    }

    private static Definition readWsdl(File wsdlFile) throws WSDLException {
        WSDLFactory wsdlFactory = WSDLFactory.newInstance();
        ExtensionRegistry registry = wsdlFactory.newPopulatedExtensionRegistry();
        WSDLReader reader = ((WSDLFactoryImpl)wsdlFactory).newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        reader.setFeature("javax.wsdl.importDocuments", true);
        Jbi4EjbExtension.register(registry);
        LOG.debug("Extension QName: uri://schemas.imola.it/jbi/wsdl-extensions/ejb/");
        reader.setExtensionRegistry(registry);
        Definition def = reader.readWSDL(wsdlFile.getAbsolutePath());
        return def;
    }

    private static void writeWsdl(Definition def, File wsdlFile) throws WSDLException, EJBDeployException {
        FileWriter fr = null;
        try {
            fr = new FileWriter(wsdlFile);
        }
        catch (IOException e) {
            String msg = e.getMessage();
            LOG.error(msg);
            throw new EJBDeployException(e);
        }
        WSDLFactory wsdlFactory = WSDLFactory.newInstance();
        ExtensionRegistry registry = wsdlFactory.newPopulatedExtensionRegistry();
        WSDLReader reader = ((WSDLFactoryImpl)wsdlFactory).newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        reader.setFeature("javax.wsdl.importDocuments", true);
        Jbi4EjbExtension.register(registry);
        LOG.debug("Extension QName: uri://schemas.imola.it/jbi/wsdl-extensions/ejb/");
        reader.setExtensionRegistry(registry);
        WSDLWriter writer = wsdlFactory.newWSDLWriter();
        LOG.debug("Writing WSDL: " + wsdlFile.getAbsolutePath());
        writer.writeWSDL(def, (Writer)fr);
        try {
            fr.flush();
        }
        catch (IOException e) {
            String msg = e.getMessage();
            LOG.error(msg);
            throw new EJBDeployException(e);
        }
    }
}

