/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4ejb.jbi.wsdl;

import it.imolinfo.jbi4ejb.Logger;
import it.imolinfo.jbi4ejb.LoggerFactory;
import it.imolinfo.jbi4ejb.jbi.wsdl.Jbi4EjbAddress;
import it.imolinfo.jbi4ejb.jbi.wsdl.Jbi4EjbBinding;
import it.imolinfo.jbi4ejb.jbi.wsdl.Jbi4EjbTypes;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;

public final class Jbi4EjbExtensionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(Jbi4EjbExtensionUtils.class);

    private Jbi4EjbExtensionUtils() {
    }

    public static Binding getBinding(Definition def, String serviceName, String endpointName) {
        Service svc = def.getService(QName.valueOf(serviceName));
        if (svc == null) {
            return null;
        }
        Port port = svc.getPort(endpointName);
        if (port == null) {
            return null;
        }
        return port.getBinding();
    }

    public static PortType getPortType(Definition def, String serviceName, String endpointName) {
        Service svc = def.getService(QName.valueOf(serviceName));
        if (svc == null) {
            return null;
        }
        Port port = svc.getPort(QName.valueOf(endpointName).getLocalPart());
        Binding binding = null;
        if (port == null) {
            return null;
        }
        binding = port.getBinding();
        PortType portType = null;
        if (binding != null) {
            portType = binding.getPortType();
        }
        return portType;
    }

    public static Jbi4EjbTypes getEjbTypes(Definition def) {
        Jbi4EjbTypes ejbTypes = null;
        List extElems = def.getExtensibilityElements();
        Iterator extIter = null;
        if (extElems != null) {
            extIter = extElems.iterator();
        }
        while (extIter != null && extIter.hasNext() && ejbTypes == null) {
            ExtensibilityElement ee = (ExtensibilityElement)extIter.next();
            LOG.debug("Inspecting: " + ee);
            if (!Jbi4EjbTypes.class.isInstance(ee)) continue;
            ejbTypes = (Jbi4EjbTypes)ee;
            LOG.debug("Found a Jbi4EjbTypes instance: " + ejbTypes.getTypesSerialVersionUIDs());
        }
        if (ejbTypes == null) {
            LOG.debug("No jbi4EjbTypes instance found, returning an empty one");
            ejbTypes = new Jbi4EjbTypes();
        }
        return ejbTypes;
    }

    public static Jbi4EjbBinding getEjbBinding(Definition def, String serviceName, String endpointName) {
        Jbi4EjbBinding ejbBinding = null;
        Binding binding = Jbi4EjbExtensionUtils.getBinding(def, serviceName, endpointName);
        if (binding != null) {
            List extElems = binding.getExtensibilityElements();
            Iterator extIter = null;
            if (extElems != null) {
                extIter = extElems.iterator();
            }
            while (extIter != null && extIter.hasNext() && ejbBinding == null) {
                ExtensibilityElement ee = (ExtensibilityElement)extIter.next();
                if (!Jbi4EjbBinding.class.isInstance(ee)) continue;
                ejbBinding = (Jbi4EjbBinding)ee;
            }
        }
        return ejbBinding;
    }

    public static Jbi4EjbAddress getEjbAddress(Definition def, String serviceName, String endpointName) {
        Jbi4EjbAddress address = null;
        Service svc = def.getService(QName.valueOf(serviceName));
        if (svc == null) {
            return null;
        }
        Port port = svc.getPort(QName.valueOf(endpointName).getLocalPart());
        if (port != null) {
            List extElems = port.getExtensibilityElements();
            Iterator extIter = null;
            if (extElems != null) {
                extIter = extElems.iterator();
            }
            while (extIter != null && extIter.hasNext() && address == null) {
                ExtensibilityElement ee = (ExtensibilityElement)extIter.next();
                if (!Jbi4EjbAddress.class.isInstance(ee)) continue;
                address = (Jbi4EjbAddress)ee;
            }
        }
        return address;
    }
}

