/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4ejb.jbi.component;

import it.imolinfo.jbi4ejb.Logger;
import it.imolinfo.jbi4ejb.LoggerFactory;
import it.imolinfo.jbi4ejb.jbi.component.Jbi4EjbMessageExchangeHandlerFactory;
import it.imolinfo.jbi4ejb.jbi.component.Jbi4EjbSUManager;
import it.imolinfo.jbi4ejb.jbi.component.runtime.AbstractComponentLifeCycle;
import it.imolinfo.jbi4ejb.jbi.component.runtime.ComponentRuntime;
import it.imolinfo.jbi4ejb.jbi.component.runtime.MessageExchangeReceiver;
import it.imolinfo.jbi4ejb.jbi.component.runtime.RuntimeContext;
import it.imolinfo.jbi4ejb.jbi.xfire.EjbTransport;
import javax.jbi.JBIException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.codehaus.xfire.DefaultXFire;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.transport.Transport;

public class Jbi4EjbLifeCycle
extends AbstractComponentLifeCycle {
    private static final Logger LOG = LoggerFactory.getLogger(Jbi4EjbLifeCycle.class);
    private XFire xfire;

    public Jbi4EjbLifeCycle(ComponentRuntime compRuntime) {
        super(compRuntime);
    }

    protected void onInit() throws JBIException {
        this.xfire = Jbi4EjbLifeCycle.createXFire();
    }

    protected void initMessageExchangeHandlerFactory() throws JBIException {
        if (!(this.getComponentRuntime().getServiceUnitManager() instanceof Jbi4EjbSUManager)) {
            String msg = "Service Unit Manager wrong type";
            LOG.error(msg);
            throw new JBIException(msg);
        }
        Jbi4EjbSUManager suManager = (Jbi4EjbSUManager)this.getComponentRuntime().getServiceUnitManager();
        RuntimeContext.getInstance().setMessageExchangeHandlerFactory(new Jbi4EjbMessageExchangeHandlerFactory(suManager));
    }

    protected MessageExchangeReceiver createMessageExchangeReceiver() throws Exception {
        return new MessageExchangeReceiver();
    }

    protected void activateServiceConsumers() throws JBIException {
    }

    protected void deactivateServiceConsumers() throws JBIException {
    }

    protected void activateServiceProviders() throws JBIException {
    }

    protected void deactivateServiceProviders() throws JBIException {
    }

    protected ObjectName createExtensionMBeanName() {
        return null;
    }

    protected StandardMBean createExtensionMBean() {
        return null;
    }

    public XFire getXfire() {
        return this.xfire;
    }

    private static XFire createXFire() {
        DefaultXFire xfire = new DefaultXFire();
        Object[] transports = xfire.getTransportManager().getTransports().toArray();
        for (int i = 0; i < transports.length; ++i) {
            xfire.getTransportManager().unregister((Transport)transports[i]);
        }
        xfire.getTransportManager().register((Transport)new EjbTransport());
        return xfire;
    }
}

