/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.coco.runtime.messages;

import com.sun.encoder.coco.runtime.messages.DefaultErrorManager;
import java.util.HashMap;
import java.util.Map;

public abstract class ErrorManager {
    private static final Map<Object, ErrorManager> mErrorManagers = new HashMap<Object, ErrorManager>();

    protected ErrorManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ErrorManager getManager(Object name) {
        if (name == null) {
            name = "";
        }
        Map<Object, ErrorManager> map = mErrorManagers;
        synchronized (map) {
            ErrorManager mgr = ErrorManager.lookupMgr(name);
            if (mgr == null) {
                mgr = new DefaultErrorManager(name);
                mErrorManagers.put(name, mgr);
            }
            return mgr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ErrorManager lookupMgr(Object name) {
        Map<Object, ErrorManager> map = mErrorManagers;
        synchronized (map) {
            return mErrorManagers.get(name);
        }
    }

    public void post(Severity sev, Throwable t, String msg) {
        Object level = this.mapSeverityToNativeLevel(sev);
        if (msg != null && !"".equals(msg)) {
            this.postNotification(level, msg, t);
        }
    }

    public void log(Severity sev, Throwable t, String msg) {
        Object level = this.mapSeverityToNativeLevel(sev);
        if (msg != null && !"".equals(msg)) {
            this.logNotification(level, msg, t);
        }
    }

    protected abstract void postNotification(Object var1, String var2, Throwable var3);

    protected abstract void logNotification(Object var1, String var2, Throwable var3);

    protected abstract Object mapSeverityToNativeLevel(Severity var1);

    public static class Severity {
        public static final Severity ERROR = new Severity();
        public static final Severity WARN = new Severity();
        public static final Severity INFO = new Severity();
        public static final Severity DEBUG = new Severity();

        private Severity() {
        }
    }
}

