/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.layout;

import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Iterator;
import prefuse.action.layout.Layout;
import prefuse.data.Table;
import prefuse.data.query.NumberRangeModel;
import prefuse.util.ArrayLib;
import prefuse.util.MathLib;
import prefuse.util.PrefuseLib;
import prefuse.util.ui.ValuedRangeModel;
import prefuse.visual.VisualItem;

public class StackedAreaChart
extends Layout {
    private String m_field;
    private String m_start;
    private String m_end;
    private String[] columns;
    private double[] baseline;
    private float[] poly;
    private double m_padding = 0.05;
    private float m_threshold;
    private Rectangle2D bounds;
    private NumberRangeModel m_model;

    public StackedAreaChart(String group, String field, String[] columns) {
        this(group, field, columns, 1.0);
    }

    public StackedAreaChart(String group, String field, String[] columns, double threshold) {
        super(group);
        this.columns = columns;
        this.baseline = new double[columns.length];
        this.poly = new float[4 * columns.length];
        this.m_field = field;
        this.m_start = PrefuseLib.getStartField(field);
        this.m_end = PrefuseLib.getEndField(field);
        this.setThreshold(threshold);
        this.m_model = new NumberRangeModel(0, 1, 0, 1);
    }

    public double getPaddingPercentage() {
        return this.m_padding;
    }

    public void setPaddingPercentage(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Illegal padding percentage: " + p);
        }
        this.m_padding = p;
    }

    public double getThreshold() {
        return this.m_threshold;
    }

    public void setThreshold(double threshold) {
        this.m_threshold = (float)threshold;
    }

    public ValuedRangeModel getRangeModel() {
        return this.m_model;
    }

    public void run(double frac) {
        Arrays.fill(this.baseline, 0.0);
        this.bounds = this.getLayoutBounds();
        float inc = (float)(this.bounds.getMaxX() - this.bounds.getMinX()) / (float)(this.columns.length - 1);
        int len = this.columns.length;
        Iterator iter = this.m_vis.visibleItems(this.m_group);
        while (iter.hasNext()) {
            VisualItem item = (VisualItem)iter.next();
            for (int i = 0; i < this.columns.length; ++i) {
                int n = i;
                this.baseline[n] = this.baseline[n] + item.getDouble(this.columns[i]);
            }
        }
        double maxValue = ArrayLib.max(this.baseline);
        maxValue += this.m_padding * maxValue;
        Arrays.fill(this.baseline, this.bounds.getMaxY());
        this.m_model.setValueRange(0.0, maxValue, 0.0, maxValue);
        Table t = (Table)this.m_vis.getGroup(this.m_group);
        iter = t.tuplesReversed();
        while (iter.hasNext()) {
            VisualItem item = (VisualItem)iter.next();
            if (!item.isVisible()) continue;
            float height = 0.0f;
            int i = len;
            while (--i >= 0) {
                this.poly[2 * (len - 1 - i)] = (float)this.bounds.getMinX() + (float)i * inc;
                this.poly[2 * (len - 1 - i) + 1] = (float)this.baseline[i];
            }
            for (i = 0; i < this.columns.length; ++i) {
                int base = 2 * (len + i);
                double value = item.getDouble(this.columns[i]);
                int n = i;
                this.baseline[n] = this.baseline[n] - (double)((float)this.bounds.getHeight()) * MathLib.linearInterp(value, 0.0, maxValue);
                this.poly[base] = (float)this.bounds.getMinX() + (float)i * inc;
                this.poly[base + 1] = (float)this.baseline[i];
                height = Math.max(height, this.poly[2 * (len - 1 - i) + 1] - this.poly[base + 1]);
            }
            if (height < this.m_threshold) {
                item.setVisible(false);
            }
            this.setX(item, null, 0.0);
            this.setY(item, null, 0.0);
            this.setPolygon(item, this.poly);
        }
    }

    private void setPolygon(VisualItem item, float[] poly) {
        float[] a = this.getPolygon(item, this.m_field);
        float[] s = this.getPolygon(item, this.m_start);
        float[] e = this.getPolygon(item, this.m_end);
        System.arraycopy(a, 0, s, 0, a.length);
        System.arraycopy(poly, 0, a, 0, poly.length);
        System.arraycopy(poly, 0, e, 0, poly.length);
        item.setValidated(false);
    }

    private float[] getPolygon(VisualItem item, String field) {
        float[] poly = (float[])item.get(field);
        if (poly == null || poly.length < 4 * this.columns.length) {
            int len = this.columns.length;
            float inc = (float)(this.bounds.getMaxX() - this.bounds.getMinX()) / (float)(len - 1);
            poly = new float[4 * len];
            Arrays.fill(poly, (float)this.bounds.getMaxY());
            for (int i = 0; i < len; ++i) {
                float x;
                poly[2 * (len + i)] = x = (float)i * inc + (float)this.bounds.getMinX();
                poly[2 * (len - 1 - i)] = x;
            }
            item.set(field, poly);
        }
        return poly;
    }
}

